/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLogarithmicLine;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class LogarithmicPathIterator
implements PathIterator {
    int n = 0;
    int P0 = 0;
    int P1 = 1;
    double[] mXvalues = null;
    double[] mYvalues = null;
    int mSamples = 0;
    private final AffineTransform mAt;
    G2dLogarithmicLine.LogFunction _function;
    boolean mDone = false;

    public LogarithmicPathIterator(double[] xvalues, double[] yvalues, int numPoints, int samples, AffineTransform at) {
        int size = numPoints;
        this.mXvalues = new double[size];
        this.mYvalues = new double[size];
        System.arraycopy(xvalues, 0, this.mXvalues, 0, size);
        System.arraycopy(yvalues, 0, this.mYvalues, 0, size);
        this.mSamples = samples + 1;
        this.mAt = at;
        double[] xpts = new double[]{this.mXvalues[this.P0], this.mXvalues[this.P1]};
        double[] ypts = new double[]{this.mYvalues[this.P0], this.mYvalues[this.P1]};
        this._function = new G2dLogarithmicLine.LogFunction(xpts, ypts);
    }

    public LogarithmicPathIterator(float[] xvalues, float[] yvalues, int numPoints, int samples, AffineTransform at) {
        int size = numPoints;
        this.mXvalues = new double[size];
        this.mYvalues = new double[size];
        for (int i = 0; i < size; ++i) {
            this.mXvalues[i] = xvalues[i];
            this.mYvalues[i] = yvalues[i];
        }
        this.mSamples = samples;
        this.mAt = at;
        double[] xpts = new double[]{this.mXvalues[this.P0], this.mXvalues[this.P1]};
        double[] ypts = new double[]{this.mYvalues[this.P0], this.mYvalues[this.P1]};
        this._function = new G2dLogarithmicLine.LogFunction(xpts, ypts);
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.mDone;
    }

    @Override
    public void next() {
        ++this.n;
        if (this.n % (this.mSamples + 1) == 0) {
            this.n = 1;
            ++this.P1;
            ++this.P0;
            if (this.P1 < this.mXvalues.length) {
                double[] xpts = new double[]{this.mXvalues[this.P0], this.mXvalues[this.P1]};
                double[] ypts = new double[]{this.mYvalues[this.P0], this.mYvalues[this.P1]};
                this._function = new G2dLogarithmicLine.LogFunction(xpts, ypts);
            }
        }
        this.mDone = this.P1 >= this.mXvalues.length;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.mDone) {
            return 4;
        }
        int type = this.n == 0 && this.P0 == 0 ? 0 : 1;
        double pctComplete = (double)this.n / (double)this.mSamples;
        coords[0] = (float)(this.mXvalues[this.P0] + pctComplete * (this.mXvalues[this.P1] - this.mXvalues[this.P0]));
        coords[1] = (float)this._function.logEquation(coords[0]);
        if (this.mAt != null) {
            this.mAt.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.mDone) {
            return 4;
        }
        int type = this.n == 0 && this.P0 == 0 ? 0 : 1;
        double pctComplete = (double)this.n / (double)this.mSamples;
        coords[0] = this.mXvalues[this.P0] + pctComplete * (this.mXvalues[this.P1] - this.mXvalues[this.P0]);
        coords[1] = this._function.logEquation(coords[0]);
        if (this.mAt != null) {
            this.mAt.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }

    boolean hasNext() {
        return !this.isDone();
    }
}

