/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.Margin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import javax.swing.JDialog;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class MarginJDialog
extends RmaJDialog
implements ButtonCmdPanelListener {
    private Margin _margin = new Margin(1.0, 1.0, 1.0, 1.0);
    private boolean _canceled = false;
    RmaJDecimalField jTopTxt = new RmaJDecimalField();
    RmaJDecimalField jLeftTxt = new RmaJDecimalField();
    RmaJDecimalField jBottomTxt = new RmaJDecimalField();
    RmaJDecimalField jRightTxt = new RmaJDecimalField();
    boolean fComponentsAdjusted = false;

    public MarginJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.createControls();
    }

    public MarginJDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.createControls();
    }

    private void createControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(200, 150);
        this.setTitle("Printer Margins");
        this.getContentPane().add((Component)new JLabel("Top"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("Left"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("Bottom"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("Right"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.1, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.jTopTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLeftTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jBottomTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jRightTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("in"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)new JLabel("in"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)new JLabel("in"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)new JLabel("in"), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.1, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        cmdPanel.addCmdPanelListener(this);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public MarginJDialog(String title) {
        this();
        this.setTitle(title);
    }

    public MarginJDialog() {
        this((Frame)null, true);
    }

    public static void main(String[] args) {
        new MarginJDialog().setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
            this.fillForm();
        }
        super.setVisible(b);
    }

    void MarginJDialog_WindowClosing(WindowEvent event) {
        this.dispose();
        this._canceled = true;
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 8) {
            this.ButtonOK_ActionPerformed();
        } else if (event.getID() == 4) {
            this.ButtonCancel_ActionPerformed();
        }
    }

    private void ButtonOK_ActionPerformed() {
        if (!this.saveForm()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
        this._canceled = false;
    }

    private void ButtonCancel_ActionPerformed() {
        this.setVisible(false);
        this.dispose();
        this._canceled = true;
    }

    public Margin getMargin() {
        if (this._margin == null) {
            return new Margin(1.0, 1.0, 1.0, 1.0);
        }
        return new Margin(this._margin.getTopMargin(), this._margin.getLeftMargin(), this._margin.getBottomMargin(), this._margin.getRightMargin());
    }

    public void setMargin(Margin margin) {
        this._margin = margin;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void fillForm() {
        if (this._margin == null) {
            return;
        }
        this.jTopTxt.setText(RMAIO.toTable(this._margin.getTopMargin()));
        this.jLeftTxt.setText(RMAIO.toTable(this._margin.getLeftMargin()));
        this.jBottomTxt.setText(RMAIO.toTable(this._margin.getBottomMargin()));
        this.jRightTxt.setText(RMAIO.toTable(this._margin.getRightMargin()));
    }

    public boolean saveForm() {
        PageFormat pageFormat = new PageFormat();
        double pWidth = pageFormat.getWidth() / 72.0;
        double pHeight = pageFormat.getHeight() / 72.0;
        double topMargin = RMAIO.parseDouble(this.jTopTxt.getText());
        double leftMargin = RMAIO.parseDouble(this.jLeftTxt.getText());
        double bottomMargin = RMAIO.parseDouble(this.jBottomTxt.getText());
        double rightMargin = RMAIO.parseDouble(this.jRightTxt.getText());
        boolean error = false;
        String errorStr = null;
        if (topMargin == Double.NEGATIVE_INFINITY) {
            errorStr = new String("Please Define a Top Margin");
            error = true;
        }
        if (leftMargin == Double.NEGATIVE_INFINITY) {
            errorStr = new String("Please Define a Left Margin");
            error = true;
        }
        if (bottomMargin == Double.NEGATIVE_INFINITY) {
            errorStr = new String("Please Define a Bottom Margin");
            error = true;
        }
        if (rightMargin == Double.NEGATIVE_INFINITY) {
            errorStr = new String("Please Define a Right Margin");
            error = true;
        }
        if (pWidth - (leftMargin + rightMargin) < 0.0) {
            errorStr = new String("Left or Right Margins are too large.  Your imageable width is less than 0.");
            error = true;
        }
        if (pHeight - (topMargin + bottomMargin) < 0.0) {
            errorStr = new String("Top and Bottom Margins are too large. Your imageable height is less that 0.");
            error = true;
        }
        if (error) {
            RMAIO.postError(this, errorStr);
            return false;
        }
        this._margin.setTopMargin(RMAIO.parseDouble(RMAIO.setPrecision2(topMargin, 2)));
        this._margin.setLeftMargin(RMAIO.parseDouble(RMAIO.setPrecision2(leftMargin, 2)));
        this._margin.setBottomMargin(RMAIO.parseDouble(RMAIO.setPrecision2(bottomMargin, 2)));
        this._margin.setRightMargin(RMAIO.parseDouble(RMAIO.setPrecision2(rightMargin, 2)));
        return true;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MarginJDialog.this) {
                MarginJDialog.this.MarginJDialog_WindowClosing(event);
            }
        }
    }
}

