/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.Margin;
import hec.gfx2d.MarginJDialog;
import hec.gfx2d.PrintProperties;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;

public class PageSetupJDialog
extends RmaJDialog
implements ButtonCmdPanelListener,
ActionListener {
    private int _pageLayout = 1;
    private boolean _canceled = false;
    private String leftMarginLabel = "Left:   %val%. in";
    private String rightMarginLabel = "Right:  %val%. in";
    private String topMarginLabel = "Top:    %val%. in";
    private String bottomMarginLabel = "Bottom: %val%. in";
    private Margin _margin = new Margin(1.0, 1.0, 1.0, 1.0);
    PrintProperties _properties = new PrintProperties();
    ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
    JPanel jOrientationPanel = new JPanel(new GridBagLayout());
    JPanel jMarginPanel = new JPanel(new GridBagLayout());
    JPanel jPrintScalePanel = new JPanel(new GridBagLayout());
    JPanel jAddtnlOptsPanel = new JPanel(new GridBagLayout());
    JRadioButton jMaxPlotAreaRadio = new JRadioButton("Maximum Plotting Area");
    JRadioButton jUserScaleRadio = new JRadioButton("User Defined Scale");
    JCheckBox jPlotFrameCheck = new JCheckBox("Frame around plot");
    JCheckBox jPageNumbersCheck = new JCheckBox("Page Numbers");
    JRadioButton jPortraitRadio = new JRadioButton("Portrait");
    JRadioButton jLandscapeRadio = new JRadioButton("Landscape");
    JRadioButton jReversedRadio = new JRadioButton("Reversed");
    JLabel jLeftMarginLbl = new JLabel("Left:     1. in");
    JLabel jRightMarginLbl = new JLabel("Right:  1. in");
    JLabel jTopMarginLbl = new JLabel("   Top:       1. in");
    JLabel jBottomMarginLbl = new JLabel("   Bottom: 1. in");
    JLabel jHorizScaleLbl = new JLabel("1 in Horiz =");
    JLabel jVertScaleLbl = new JLabel("1 in Vert  =");
    JLabel jHorizUnitsLbl = new JLabel("ft.");
    JLabel jVertUnitsLbl = new JLabel("ft.");
    RmaJDecimalField jVertScaleTxt = new RmaJDecimalField();
    RmaJDecimalField jHorizScaleTxt = new RmaJDecimalField();
    JButton jSetMarginButton = new JButton("Set Margins");
    boolean fComponentsAdjusted = false;

    public PageSetupJDialog(Frame parent, boolean model) {
        super(parent, model);
        this.setupControls();
    }

    public PageSetupJDialog(JDialog parent, boolean model) {
        super((Dialog)parent, model);
        this.setupControls();
    }

    private void setupControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(300, 375);
        this.setResizable(false);
        this.setTitle("Page Setup");
        this.getContentPane().add((Component)this.jOrientationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jMarginPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jAddtnlOptsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jPrintScalePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.cmdPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jOrientationPanel.add((Component)this.jPortraitRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jOrientationPanel.add((Component)this.jLandscapeRadio, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jOrientationPanel.add((Component)this.jReversedRadio, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jMarginPanel.add((Component)this.jLeftMarginLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jMarginPanel.add((Component)this.jRightMarginLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jMarginPanel.add((Component)this.jTopMarginLbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jMarginPanel.add((Component)this.jBottomMarginLbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jMarginPanel.add((Component)this.jSetMarginButton, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jAddtnlOptsPanel.add((Component)this.jPlotFrameCheck, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jAddtnlOptsPanel.add((Component)this.jPageNumbersCheck, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPlotFrameCheck.setMargin(new Insets(0, 0, 0, 0));
        this.jPageNumbersCheck.setMargin(new Insets(0, 0, 0, 0));
        this.jPrintScalePanel.add((Component)this.jMaxPlotAreaRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jUserScaleRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jHorizScaleLbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jVertScaleLbl, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(2, 5, 5, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jHorizScaleTxt, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jVertScaleTxt, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 5, 5, 0), 0, 0));
        this.jPrintScalePanel.add((Component)this.jHorizUnitsLbl, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
        this.jPrintScalePanel.add((Component)this.jVertUnitsLbl, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.jUserScaleRadio.setMargin(new Insets(0, 0, 0, 0));
        this.jMaxPlotAreaRadio.setMargin(new Insets(0, 0, 0, 0));
        this.jOrientationPanel.setBorder(new TitledBorder("Orientation"));
        this.jMarginPanel.setBorder(new TitledBorder("Margins"));
        this.jPrintScalePanel.setBorder(new TitledBorder("Printer Scale"));
        this.jAddtnlOptsPanel.setBorder(new TitledBorder("Additional Options"));
        ButtonGroup orientationGroup = new ButtonGroup();
        orientationGroup.add(this.jPortraitRadio);
        orientationGroup.add(this.jLandscapeRadio);
        orientationGroup.add(this.jReversedRadio);
        this.jPortraitRadio.setSelected(true);
        ButtonGroup scaleGroup = new ButtonGroup();
        scaleGroup.add(this.jMaxPlotAreaRadio);
        scaleGroup.add(this.jUserScaleRadio);
        this.jMaxPlotAreaRadio.setSelected(true);
        this.jUserScaleRadio.setEnabled(false);
        this.jHorizScaleTxt.setEnabled(false);
        this.jHorizScaleLbl.setEnabled(false);
        this.jHorizUnitsLbl.setEnabled(false);
        this.jVertScaleTxt.setEnabled(false);
        this.jVertScaleLbl.setEnabled(false);
        this.jVertUnitsLbl.setEnabled(false);
        this.jPlotFrameCheck.setEnabled(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.cmdPanel.addCmdPanelListener(this);
        this.jSetMarginButton.addActionListener(this);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public PageSetupJDialog(String title) {
        this();
        this.setTitle(title);
    }

    public PageSetupJDialog() {
        this((Frame)null, true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new PageSetupJDialog().setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
            this.fillForm();
        }
        super.setVisible(b);
    }

    void PageSetupJDialog_WindowClosing(WindowEvent event) {
        this.dispose();
        this._canceled = true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.jSetMarginButton) {
            this.MarginButton_ActionPerformed();
        }
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 8) {
            this.ButtonOK_ActionPerformed();
        } else if (event.getID() == 4) {
            this.ButtonCancel_ActionPerformed();
        }
    }

    private void ButtonOK_ActionPerformed() {
        this.setVisible(false);
        this.dispose();
        this._canceled = false;
        this.saveForm();
    }

    private void ButtonCancel_ActionPerformed() {
        this.setVisible(false);
        this.dispose();
        this._canceled = true;
    }

    private void MarginButton_ActionPerformed() {
        Margin margin;
        MarginJDialog dlg = new MarginJDialog(this, true);
        dlg.setMargin(this._margin);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        this._margin = margin = dlg.getMargin();
        this.jLeftMarginLbl.setText("Left:     " + margin.getLeftMargin() + " in");
        this.jRightMarginLbl.setText("Right:  " + margin.getRightMargin() + " in");
        this.jTopMarginLbl.setText("   Top:       " + margin.getTopMargin() + " in");
        this.jBottomMarginLbl.setText("   Bottom: " + margin.getBottomMargin() + " in");
    }

    public void fillForm() {
        this._properties.loadFromPreferences();
        this._pageLayout = this._properties.getLayout();
        this._margin = this._properties.getMargins();
        if (this._pageLayout == 0) {
            this.jLandscapeRadio.setSelected(true);
        } else if (this._pageLayout == 1) {
            this.jPortraitRadio.setSelected(true);
        } else if (this._pageLayout == 2) {
            this.jReversedRadio.setSelected(true);
        }
        this.jLeftMarginLbl.setText("Left:     " + this._margin.getLeftMargin() + " in");
        this.jRightMarginLbl.setText("Right:  " + this._margin.getRightMargin() + " in");
        this.jTopMarginLbl.setText("   Top:       " + this._margin.getTopMargin() + " in");
        this.jBottomMarginLbl.setText("   Bottom: " + this._margin.getBottomMargin() + " in");
        if (this._properties.usePageNumber()) {
            this.jPageNumbersCheck.setSelected(true);
        } else {
            this.jPageNumbersCheck.setSelected(false);
        }
        if (this._properties.usePlotFrame()) {
            this.jPlotFrameCheck.setSelected(true);
        } else {
            this.jPlotFrameCheck.setSelected(false);
        }
    }

    public void saveForm() {
        if (this.jPortraitRadio.isSelected()) {
            this._pageLayout = 1;
        } else if (this.jLandscapeRadio.isSelected()) {
            this._pageLayout = 0;
        } else if (this.jReversedRadio.isSelected()) {
            this._pageLayout = 2;
        }
        this._properties.setLayout(this._pageLayout);
        this._properties.setMargins(this._margin);
        this._properties.setUsePageNumbers(this.jPageNumbersCheck.isSelected());
        this._properties.setUsePlotFrame(this.jPlotFrameCheck.isSelected());
        this._properties.saveToPreferences();
    }

    public void setPrintProperties(PrintProperties prop) {
        if (prop == null) {
            return;
        }
        this._properties = prop;
    }

    public PrintProperties getPrintProperties() {
        return this._properties;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PageSetupJDialog.this) {
                PageSetupJDialog.this.PageSetupJDialog_WindowClosing(event);
            }
        }
    }
}

