/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.Viewport;
import hec.io.PairedDataContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PairedDataGlyph
extends G2dGlyph {
    private static final Logger LOGGER = Logger.getLogger(PairedDataGlyph.class.getName());
    PairedDataSet _obj;
    private boolean m_firstPaint = true;

    public PairedDataGlyph(Viewport view, PairedDataSet map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        for (int i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i].setName(PairedDataGlyph.getNameForLineElement(this._obj, i));
        }
    }

    private static String getNameForLineElement(PairedDataSet obj, int i) {
        String name = obj.getName() + " " + PairedDataGlyph.getLabelForCurve(obj._pairedData, i);
        return name;
    }

    private static String getLabelForCurve(PairedDataContainer pdc, int i) {
        Object label;
        if (pdc.labelsUsed) {
            if (pdc.labels == null) {
                LOGGER.log(Level.FINER, "PairedDataGlyph constructed with a PairedDataContainer using labels but the label array was null.{0}", pdc);
                label = " " + i;
            } else if (pdc.labels.length <= i) {
                LOGGER.log(Level.FINER, "PairedDataGlyph constructed with a PairedDataContainer using labels but the label array was improperly sized:{0}<={1}. {2}", new Object[]{pdc.labels.length, i, pdc});
                label = " " + i;
            } else {
                label = pdc.labels[i];
            }
        } else {
            label = " " + i;
        }
        return label;
    }

    @Override
    public void setColor(Color c2) {
        super.setColor(c2);
        for (int i = 0; i < this._lineArray.length; ++i) {
            G2dLineProperties p = this._lineArray[i].getProperties();
            p.setSymbolFillColor(c2);
            p.setLineColor(c2);
            p.setSymbolLineColor(c2);
            p.setFillColor(c2);
            this._lineArray[i].setProperties(p);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this._obj == null || !this._obj.isVisible()) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        for (G2dLine g2dLine : this._lineArray) {
            g2dLine.clearLineData();
        }
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        Scale scale = this.getScale();
        int xAxisType = scale.getAxis(0) != null ? scale.getAxis(0).getType() : 3;
        int yAxisType = scale.getAxis(1) != null ? scale.getAxis(1).getType() : 3;
        for (int yIdx = 0; yIdx < this._obj.curves; ++yIdx) {
            int icnt = 0;
            for (int xIdx = 0; xIdx < this._obj.size; ++xIdx) {
                if (!RMAConst.isValidValue(this._obj.xdata[xIdx]) || !RMAConst.isValidValue(this._obj.ydata[yIdx][xIdx]) || xAxisType == 3 && this._obj.xdata[xIdx] <= 0.0 || yAxisType == 3 && this._obj.ydata[yIdx][xIdx] <= 0.0) {
                    if (icnt <= 0) continue;
                    this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
                    icnt = 0;
                    continue;
                }
                int xdivisor = 1;
                int ydivisor = 1;
                if (this._obj.getXParameterId() == Parameter.PARAMID_PERCENT && this._obj.getXAxisType() == 4) {
                    xdivisor = 100;
                }
                if (this._obj.getYParameterId() == Parameter.PARAMID_PERCENT && this._obj.getYAxisType() == 4) {
                    ydivisor = 100;
                }
                if (this._obj.swapXYValues()) {
                    yarray[icnt] = this._obj.xdata[xIdx] / (double)xdivisor;
                    xarray[icnt] = this._obj.ydata[yIdx][xIdx] / (double)ydivisor;
                } else {
                    xarray[icnt] = this._obj.xdata[xIdx] / (double)xdivisor;
                    yarray[icnt] = this._obj.ydata[yIdx][xIdx] / (double)ydivisor;
                }
                if (++icnt < 10000) continue;
                this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
                icnt = 0;
            }
            this._lineArray[yIdx].addLineData(xarray, yarray, icnt);
        }
        for (int i = 0; i < this._lineArray.length; ++i) {
            G2dLineProperties properties;
            G2dLine line = this._lineArray[i];
            if (this.m_firstPaint && ((properties = line.getProperties()).getLabel() == null || properties.getLabel().equals(""))) {
                String lineLabel = PairedDataGlyph.getLabelForCurve(this._obj._pairedData, i);
                properties.setLabel(lineLabel);
                line.setProperties(properties);
            }
            if (!this._obj.isCurveDrawn(i)) continue;
            this._lineArray[i].drawLine(g, rect);
        }
        this.m_firstPaint = false;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        for (int i = 0; i < this._lineArray.length; ++i) {
            LocalPt rpt;
            if (!this._lineArray[i].contains(pt) || (rpt = this._lineArray[i].getNearestDataPt(pt)) == null) continue;
            String xval = RMAIO.setPrecision2(this._scale.getAxis(0).l2w(rpt.x), this._scale.getAxis(0).getSigFig());
            String yval = RMAIO.setPrecision2(this._scale.getAxis(1).l2w(rpt.y), this._scale.getAxis(1).getSigFig());
            return new String("[" + xval + "," + yval + "]");
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("reset data".equals(arg) && this._lineArray.length != this._obj.getCurveCount()) {
            this._lineArray = new G2dLine[this._obj.getCurveCount()];
            this.buildLineArray();
        }
        super.update(o, arg);
    }

    @Override
    public boolean isCurveDrawn(int curveNumber) {
        return this._obj.isCurveDrawn(curveNumber);
    }

    @Override
    public void setCurveDrawn(int curveNumber, boolean drawn) {
        this._obj.setCurveDrawn(curveNumber, drawn);
    }
}

