/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFontButton;
import rma.swing.RmaJRadioButton;

public class PairedDataLineLabelPanel
extends DefaultJPanel
implements ItemListener {
    G2dLine[] m_lineData = null;
    G2dLineProperties m_properties = null;
    private static final String MAJOR_MINOR = "Major/Minor Font";
    private static final String NORMAL_FONT = "Normal Font";
    private static final String LEFT = "Left";
    private static final String RIGHT = "Right";
    private static final String CENTER = "Center";
    private static final String ABOVE = "Above";
    private static final String BELOW = "Below";
    private String _align = "Left";
    private String _position = "Above";
    private String _mode = "Major/Minor Font";
    SamplePanel samplePanel = new SamplePanel();
    RmaJFontButton m_fontButton = new RmaJFontButton("Font...");
    RmaJFontButton m_majorFontButton = new RmaJFontButton("Major Font...");
    RmaJFontButton m_minorFontButton = new RmaJFontButton("Minor Font...");
    JPanel m_fontButtonPanel = new JPanel(new CardLayout());
    RmaJComboBox jAlignmentCombo = new RmaJComboBox();
    RmaJComboBox jPositionCombo = new RmaJComboBox();
    RmaJColorComboBox jColorCombo = new RmaJColorComboBox();
    JLabel jColorLabel = new JLabel("Color:");
    RmaJRadioButton jLabelNoneRadio = new RmaJRadioButton("None");
    RmaJRadioButton jLabelCustomRadio = new RmaJRadioButton("Custom");
    JLabel jLabelAlignment = new JLabel("Alignment:");
    JLabel jLabelPositition = new JLabel("Position:");
    JPanel jLabelPanel = new JPanel(new GridBagLayout());

    public PairedDataLineLabelPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Label");
        this.jLabelNoneRadio.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jLabelCustomRadio.setMargin(RmaInsets.insets(0, 0, 0, 0));
        ButtonGroup customLabelGroup = new ButtonGroup();
        customLabelGroup.add(this.jLabelNoneRadio);
        customLabelGroup.add(this.jLabelCustomRadio);
        this.jLabelNoneRadio.setSelected(true);
        this.add((Component)this.jLabelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.samplePanel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 5, 5), 0, 25));
        this.jLabelPanel.add((Component)this.jLabelNoneRadio, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, RmaInsets.insets(0, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelCustomRadio, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, RmaInsets.insets(0, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelAlignment, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jAlignmentCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelPositition, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jPositionCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jLabelPanel.add((Component)this.jColorLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jColorCombo, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jLabelPanel.add((Component)this.m_fontButtonPanel, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 0, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        GridLayout layout = new GridLayout();
        layout.setHgap(5);
        layout.setVgap(5);
        JPanel tempPanel = new JPanel(layout);
        tempPanel.add(this.m_majorFontButton);
        tempPanel.add(this.m_minorFontButton);
        this.m_fontButtonPanel.add((Component)tempPanel, MAJOR_MINOR);
        layout = new GridLayout();
        layout.setHgap(5);
        layout.setVgap(5);
        tempPanel = new JPanel(layout);
        tempPanel.add(this.m_fontButton);
        this.m_fontButtonPanel.add((Component)tempPanel, NORMAL_FONT);
        this.jPositionCombo.setModel(new DefaultComboBoxModel<String>(G2dLineProperties.LABEL_POS_NAMES));
        this.jAlignmentCombo.setModel(new DefaultComboBoxModel<String>(G2dLineProperties.LABEL_ALIGN_NAMES));
        this.jLabelPanel.setBorder(new TitledBorder("Label"));
        this.jPositionCombo.setModifiable(true);
        this.jAlignmentCombo.setModifiable(true);
        this.jPositionCombo.addActionListener(this);
        this.jAlignmentCombo.addActionListener(this);
        this.jLabelNoneRadio.addActionListener(this);
        this.jLabelCustomRadio.addActionListener(this);
        this.jLabelNoneRadio.setSelected(true);
    }

    @Override
    public void fillPanel() {
    }

    public Font getLabelFont() {
        return this.m_fontButton.getFont();
    }

    public Font getMajorFont() {
        return this.m_majorFontButton.getFont();
    }

    public boolean getUseLabel() {
        return this.jLabelCustomRadio.isSelected();
    }

    public Font getMinorFont() {
        return this.m_minorFontButton.getFont();
    }

    public void setLineData(G2dLine[] data) {
        this.m_lineData = data;
        if (this.m_lineData != null && this.m_lineData.length > 0) {
            this.m_properties = this.m_lineData[0].getProperties();
            this.m_fontButton.setFont(this.m_properties.getLabelFont());
            this.m_majorFontButton.setFont(this.m_properties.getLabelFont());
            this.jLabelCustomRadio.setSelected(this.m_properties.hasLabel());
            this.jAlignmentCombo.setSelectedIndex(this.m_properties.getLabelAlignment());
            this.jPositionCombo.setSelectedIndex(this.m_properties.getLabelPosition());
            this.jColorCombo.setSelectedColor(this.m_properties.getLabelColor());
        }
        if (this.m_lineData != null && this.m_lineData.length > 1) {
            this.m_minorFontButton.setFont(this.m_properties.getLabelFont());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getID() == 1) {
            ((CardLayout)this.m_fontButtonPanel.getLayout()).show(this.m_fontButtonPanel, MAJOR_MINOR);
            this._mode = MAJOR_MINOR;
        } else {
            ((CardLayout)this.m_fontButtonPanel.getLayout()).show(this.m_fontButtonPanel, NORMAL_FONT);
            this._mode = NORMAL_FONT;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.jPositionCombo) {
            this.PositionCombo_ActionPerformed();
        } else if (obj == this.jAlignmentCombo) {
            this.AlignmentCombo_ActionPerformed();
        } else if (obj == this.jLabelNoneRadio) {
            this.setLabelComponentsEnabled(false);
        } else if (obj == this.jLabelCustomRadio) {
            this.setLabelComponentsEnabled(true);
        }
    }

    private void PositionCombo_ActionPerformed() {
        this._position = (String)this.jPositionCombo.getSelectedItem();
        this.samplePanel.repaint();
    }

    private void AlignmentCombo_ActionPerformed() {
        this._align = (String)this.jAlignmentCombo.getSelectedItem();
        this.samplePanel.repaint();
    }

    private void setLabelComponentsEnabled(boolean enabled) {
        this.jAlignmentCombo.setEnabled(enabled);
        this.jPositionCombo.setEnabled(enabled);
        this.jLabelPositition.setEnabled(enabled);
        this.jLabelAlignment.setEnabled(enabled);
        this.jColorCombo.setEnabled(enabled);
        this.jColorLabel.setEnabled(enabled);
        this.m_fontButton.setEnabled(enabled);
        this.m_majorFontButton.setEnabled(enabled);
        this.m_minorFontButton.setEnabled(enabled);
        this.samplePanel.repaint();
    }

    @Override
    public boolean savePanel() {
        if (this.jLabelNoneRadio.isSelected()) {
            for (int i = 0; i < this.m_lineData.length; ++i) {
                this.m_lineData[i].setLineLabelVisible(false);
            }
            return true;
        }
        if (this._mode == MAJOR_MINOR) {
            // empty if block
        }
        return true;
    }

    public int getLabelPosition() {
        String pos = (String)this.jPositionCombo.getSelectedItem();
        if (pos.equals(ABOVE)) {
            return 0;
        }
        if (pos.equals(BELOW)) {
            return 1;
        }
        if (pos.equals(CENTER)) {
            return 2;
        }
        return 0;
    }

    public Color getLabelColor() {
        return this.jColorCombo.getSelectedColor();
    }

    public int getLabelAlignment() {
        String align = (String)this.jAlignmentCombo.getSelectedItem();
        if (align.equals(LEFT)) {
            return 0;
        }
        if (align.equals(RIGHT)) {
            return 1;
        }
        if (align.equals(CENTER)) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getName() {
        return "Label";
    }

    public class SamplePanel
    extends JPanel {
        int strLen = 0;
        String sample = "Sample Text";
        String _position = "Left";
        String _align = "Above";
        Color _labelColor = Color.black;

        public SamplePanel() {
            this.setBorder(new TitledBorder("Sample"));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (PairedDataLineLabelPanel.this.jLabelNoneRadio.isSelected()) {
                Dimension d = this.getSize();
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
                return;
            }
            Color oldColor = g.getColor();
            this._labelColor = PairedDataLineLabelPanel.this.jColorCombo.getSelectedColor();
            Dimension d = this.getSize();
            this._position = (String)PairedDataLineLabelPanel.this.jPositionCombo.getSelectedItem();
            this._align = (String)PairedDataLineLabelPanel.this.jAlignmentCombo.getSelectedItem();
            this.strLen = g.getFontMetrics().stringWidth(this.sample);
            if (this._position.equals(PairedDataLineLabelPanel.ABOVE) && this._align.equals(PairedDataLineLabelPanel.LEFT)) {
                this.drawAboveLeft(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.ABOVE) && this._align.equals(PairedDataLineLabelPanel.CENTER)) {
                this.drawAboveCenter(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.ABOVE) && this._align.equals(PairedDataLineLabelPanel.RIGHT)) {
                this.drawAboveRight(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.BELOW) && this._align.equals(PairedDataLineLabelPanel.LEFT)) {
                this.drawBelowLeft(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.BELOW) && this._align.equals(PairedDataLineLabelPanel.CENTER)) {
                this.drawBelowCenter(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.BELOW) && this._align.equals(PairedDataLineLabelPanel.RIGHT)) {
                this.drawBelowRight(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.CENTER) && this._align.equals(PairedDataLineLabelPanel.CENTER)) {
                this.drawCenterCenter(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.CENTER) && this._align.equals(PairedDataLineLabelPanel.RIGHT)) {
                this.drawCenterRight(g);
            } else if (this._position.equals(PairedDataLineLabelPanel.CENTER) && this._align.equals(PairedDataLineLabelPanel.LEFT)) {
                this.drawCenterLeft(g);
            }
            g.setColor(oldColor);
        }

        private void drawAboveLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, 10, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawBelowLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawCenterRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 12 - this.strLen, d.height / 2 + 2);
            g.drawLine(d.width - 10 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width / 2 - this.strLen / 2 - 2, d.height / 2 + 2);
            g.drawLine(d.width / 2 + this.strLen / 2 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, 8, d.height / 2 + 2);
            g.drawLine(10 + this.strLen + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.setColor(this._labelColor != null ? this._labelColor : Color.black);
            g.drawString(this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }
}

