/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinePropertiesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class PairedDataLinePropertiesPanel
extends DefaultJPanel
implements ItemListener {
    G2dLinePropertiesPanel m_linePropertiesPanel = new G2dLinePropertiesPanel();
    RmaJComboBox m_lineComboBox = new RmaJComboBox();
    G2dLine[] m_lineData = null;
    private static final String MAJOR_LINE_STYLE = "Major Line Styles";
    private static final String MINOR_LINE_STYLE = "Minor Line Styles";
    private static final String ALL_LINES = "All";
    Map m_linePropertiesCache = new LinkedHashMap();
    Object m_selectedItem = null;

    public PairedDataLinePropertiesPanel() {
        this.setName("Line Properties");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lineComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0));
        this.add((Component)this.m_linePropertiesPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0));
        this.m_lineComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PairedDataLinePropertiesPanel.this.m_selectedItem == PairedDataLinePropertiesPanel.this.m_lineComboBox.getSelectedItem()) {
                    return;
                }
                PairedDataLinePropertiesPanel.this.lineComboBoxChanged();
                PairedDataLinePropertiesPanel.this.m_selectedItem = PairedDataLinePropertiesPanel.this.m_lineComboBox.getSelectedItem();
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getID() == 0) {
            this.m_lineComboBox.setModel(new RmaListModel<G2dLine>(false, this.m_lineData));
            if (this.m_lineData.length > 0) {
                this.m_lineComboBox.setSelectedIndex(0);
            }
        } else if (e.getID() == 1) {
            this.m_lineComboBox.setModel(new RmaListModel<Object>(false, MAJOR_LINE_STYLE, MINOR_LINE_STYLE));
            this.m_lineComboBox.setSelectedIndex(0);
        } else if (e.getID() == 2) {
            this.m_lineComboBox.setModel(new RmaListModel<Object>(true, ALL_LINES));
            this.m_lineComboBox.setSelectedIndex(0);
        }
    }

    public void setLineData(G2dLine[] g2dLines) {
        this.m_lineData = g2dLines;
        this.resetLinePropertiesCache();
        if (this.m_lineData != null && this.m_lineData.length > 0) {
            this.m_linePropertiesCache.put(MAJOR_LINE_STYLE, this.m_lineData[0].getProperties().clone());
            this.m_linePropertiesCache.put(ALL_LINES, this.m_lineData[0].getProperties().clone());
        }
        if (this.m_lineData != null && this.m_lineData.length > 1) {
            this.m_linePropertiesCache.put(MINOR_LINE_STYLE, this.m_lineData[1].getProperties().clone());
        }
        for (int i = 0; this.m_lineData != null && i < this.m_lineData.length; ++i) {
            this.m_linePropertiesCache.put(this.m_lineData[i], this.m_lineData[i].getProperties().clone());
        }
    }

    private void resetLinePropertiesCache() {
        this.m_linePropertiesCache.clear();
        this.m_linePropertiesCache.put(MAJOR_LINE_STYLE, new G2dLineProperties());
        this.m_linePropertiesCache.put(MINOR_LINE_STYLE, new G2dLineProperties());
        this.m_linePropertiesCache.put(ALL_LINES, new G2dLineProperties());
    }

    private void lineComboBoxChanged() {
        this.m_linePropertiesPanel.savePanel();
        Object selectedItem = this.m_lineComboBox.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        G2dLineProperties properties = (G2dLineProperties)this.m_linePropertiesCache.get(selectedItem);
        if (selectedItem instanceof G2dLine) {
            if (properties == null) {
                properties = ((G2dLine)selectedItem).getProperties();
                this.m_linePropertiesCache.put(selectedItem, properties);
            }
            this.m_linePropertiesPanel.setData(properties);
        } else {
            this.m_linePropertiesPanel.setData(properties);
        }
        this.m_linePropertiesPanel.fillPanel();
    }

    public G2dLineProperties getSelectedLineProperties() {
        return this.m_linePropertiesPanel.getData();
    }

    public G2dLine getSelectedLine() {
        Object selectedItem = this.m_lineComboBox.getSelectedItem();
        if (selectedItem instanceof G2dLine) {
            return (G2dLine)selectedItem;
        }
        return null;
    }

    public void setSelectedLineIndex(int curveNum) {
        if (curveNum < 0 || curveNum >= this.m_lineComboBox.getItemCount()) {
            return;
        }
        this.m_lineComboBox.setSelectedIndex(curveNum);
    }

    @Override
    public boolean savePanel() {
        if (!this.m_linePropertiesPanel.savePanel()) {
            return false;
        }
        G2dLineProperties prop = this.m_linePropertiesPanel.getData();
        return prop != null;
    }

    public G2dLineProperties getMinorLineProperties() {
        return (G2dLineProperties)this.m_linePropertiesCache.get(MINOR_LINE_STYLE);
    }

    public G2dLineProperties getMajorLineProperties() {
        return (G2dLineProperties)this.m_linePropertiesCache.get(MAJOR_LINE_STYLE);
    }

    private void setLineProperties(G2dLine line, G2dLineProperties properties) {
        G2dLineProperties lineProperties = line.getProperties();
        lineProperties.copyCurveProperties(properties);
        line.setProperties(lineProperties);
    }
}

