/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.PairedDataGlyph;
import hec.gfx2d.autoload.RefreshCookie;
import hec.heclib.util.Unit;
import hec.io.PairedDataContainer;
import java.util.Arrays;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.lookup.Lookups;

public class PairedDataSet
extends G2dData
implements G2dObject {
    public Vector labels;
    public String xtype;
    public String ytype;
    public double[] xdata = null;
    public PairedDataContainer _pairedData;
    public double[][] ydata = null;
    public int curves = 0;
    public int size = 0;
    boolean _loaded = false;
    public boolean[] curveDrawn;
    boolean _visible = true;

    public PairedDataSet(PairedDataContainer pairedDataContainer) {
        this._lookup = Lookups.fixed((Object[])new Object[]{this.createRefreshCookie()});
        this.setData(pairedDataContainer);
    }

    public void setData(PairedDataContainer pairedDataContainer) {
        this._pairedData = pairedDataContainer;
        this.bounds = null;
        this.xdata = this._pairedData.xOrdinates;
        this.ydata = this._pairedData.yOrdinates;
        this.curves = this._pairedData.numberCurves;
        this.size = this._pairedData.numberOrdinates;
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xtype = this._pairedData.xtype;
        this.ytype = this._pairedData.ytype;
        this.setSwapXYValues(this._pairedData.switchXyAxis);
        this.name = this._pairedData.location;
        this.curveDrawn = new boolean[this.curves];
        Arrays.fill(this.curveDrawn, true);
        if (this._pairedData.other != null && this._pairedData.other.length() > 0) {
            this.name = this.name.concat(" ").concat(this._pairedData.other);
        }
        if (this._pairedData.version != null && this._pairedData.version.length() > 0) {
            this.name = this.name.concat(" ").concat(this._pairedData.version);
        }
        if (this._pairedData.date != null && this._pairedData.date.length() > 0) {
            this.name = this.name.concat(" ").concat(this._pairedData.date);
        }
        this.setYParameterId(this.getParameterId(this._pairedData.yparameter));
        this.setXParameterId(this.getParameterId(this._pairedData.xparameter));
        String units = Units.getUnitsForAlias(this._pairedData.yunits);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem("English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem("SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        if (this.xtype != null && (this.xtype.equalsIgnoreCase("PROB") || this.xtype.equalsIgnoreCase("FREQ")) && this._pairedData.xunits != null && this._pairedData.xunits.toLowerCase().indexOf("perc") == 0) {
            this.setXParameterId(Parameter.PARAMID_PERCENT);
        }
        if (this.ytype != null && (this.ytype.equalsIgnoreCase("PROB") || this.ytype.equalsIgnoreCase("FREQ")) && this._pairedData.yunits != null && this._pairedData.yunits.toLowerCase().indexOf("perc") == 0) {
            this.setYParameterId(Parameter.PARAMID_PERCENT);
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public PairedDataContainer getData() {
        return this._pairedData;
    }

    @Override
    public int getCurveCount() {
        return this.curves;
    }

    private int getParameterId(String parameter) {
        if (parameter == null) {
            return -1;
        }
        try {
            Parameter param = new Parameter(parameter);
            int paramId = param.getParameterId();
            if (paramId != -1) {
                return paramId;
            }
        }
        catch (DataSetIllegalArgumentException e) {
            return -1;
        }
        return -1;
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.ydata == null || this.ydata.length == 0 || this.ydata[0] == null || this.ydata[0].length == 0) {
            return this.bounds;
        }
        int xdivisor = 1;
        int ydivisor = 1;
        if (this.getXParameterId() == Parameter.PARAMID_PERCENT && this.getXAxisType() == 4) {
            xdivisor = 100;
        }
        if (this.getYParameterId() == Parameter.PARAMID_PERCENT && this.getYAxisType() == 4) {
            ydivisor = 100;
        }
        if (this.bounds == null && this.xdata != null || this.ydata != null) {
            this.buildBounds(xdivisor, ydivisor);
            if (this.swapXYValues()) {
                this.swapBoundsXyValues();
            }
        }
        return this.bounds;
    }

    private void swapBoundsXyValues() {
        double tmp = this.bounds.w;
        this.bounds.w = this.bounds.s;
        this.bounds.s = tmp;
        tmp = this.bounds.e;
        this.bounds.e = this.bounds.n;
        this.bounds.n = tmp;
    }

    protected void buildBounds(int xdivisor, int ydivisor) {
        int k;
        boolean isLogX = this.getXAxisType() == 3;
        boolean isLogY = this.getYAxisType() == 3;
        for (k = 0; k < this.xdata.length; ++k) {
            if (isLogX && this.xdata[k] <= 0.0 || !RMAConst.isValidValue(this.xdata[k] / (double)xdivisor) || !RMAConst.isValidValue(this.ydata[0][k] / (double)ydivisor) || isLogY && this.ydata[0][k] / (double)ydivisor <= 0.0) continue;
            this.bounds = new WorldRect(this.xdata[k] / (double)xdivisor, this.ydata[0][k] / (double)ydivisor, this.xdata[k] / (double)xdivisor, this.ydata[0][k] / (double)ydivisor);
            break;
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(0.0, 1.0, 0.0, 1.0);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!RMAConst.isValidValue(this.xdata[i])) continue;
            if (this.bounds.w > this.xdata[i] / (double)xdivisor) {
                this.bounds.w = this.xdata[i] / (double)xdivisor;
                continue;
            }
            if (!(this.bounds.e < this.xdata[i] / (double)xdivisor)) continue;
            this.bounds.e = this.xdata[i] / (double)xdivisor;
        }
        for (k = 0; k < this.curves; ++k) {
            for (int j = 0; j < this.size; ++j) {
                if (isLogY && this.ydata[k][j] / (double)ydivisor <= 0.0 || !RMAConst.isValidValue(this.ydata[k][j] / (double)ydivisor)) continue;
                if (this.bounds.s > this.ydata[k][j] / (double)ydivisor) {
                    this.bounds.s = this.ydata[k][j] / (double)ydivisor;
                    continue;
                }
                if (!(this.bounds.n < this.ydata[k][j] / (double)ydivisor)) continue;
                this.bounds.n = this.ydata[k][j] / (double)ydivisor;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public int numYCoord() {
        return this.curves;
    }

    @Override
    public String getXAxisName() {
        Object parameterdString = Parameter.getParamString(this.getXParameterId());
        if (this.getUnitSystem() == 0 || this.getXParameterId() == -1) {
            if (this.xunits.equals("xunits")) {
                if (this.swapXYValues()) {
                    return this._pairedData.yunits + " " + this._pairedData.yparameter;
                }
                return this._pairedData.xunits + " " + this._pairedData.xparameter;
            }
            return this.xunits + " " + this._pairedData.xparameter;
        }
        if (this.getXParameterId() == Parameter.PARAMID_PERCENT) {
            return "Probability";
        }
        if (PairedDataSet.useDisplayUnits()) {
            parameterdString = (String)parameterdString + " (%S) ";
        } else {
            String units = null;
            String tempUnits = this.swapXYValues() ? this._pairedData.yunits : this._pairedData.xunits;
            units = Units.getUnitsForAlias(tempUnits);
            if (units == null) {
                units = tempUnits;
            }
            parameterdString = (String)parameterdString + " (" + units + ")";
        }
        return parameterdString;
    }

    @Override
    public String getYAxisName() {
        if (this.getUnitSystem() == 0 || this.getYParameterId() == -1) {
            if (this.yunits.equals("yunits")) {
                if (this.swapXYValues()) {
                    return this._pairedData.xunits + " " + this._pairedData.xparameter;
                }
                return this._pairedData.yunits + " " + this._pairedData.yparameter;
            }
            return this.yunits;
        }
        Object parameterdString = Parameter.getParamString(this.getYParameterId());
        if (PairedDataSet.useDisplayUnits()) {
            parameterdString = (String)parameterdString + " (%S) ";
        } else {
            String units = null;
            String tempUnits = this.swapXYValues() ? this._pairedData.xunits : this._pairedData.yunits;
            units = Units.getUnitsForAlias(tempUnits);
            if (units == null) {
                units = tempUnits;
            }
            parameterdString = (String)parameterdString + " (" + units + ")";
        }
        return parameterdString;
    }

    @Override
    public int getXAxisType() {
        if (this.xtype == null) {
            return 0;
        }
        if (this.xtype.equalsIgnoreCase("LOG")) {
            return 3;
        }
        if (this.xtype.equalsIgnoreCase("PROB")) {
            return 4;
        }
        if (this.xtype.equalsIgnoreCase("FREQ")) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getYAxisType() {
        if (this.ytype == null) {
            return 0;
        }
        if (this.ytype.equalsIgnoreCase("LOG")) {
            return 3;
        }
        if (this.ytype.equalsIgnoreCase("PROB")) {
            return 4;
        }
        if (this.ytype.equalsIgnoreCase("FREQ")) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getXParameterId() {
        if (this.swapXYValues()) {
            return super.getYParameterId();
        }
        return super.getXParameterId();
    }

    @Override
    public int getYParameterId() {
        if (this.swapXYValues()) {
            return super.getXParameterId();
        }
        return super.getYParameterId();
    }

    @Override
    public void load() {
        if (this._loaded) {
            return;
        }
        this._loaded = false;
        this._loaded = true;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    @Override
    public void setSwapXYValues(boolean b) {
        super.setSwapXYValues(b);
    }

    @Override
    public boolean canSwapXYValues() {
        return true;
    }

    public boolean isCurveDrawn(int lineNum) {
        if (lineNum < 0 || lineNum >= this.curveDrawn.length) {
            return false;
        }
        return this.curveDrawn[lineNum];
    }

    public void setCurveDrawn(int lineNum, boolean drawLine) {
        if (lineNum < 0 || lineNum >= this.curveDrawn.length) {
            return;
        }
        this.curveDrawn[lineNum] = drawLine;
    }

    public void setVisible(boolean tf) {
        this._visible = tf;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public double[] getYValues(int curveNum) {
        if (this.ydata == null || curveNum < 0 || curveNum >= this.ydata.length) {
            return null;
        }
        return this.ydata[curveNum];
    }

    public boolean hasVisibleCurve() {
        for (int i = 0; i < this.curveDrawn.length; ++i) {
            if (!this.curveDrawn[i]) continue;
            return true;
        }
        return false;
    }

    public void setLoaded(boolean b) {
        this._loaded = b;
    }

    protected RefreshCookie createRefreshCookie() {
        return new ReloadCookie();
    }

    static {
        G2dGlyphFactory.addMapping(PairedDataSet.class, PairedDataGlyph.class);
    }

    private class ReloadCookie
    implements RefreshCookie {
        private ReloadCookie() {
        }

        @Override
        public void refresh(String msg) {
            PairedDataSet.this.setLoaded(false);
            PairedDataSet.this.load();
        }
    }
}

