/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.PairedValuesExtDataGlyph;
import hec.model.PairedValuesExt;
import rma.util.RMAConst;

public class PairedValuesExtData
extends G2dData
implements G2dObject {
    public double[] xdata;
    public double[][] ydata;
    public String[] curveLabels;
    public int numberCurves = 0;
    public double[] xdataOrg;
    public double[][] ydataOrg;
    int _xAxisType = 0;
    int _yAxisType = 0;
    protected PairedValuesExt _pv;
    protected String _interpolationType = "linear";
    boolean _plotXvsY = false;
    boolean _loaded = false;
    boolean _plotAll = true;

    public PairedValuesExtData() {
        this(true);
    }

    public PairedValuesExtData(boolean createDefaults) {
        this.name = "Simple Table Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        if (createDefaults) {
            this.createDefaultData();
        }
    }

    protected void createDefaultData() {
        this.xdata = new double[100];
        this.numberCurves = 1;
        this.ydata = new double[this.numberCurves][100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[i] = i;
            this.ydata[0][i] = 5.0 * Math.sin(Math.PI * (double)i / 20.0);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getXParameterId() {
        if (this._plotXvsY) {
            return super.getYParameterId();
        }
        return super.getXParameterId();
    }

    @Override
    public int getYParameterId() {
        if (this._plotXvsY) {
            return super.getXParameterId();
        }
        return super.getYParameterId();
    }

    @Override
    public int getCurveCount() {
        return this.numberCurves;
    }

    public void setData(double[] xd, double[][] yd) {
        if (xd == null || yd == null) {
            return;
        }
        this.xdata = xd;
        this.ydata = yd;
        this.bounds = null;
        if (!this.calcPlotArrays()) {
            System.out.println("ERROR <SimplePairedValuesData.setData(PairedValues)> : Error calculating new plot arrays");
            return;
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setData(PairedValuesExt pv) {
        this._pv = pv;
        if (this._pv == null || this._pv.getXArray() == null || this._pv.getXArray().length < 2) {
            return;
        }
        this.xdata = this._pv.getXArray();
        this.ydata = this._pv.getYData();
        this.numberCurves = this._pv.getNumberCurves();
        this.curveLabels = this._pv.getCurveLabels();
        this.setUnitSystem(this._pv.getUnitSystem());
        this.bounds = null;
        if (!this.calcPlotArrays()) {
            System.out.println("ERROR <SimplePairedValuesData.setData(PairedValues)> : Error calculating new plot arrays");
            return;
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void resetData() {
        this.xdata = null;
        this.ydata = null;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setInterpolationType(String interpType) {
        if (interpType.equalsIgnoreCase("linear") || interpType.equalsIgnoreCase("step") || interpType.equalsIgnoreCase("cubic")) {
            this._interpolationType = interpType;
        }
    }

    public void setPlotXvsY(boolean tf) {
        this._plotXvsY = tf;
    }

    public boolean getPlotXvsY() {
        return this._plotXvsY;
    }

    public boolean calcPlotArrays() {
        if (this._pv == null) {
            return false;
        }
        this.setXParameterId(this._pv.getParametersIds()[0]);
        this.setYParameterId(this._pv.getParametersIds()[1]);
        this.xdata = this._pv.getXArray();
        this.xdataOrg = this._pv.getXArray();
        this.ydataOrg = this._pv.getYData();
        this.ydata = new double[this.numberCurves][];
        if (this.xdata == null || this.xdata.length < 2 || this.ydataOrg == null) {
            return false;
        }
        double[] pXarray = null;
        double[] pYarray = null;
        for (int icurve = 0; icurve < this.numberCurves; ++icurve) {
            double[] yvalues = this._pv.getYArray(icurve);
            int npts = this.xdata.length;
            int numPts = 0;
            pYarray = null;
            if (this._interpolationType.equalsIgnoreCase("linear")) {
                numPts = npts;
                pXarray = new double[numPts];
                pYarray = new double[numPts];
                System.arraycopy(this.xdata, 0, pXarray, 0, npts);
                System.arraycopy(yvalues, 0, pYarray, 0, npts);
            } else if (this._interpolationType.equalsIgnoreCase("step")) {
                int i;
                numPts = npts * 2 - 1;
                pXarray = new double[numPts];
                pYarray = new double[numPts];
                if (this._plotXvsY) {
                    for (i = 0; i < npts - 1; ++i) {
                        pXarray[i * 2] = this.xdata[i];
                        pYarray[i * 2] = yvalues[i];
                        pXarray[i * 2 + 1] = this.xdata[i];
                        pYarray[i * 2 + 1] = yvalues[i + 1];
                    }
                    pXarray[numPts - 1] = this.xdata[npts - 1];
                    pYarray[numPts - 1] = yvalues[npts - 1];
                } else {
                    for (i = 0; i < npts - 1; ++i) {
                        pXarray[i * 2] = this.xdata[i];
                        pYarray[i * 2] = yvalues[i];
                        pXarray[i * 2 + 1] = this.xdata[i + 1];
                        pYarray[i * 2 + 1] = yvalues[i];
                    }
                    pXarray[numPts - 1] = this.xdata[npts - 1];
                    pYarray[numPts - 1] = yvalues[npts - 1];
                }
            } else if (this._interpolationType.equalsIgnoreCase("cubic")) {
                numPts = 101;
                pXarray = new double[numPts];
                pYarray = new double[numPts];
                double dx = (this.xdata[npts - 1] - this.xdata[0]) / (double)(numPts - 1);
                for (int i = 0; i < numPts; ++i) {
                    double xval;
                    pXarray[i] = xval = this.xdata[0] + (double)i * dx;
                    pYarray[i] = this._pv.interpolateValueCubicSpline(xval, icurve);
                }
            } else {
                return false;
            }
            this.ydata[icurve] = pYarray;
        }
        this.xdata = pXarray;
        return true;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null || this.xdata.length < 1 || this.ydata.length < 1) {
            return null;
        }
        if (this.bounds == null) {
            int icurve;
            for (int k = 0; k < this.xdata.length; ++k) {
                if (!RMAConst.isValidValue(this.xdata[k])) continue;
                boolean found = false;
                for (icurve = 0; icurve < this.numberCurves; ++icurve) {
                    if (this.ydata[icurve] == null || !RMAConst.isValidValue(this.ydata[icurve][k])) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.bounds = new WorldRect(this.xdata[k], this.ydata[icurve][k], this.xdata[k], this.ydata[icurve][k]);
                break;
            }
            for (int i = 0; i < this.xdata.length; ++i) {
                double dx = this.xdata[i];
                if (!RMAConst.isValidValue(dx)) continue;
                for (icurve = 0; icurve < this.numberCurves; ++icurve) {
                    double dy;
                    if (this.ydata[icurve] == null || !RMAConst.isValidValue(dy = this.ydata[icurve][i])) continue;
                    if (this.bounds.w > dx) {
                        this.bounds.w = dx;
                    } else if (this.bounds.e < dx) {
                        this.bounds.e = dx;
                    }
                    if (this.bounds.s > dy) {
                        this.bounds.s = dy;
                        continue;
                    }
                    if (!(this.bounds.n < dy)) continue;
                    this.bounds.n = dy;
                }
            }
            if (this._plotXvsY && this.bounds != null) {
                double tmp = this.bounds.w;
                this.bounds.w = this.bounds.s;
                this.bounds.s = tmp;
                tmp = this.bounds.e;
                this.bounds.e = this.bounds.n;
                this.bounds.n = tmp;
            }
        }
        return this.bounds;
    }

    static {
        G2dGlyphFactory.addMapping(PairedValuesExtData.class, PairedValuesExtDataGlyph.class);
    }
}

