/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.PairedValuesExtData;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PairedValuesExtDataGlyph
extends G2dGlyph {
    PairedValuesExtData _obj;

    public PairedValuesExtDataGlyph(Viewport view, PairedValuesExtData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        G2dLineProperties prop = this._line.getProperties();
        prop._drawPoints = true;
        prop._symbolSize = 3.0f;
        this._line.setProperties(prop);
        for (int i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i].setName(this._obj.getName() + " " + (String)(this._obj.curveLabels != null ? this._obj.curveLabels[i] : " " + i));
        }
    }

    @Override
    public void draw(Graphics g) {
        Rectangle rect = this.getVisibleRect();
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        int ilen = this._obj.xdata.length;
        int icnt = 0;
        for (int icurve = 0; icurve < this._obj.numberCurves; ++icurve) {
            int i;
            for (int ioff = 0; ioff < ilen; ioff += i) {
                int imax;
                if (ioff > 0 && icnt > 0) {
                    --ioff;
                }
                if ((imax = 10000) > ilen - ioff) {
                    imax = ilen - ioff;
                }
                icnt = 0;
                for (i = 0; i < imax; ++i) {
                    double dx = this._obj.xdata[i + ioff];
                    if (this._obj.ydata[icurve] == null) continue;
                    double dy = this._obj.ydata[icurve][i + ioff];
                    if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                        ++i;
                        break;
                    }
                    xarray[i] = dx;
                    yarray[i] = dy;
                    ++icnt;
                }
                if (this._obj.getPlotXvsY()) {
                    double[] tmpArray = xarray;
                    xarray = yarray;
                    yarray = tmpArray;
                    tmpArray = null;
                }
                if (icnt <= 0) continue;
                this._lineArray[icurve].setLineData(xarray, yarray, icnt);
                this._lineArray[icurve].drawLine(g, rect);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        for (int icurve = 0; icurve < this._lineArray.length; ++icurve) {
            this._line = this._lineArray[icurve];
            if (!this._line.contains(pt)) continue;
            LocalPt rpt = this._line.getNearestDataPt(pt);
            WorldPt wp = new WorldPt();
            double distance = this._line.getNearestDataPt(pt, wp);
            if (distance == Double.NEGATIVE_INFINITY) continue;
            int julianDay = (int)this._scale.getAxis(0).l2w(rpt.x) / 1440;
            String xvalstr = HecTime.juldat(julianDay, 4);
            xvalstr = xvalstr.substring(0, xvalstr.length() - 4);
            try {
                double yVal = Units.convertUnits(wp.n, this._obj.getYParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                return new String("[" + xvalstr + " ," + RMAIO.setPrecision2(yVal, 0) + "]");
            }
            catch (DataSetException exp) {
                return new String("[" + xvalstr + " ," + RMAIO.setPrecision2(wp.n, 0) + "]");
            }
        }
        return null;
    }
}

