/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.DnDUtils;
import hec.gfx2d.G2dGlyph;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class PanelDropTarget
implements DropTargetListener {
    TransferHandler mTransferHandler = null;
    protected JPanel pane;
    protected DropTarget dropTarget;
    protected boolean acceptableType;
    protected DataFlavor targetFlavor;

    public PanelDropTarget(JPanel pane) {
        this.pane = pane;
        if (!GraphicsEnvironment.isHeadless()) {
            this.dropTarget = new DropTarget(pane, 3, this, true, null);
        }
    }

    public void setTransferHandler(TransferHandler handler) {
        this.mTransferHandler = handler;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        System.out.println("dragEnter, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        DnDUtils.debugPrintln("dragEnter, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        this.checkTransferType(dtde);
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        DnDUtils.debugPrintln("DropTarget dragExit");
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        DnDUtils.debugPrintln("DropTarget dragOver, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        DnDUtils.debugPrintln("DropTarget dropActionChanged, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DnDUtils.debugPrintln("DropTarget drop, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        if ((dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            try {
                boolean result = this.dropComponent(transferable);
                dtde.dropComplete(result);
                DnDUtils.debugPrintln("Drop completed, success: " + result);
            }
            catch (Exception e) {
                DnDUtils.debugPrintln("Exception while handling drop " + e);
                dtde.dropComplete(false);
            }
        } else {
            DnDUtils.debugPrintln("Drop target rejected drop");
            dtde.rejectDrop();
        }
    }

    protected boolean acceptOrRejectDrag(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        int sourceActions = dtde.getSourceActions();
        boolean acceptedDrag = false;
        DnDUtils.debugPrintln("\tSource actions are " + DnDUtils.showActions(sourceActions) + ", drop action is " + DnDUtils.showActions(dropAction));
        if (dtde.getTransferable() == this.pane) {
            DnDUtils.debugPrintln("\tRejecting because dragging over same panel");
            dtde.rejectDrag();
            return false;
        }
        if (!this.acceptableType || (sourceActions & 3) == 0) {
            DnDUtils.debugPrintln("Drop target rejecting drag");
            dtde.rejectDrag();
        } else if ((dropAction & 3) == 0) {
            DnDUtils.debugPrintln("Drop target offering COPY");
            dtde.acceptDrag(1);
            acceptedDrag = true;
        } else {
            DnDUtils.debugPrintln("Drop target accepting drag");
            dtde.acceptDrag(dropAction);
            acceptedDrag = true;
        }
        return acceptedDrag;
    }

    protected void checkTransferType(DropTargetDragEvent dtde) {
        this.acceptableType = false;
        DataFlavor[] fl = dtde.getCurrentDataFlavors();
        if (this.mTransferHandler != null && this.mTransferHandler.canImport(this.pane, fl)) {
            this.acceptableType = true;
            this.targetFlavor = fl[0];
            return;
        }
        for (int i = 0; i < fl.length; ++i) {
            Class<?> dataClass = fl[i].getRepresentationClass();
            if (!G2dGlyph.class.isAssignableFrom(dataClass)) continue;
            this.targetFlavor = fl[i];
            this.acceptableType = true;
            break;
        }
        if (!this.acceptableType) {
            System.out.println("NOT ACCEPTABLE");
        }
        DnDUtils.debugPrintln("File type acceptable - " + this.acceptableType);
    }

    protected boolean dropComponent(Transferable transferable) throws IOException, UnsupportedFlavorException {
        Object o = transferable.getTransferData(this.targetFlavor);
        if (o instanceof Component) {
            DnDUtils.debugPrintln("Dragged component class is " + o.getClass().getName());
            this.pane.add((Component)o);
            this.pane.validate();
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame("Component drop target example");
        JPanel pane = new JPanel();
        PanelDropTarget target = new PanelDropTarget(pane);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        f.getContentPane().add((Component)new JScrollPane(pane), "Center");
        f.setSize(500, 400);
        f.setVisible(true);
    }
}

