/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.PlotIconBase;
import hec.gfx2d.Symbol;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.util.List;
import java.util.Vector;

public class PlotIcon
extends PlotIconBase {
    public Insets margins = new Insets(2, 2, 2, 2);
    public int lineThickness = 1;
    public Vector _curveColors = new Vector();
    protected Vector _xData = null;
    protected Vector _yData = null;
    protected Vector _xCurve = null;
    protected Vector _yCurve = null;
    protected Vector _sizes = null;
    private boolean _drawPoints;
    private int _pointSize;

    public PlotIcon() {
    }

    public PlotIcon(Dimension dim) {
        this.setSize(dim);
    }

    public PlotIcon(double[] x, double[] y) {
        this.setData(x, y);
    }

    public PlotIcon(int[] x, double[] y) {
        this.setData(x, y);
    }

    @Override
    public void addData(TimeSeriesContainer tsContainer) {
        if (tsContainer == null) {
            return;
        }
        super.addData(tsContainer);
        this.addData(tsContainer.times, tsContainer.values);
    }

    @Override
    public void setData(TimeSeriesContainer tsContainer) {
        if (tsContainer == null) {
            return;
        }
        this.clearData();
        this._dataContainerList = new Vector();
        this._dataContainerList.add(tsContainer);
        this.setData(tsContainer.times, tsContainer.values);
    }

    @Override
    public void addData(PairedDataContainer pdContainer) {
        if (pdContainer == null) {
            return;
        }
        super.addData(pdContainer);
        this.addData(pdContainer.xOrdinates, pdContainer.yOrdinates[0]);
    }

    @Override
    public void setData(PairedDataContainer pdContainer) {
        if (pdContainer == null) {
            return;
        }
        this._dataContainerList = new Vector();
        this._dataContainerList.add(pdContainer);
        this.setData(pdContainer.xOrdinates, pdContainer.yOrdinates[0]);
    }

    public void setData(double[] x, double[] y) {
        if (x == null || y == null) {
            return;
        }
        this._sizes = null;
        this._xData = null;
        this._yData = null;
        this.addData(x, y);
    }

    public void setData(int[] x, double[] y) {
        if (x == null || y == null) {
            return;
        }
        double[] xData = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xData[i] = x[i];
        }
        double[] yData = this._cumulativeInterval == -1 ? y : this.accumulate(x, y);
        this.setData(xData, yData);
    }

    public void addData(double[] x, double[] y) {
        if (x == null || y == null) {
            return;
        }
        this._sizes = null;
        if (this._xData == null || this._yData == null) {
            this._xData = new Vector();
            this._yData = new Vector();
        }
        this._xData.addElement(new doubleArrayContainer(x));
        this._yData.addElement(new doubleArrayContainer(y));
    }

    public void addData(int[] x, double[] y) {
        if (x == null || y == null) {
            return;
        }
        double[] xData = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xData[i] = x[i];
        }
        double[] yData = this._cumulativeInterval == -1 ? y : this.accumulate(x, y);
        this.addData(xData, yData);
    }

    public void setData(Vector x, Vector y) {
        this._sizes = null;
        if (x.size() != y.size()) {
            return;
        }
        this._xData = new Vector();
        this._yData = new Vector();
        for (int i = 0; i < x.size(); ++i) {
            Object yData = y.elementAt(i);
            if (!(yData instanceof doubleArrayContainer)) {
                this._yData = null;
                return;
            }
            this._yData.addElement(yData);
            Object xData = x.elementAt(i);
            if (xData instanceof doubleArrayContainer) {
                this._xData.addElement(xData);
                continue;
            }
            if (xData instanceof intArrayContainer) {
                intArrayContainer iac = (intArrayContainer)xData;
                double[] xarray = new double[iac.length];
                for (int j = 0; j < xarray.length; ++j) {
                    xarray[j] = iac.array[j];
                }
                this._xData.addElement(new doubleArrayContainer(xarray));
                continue;
            }
            this._yData = null;
            return;
        }
    }

    public void setColors(Vector colors) {
        this._sizes = null;
        this._curveColors = colors;
    }

    public Vector getColors() {
        return this._curveColors;
    }

    @Override
    public void clearData() {
        super.clearData();
        this._sizes = null;
        this._xData = null;
        this._yData = null;
        this._xCurve = null;
        this._yCurve = null;
        this._dataContainerList = null;
    }

    @Override
    public List getDataContainerList() {
        return this._dataContainerList;
    }

    public Vector getXDataVector() {
        return this._xData;
    }

    public Vector getYDataVector() {
        return this._yData;
    }

    public boolean isDrawingPoints() {
        return this._drawPoints;
    }

    public void setDrawPoints(boolean drawpoints) {
        this._drawPoints = drawpoints;
    }

    public int getPointSize() {
        return this._pointSize;
    }

    public void setPointSize(int pointSize) {
        this._pointSize = pointSize;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke originalStroke = g2.getStroke();
        this.paintPlotIcon(c2, g2, x, y);
        g2.setStroke(originalStroke);
    }

    protected void paintPlotIcon(Component c2, Graphics2D g2, int x, int y) {
        BasicStroke s = new BasicStroke(this.lineThickness, 0, 2);
        g2.setStroke(s);
        Dimension dim = this._fixedDimension != null ? this._fixedDimension : c2.size();
        if (this._sizes == null || dim.height != this._dimension.height || dim.width != this._dimension.width || x != this._xLoc || y != this._yLoc) {
            this._dimension = dim;
            this._xLoc = x;
            this._yLoc = y;
            this.computeCurve();
        }
        if (this._sizes != null) {
            g2.setBackground(this._backgroundColor);
            g2.clearRect(x, y, this._dimension.width, this._dimension.height);
            for (int i = 0; i < this._sizes.size(); ++i) {
                int size = (Integer)this._sizes.elementAt(i);
                if (size <= 1) continue;
                Color curveColor = (Color)this._curveColors.elementAt(i);
                g2.setColor(curveColor);
                int[] xCurve = ((intArrayContainer)this._xCurve.elementAt((int)i)).array;
                int[] yCurve = ((intArrayContainer)this._yCurve.elementAt((int)i)).array;
                if (this._drawPoints) {
                    for (int p = 0; p < xCurve.length; ++p) {
                        Symbol.draw(g2, xCurve[p], yCurve[p], 1, curveColor, curveColor, this._pointSize);
                    }
                    continue;
                }
                g2.drawPolyline(xCurve, yCurve, size);
            }
        } else {
            g2.setBackground(this._noDataColor);
            if (this._dimension.height > 0) {
                g2.clearRect(x, y, this._dimension.width, this._dimension.height);
            }
        }
    }

    protected void computeCurve() {
        double[] xData;
        double[] yData;
        int j;
        if (this._yData == null) {
            return;
        }
        double dataMinX = 3.4028234663852886E38;
        double dataMaxX = -3.4028234663852886E38;
        double dataMinY = 3.4028234663852886E38;
        double dataMaxY = -3.4028234663852886E38;
        this._xCurve = new Vector();
        this._yCurve = new Vector();
        this._sizes = new Vector();
        for (j = 0; j < this._yData.size(); ++j) {
            yData = ((doubleArrayContainer)this._yData.elementAt((int)j)).array;
            xData = ((doubleArrayContainer)this._xData.elementAt((int)j)).array;
            for (int i = 0; i < yData.length; ++i) {
                if (xData[i] == -3.4028234663852886E38 || yData[i] == -3.4028234663852886E38) continue;
                if (xData[i] < dataMinX) {
                    dataMinX = xData[i];
                }
                if (xData[i] > dataMaxX) {
                    dataMaxX = xData[i];
                }
                if (yData[i] < dataMinY) {
                    dataMinY = yData[i];
                }
                if (!(yData[i] > dataMaxY)) continue;
                dataMaxY = yData[i];
            }
        }
        if (this._minXSet != -3.4028234663852886E38 && this._minXSet < dataMinX) {
            dataMinX = this._minXSet;
        }
        if (this._maxXSet != -3.4028234663852886E38 && this._maxXSet > dataMaxX) {
            dataMaxX = this._maxXSet;
        }
        if (this._minYSet != -3.4028234663852886E38 && this._minYSet < dataMinY) {
            dataMinY = this._minYSet;
        }
        if (this._maxYSet != -3.4028234663852886E38 && this._maxYSet > dataMaxY) {
            dataMaxY = this._maxYSet;
        }
        if (dataMinY == dataMaxY) {
            dataMinY -= 1.0;
            dataMaxY += 1.0;
        }
        for (j = 0; j < this._yData.size(); ++j) {
            if (this._curveColors.size() <= j) {
                this._curveColors.add(Color.black);
            }
            yData = ((doubleArrayContainer)this._yData.elementAt((int)j)).array;
            xData = ((doubleArrayContainer)this._xData.elementAt((int)j)).array;
            int[] xCurve = new int[yData.length];
            int[] yCurve = new int[yData.length];
            double diffDataX = dataMaxX - dataMinX;
            double diffDataY = dataMaxY - dataMinY;
            double totalWidth = (double)this._dimension.width - (double)(this.margins.left + this.margins.right);
            double totalHeight = (double)this._dimension.height - (double)(this.margins.top + this.margins.bottom);
            int count = 0;
            for (int i = 0; i < yData.length; ++i) {
                if (xData[i] == -3.4028234663852886E38 || yData[i] == -3.4028234663852886E38) continue;
                double x = (xData[i] - dataMinX) / diffDataX * totalWidth;
                xCurve[count] = (int)(x + 0.5) + this.margins.left + this._xLoc;
                double y = (yData[i] - dataMinY) / diffDataY * totalHeight;
                yCurve[count] = (int)(totalHeight - (y + 0.5)) + this.margins.top + this._yLoc;
                if (count > 0 && xCurve[count] == xCurve[count - 1] && yCurve[count] == yCurve[count - 1]) {
                    --count;
                }
                ++count;
            }
            if (count == 0) {
                yCurve = new int[1];
                xCurve = new int[1];
            }
            this._xCurve.add(new intArrayContainer(xCurve));
            this._yCurve.add(new intArrayContainer(yCurve));
            this._sizes.add(new Integer(count));
        }
    }
}

