/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalRect;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.model.TsDataSetName;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PlotIconBase
extends ImageIcon {
    public int _accumulationType = 0;
    public int _cumulativeInterval = -1;
    public Color _backgroundColor = new Color(234, 234, 234);
    public Color _noDataColor = Color.gray;
    public Color _borderColor = Color.black;
    public static final double UNDEFINED_MAX = -3.4028234663852886E38;
    public static final double UNDEFINED_MIN = 3.4028234663852886E38;
    public static final double UNDEFINED = -3.4028234663852886E38;
    protected int _size = 0;
    protected int _xLoc = 0;
    protected int _yLoc = 0;
    protected Dimension _dimension = new Dimension(40, 60);
    protected Dimension _fixedDimension = null;
    protected Vector _dataSetNames = new Vector();
    protected boolean _selected = false;
    protected double _minXSet = -3.4028234663852886E38;
    protected double _maxXSet = -3.4028234663852886E38;
    protected double _minYSet = -3.4028234663852886E38;
    protected double _maxYSet = -3.4028234663852886E38;
    protected List _dataContainerList = null;

    public void setSize(Dimension dim) {
        this._fixedDimension = dim;
        this._dimension = new Dimension(dim);
    }

    public void setDataSetName(String name) {
        this._dataSetNames = new Vector();
        this._dataSetNames.add(name);
    }

    public void setDataSetNames(Vector names) {
        this._dataSetNames = names;
    }

    public void setTsDataSetNames(Vector names) {
        this._dataSetNames = new Vector();
        for (int i = 0; i < names.size(); ++i) {
            TsDataSetName dsn = (TsDataSetName)names.elementAt(i);
            if (dsn.fromOracle()) {
                this._dataSetNames.addElement(dsn.oracleName());
                continue;
            }
            this._dataSetNames.addElement(dsn.combinedPathAndFilename());
        }
    }

    public String getDataSetName() {
        if (this._dataSetNames != null && this._dataSetNames.size() > 0) {
            return (String)this._dataSetNames.elementAt(0);
        }
        return null;
    }

    public Vector getDataSetNames() {
        return this._dataSetNames;
    }

    protected void setCumulative(int cumulativeInterval, int accumulationType) {
        this._cumulativeInterval = cumulativeInterval;
        this._accumulationType = accumulationType;
        if (this._cumulativeInterval >= 0) {
            this._borderColor = new Color(0, 0, 150);
        }
    }

    protected int getCumulativeInterval() {
        return this._cumulativeInterval;
    }

    protected double[] accumulate(int[] times, double[] values) {
        if (this._cumulativeInterval == -1) {
            return values;
        }
        if (values == null || values.length == 0) {
            return new double[0];
        }
        int numberMissing = 0;
        double[] vals = new double[values.length];
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int begPos = 0;
        int cumInterval = this._cumulativeInterval;
        if (cumInterval == 0) {
            cumInterval = times[times.length - 1] - times[0] + 1;
        }
        double previousValue = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != -3.4028234663852886E38) {
                vals[i] = previousValue + values[i];
                if (values[i] < min) {
                    min = values[i];
                }
                if (values[i] > max) {
                    max = values[i];
                }
            } else {
                vals[i] = previousValue;
                ++numberMissing;
            }
            previousValue = vals[i];
            int interval = begPos > 0 ? times[i] - times[begPos - 1] : times[i] - times[0] + (times[1] - times[0]);
            if (interval < cumInterval && i != values.length - 1) continue;
            if (this._accumulationType != 0) {
                if (this._accumulationType == 1) {
                    for (int j = begPos; j <= i; ++j) {
                        vals[j] = vals[i];
                    }
                } else if (this._accumulationType == 2) {
                    for (int j = begPos; j <= i; ++j) {
                        vals[j] = min;
                    }
                } else if (this._accumulationType == 3) {
                    for (int j = begPos; j <= i; ++j) {
                        vals[j] = max;
                    }
                } else if (this._accumulationType == 4) {
                    int numb = i - begPos + 1 - numberMissing;
                    double avg = numb > 0 ? vals[i] / (double)numb : values[i];
                    for (int j = begPos; j <= i; ++j) {
                        vals[j] = avg;
                    }
                } else if (this._accumulationType == 5) {
                    double last = -3.4028234663852886E38;
                    for (int k = i; k >= begPos; --k) {
                        if (values[k] == -3.4028234663852886E38) continue;
                        last = values[k];
                        break;
                    }
                    for (int j = begPos; j <= i; ++j) {
                        vals[j] = last;
                    }
                }
            }
            numberMissing = 0;
            begPos = i + 1;
            previousValue = 0.0;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
        }
        return vals;
    }

    public DataContainer getDataContainer(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (this._dataContainerList == null) {
            return null;
        }
        for (int i = 0; i < this._dataContainerList.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataContainerList.get(i);
            if (dc.fullName == null || !name.startsWith(dc.fullName)) continue;
            return dc;
        }
        return null;
    }

    public void setData(PairedDataContainer pdContainer) {
        if (pdContainer == null) {
            return;
        }
        this._dataContainerList = new Vector();
        this._dataContainerList.add(pdContainer);
    }

    public void setData(TimeSeriesContainer tsContainer) {
        if (tsContainer == null) {
            return;
        }
        this._dataContainerList = new Vector();
        this._dataContainerList.add(tsContainer);
    }

    public void addData(TimeSeriesContainer tsContainer) {
        if (tsContainer == null) {
            return;
        }
        if (tsContainer.times == null) {
            return;
        }
        if (this._dataContainerList == null) {
            this._dataContainerList = new Vector();
        }
        if (!this.hasData(tsContainer)) {
            this._dataContainerList.add(tsContainer);
        }
    }

    public void addData(PairedDataContainer pdContainer) {
        if (pdContainer == null) {
            return;
        }
        if (pdContainer.xOrdinates == null) {
            this.clearData();
            return;
        }
        if (this._dataContainerList == null) {
            this._dataContainerList = new Vector();
        }
        if (!this.hasData(pdContainer)) {
            this._dataContainerList.add(pdContainer);
        }
    }

    public boolean hasData(DataContainer dataContainer) {
        if (this._dataContainerList == null || this._dataContainerList.size() == 0) {
            return false;
        }
        for (int i = 0; i < this._dataContainerList.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataContainerList.get(i);
            if (!dataContainer.fullName.equalsIgnoreCase(dc.fullName)) continue;
            return true;
        }
        return false;
    }

    public void setColorSettings(String settings) {
    }

    public String getColorSettings() {
        return null;
    }

    public void clearData() {
        this._dataContainerList = null;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public void setXLimits(int minX, int maxX) {
        this._minXSet = minX;
        this._maxXSet = maxX;
    }

    public void setXLimits(double minX, double maxX) {
        this._minXSet = minX;
        this._maxXSet = maxX;
    }

    public void setYLimits(double minY, double maxY) {
        this._minYSet = minY;
        this._maxYSet = maxY;
    }

    @Override
    public int getIconWidth() {
        if (this._fixedDimension != null) {
            return this._fixedDimension.width;
        }
        return this._dimension.width;
    }

    @Override
    public int getIconHeight() {
        if (this._fixedDimension != null) {
            return this._fixedDimension.height;
        }
        return this._dimension.height;
    }

    public LocalRect getRectangle() {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        LocalRect rect = new LocalRect();
        rect.l = -(w / 2);
        rect.r = w + rect.l;
        rect.t = -(h / 2);
        rect.b = h + rect.t;
        return rect;
    }

    public List getDataContainerList() {
        return this._dataContainerList;
    }

    public void setDataContainerList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof TimeSeriesContainer) {
                this.addData((TimeSeriesContainer)o);
                continue;
            }
            if (!(o instanceof PairedDataContainer)) continue;
            this.addData((PairedDataContainer)o);
        }
    }

    public Vector[] getLastValue() {
        Vector[] info = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector()};
        if (this._dataContainerList == null || this._dataContainerList.size() == 0) {
            return info;
        }
        block0: for (int i = 0; i < this._dataContainerList.size(); ++i) {
            DataContainer dc = (DataContainer)this._dataContainerList.get(i);
            info[2].add(dc.location);
            if (dc instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
                info[3].add(tsc.parameter);
                HecDouble lastValue = new HecDouble();
                info[0].add(lastValue);
                HecTime lastTime = new HecTime();
                info[1].add(lastTime);
                for (int j = tsc.values.length - 1; j >= 0; --j) {
                    if (tsc.values[j] == -3.4028234663852886E38) continue;
                    lastValue.set(tsc.values[j], tsc.precision);
                    lastTime.set(tsc.times[j]);
                    continue block0;
                }
                continue;
            }
            if (!(dc instanceof PairedDataContainer)) continue;
            PairedDataContainer pdc = (PairedDataContainer)dc;
            info[3].add(pdc.xparameter + " - " + pdc.yparameter);
            HecDouble lastXValue = new HecDouble(pdc.xOrdinates[pdc.xOrdinates.length - 1], pdc.xprecision);
            info[0].add(lastXValue);
            info[1].add(new HecTime());
        }
        return info;
    }
}

