/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.ViewportLayout;
import hec.gfx2d.ViewportToolbarProp;
import java.util.List;
import java.util.Vector;

public class PlotLayout {
    boolean m_hasToolBar = true;
    boolean m_hasLegend = true;
    List<ViewportLayout> m_viewportList = new Vector<ViewportLayout>();
    List<Double> m_viewWeightList = new Vector<Double>();
    String m_title;
    private ViewportToolbarProp _viewportToolbarProperties = null;

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setToolbarProperties(ViewportToolbarProp properties) {
        this._viewportToolbarProperties = properties;
    }

    public ViewportToolbarProp getToolbarProperties() {
        return this._viewportToolbarProperties;
    }

    public void setToolbarOn() {
        this.setHasToolbar(true);
    }

    public void setToolbarOff() {
        this.setHasToolbar(false);
    }

    public void setHasToolbar(boolean b) {
        this.m_hasToolBar = b;
    }

    public boolean hasToolbar() {
        return this.m_hasToolBar;
    }

    public void setHasLegendOn() {
        this.setHasLegend(true);
    }

    public void setHasLegendOff() {
        this.setHasLegend(false);
    }

    public void setHasLegend(boolean b) {
        this.m_hasLegend = b;
    }

    public boolean hasLegend() {
        return this.m_hasLegend;
    }

    public ViewportLayout addViewport() {
        return this.addViewport(100.0);
    }

    public ViewportLayout addViewport(double weight) {
        ViewportLayout view = new ViewportLayout();
        this.m_viewWeightList.add(new Double(weight));
        this.m_viewportList.add(view);
        return view;
    }

    public void addViewport(ViewportLayout viewport, double weight) {
        if (viewport == null) {
            return;
        }
        if (this.m_viewportList.contains(viewport)) {
            return;
        }
        this.m_viewportList.add(viewport);
        this.m_viewWeightList.add(weight);
    }

    public double[] getViewportWeights() {
        double[] weights = new double[this.m_viewWeightList.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.m_viewWeightList.get(i);
        }
        return weights;
    }

    public List<ViewportLayout> getViewports() {
        return this.m_viewportList;
    }

    public int getViewportCount() {
        return this.m_viewportList.size();
    }

    public boolean removeViewport(ViewportLayout vLayout) {
        int idx = this.m_viewportList.indexOf(vLayout);
        if (idx == -1) {
            return false;
        }
        if (this.m_viewportList.remove(vLayout)) {
            this.m_viewWeightList.remove(idx);
            return true;
        }
        return false;
    }

    public double getViewportWeight(ViewportLayout vLayout) {
        if (vLayout == null) {
            return -1.0;
        }
        int idx = this.m_viewportList.indexOf(vLayout);
        if (idx > -1) {
            return this.m_viewWeightList.get(idx);
        }
        return -1.0;
    }
}

