/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.geometry.Axis;
import hec.geometry.AxisProp;
import hec.geometry.ScaleProperties;
import hec.geometry.TSAxis;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dAxisLabelPropertiesPanel;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dGridPropertiesPanel;
import hec.gfx2d.G2dLineMarkerPropertiesPanel;
import hec.gfx2d.G2dLinesPropPanel;
import hec.gfx2d.G2dMarkerLine;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dMarkerValueLabelPropertiesPanel;
import hec.gfx2d.G2dMiscPropertiesPanel;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dScalePropertiesPanel;
import hec.gfx2d.G2dTitlePropertiesPanel;
import hec.gfx2d.G2dViewportPropertiesPanel;
import hec.gfx2d.LegendPropertiesPanel;
import hec.gfx2d.ScalePropertiesPanel;
import hec.gfx2d.TsAxisScalePropertiesPanel;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportDrawProp;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;
import rma.util.RMAConst;

public class PlotPropertiesDialog
extends RmaJDialog
implements ItemListener {
    private boolean _canceled;
    private RmaJComboBox _viewPortcombo;
    private JTabbedPane _tabbedPane;
    private ButtonCmdPanel _cmdPanel;
    private G2dViewportPropertiesPanel _viewPortPanel;
    private G2dTitlePropertiesPanel _titlePanel;
    private G2dGridPropertiesPanel _gridPanel;
    private PropPanel _axisPanel;
    private G2dLinesPropPanel _curvesPanel;
    private PropPanel _markerPanel;
    private G2dMiscPropertiesPanel _miscPanel;
    private LegendPropertiesPanel _legendPanel;
    private G2dPanel _g2dPanel;

    public PlotPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Select Viewport:");
        label.setDisplayedMnemonic('S');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._viewPortcombo = new RmaJComboBox(new RmaListModel(true));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._viewPortcombo, gbc);
        this._tabbedPane = new JTabbedPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._tabbedPane, gbc);
        final G2dAxisLabelPropertiesPanel labelPanel = new G2dAxisLabelPropertiesPanel();
        final AxisScalePanel scalePanel = new AxisScalePanel();
        final G2dAxisPropertiesPanel ticsPanel = new G2dAxisPropertiesPanel();
        DefaultJPanel[] axisPanels = new DefaultJPanel[]{scalePanel, labelPanel, ticsPanel};
        this._axisPanel = new PropPanel(axisPanels, true, "Axis:"){
            private AxisTics.PropertiesOKListener _propListener;

            @Override
            protected void selecterComboDeselected() {
                labelPanel.savePanel();
                scalePanel.savePanel();
                ticsPanel.savePanel();
                if (this._propListener != null) {
                    this._propListener.actionPerformed(null);
                }
            }

            @Override
            protected void selecterComboSelected() {
                AxisContainer container = (AxisContainer)this._selecter.getSelectedItem();
                if (container == null) {
                    return;
                }
                AxisLabel label = container.label;
                AxisTics tics = container.tics;
                if (label != null) {
                    labelPanel.setData(label.getProperties());
                    labelPanel.setLabelText(label.getText());
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(labelPanel, true);
                } else {
                    labelPanel.setData(null);
                    labelPanel.setLabelText(null);
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(labelPanel, false);
                }
                if (tics != null) {
                    Axis axis = tics.getAxis();
                    this._propListener = tics.getPropertiesOKListener(scalePanel, labelPanel);
                    labelPanel.setParameterText(Parameter.getParamString(axis.getParameterId()));
                    AxisProp prop = axis.getAxisProp();
                    prop.max = axis.getMax();
                    prop.min = axis.getMin();
                    prop.minortic = axis.getMinorTic();
                    prop.majortic = axis.getMajorTic();
                    prop.actmax = axis.getActMax();
                    prop.actmin = axis.getActMin();
                    prop.isReversed = axis.getReversed();
                    prop.swapAxis = tics.getAxisSwapped();
                    prop.canSwapAxis = tics.getCanSwapAxis();
                    if (tics._alignment == 1 || tics._alignment == 0) {
                        prop.isReversed = !prop.isReversed;
                    }
                    prop.isDefaultLimits = false;
                    scalePanel.selectAxisPanel(axis);
                    scalePanel.setData(prop);
                    ticsPanel.setData(tics.getProperties());
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(scalePanel, true);
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(ticsPanel, true);
                } else {
                    ticsPanel.setData(null);
                    scalePanel.setData(null);
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(scalePanel, false);
                    PlotPropertiesDialog.this._axisPanel.setTabEnabled(ticsPanel, false);
                }
                labelPanel.fillPanel();
                scalePanel.fillPanel();
                ticsPanel.fillPanel();
            }

            @Override
            public boolean savePanel() {
                AxisContainer container = (AxisContainer)this._selecter.getSelectedItem();
                if (container == null) {
                    return true;
                }
                AxisLabel label = container.label;
                AxisTics tics = container.tics;
                if (tics != null) {
                    Axis axis = tics.getAxis();
                    axis.setLabel(labelPanel.getLabelText());
                }
                labelPanel.savePanel();
                scalePanel.savePanel();
                ticsPanel.savePanel();
                if (this._propListener != null) {
                    this._propListener.actionPerformed(null);
                }
                return true;
            }
        };
        this._axisPanel.setName("Axis");
        this._curvesPanel = new G2dLinesPropPanel();
        final G2dLineMarkerPropertiesPanel linePanel = new G2dLineMarkerPropertiesPanel();
        DefaultJPanel[] markerPanels = new DefaultJPanel[]{linePanel};
        this._markerPanel = new PropPanel(markerPanels, true, "Marker Lines:"){
            private Vector _propsVector;
            private Vector _markerLines;
            {
                super(panels, hasSelecter, selecterLabel);
                this._propsVector = new Vector();
                this._markerLines = new Vector();
            }

            @Override
            public void setData(Vector viewports) {
                this._propsVector.clear();
                this._markerLines.clear();
                if (viewports.size() == 0) {
                    return;
                }
                Viewport view = (Viewport)viewports.elementAt(0);
                Vector<G2dMarkerLine> markerLines = view._markerLines;
                for (int j = 0; j < markerLines.size(); ++j) {
                    G2dMarkerLine line = markerLines.get(j);
                    if (this._markerLines.contains(line)) continue;
                    this._markerLines.add(line);
                    this._propsVector.add(line.getProperties().clone());
                }
                if (this._markerLines.size() == 0) {
                    linePanel.clearPanel();
                }
                super.setData(this._markerLines);
            }

            @Override
            protected void selecterComboDeselected() {
                linePanel.savePanel();
            }

            @Override
            protected void selecterComboSelected() {
                G2dMarkerLine line;
                int idx = this._selecter.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                G2dMarkerProperties props = (G2dMarkerProperties)this._propsVector.get(idx);
                int axisType = G2dMarkerValueLabelPropertiesPanel.NUMERIC_AXIS;
                if (props.drawOnAxis == 0 && (line = (G2dMarkerLine)this._selecter.getSelectedItem()) != null && line.getScale().getAxis(0) instanceof TSAxis) {
                    axisType = G2dMarkerValueLabelPropertiesPanel.TIME_AXIS;
                }
                linePanel.setAxisType(axisType);
                line = (G2dMarkerLine)this._selecter.getSelectedItem();
                SimpleTimeZone tz = line.getScale().getGmtOffset() != Integer.MIN_VALUE ? new SimpleTimeZone(line.getScale().getGmtOffset() * 1000 * 60 * 60, "Marker Time Zone") : null;
                linePanel.setData(props, tz);
                linePanel.fillPanel();
            }

            @Override
            public boolean savePanel() {
                linePanel.savePanel();
                for (int i = 0; i < this._markerLines.size(); ++i) {
                    G2dMarkerLine markerLine = (G2dMarkerLine)this._markerLines.get(i);
                    G2dMarkerProperties props = (G2dMarkerProperties)this._propsVector.get(i);
                    markerLine.setProperties(props);
                }
                return true;
            }
        };
        this._viewPortPanel = new G2dViewportPropertiesPanel();
        this._titlePanel = new G2dTitlePropertiesPanel();
        this._gridPanel = new G2dGridPropertiesPanel();
        this._miscPanel = new G2dMiscPropertiesPanel();
        this._legendPanel = new LegendPropertiesPanel();
        this._tabbedPane.addTab(this._curvesPanel.getName(), this._curvesPanel);
        this._tabbedPane.addTab("Viewport", this._viewPortPanel);
        this._tabbedPane.addTab("Title", this._titlePanel);
        this._tabbedPane.addTab(this._axisPanel.getName(), this._axisPanel);
        this._tabbedPane.addTab("Legend", this._legendPanel);
        this._tabbedPane.addTab("Marker Lines", this._markerPanel);
        this._tabbedPane.addTab("Layout", this._miscPanel);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!PlotPropertiesDialog.this.saveForm()) break;
                        PlotPropertiesDialog.this._canceled = false;
                        PlotPropertiesDialog.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        PlotPropertiesDialog.this.saveForm();
                        break;
                    }
                    case 4: {
                        PlotPropertiesDialog.this._canceled = true;
                        PlotPropertiesDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._viewPortcombo.addItemListener(this);
        this._tabbedPane.setEnabledAt(0, false);
        this._tabbedPane.setEnabledAt(2, false);
        this._tabbedPane.setEnabledAt(3, false);
        this._tabbedPane.setEnabledAt(4, false);
        this._tabbedPane.setEnabledAt(6, false);
        this.pack();
        this.setLocation();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj == this._viewPortcombo) {
            if (e.getStateChange() == 2) {
                this.viewPortComboDeselected((Viewport)e.getItem());
            } else {
                this.viewPortComboSelected();
            }
        }
    }

    Viewport getSelectedViewport() {
        return (Viewport)this._viewPortcombo.getSelectedItem();
    }

    void viewPortComboDeselected(Viewport viewport) {
        if (viewport == null) {
            return;
        }
        if (this.isModified()) {
            int opt = JOptionPane.showConfirmDialog(this, "Properties have changed for " + viewport + "\nSave Changes?", "Save Changes", 0);
            if (opt == 1) {
                this.setModified(false);
                return;
            }
            this.saveForm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewPortComboSelected() {
        Viewport viewport = this.getSelectedViewport();
        if (viewport == null) {
            this._tabbedPane.setEnabledAt(0, false);
            this._tabbedPane.setEnabledAt(2, false);
            this._tabbedPane.setEnabledAt(3, false);
            this._tabbedPane.setEnabledAt(4, false);
            this._tabbedPane.setEnabledAt(5, false);
            this._tabbedPane.setEnabledAt(6, false);
            return;
        }
        this.setIgnoreModifiedEvents(true);
        try {
            this._tabbedPane.setEnabledAt(0, true);
            this._tabbedPane.setEnabledAt(2, true);
            this._tabbedPane.setEnabledAt(3, true);
            this._tabbedPane.setEnabledAt(4, true);
            this._tabbedPane.setEnabledAt(5, true);
            this._tabbedPane.setEnabledAt(6, true);
            G2dPanelProp g2dPanelProperties = this._g2dPanel.getProperties();
            ViewportDrawProp vdp = viewport.getProperties();
            this._miscPanel.setData(this._g2dPanel);
            if (this._legendPanel != null && this._g2dPanel._legend != null) {
                this._legendPanel.setData(this._g2dPanel._legend.getProperties());
            }
            this._curvesPanel.setLegendPanel(this._g2dPanel.getLegendPanel());
            this._gridPanel.setData(vdp);
            this._viewPortPanel.setData(vdp);
            Vector v = viewport.getGlyphVector();
            this._curvesPanel.setGlyphVector(v);
            Vector<Viewport> viewports = new Vector<Viewport>();
            viewports.add(viewport);
            this._markerPanel.setData(viewports);
            this._tabbedPane.setEnabledAt(5, this._markerPanel.getSelecterItemCount() > 0);
            Vector<AxisContainer> axisContainers = new Vector<AxisContainer>(4);
            for (int axis = 0; axis <= 3; ++axis) {
                AxisLabel al = this._g2dPanel.getViewportAxisLabel(viewport, axis);
                AxisTics at = this._g2dPanel.getViewportAxisTics(viewport, axis);
                if (al == null && at == null) continue;
                AxisContainer container = new AxisContainer(axis);
                container.axis = axis;
                container.label = al;
                container.tics = at;
                axisContainers.add(container);
            }
            this._axisPanel.setData(axisContainers);
            this._gridPanel.fillPanel();
            this._viewPortPanel.fillPanel();
            this._curvesPanel.fillPanel();
            this._axisPanel.fillPanel();
            this._miscPanel.fillPanel();
            this._legendPanel.fillPanel();
        }
        finally {
            this.setIgnoreModifiedEvents(false);
            this.setModified(false);
        }
    }

    public void setG2dPanel(G2dPanel gfxPanel) {
        if (gfxPanel == null) {
            return;
        }
        this._g2dPanel = gfxPanel;
        Viewport[] viewports = this._g2dPanel.getViewports();
        ((RmaListModel)this._viewPortcombo.getModel()).setAll(viewports);
        if (this._g2dPanel._title != null) {
            this._titlePanel.setData(this._g2dPanel._title.getTitleProperties());
            this._titlePanel.fillPanel();
        }
        int idx = viewports != null && viewports.length > 0 ? 0 : -1;
        this._viewPortcombo.setSelectedIndex(idx);
        this.setModified(false);
    }

    protected boolean saveForm() {
        this._gridPanel.savePanel();
        this._markerPanel.savePanel();
        this._viewPortPanel.savePanel();
        this._curvesPanel.savePanel();
        this._axisPanel.savePanel();
        this._miscPanel.savePanel();
        Window w = SwingUtilities.windowForComponent(this);
        if (w != null) {
            Dimension d = w.getSize();
            if (RMAConst.isValidValue(this._miscPanel._panelProperties.dialogWidth)) {
                d.width = this._miscPanel._panelProperties.dialogWidth;
            }
            if (RMAConst.isValidValue(this._miscPanel._panelProperties.dialogHeight)) {
                d.height = this._miscPanel._panelProperties.dialogHeight;
            }
            w.setSize(d);
        }
        this._g2dPanel._panelProperties.setViewportSpaceSize(this._miscPanel._panelProperties.viewportSpaceSize);
        this._g2dPanel.setHorizontalViewportSpacing(this._miscPanel._panelProperties.viewportSpaceSize);
        if (this._g2dPanel._title != null) {
            this._titlePanel.savePanel();
            this._g2dPanel._title.setProperties(this._titlePanel.getProperties());
            this._g2dPanel._title.repaint();
        }
        if (this._g2dPanel._legend != null) {
            this._legendPanel.savePanel();
            this._g2dPanel._legend._glyphVector.clear();
            this._g2dPanel._legend._viewportVector.clear();
            this._g2dPanel._legend._itemContainer.removeAllItems();
            Vector viewportVector = this._g2dPanel._viewportVector;
            this._g2dPanel._legend.removeAll();
            this._g2dPanel._legend.setProperties(this._legendPanel.getProperties());
            this._g2dPanel._legend.buildDefaultComponents(this._legendPanel.getProperties());
            Enumeration ev = viewportVector.elements();
            while (ev.hasMoreElements()) {
                this._g2dPanel._legend.addViewport((Viewport)ev.nextElement());
            }
            this._g2dPanel._legend._itemContainer.resetConstraints();
            int idx = this._g2dPanel._legend._legendPosition;
            switch (idx) {
                case 0: {
                    this._g2dPanel.moveLegendToPosition(0);
                    break;
                }
                case 1: {
                    this._g2dPanel.moveLegendToPosition(1);
                    break;
                }
                case 5: {
                    this._g2dPanel.moveLegendToPosition(5);
                    break;
                }
                case 6: {
                    this._g2dPanel.moveLegendToPosition(6);
                    break;
                }
                case 7: {
                    this._g2dPanel.moveLegendToPosition(7);
                }
            }
            this._g2dPanel.setLegendVisible(this._g2dPanel._legend._properties.legendVisible);
        }
        if (this._g2dPanel.getLegendPanel() != null) {
            this._g2dPanel.getLegendPanel().refreshLegendItems();
        }
        this._g2dPanel.revalidate();
        this._g2dPanel.paintGfx();
        this.setModified(false);
        return true;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new PlotPropertiesDialog(null, false).setVisible(true);
    }

    class AxisScalePanel
    extends DefaultJPanel
    implements ScalePropertiesPanel {
        private static final String TS_AXIS = "TS";
        private static final String LINEAR_AXIS = "LINEAR";
        private JPanel axisPanelContainer = new JPanel(new CardLayout());
        private TsAxisScalePropertiesPanel tsScalePanel = new TsAxisScalePropertiesPanel();
        private G2dScalePropertiesPanel axisPanel = new G2dScalePropertiesPanel();
        private ScalePropertiesPanel currentPanel;

        public AxisScalePanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.axisPanelContainer, "Center");
            this.axisPanelContainer.add((Component)this.tsScalePanel, TS_AXIS);
            this.axisPanelContainer.add((Component)this.axisPanel, LINEAR_AXIS);
            ((CardLayout)this.axisPanelContainer.getLayout()).show(this.axisPanelContainer, LINEAR_AXIS);
            this.currentPanel = this.axisPanel;
        }

        public void selectAxisPanel(Axis axis) {
            if (axis instanceof TSAxis) {
                ((CardLayout)this.axisPanelContainer.getLayout()).show(this.axisPanelContainer, TS_AXIS);
                this.currentPanel = this.tsScalePanel;
            } else {
                ((CardLayout)this.axisPanelContainer.getLayout()).show(this.axisPanelContainer, LINEAR_AXIS);
                this.currentPanel = this.axisPanel;
            }
        }

        @Override
        public void refresh() {
            this.currentPanel.refresh();
        }

        @Override
        public void setData(ScaleProperties prop) {
            this.currentPanel.setData(prop);
        }

        @Override
        public ScaleProperties getData() {
            return this.currentPanel.getData();
        }

        @Override
        public void fillPanel() {
            this.currentPanel.fillPanel();
        }

        @Override
        public boolean savePanel() {
            return this.currentPanel.savePanel();
        }

        @Override
        public String getName() {
            return ((DefaultJPanel)((Object)this.currentPanel)).getName();
        }
    }

    private class PropPanel
    extends DefaultJPanel
    implements ItemListener {
        private JTabbedPane _tabPane;
        protected RmaJComboBox _selecter;

        PropPanel(DefaultJPanel[] panels, boolean hasSelecter, String selecterLabel) {
            this.buildControls(panels, hasSelecter, selecterLabel);
        }

        protected void buildControls(DefaultJPanel[] panels, boolean hasSelecter, String selecterLabel) {
            GridBagConstraints gbc;
            this.setLayout(new GridBagLayout());
            int gridY = 0;
            if (hasSelecter) {
                JLabel label = new JLabel(selecterLabel);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridY;
                gbc.gridwidth = 1;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)label, gbc);
                this._selecter = new RmaJComboBox(new RmaListModel(false));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = gridY++;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.insets(5, 5, 0, 5);
                this.add((Component)this._selecter, gbc);
                this._selecter.addItemListener(this);
            }
            this._tabPane = new JTabbedPane();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridY;
            gbc.gridwidth = gridY + 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.add((Component)this._tabPane, gbc);
            for (int i = 0; i < panels.length; ++i) {
                this._tabPane.addTab(panels[i].getName(), panels[i]);
                panels[i].setEnabled(false);
            }
        }

        void setTabEnabled(Component c2, boolean enabled) {
            for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
                Component tab = this._tabPane.getComponentAt(i);
                if (tab != c2) continue;
                this._tabPane.setEnabledAt(i, enabled);
                c2.setEnabled(enabled);
                if (this._tabPane.getSelectedIndex() != i) continue;
                if (enabled) {
                    return;
                }
                while (!this._tabPane.isEnabledAt(i)) {
                    i = (i + 1) % this._tabPane.getTabCount();
                }
                this._tabPane.setSelectedIndex(i);
                break;
            }
        }

        void setData(Vector items) {
            if (this._selecter == null) {
                return;
            }
            ((RmaListModel)this._selecter.getModel()).clear();
            ((RmaListModel)this._selecter.getModel()).addAll(items);
            if (items.size() > 0) {
                this._selecter.setSelectedIndex(-1);
                this._selecter.setSelectedIndex(0);
            }
        }

        public int getSelecterItemCount() {
            return this._selecter.getModel().getSize();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this._selecter == null) {
                return;
            }
            if (e.getStateChange() == 2) {
                this.selecterComboDeselected();
            } else {
                this.setIgnoreModifiedEvents(true);
                if (this._selecter != null) {
                    boolean enabled = this._selecter.getSelectedItem() != null;
                    for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
                        this._tabPane.getComponentAt(i).setEnabled(enabled);
                    }
                }
                this.selecterComboSelected();
                this.setIgnoreModifiedEvents(false);
            }
        }

        protected void selecterComboSelected() {
        }

        protected void selecterComboDeselected() {
        }
    }

    class AxisContainer {
        private String[] axisToString = new String[]{"X1", "X2", "Y1", "Y2"};
        AxisLabel label;
        AxisTics tics;
        int axis;

        AxisContainer(int axis) {
            this.axis = axis;
        }

        public String toString() {
            return this.axisToString[this.axis];
        }
    }
}

