/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Interval;
import hec.geometry.Axis;
import hec.geometry.AxisProp;
import hec.geometry.Scale;
import hec.gfx2d.AxisMarkerDescription;
import hec.gfx2d.AxisTics;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerLine;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dTitle;
import hec.gfx2d.LegendItem;
import hec.gfx2d.LegendItemContainer;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PairedDataGlyph;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeSeriesGlyph;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.ViewportLayout;
import hec.gfx2d.ViewportLinkRecord;
import hec.heclib.dss.HecDss;
import hec.heclib.util.HecTime;
import hec.hecmath.DSSFile;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.Reflection;
import hec.util.TextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import rma.swing.RmaColor;
import rma.util.RmaDrawConst;

public class PlotSpecification {
    protected static final Pattern reXmlDuration = Pattern.compile("P((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+)S)?)?", 2);
    protected static final Pattern reHecDuration = Pattern.compile("(\\d+)(year|mon|day|hour|min)", 2);
    protected static final Pattern reXmlTime = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2})(:(\\d{2})([.]\\d+)?)?", 2);
    protected static final Pattern reXmlTimeZone = Pattern.compile("([-+]\\d{2}:\\d{2}|Z)", 2);
    protected static final Pattern reValidCurve = Pattern.compile("\\d,\\d,y\\d,\\d", 2);
    protected static final Logger logger = Logger.getLogger(PlotSpecification.class.getName());
    protected static final TimeZone tzUtc = TimeZone.getTimeZone("UTC");
    protected static final List<String> validUtcIds = new Vector<String>();
    protected static final Map<String, String[]> xmlTypeAttributes = new HashMap<String, String[]>();
    protected static final Map<String, String> xmlElementTypes = new HashMap<String, String>();
    protected static final Map<String, String> colorNames = new HashMap<String, String>();
    protected static final Map<float[], String> lineStyleNames = new HashMap<float[], String>();
    protected static final Map<String, float[]> lineStylePatterns = new HashMap<String, float[]>();
    protected static final Map<Integer, String> lineStepStyleNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> lineStepStyleNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> fillPatternNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> fillPatternNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> alignmentNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> alignmentNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> fillPositionNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> fillPositionNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> labelPositionNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> labelPositionNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> fontStyleNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> fontStyleNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> legendLocationNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> legendLocationNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> axisTypeNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> axisTypeNumbers = new HashMap<String, Integer>();
    protected static final Map<Integer, String> symbolTypeNames = new HashMap<Integer, String>();
    protected static final Map<String, Integer> symbolTypeNumbers = new HashMap<String, Integer>();
    protected static final Color[] lineColors = new Color[]{Color.blue, Color.red, Color.green.darker(), Color.darkGray, Color.magenta, Color.orange, Color.black};
    protected static final G2dLabelDrawProp defaultLabelProp = new G2dLabelDrawProp();
    protected static final G2dPanelProp defaultPanelProp = new G2dPanelProp();
    protected static final LegendPanelProp defaultLegendProp = new LegendPanelProp();
    protected static final ViewportDrawProp defaultViewportProp = new ViewportDrawProp();
    protected static final AxisProp defaultAxisProp = new AxisProp();
    protected static final AxisTicsDrawProp defaultAxisTicsProp = new AxisTicsDrawProp();
    protected static final G2dMarkerProperties defaultAxisMarkerProp = new G2dMarkerProperties();
    protected static final G2dLineProperties defaultLineProp = new G2dLineProperties();
    protected int lineColorIndex = 0;
    private boolean includeDefaults = false;
    private boolean includeData = false;
    private boolean includeDataReference = false;
    private boolean useCompactForm = true;
    private String indent = "    ";
    private TimeZone timeZone = null;
    private Map<String, String> curveData = new HashMap<String, String>();

    protected static boolean sameProperties(G2dLabelDrawProp prop1, G2dLabelDrawProp prop2) throws IOException {
        boolean same = false;
        if (prop1.getClass() == prop2.getClass()) {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            prop1.writeProperties(bw, "");
            bw.close();
            String str1 = sw.getBuffer().toString();
            sw = new StringWriter();
            bw = new BufferedWriter(sw);
            prop2.writeProperties(bw, "");
            bw.close();
            String str2 = sw.getBuffer().toString();
            same = str1.equals(str2);
        }
        return same;
    }

    public static String getXmlDuration(int start, int end) {
        return PlotSpecification.getXmlDurationFromMinutes(start, end);
    }

    public static String getXmlDuration(String hecDuration) {
        return PlotSpecification.getXmlDurationFromHecDuration(hecDuration);
    }

    public static String getHecDuration(String xmlDuration) {
        String hecDuration = null;
        Matcher m = reXmlDuration.matcher(xmlDuration);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid XML duration: " + xmlDuration);
        }
        int matched = 0;
        for (int i : Arrays.asList(1, 3, 5, 8, 10, 12)) {
            if (m.group(i) == null) continue;
            if (matched != 0) {
                throw new IllegalArgumentException("Cannot convert to HEC Duration: " + xmlDuration);
            }
            matched = i;
        }
        switch (matched) {
            case 1: {
                hecDuration = String.format("%sYEAR", m.group(2));
                break;
            }
            case 3: {
                hecDuration = String.format("%sMON", m.group(4));
                break;
            }
            case 5: {
                hecDuration = String.format("%sDAY", m.group(6));
                break;
            }
            case 8: {
                hecDuration = String.format("%sHOUR", m.group(9));
                break;
            }
            case 10: {
                hecDuration = String.format("%sMIN", m.group(11));
                break;
            }
            case 12: {
                throw new IllegalArgumentException("Cannot convert to HEC Duration: " + xmlDuration);
            }
            default: {
                throw new IllegalArgumentException("Invalid XML duration: " + xmlDuration);
            }
        }
        return hecDuration;
    }

    public static String getHecDuration(int minutes) {
        if (minutes >= 525600) {
            return String.format("%dYEAR", minutes / 1440 / 365);
        }
        if (minutes >= 43200) {
            return String.format("%dMON", minutes / 1440 / 30);
        }
        if (minutes >= 1440) {
            return String.format("%dDAY", minutes / 1440);
        }
        if (minutes >= 60) {
            return String.format("%dDAY", minutes / 60);
        }
        return String.format("%dMIN", minutes);
    }

    public static int getMinutes(String durationStr) {
        int minutes = Integer.MIN_VALUE;
        Matcher m = reHecDuration.matcher(durationStr);
        if (!m.matches() && !(m = reHecDuration.matcher(PlotSpecification.getHecDuration(durationStr))).matches()) {
            throw new IllegalArgumentException("Invalid HEC or XML duration: " + durationStr);
        }
        minutes = Integer.parseInt(m.group(1));
        String unit = m.group(2).toUpperCase();
        if (unit.equals("HOUR")) {
            minutes *= 60;
        } else if (unit.equals("DAY")) {
            minutes *= 1440;
        } else if (unit.equals("MON")) {
            minutes *= 43200;
        } else if (unit.equals("YEAR")) {
            minutes *= 525600;
        }
        return minutes;
    }

    public static HecTime addDuration(HecTime baseTime, String durationStr) {
        Matcher m = reXmlDuration.matcher(durationStr);
        if (!m.matches()) {
            try {
                m = reXmlDuration.matcher(PlotSpecification.getXmlDurationFromHecDuration(durationStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid HEC or XML duration: " + durationStr);
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(baseTime.getTimeInMillis());
        if (m.group(1) != null) {
            cal.add(1, Integer.parseInt(m.group(2)));
        }
        if (m.group(3) != null) {
            cal.add(2, Integer.parseInt(m.group(4)));
        }
        if (m.group(5) != null) {
            cal.add(5, Integer.parseInt(m.group(6)));
        }
        if (m.group(8) != null) {
            cal.add(11, Integer.parseInt(m.group(9)));
        }
        if (m.group(10) != null) {
            cal.add(12, Integer.parseInt(m.group(11)));
        }
        if (m.group(12) != null) {
            cal.add(13, Integer.parseInt(m.group(13)));
        }
        HecTime result = new HecTime();
        result.setTimeInMillis(cal.getTimeInMillis());
        return result;
    }

    public static String getValue(String valueStr) {
        String result = null;
        if (valueStr != null) {
            Double d = Double.parseDouble(valueStr);
            result = d.toString();
            try {
                Long l = Long.parseLong(valueStr);
                result = l.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String validateCurveId(String curveId) {
        if (!reValidCurve.matcher(curveId).matches()) {
            throw new IllegalArgumentException("Invalid curve identifier: " + curveId);
        }
        return curveId;
    }

    public PlotSpecification() {
        this.init();
    }

    public Map<String, String> getCurveData() {
        HashMap<String, String> _curveData = new HashMap<String, String>();
        _curveData.putAll(this.curveData);
        return _curveData;
    }

    public String getCurveData(String curveId) {
        return this.curveData.get(PlotSpecification.validateCurveId(curveId));
    }

    public void setData(String curveId, String curveDataStr) {
        this.curveData.put(PlotSpecification.validateCurveId(curveId), curveDataStr);
    }

    public void setData(String curveId, DataContainer dc) throws Exception {
        String curveDataStr = PlotSpecification.getPlotText(dc);
        this.curveData.put(PlotSpecification.validateCurveId(curveId), curveDataStr);
    }

    public void clearCurveData() {
        this.curveData.clear();
    }

    public boolean doesIncludeDefaults() {
        return this.includeDefaults;
    }

    public void setIncludeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
    }

    public boolean doesIncludeData() {
        return this.includeData;
    }

    public void setIncludeData(boolean includeData) {
        this.includeData = includeData;
        if (includeData) {
            this.includeDataReference = false;
        }
    }

    public boolean doesIncludeDataReference() {
        return this.includeDataReference;
    }

    public void setIncludeDataReference(boolean includeDataReference) {
        this.includeDataReference = includeDataReference;
        if (includeDataReference) {
            this.includeData = false;
        }
    }

    public boolean doesUseCompactForm() {
        return this.useCompactForm;
    }

    public void setUseCompactForm(boolean useCompactForm) {
        this.useCompactForm = useCompactForm;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String specTextToXml(String specText) {
        return this.getPlotSpecXml(PlotSpecification.parsePlotSpecText(specText));
    }

    public String specXmlToText(String specXml) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build((Reader)new StringReader(specXml));
        return this.getPlotSpecText(doc);
    }

    public String getPlotSpecXml(G2dDialog plot) throws IOException {
        return this.getPlotSpecXml(this.buildPlotDoc(plot));
    }

    public String getPlotSpecText(G2dDialog plot) throws IOException {
        return this.getPlotSpecText(this.buildPlotDoc(plot));
    }

    protected void init() {
        this.clearCurveData();
    }

    protected String getPlotSpecText(Document plotDoc) {
        List<String> elementLines = PlotSpecification.getElementLines(plotDoc.getRootElement(), this.useCompactForm ? "" : this.indent, 0);
        String[] linesArray = new String[elementLines.size()];
        elementLines.toArray(linesArray);
        String plotSpecText = TextUtil.join(this.useCompactForm ? " " : "\n", linesArray);
        return plotSpecText;
    }

    protected String getPlotSpecXml(Document plotDoc) {
        String xmlString = null;
        xmlString = this.doesUseCompactForm() ? new XMLOutputter().outputString(plotDoc) : new XMLOutputter(Format.getPrettyFormat().setIndent(this.indent)).outputString(plotDoc);
        return xmlString;
    }

    protected Element buildColorElem(Color color, String name) {
        Element colorElem = null;
        if (color == null) {
            if (this.includeDefaults) {
                colorElem = new Element(name).setAttribute("percent-transparent", "0").addContent("black");
            }
        } else {
            ColorInfo ci = PlotSpecification.getColorInfo(color);
            colorElem = new Element(name).addContent(ci.colorStr);
            if (ci.transparency > 0) {
                colorElem.setAttribute("percent-transparent", Integer.toString(ci.transparency));
            }
        }
        return colorElem;
    }

    protected Element buildLabelElem(G2dLabel label, String name, List<?> options) {
        Element labelElem = null;
        String expectedText = "";
        int expectedRotation = 0;
        int expectedSize = PlotSpecification.defaultLabelProp.fontSize;
        int expectedTiny = PlotSpecification.defaultLabelProp.tinyFontSize;
        int expectedMin = PlotSpecification.defaultLabelProp.minFontSize;
        int expectedMax = PlotSpecification.defaultLabelProp.maxFontSize;
        int expectedAlign = PlotSpecification.defaultLabelProp.align;
        boolean expectedVisibility = true;
        if (options != null) {
            for (int i = 0; i < options.size() / 2; ++i) {
                Object key = options.get(2 * i);
                Object val = options.get(2 * i + 1);
                if (!key.getClass().getName().equals("java.lang.String")) {
                    throw new IllegalArgumentException("Option key is not a string");
                }
                String keyStr = (String)key;
                if (keyStr.equals("expectedText")) {
                    if (!val.getClass().getName().equals("java.lang.String")) {
                        throw new IllegalArgumentException("Value for \"expectedText\" is not a string");
                    }
                    expectedText = (String)val;
                    continue;
                }
                if (keyStr.equals("expectedRotation")) {
                    if (!val.getClass().getName().equals("java.lang.Integer")) {
                        throw new IllegalArgumentException("Value for \"expectedRotation\" is not an integer");
                    }
                    expectedRotation = (Integer)val;
                    continue;
                }
                if (keyStr.equals("expectedSize")) {
                    if (!val.getClass().getName().equals("java.lang.Integer")) {
                        throw new IllegalArgumentException("Value for \"expectedSize\" is not an integer");
                    }
                    expectedSize = (Integer)val;
                    continue;
                }
                if (keyStr.equals("expectedTiny")) {
                    if (!val.getClass().getName().equals("java.lang.Integer")) {
                        throw new IllegalArgumentException("Value for \"expectedTiny\" is not an integer");
                    }
                    expectedTiny = (Integer)val;
                    continue;
                }
                if (keyStr.equals("expectedMin")) {
                    if (!val.getClass().getName().equals("java.lang.Integer")) {
                        throw new IllegalArgumentException("Value for \"expectedMin\" is not an integer");
                    }
                    expectedMin = (Integer)val;
                    continue;
                }
                if (keyStr.equals("expectedMax")) {
                    if (!val.getClass().getName().equals("java.lang.Integer")) {
                        throw new IllegalArgumentException("Value for \"expectedMax\" is not an integer");
                    }
                    expectedMax = (Integer)val;
                    continue;
                }
                if (keyStr.equals("expectedAlign")) {
                    if (val.getClass().getName().equals("java.lang.String")) {
                        if (alignmentNumbers.containsKey((String)val)) {
                            expectedAlign = alignmentNumbers.get((String)val);
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value for \"expectedAlign\" : " + (String)val);
                    }
                    if (val.getClass().getName().equals("java.lang.Integer")) {
                        if (alignmentNames.containsKey((Integer)val)) {
                            expectedAlign = (Integer)val;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value for \"expectedAlign\" : " + (Integer)val);
                    }
                    throw new IllegalArgumentException("Value for \"expectedAlign\" is not an string or an integer");
                }
                if (!keyStr.equals("expectedVisibility")) continue;
                if (!val.getClass().getName().equals("java.lang.Boolean")) {
                    throw new IllegalArgumentException("Value for \"expectedVisibility\" is not a boolean");
                }
                expectedVisibility = (Boolean)val;
            }
        }
        G2dLabelDrawProp prop = null;
        String text = null;
        if (label == null) {
            prop = new G2dLabelDrawProp(defaultLabelProp);
            text = prop.text;
            prop.showLabel = false;
        } else {
            prop = label.getProperties();
            text = label.getText().trim();
        }
        HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
        isDefault.put("fontStyle", prop.fontStyle == PlotSpecification.defaultLabelProp.fontStyle);
        isDefault.put("fontFamily", prop.fontFamily.equals(PlotSpecification.defaultLabelProp.fontFamily));
        isDefault.put("textColor", PlotSpecification.sameColor(prop.textColor, PlotSpecification.defaultLabelProp.textColor));
        isDefault.put("space", prop.space == PlotSpecification.defaultLabelProp.space);
        isDefault.put("drawBorder", prop.drawBorder == PlotSpecification.defaultLabelProp.drawBorder);
        isDefault.put("drawBackground", prop.drawBackground == PlotSpecification.defaultLabelProp.drawBackground);
        isDefault.put("borderStyle", PlotSpecification.sameArray(prop.borderStyle, PlotSpecification.defaultLabelProp.borderStyle));
        isDefault.put("borderWeight", prop.borderWeight == PlotSpecification.defaultLabelProp.borderWeight);
        isDefault.put("borderColor", PlotSpecification.sameColor(prop.borderColor, PlotSpecification.defaultLabelProp.borderColor));
        isDefault.put("backgroundColor", PlotSpecification.sameColor(prop.backgroundColor, PlotSpecification.defaultLabelProp.backgroundColor));
        isDefault.put("fillPattern", prop.fillPattern == PlotSpecification.defaultLabelProp.fillPattern);
        isDefault.put("iconPath", TextUtil.equals(prop.iconPath, PlotSpecification.defaultLabelProp.iconPath));
        isDefault.put("alphaComposite", prop.alphaComposite == PlotSpecification.defaultLabelProp.alphaComposite);
        isDefault.put("rotation", prop.rotation == expectedRotation);
        isDefault.put("text", TextUtil.equals(text, expectedText));
        isDefault.put("useFontScaling", prop.useFontScaling());
        isDefault.put("fontSize", prop.fontSize == expectedSize);
        isDefault.put("tinyFontSize", prop.tinyFontSize == expectedTiny);
        isDefault.put("minFontSize", prop.minFontSize == expectedMin);
        isDefault.put("maxFontSize", prop.maxFontSize == expectedMax);
        isDefault.put("align", prop.align == expectedAlign);
        if (prop instanceof TitleDrawProp) {
            isDefault.put("showLabel", ((TitleDrawProp)prop).drawTitle == expectedVisibility);
        } else {
            isDefault.put("showLabel", prop.showLabel == expectedVisibility);
        }
        isDefault.put("font", PlotSpecification.all(isDefault, "fontStyle", "fontFamily", "fontSize", "textColor"));
        isDefault.put("alignment", PlotSpecification.all(isDefault, "align"));
        isDefault.put("border", PlotSpecification.all(isDefault, "drawBorder", "borderStyle", "borderWeight", "borderColor"));
        isDefault.put("background", PlotSpecification.all(isDefault, "backgroundColor", "fillPattern", "drawBackground"));
        isDefault.put("area", PlotSpecification.all(isDefault, "border", "background"));
        isDefault.put("spacing", PlotSpecification.all(isDefault, "space"));
        isDefault.put("visible", PlotSpecification.all(isDefault, "showLabel"));
        isDefault.put("label", PlotSpecification.all(isDefault, "fontStyle", "fontFamily", "textColor", "space", "drawBorder", "drawBackground", "borderStyle", "borderWeight", "borderColor", "backgroundColor", "fillPattern", "iconPath", "alphaComposite", "rotation", "text", "useFontScaling"));
        if (this.includeDefaults || !((Boolean)isDefault.get("label")).booleanValue()) {
            labelElem = new Element(name).addContent((Content)new Element("text").addContent(text));
            if (this.includeDefaults || !((Boolean)isDefault.get("font")).booleanValue()) {
                Element fontElem = new Element("font");
                if (prop.fontFamily != null && prop.fontFamily.length() > 0) {
                    fontElem.addContent((Content)new Element("family").addContent(prop.fontFamily.toLowerCase()));
                }
                labelElem.addContent((Content)fontElem);
                if (this.includeDefaults || !((Boolean)isDefault.get("fontStyle")).booleanValue()) {
                    fontElem.addContent((Content)new Element("style").addContent(fontStyleNames.get(prop.fontStyle)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("fontSize")).booleanValue()) {
                    fontElem.addContent((Content)new Element("size").addContent(Integer.toString(prop.fontSize)));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("textColor")).booleanValue()) && prop.textColor != null) {
                    fontElem.addContent((Content)this.buildColorElem(prop.textColor, "color"));
                }
                if (this.includeDefaults || !PlotSpecification.all(isDefault, "tinyFontSize", "minFontSize", "maxFontSize")) {
                    fontElem.addContent((Content)new Element("sizes").addContent((Content)new Element("tiny").addContent(Integer.toString(prop.tinyFontSize))).addContent((Content)new Element("min").addContent(Integer.toString(prop.minFontSize))).addContent((Content)new Element("max").addContent(Integer.toString(prop.maxFontSize))));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("alignment")).booleanValue()) {
                labelElem.addContent((Content)new Element("alignment").addContent(alignmentNames.get(prop.align)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("rotation")).booleanValue()) {
                labelElem.addContent((Content)new Element("rotation").addContent(Integer.toString(prop.rotation)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("iconPath")).booleanValue()) {
                labelElem.addContent((Content)new Element("iconpath").addContent(prop.iconPath));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("area")).booleanValue()) {
                Element areaElem = new Element("area");
                labelElem.addContent((Content)areaElem);
                if (this.includeDefaults || !((Boolean)isDefault.get("border")).booleanValue()) {
                    Element borderElem = new Element("border");
                    areaElem.addContent((Content)borderElem);
                    if ((this.includeDefaults || !((Boolean)isDefault.get("borderColor")).booleanValue()) && prop.borderColor != null) {
                        borderElem.addContent((Content)this.buildColorElem(prop.borderColor, "color"));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("borderStyle")).booleanValue()) {
                        borderElem.addContent((Content)new Element("style").addContent(lineStyleNames.get(prop.borderStyle)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("borderWeight")).booleanValue()) {
                        borderElem.addContent((Content)new Element("width").addContent(Float.toString(prop.borderWeight)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("drawBorder")).booleanValue()) {
                        borderElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.drawBorder)));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("background")).booleanValue()) {
                    Element backgroundElem = new Element("background");
                    areaElem.addContent((Content)backgroundElem);
                    if ((this.includeDefaults || !((Boolean)isDefault.get("backgroundColor")).booleanValue()) && prop.backgroundColor != null) {
                        backgroundElem.addContent((Content)this.buildColorElem(prop.backgroundColor, "color"));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("fillPattern")).booleanValue()) {
                        backgroundElem.addContent((Content)new Element("fill-pattern").addContent(fillPatternNames.get(prop.fillPattern)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("drawBackground")).booleanValue()) {
                        backgroundElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.drawBackground)));
                    }
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("spacing")).booleanValue()) {
                labelElem.addContent((Content)new Element("spacing").addContent(Integer.toString(prop.space)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("visible")).booleanValue()) {
                if (prop instanceof TitleDrawProp) {
                    labelElem.addContent((Content)new Element("visible").addContent(Boolean.toString(((TitleDrawProp)prop).drawTitle)));
                } else {
                    labelElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.showLabel)));
                }
            }
        }
        this.prune(labelElem);
        if (labelElem.getContentSize() == 1 && ((Boolean)isDefault.get("text")).booleanValue()) {
            labelElem = null;
        }
        return labelElem;
    }

    protected Element buildLabelElem(G2dLabel label, String name) {
        return this.buildLabelElem(label, name, null);
    }

    protected Element buildScaleElem(Axis axis, String name, Viewport viewport) {
        Element scaleElem = null;
        AxisProp prop = axis.getAxisProp();
        String scaleType = axisTypeNames.get(prop.type);
        HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
        isDefault.put("automax", prop.automax == PlotSpecification.defaultAxisProp.automax);
        isDefault.put("automin", prop.automin == PlotSpecification.defaultAxisProp.automin);
        isDefault.put("autoviewmax", prop.autoviewmax == PlotSpecification.defaultAxisProp.autoviewmax);
        isDefault.put("autoviewmin", prop.autoviewmin == PlotSpecification.defaultAxisProp.autoviewmin);
        isDefault.put("autocomputeMajorTics", prop.autocomputeMajorTics == PlotSpecification.defaultAxisProp.autocomputeMajorTics);
        isDefault.put("autocomputeMinorTics", prop.autocomputeMinorTics == PlotSpecification.defaultAxisProp.autocomputeMinorTics);
        isDefault.put("reversed", prop.isReversed() == name.toUpperCase().startsWith("Y"));
        switch (prop.type) {
            case 0: 
            case 3: 
            case 4: {
                isDefault.put("numTicLabelLayers", prop.numTicLabelLayers == -1);
                break;
            }
            default: {
                isDefault.put("numTicLabelLayers", prop.numTicLabelLayers == 2);
            }
        }
        isDefault.put("scale", PlotSpecification.all(isDefault, "automax", "automin", "autoviewmax", "autoviewmin", "autocomputeMajorTics", "autocomputeMinorTics", "reversed", "numTicLabelLayers"));
        if (this.includeDefaults || !((Boolean)isDefault.get("scale")).booleanValue()) {
            boolean reversed = prop.isReversed() == name.toUpperCase().startsWith("X");
            scaleElem = new Element("scale");
            Element typeElem = new Element(scaleType).setAttribute("reverse", Boolean.toString(reversed));
            scaleElem.addContent((Content)typeElem);
            switch (prop.type) {
                case 0: 
                case 3: 
                case 4: {
                    if (this.includeDefaults || !((Boolean)isDefault.get("automin")).booleanValue()) {
                        typeElem.addContent((Content)new Element("scale-minimum").setAttribute("use-automatic", Boolean.toString(prop.automin)).addContent(Double.toString(prop.min)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("automax")).booleanValue()) {
                        typeElem.addContent((Content)new Element("scale-maximum").setAttribute("use-automatic", Boolean.toString(prop.automax)).addContent(Double.toString(prop.max)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmin")).booleanValue()) {
                        typeElem.addContent((Content)new Element("view-minimum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmin)).addContent(Double.toString(prop.actmin)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmax")).booleanValue()) {
                        typeElem.addContent((Content)new Element("view-maximum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmax)).addContent(Double.toString(prop.actmax)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autocomputeMajorTics")).booleanValue()) {
                        typeElem.addContent((Content)new Element("major-tic-interval").setAttribute("use-automatic", Boolean.toString(prop.autocomputeMajorTics)).addContent(Double.toString(prop.majortic)));
                    }
                    if (!this.includeDefaults && ((Boolean)isDefault.get("autocomputeMinorTics")).booleanValue()) break;
                    typeElem.addContent((Content)new Element("minor-tic-interval").setAttribute("use-automatic", Boolean.toString(prop.autocomputeMinorTics)).addContent(Double.toString(prop.minortic)));
                    break;
                }
                case 1: {
                    HecTime t = new HecTime();
                    if (this.includeDefaults || !((Boolean)isDefault.get("automin")).booleanValue()) {
                        t.setMinutes(prop.min);
                        typeElem.addContent((Content)new Element("scale-minimum").setAttribute("use-automatic", Boolean.toString(prop.automin)).addContent(t.getXMLDateTime(0)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("automax")).booleanValue()) {
                        t.setMinutes(prop.max);
                        typeElem.addContent((Content)new Element("scale-maximum").setAttribute("use-automatic", Boolean.toString(prop.automax)).addContent(t.getXMLDateTime(0)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmin")).booleanValue()) {
                        t.setMinutes(prop.actmin);
                        typeElem.addContent((Content)new Element("view-minimum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmin)).addContent(t.getXMLDateTime(0)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmax")).booleanValue()) {
                        t.setMinutes(prop.actmax);
                        typeElem.addContent((Content)new Element("view-maximum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmax)).addContent(t.getXMLDateTime(0)));
                    }
                    if (!this.includeDefaults && ((Boolean)isDefault.get("numTicLabelLayers")).booleanValue()) break;
                    typeElem.addContent((Content)new Element("label-level-count").addContent(Integer.toString(prop.numTicLabelLayers)));
                    break;
                }
                case 2: {
                    int dataStart = Integer.MIN_VALUE;
                    for (Object obj : viewport.getGlyphVector()) {
                        G2dGlyph glyph = (G2dGlyph)obj;
                        int t = (int)glyph.getG2dObject().getXValues()[0];
                        if (dataStart != Integer.MIN_VALUE && t >= dataStart) continue;
                        dataStart = t;
                    }
                    String scaleStart = PlotSpecification.getXmlDuration(dataStart, (int)prop.min);
                    String scaleEnd = PlotSpecification.getXmlDuration(dataStart, (int)prop.max);
                    String viewStart = PlotSpecification.getXmlDuration(dataStart, (int)prop.actmin);
                    String viewEnd = PlotSpecification.getXmlDuration(dataStart, (int)prop.actmax);
                    if (this.includeDefaults || !((Boolean)isDefault.get("automin")).booleanValue()) {
                        typeElem.addContent((Content)new Element("scale-minimum").setAttribute("use-automatic", Boolean.toString(prop.automin)).addContent(scaleStart));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("automax")).booleanValue()) {
                        typeElem.addContent((Content)new Element("scale-maximum").setAttribute("use-automatic", Boolean.toString(prop.automax)).addContent(scaleEnd));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmin")).booleanValue()) {
                        typeElem.addContent((Content)new Element("view-minimum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmin)).addContent(viewStart));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("autoviewmax")).booleanValue()) {
                        typeElem.addContent((Content)new Element("view-maximum").setAttribute("use-automatic", Boolean.toString(prop.autoviewmax)).addContent(viewEnd));
                    }
                    if (!this.includeDefaults && ((Boolean)isDefault.get("numTicLabelLayers")).booleanValue()) break;
                    typeElem.addContent((Content)new Element("label-level-count").addContent(Integer.toString(prop.numTicLabelLayers)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected scale type: " + scaleType);
                }
            }
        }
        return scaleElem;
    }

    protected Element buildTicsElem(AxisTics axisTics) {
        Element ticsElem = null;
        if (axisTics != null) {
            AxisTicsDrawProp prop = axisTics.getProperties();
            HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
            isDefault.put("drawMajorTics", prop.drawMajorTics == PlotSpecification.defaultAxisTicsProp.drawMajorTics);
            isDefault.put("drawMajorTicLabels", prop.drawMajorTicLabels == PlotSpecification.defaultAxisTicsProp.drawMajorTicLabels);
            isDefault.put("drawMinorTics", prop.drawMinorTics == PlotSpecification.defaultAxisTicsProp.drawMinorTics);
            isDefault.put("drawMinorTicLabels", prop.drawMinorTicLabels == PlotSpecification.defaultAxisTicsProp.drawMinorTicLabels);
            isDefault.put("majorTicLength", prop.majorTicLength == PlotSpecification.defaultAxisTicsProp.majorTicLength);
            isDefault.put("minorTicLength", prop.minorTicLength == PlotSpecification.defaultAxisTicsProp.minorTicLength);
            isDefault.put("axisTicColor", PlotSpecification.sameColor(prop.axisTicColor, PlotSpecification.defaultAxisTicsProp.axisTicColor));
            isDefault.put("majorTicFontSize", prop.majorTicFontSize == PlotSpecification.defaultAxisTicsProp.majorTicFontSize);
            isDefault.put("majorTicTinyFontSize", prop.majorTicTinyFontSize == PlotSpecification.defaultAxisTicsProp.majorTicTinyFontSize);
            isDefault.put("majorTicMinFontSize", prop.majorTicMinFontSize == PlotSpecification.defaultAxisTicsProp.majorTicMinFontSize);
            isDefault.put("majorTicMaxFontSize", prop.majorTicMaxFontSize == PlotSpecification.defaultAxisTicsProp.majorTicMaxFontSize);
            isDefault.put("majorTicFontStyle", prop.majorTicFontStyle == PlotSpecification.defaultAxisTicsProp.majorTicFontStyle);
            isDefault.put("majorTicFontFamily", prop.majorTicFontFamily.equals(PlotSpecification.defaultAxisTicsProp.majorTicFontFamily));
            isDefault.put("minorTicFontSize", prop.minorTicFontSize == PlotSpecification.defaultAxisTicsProp.minorTicFontSize);
            isDefault.put("minorTicTinyFontSize", prop.minorTicTinyFontSize == PlotSpecification.defaultAxisTicsProp.minorTicTinyFontSize);
            isDefault.put("minorTicMinFontSize", prop.minorTicMinFontSize == PlotSpecification.defaultAxisTicsProp.minorTicMinFontSize);
            isDefault.put("minorTicMaxFontSize", prop.minorTicMaxFontSize == PlotSpecification.defaultAxisTicsProp.minorTicMaxFontSize);
            isDefault.put("minorTicFontStyle", prop.minorTicFontStyle == PlotSpecification.defaultAxisTicsProp.minorTicFontStyle);
            isDefault.put("minorTicFontFamily", prop.minorTicFontFamily.equals(PlotSpecification.defaultAxisTicsProp.minorTicFontFamily));
            isDefault.put("minorTicLabelColor", PlotSpecification.sameColor(prop.minorTicLabelColor, PlotSpecification.defaultAxisTicsProp.minorTicLabelColor));
            isDefault.put("majorFontSizes", PlotSpecification.all(isDefault, "majorTicFontSize", "majorTicTinyFontSize", "majorTicMinFontSize", "majorTicMaxFontSize"));
            isDefault.put("majorFontLabel", PlotSpecification.all(isDefault, "majorFontSizes", "drawMajorTicLabels", "majorTicFontStyle", "majorTicFontFamily", "axisTicColor"));
            isDefault.put("majorTicMarks", PlotSpecification.all(isDefault, "drawMajorTics", "majorTicLength"));
            isDefault.put("majorTics", PlotSpecification.all(isDefault, "majorFontLabel", "majorTicMarks"));
            isDefault.put("minorFontSizes", PlotSpecification.all(isDefault, "minorTicFontSize", "minorTicTinyFontSize", "minorTicMinFontSize", "minorTicMaxFontSize"));
            isDefault.put("minorFontLabel", PlotSpecification.all(isDefault, "minorFontSizes", "drawMinorTicLabels", "minorTicFontStyle", "minorTicFontFamily", "axisTicColor"));
            isDefault.put("minorTicMarks", PlotSpecification.all(isDefault, "drawMinorTics", "minorTicLength"));
            isDefault.put("minorTics", PlotSpecification.all(isDefault, "minorFontLabel", "minorTicMarks"));
            isDefault.put("tics", PlotSpecification.all(isDefault, "majorTics", "minorTics"));
            if (this.includeDefaults || !((Boolean)isDefault.get("tics")).booleanValue()) {
                Element sizesElem;
                ticsElem = new Element("tics");
                if (this.includeDefaults || !((Boolean)isDefault.get("majorTics")).booleanValue()) {
                    Element majorElem = new Element("major").addContent((Content)new Element("family").addContent(prop.majorTicFontFamily));
                    ticsElem.addContent((Content)majorElem);
                    majorElem.setAttribute("show-labels", Boolean.toString(prop.drawMajorTicLabels));
                    majorElem.setAttribute("show-marks", Boolean.toString(prop.drawMajorTics));
                    if (this.includeDefaults || !((Boolean)isDefault.get("majorTicFontStyle")).booleanValue()) {
                        majorElem.addContent((Content)new Element("style").addContent(fontStyleNames.get(prop.majorTicFontStyle)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("majorTicFontSize")).booleanValue()) {
                        majorElem.addContent((Content)new Element("size").addContent(Integer.toString(prop.majorTicFontSize)));
                    }
                    if (prop.axisTicColor != null) {
                        majorElem.addContent((Content)this.buildColorElem(prop.axisTicColor, "color"));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("majorFontSize")).booleanValue()) {
                        sizesElem = new Element("sizes");
                        majorElem.addContent((Content)sizesElem);
                        sizesElem.addContent((Content)new Element("tiny").addContent(Integer.toString(prop.majorTicTinyFontSize)));
                        sizesElem.addContent((Content)new Element("min").addContent(Integer.toString(prop.majorTicMinFontSize)));
                        sizesElem.addContent((Content)new Element("max").addContent(Integer.toString(prop.majorTicMaxFontSize)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("majorTicLength")).booleanValue()) {
                        majorElem.addContent((Content)new Element("mark-length").addContent(Integer.toString(prop.majorTicLength)));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("minorTics")).booleanValue()) {
                    Element minorElem = new Element("minor").addContent((Content)new Element("family").addContent(prop.minorTicFontFamily));
                    ticsElem.addContent((Content)minorElem);
                    minorElem.setAttribute("show-labels", Boolean.toString(prop.drawMinorTicLabels));
                    minorElem.setAttribute("show-marks", Boolean.toString(prop.drawMinorTics));
                    if (this.includeDefaults || !((Boolean)isDefault.get("minorTicFontStyle")).booleanValue()) {
                        minorElem.addContent((Content)new Element("style").addContent(fontStyleNames.get(prop.minorTicFontStyle)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("minorTicFontSize")).booleanValue()) {
                        minorElem.addContent((Content)new Element("size").addContent(Integer.toString(prop.minorTicFontSize)));
                    }
                    if (prop.axisTicColor != null) {
                        minorElem.addContent((Content)this.buildColorElem(prop.axisTicColor, "color"));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("minorFontSize")).booleanValue()) {
                        sizesElem = new Element("sizes");
                        minorElem.addContent((Content)sizesElem);
                        sizesElem.addContent((Content)new Element("tiny").addContent(Integer.toString(prop.minorTicTinyFontSize)));
                        sizesElem.addContent((Content)new Element("min").addContent(Integer.toString(prop.minorTicMinFontSize)));
                        sizesElem.addContent((Content)new Element("max").addContent(Integer.toString(prop.minorTicMaxFontSize)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("minorTicLength")).booleanValue()) {
                        minorElem.addContent((Content)new Element("mark-length").addContent(Integer.toString(prop.minorTicLength)));
                    }
                }
            }
        }
        return ticsElem;
    }

    protected List<Element> buildCurveElems(Viewport viewport, Scale scale) {
        Vector<Element> curveElems = new Vector<Element>();
        Vector<G2dLine> curves = new Vector<G2dLine>();
        class IndexedDataset {
            public G2dData dataset;
            public int index;

            public IndexedDataset(G2dData dataset, int index) {
                this.dataset = dataset;
                this.index = index;
            }
        }
        Vector<IndexedDataset> datasets = new Vector<IndexedDataset>();
        Vector<G2dData> g2dObjects = new Vector<G2dData>();
        Vector<Integer> glyphIndex = new Vector<Integer>();
        Vector glyphs = viewport.getGlyphVector();
        LegendPanel legend = viewport.getG2dPanel().getLegendPanel();
        String viewportName = viewport.getName().replaceAll("Viewport \\(", "").replaceAll("\\)", "");
        String axisName = scale.getAxis(1) == viewport.getAxis("y1") ? "y1" : "y2";
        for (int i = 0; i < glyphs.size(); ++i) {
            Object obj = glyphs.get(i);
            G2dGlyph glyph = (G2dGlyph)obj;
            if (glyph.getScale() != scale) continue;
            if (glyph instanceof TimeSeriesGlyph) {
                curves.add(glyph.getLine());
                glyphIndex.add(i);
                G2dData g2dData = (G2dData)glyph.getG2dObject();
                datasets.add(new IndexedDataset(g2dData, -1));
                g2dObjects.add(g2dData);
                continue;
            }
            if (glyph instanceof PairedDataGlyph) {
                for (int j = 0; j < glyph.getCurveCount(); ++j) {
                    curves.add(glyph.getLine(j));
                    glyphIndex.add(i);
                    G2dData g2dData = (G2dData)glyph.getG2dObject();
                    datasets.add(new IndexedDataset(g2dData, j));
                    g2dObjects.add(g2dData);
                }
                continue;
            }
            throw new IllegalArgumentException("Specified viewport has unknown glyph type: " + glyph.getClass().getName());
        }
        DataTypeFactory.getFactory().reset();
        List<LineProperties> lineProps = DataTypeFactory.getFactory().getLineProperties(g2dObjects, true);
        for (int i = 0; i < curves.size(); ++i) {
            Element pointElem;
            int j;
            Element valuesElem;
            String yUnit;
            String yParameter;
            Element symElem;
            Color color;
            IndexedDataset ds = (IndexedDataset)datasets.get(i);
            G2dLineProperties prop = ((G2dLine)curves.get(i)).getProperties();
            HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
            int expectedStepStyle = 0;
            G2dLineProperties defaultsToUse = null;
            Color expectedLineColor = null;
            int expectedTransparency = 0;
            String expectedText = null;
            String expectedName = null;
            if (ds.dataset instanceof TimeSeriesDataSet && ((TimeSeriesDataSet)ds.dataset).getData().type.startsWith("PER-")) {
                expectedStepStyle = 1;
            }
            if (G2dDialog.getUseLineStyles()) {
                LineProperties obj = lineProps.get(i);
                defaultsToUse = (G2dLineProperties)obj;
                expectedLineColor = defaultsToUse._lineColor;
            } else {
                defaultsToUse = defaultLineProp;
                expectedLineColor = lineColors[this.lineColorIndex++ % lineColors.length];
            }
            if (ds.index == -1) {
                TimeSeriesContainer tsc = ((TimeSeriesDataSet)ds.dataset).getData();
                StringBuilder sb = new StringBuilder("");
                if (tsc.location != null && tsc.location.length() > 0) {
                    sb.append(tsc.location);
                    if (tsc.subLocation != null && tsc.subLocation.length() > 0) {
                        sb.append("-").append(tsc.subLocation);
                    }
                }
                if (tsc.version != null && tsc.version.length() > 0) {
                    sb.append(" ").append(tsc.version);
                    if (tsc.subLocation != null && tsc.subLocation.length() > 0) {
                        sb.append("-").append(tsc.subLocation);
                    }
                }
                if (tsc.parameter != null && tsc.parameter.length() > 0) {
                    sb.append(" ").append(tsc.parameter);
                    if (tsc.subLocation != null && tsc.subLocation.length() > 0) {
                        sb.append("-").append(tsc.subLocation);
                    }
                }
                expectedName = sb.toString();
                expectedText = defaultsToUse._label;
            } else {
                PairedDataContainer pdc = ((PairedDataSet)ds.dataset).getData();
                expectedText = pdc.labels == null ? defaultsToUse._label : pdc.labels[ds.index];
            }
            G2dLabel legendLabel = null;
            legendLabel = ds.index == -1 ? legend.getLegendItem((G2dObject)ds.dataset).label : legend.getLegendItem((G2dObject)ds.dataset, (int)ds.index).label;
            Element legendLabelElem = this.buildLabelElem(legendLabel, "legend-item", PlotSpecification.makeList("expectedText", ((G2dLine)curves.get(i)).getName(), "expectedSize", 11, "expectedTiny", 8, "expectedMin", 5, "expectedMax", 15, "expectedAlign", "left"));
            isDefault.put("_lineStylePattern", PlotSpecification.sameArray(prop._lineStylePattern, defaultsToUse._lineStylePattern));
            isDefault.put("_lineWidth", prop._lineWidth == defaultsToUse._lineWidth);
            isDefault.put("_drawLine", prop._drawLine == defaultsToUse._drawLine);
            isDefault.put("_fillType", prop._fillType == defaultsToUse._fillType);
            isDefault.put("_fillColor", PlotSpecification.sameColor(prop._fillColor, defaultsToUse._fillColor));
            isDefault.put("_fillTransparency", prop._fillTransparency == defaultsToUse._fillTransparency);
            isDefault.put("_fillPattern", prop._fillPattern == defaultsToUse._fillPattern);
            isDefault.put("_interpolateMissing", prop._interpolateMissing == defaultsToUse._interpolateMissing);
            isDefault.put("_drawMissingData", prop._drawMissingData == defaultsToUse._drawMissingData);
            isDefault.put("_placeholderSymbolType", prop._placeholderSymbolType == defaultsToUse._placeholderSymbolType);
            isDefault.put("_placeholderSymbolSize", prop._placeholderSymbolSize == defaultsToUse._placeholderSymbolSize);
            isDefault.put("_placeholderPointLineColor", PlotSpecification.sameColor(prop._placeholderPointLineColor, defaultsToUse._placeholderPointLineColor));
            isDefault.put("_placeholderPointFillColor", PlotSpecification.sameColor(prop._placeholderPointFillColor, defaultsToUse._placeholderPointFillColor));
            isDefault.put("_drawPoints", prop._drawPoints == defaultsToUse._drawPoints);
            isDefault.put("_symbolType", prop._symbolType == defaultsToUse._symbolType);
            isDefault.put("_symbolSize", prop._symbolSize == defaultsToUse._symbolSize);
            isDefault.put("_pointLineColor", PlotSpecification.sameColor(prop._pointLineColor, defaultsToUse._pointLineColor));
            isDefault.put("_pointFillColor", PlotSpecification.sameColor(prop._pointFillColor, defaultsToUse._pointFillColor));
            isDefault.put("_ptOffset", prop._ptOffset == defaultsToUse._ptOffset);
            isDefault.put("_numPtsSkip", prop._numPtsSkip == defaultsToUse._numPtsSkip);
            isDefault.put("_drawQualityData", prop._drawQualityData == defaultsToUse._drawQualityData);
            isDefault.put("_okSymbolType", prop._okSymbolType == defaultsToUse._okSymbolType);
            isDefault.put("_okSymbolSize", prop._okSymbolSize == defaultsToUse._okSymbolSize);
            isDefault.put("_okPointLineColor", PlotSpecification.sameColor(prop._okPointLineColor, defaultsToUse._okPointLineColor));
            isDefault.put("_okPointFillColor", PlotSpecification.sameColor(prop._okPointFillColor, defaultsToUse._okPointFillColor));
            isDefault.put("_questionableSymbolType", prop._questionableSymbolType == defaultsToUse._questionableSymbolType);
            isDefault.put("_questionableSymbolSize", prop._questionableSymbolSize == defaultsToUse._questionableSymbolSize);
            isDefault.put("_questionablePointLineColor", PlotSpecification.sameColor(prop._questionablePointLineColor, defaultsToUse._questionablePointLineColor));
            isDefault.put("_questionablePointFillColor", PlotSpecification.sameColor(prop._questionablePointFillColor, defaultsToUse._questionablePointFillColor));
            isDefault.put("_rejectedSymbolType", prop._rejectedSymbolType == defaultsToUse._rejectedSymbolType);
            isDefault.put("_rejectedSymbolSize", prop._rejectedSymbolSize == defaultsToUse._rejectedSymbolSize);
            isDefault.put("_rejectedPointLineColor", PlotSpecification.sameColor(prop._rejectedPointLineColor, defaultsToUse._rejectedPointLineColor));
            isDefault.put("_rejectedPointFillColor", PlotSpecification.sameColor(prop._rejectedPointFillColor, defaultsToUse._rejectedPointFillColor));
            isDefault.put("_missingSymbolType", prop._missingSymbolType == defaultsToUse._missingSymbolType);
            isDefault.put("_missingSymbolSize", prop._missingSymbolSize == defaultsToUse._missingSymbolSize);
            isDefault.put("_missingPointLineColor", PlotSpecification.sameColor(prop._missingPointLineColor, defaultsToUse._missingPointLineColor));
            isDefault.put("_missingPointFillColor", PlotSpecification.sameColor(prop._missingPointFillColor, defaultsToUse._missingPointFillColor));
            isDefault.put("hasLabel", prop.hasLabel() == defaultsToUse.hasLabel());
            isDefault.put("getLabelAlignment", prop.getLabelAlignment() == defaultsToUse.getLabelAlignment());
            isDefault.put("getLabelPosition", prop.getLabelPosition() == defaultsToUse.getLabelPosition());
            isDefault.put("_lineStepStyle", prop._lineStepStyle == expectedStepStyle);
            isDefault.put("_lineColor", PlotSpecification.sameColor(prop._lineColor, expectedLineColor));
            isDefault.put("_lineTransparency", prop._lineTransparency == expectedTransparency);
            isDefault.put("_label", prop._label.equals(expectedText));
            isDefault.put("name", ((G2dLine)curves.get(i)).getName().equals(expectedName));
            isDefault.put("line", PlotSpecification.all(isDefault, "_lineColor", "_lineTransparency", "_lineStylePattern", "_lineWidth", "_drawLine"));
            isDefault.put("fill", PlotSpecification.all(isDefault, "_fillType", "_fillColor", "_fillTransparency", "_fillPattern"));
            isDefault.put("missing-symbols", PlotSpecification.all(isDefault, "_drawMissingData", "_placeholderSymbolType", "_placeholderSymbolSize", "_placeholderPointLineColor", "_placeholderPointFillColor"));
            isDefault.put("point-symbols", PlotSpecification.all(isDefault, "_drawPoints", "_symbolType", "_symbolSize", "_pointLineColor", "_pointFillColor", "_ptOffset", "_numPtsSkip"));
            isDefault.put("q-ok-symbols", PlotSpecification.all(isDefault, "_okSymbolType", "_okSymbolSize", "_okPointLineColor", "_okPointFillColor"));
            isDefault.put("q-question-symbols", PlotSpecification.all(isDefault, "_questionableSymbolType", "_questionableSymbolSize", "_questionablePointLineColor", "_questionablePointFillColor"));
            isDefault.put("q-reject-symbols", PlotSpecification.all(isDefault, "_rejectedSymbolType", "_rejectedSymbolSize", "_rejectedPointLineColor", "_rejectedPointFillColor"));
            isDefault.put("q-missing-symbols", PlotSpecification.all(isDefault, "_missingSymbolType", "_missingSymbolSize", "_missingPointLineColor", "_missingPointFillColor"));
            isDefault.put("quality-symbols", PlotSpecification.all(isDefault, "_drawQualityData", "q-ok-symbols", "q-question-symbols", "q-reject-symbols", "q-missing-symbols"));
            isDefault.put("label", PlotSpecification.all(isDefault, "hasLabel", "_label", "getLabelAlignment", "getLabelPosition"));
            isDefault.put("visible", ((G2dLine)curves.get(i)).isVisible());
            isDefault.put("legend-label", legendLabelElem == null);
            isDefault.put("show-in-legend", ((G2dGlyph)glyphs.get((Integer)glyphIndex.get(i))).isLegendItemsVisible());
            isDefault.put("legend", PlotSpecification.all(isDefault, "legend-label", "show-in-legend"));
            Element curveElem = new Element("curve").setAttribute("id", String.format("%s,%s,%d", viewportName, axisName, i + 1));
            if (!((Boolean)isDefault.get("name")).booleanValue()) {
                curveElem.setAttribute("name", ((G2dLine)curves.get(i)).getName());
            }
            curveElems.add(curveElem);
            if (this.includeDefaults || !((Boolean)isDefault.get("line")).booleanValue()) {
                Element lineElem = new Element("line");
                curveElem.addContent((Content)lineElem);
                if (prop._lineColor != null) {
                    color = new Color(prop._lineColor.getRed(), prop._lineColor.getGreen(), prop._lineColor.getBlue(), 255 - (int)((double)prop._lineTransparency * 2.55 + 0.5));
                    lineElem.addContent((Content)this.buildColorElem(color, "color"));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_lineStylePattern")).booleanValue()) {
                    lineElem.addContent((Content)new Element("style").addContent(lineStyleNames.get(prop._lineStylePattern)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_lineWidth")).booleanValue()) {
                    lineElem.addContent((Content)new Element("width").addContent(Float.toString(prop._lineWidth)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_drawLine")).booleanValue()) {
                    lineElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop._drawLine)));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("fill")).booleanValue()) {
                Element fillElem = new Element("fill");
                curveElem.addContent((Content)fillElem);
                if (this.includeDefaults || !((Boolean)isDefault.get("_fillType")).booleanValue()) {
                    fillElem.addContent((Content)new Element("position").addContent(fillPositionNames.get(prop._fillType)));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("_fillColor")).booleanValue()) && prop._fillColor != null) {
                    color = new Color(prop._fillColor.getRed(), prop._fillColor.getGreen(), prop._fillColor.getBlue(), 255 - (int)((double)prop._fillTransparency * 2.55 + 0.5));
                    fillElem.addContent((Content)this.buildColorElem(color, "color"));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_fillPattern")).booleanValue()) {
                    fillElem.addContent((Content)new Element("pattern").addContent(fillPatternNames.get(prop._fillPattern)));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("_lineStepStyle")).booleanValue()) {
                curveElem.addContent((Content)new Element("step-style").addContent(lineStepStyleNames.get(prop._lineStepStyle)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("_interpolateMissing")).booleanValue()) {
                curveElem.addContent((Content)new Element("interpolate-missing").addContent(Boolean.toString(prop._interpolateMissing)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("missing-symbols")).booleanValue()) {
                symElem = new Element("missing-symbols");
                curveElem.addContent((Content)symElem);
                symElem.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._placeholderSymbolType)));
                if (this.includeDefaults || !((Boolean)isDefault.get("_placeholderSymbolSize")).booleanValue()) {
                    symElem.addContent((Content)new Element("size").addContent(Float.toString(prop._placeholderSymbolSize)));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("_placeholderPointLineColor")).booleanValue()) && prop._placeholderPointLineColor != null) {
                    symElem.addContent((Content)this.buildColorElem(prop._placeholderPointLineColor, "line-color"));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("_placeholderPointFillColor")).booleanValue()) && prop._placeholderPointFillColor != null) {
                    symElem.addContent((Content)this.buildColorElem(prop._placeholderPointFillColor, "fill-color"));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_drawMissingData")).booleanValue()) {
                    symElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop._drawMissingData)));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("point-symbols")).booleanValue()) {
                symElem = new Element("point-symbols");
                curveElem.addContent((Content)symElem);
                symElem.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._symbolType)));
                if (this.includeDefaults || !((Boolean)isDefault.get("_symbolSize")).booleanValue()) {
                    symElem.addContent((Content)new Element("size").addContent(Float.toString(prop._symbolSize)));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("_pointLineColor")).booleanValue()) && prop._pointLineColor != null) {
                    symElem.addContent((Content)this.buildColorElem(prop._pointLineColor, "line-color"));
                }
                if ((this.includeDefaults || !((Boolean)isDefault.get("_pointFillColor")).booleanValue()) && prop._pointFillColor != null) {
                    symElem.addContent((Content)this.buildColorElem(prop._pointFillColor, "fill-color"));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_ptOffset")).booleanValue()) {
                    symElem.addContent((Content)new Element("offset").addContent(Integer.toString(prop._ptOffset)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_numPtsSkip")).booleanValue()) {
                    symElem.addContent((Content)new Element("skip").addContent(Integer.toString(prop._numPtsSkip)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_drawPoints")).booleanValue()) {
                    symElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop._drawPoints)));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("quality-symbols")).booleanValue()) {
                Element symElem2;
                Element qualityElem = new Element("quality-symbols");
                curveElem.addContent((Content)qualityElem);
                if (this.includeDefaults || !((Boolean)isDefault.get("q-ok-symbols")).booleanValue()) {
                    symElem2 = new Element("valid");
                    qualityElem.addContent((Content)symElem2);
                    symElem2.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._okSymbolType)));
                    if (this.includeDefaults || !((Boolean)isDefault.get("_okSymbolSize")).booleanValue()) {
                        symElem2.addContent((Content)new Element("size").addContent(Float.toString(prop._okSymbolSize)));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_okPointLineColor")).booleanValue()) && prop._okPointLineColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._okPointLineColor, "line-color"));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_okPointFillColor")).booleanValue()) && prop._okPointFillColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._okPointFillColor, "fill-color"));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("q-questionable-symbols")).booleanValue()) {
                    symElem2 = new Element("questionable");
                    qualityElem.addContent((Content)symElem2);
                    symElem2.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._questionableSymbolType)));
                    if (this.includeDefaults || !((Boolean)isDefault.get("_questionableSymbolSize")).booleanValue()) {
                        symElem2.addContent((Content)new Element("size").addContent(Float.toString(prop._questionableSymbolSize)));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_questionablePointLineColor")).booleanValue()) && prop._questionablePointLineColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._questionablePointLineColor, "line-color"));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_questionablePointFillColor")).booleanValue()) && prop._questionablePointFillColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._questionablePointFillColor, "fill-color"));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("q-rejected-symbols")).booleanValue()) {
                    symElem2 = new Element("rejected");
                    qualityElem.addContent((Content)symElem2);
                    symElem2.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._rejectedSymbolType)));
                    if (this.includeDefaults || !((Boolean)isDefault.get("_rejectedSymbolSize")).booleanValue()) {
                        symElem2.addContent((Content)new Element("size").addContent(Float.toString(prop._rejectedSymbolSize)));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_rejectedPointLineColor")).booleanValue()) && prop._rejectedPointLineColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._rejectedPointLineColor, "line-color"));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_rejectedPointFillColor")).booleanValue()) && prop._rejectedPointFillColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._rejectedPointFillColor, "fill-color"));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("q-missing-symbols")).booleanValue()) {
                    symElem2 = new Element("missing");
                    qualityElem.addContent((Content)symElem2);
                    symElem2.addContent((Content)new Element("style").addContent(symbolTypeNames.get(prop._missingSymbolType)));
                    if (this.includeDefaults || !((Boolean)isDefault.get("_missingSymbolSize")).booleanValue()) {
                        symElem2.addContent((Content)new Element("size").addContent(Float.toString(prop._missingSymbolSize)));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_missingPointLineColor")).booleanValue()) && prop._missingPointLineColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._missingPointLineColor, "line-color"));
                    }
                    if ((this.includeDefaults || !((Boolean)isDefault.get("_missingPointFillColor")).booleanValue()) && prop._missingPointFillColor != null) {
                        symElem2.addContent((Content)this.buildColorElem(prop._missingPointFillColor, "fill-color"));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("_drawQualityData")).booleanValue()) {
                    qualityElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop._drawQualityData)));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("label")).booleanValue()) {
                Element labelElem = new Element("label").addContent((Content)new Element("text").addContent(prop._label));
                curveElem.addContent((Content)labelElem);
                if (this.includeDefaults || !((Boolean)isDefault.get("getLabelAlignment")).booleanValue()) {
                    labelElem.addContent((Content)new Element("alignment").addContent(alignmentNames.get(prop.getLabelAlignment())));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("getLabelPosition")).booleanValue()) {
                    labelElem.addContent((Content)new Element("position").addContent(labelPositionNames.get(prop.getLabelPosition())));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("hasLabel")).booleanValue()) {
                    labelElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.hasLabel())));
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("legend-label")).booleanValue()) {
                curveElem.addContent((Content)legendLabelElem);
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("visible")).booleanValue()) {
                curveElem.addContent((Content)new Element("visible").addContent(Boolean.toString(((G2dLine)curves.get(i)).isVisible())));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("show-in-legend")).booleanValue()) {
                G2dGlyph glyph = (G2dGlyph)glyphs.get((Integer)glyphIndex.get(i));
                curveElem.addContent((Content)new Element("show-in-legend").addContent(Boolean.toString(glyph.isLegendItemsVisible())));
            }
            if (!this.includeData && !this.includeDataReference) continue;
            Element datasetElem = new Element("data");
            curveElem.addContent((Content)datasetElem);
            if (this.includeDataReference) {
                Element referenceElem = new Element("reference");
                datasetElem.addContent((Content)referenceElem);
                DataContainer dc = null;
                if (ds.dataset instanceof TimeSeriesDataSet) {
                    dc = ((TimeSeriesDataSet)ds.dataset).getData();
                } else if (ds.dataset instanceof PairedDataSet) {
                    dc = ((PairedDataSet)ds.dataset).getData();
                } else {
                    throw new IllegalArgumentException("Unexpected data set type: " + ds.dataset.getClass().getName());
                }
                referenceElem.addContent((Content)new Element("data-source").addContent(String.format("%s:%s", dc.fileName, dc.fullName)));
                continue;
            }
            if (ds.dataset instanceof TimeSeriesDataSet) {
                String fullname;
                HecTime t = new HecTime();
                TimeSeriesContainer tsc = ((TimeSeriesDataSet)ds.dataset).getData();
                int timezoneOffset = tsc.timeZoneRawOffset / 60000;
                Element dataElem = new Element(tsc.interval > 0 ? "regular" : "irregular");
                datasetElem.addContent((Content)dataElem);
                String filename = tsc.fileName == null ? "" : tsc.fileName;
                String string = fullname = tsc.fullName == null ? "" : tsc.fullName;
                if (filename.length() + fullname.length() > 0) {
                    dataElem.addContent((Content)new Element("data-source").addContent(String.format("%s:%s", filename, fullname)));
                }
                yParameter = tsc.parameter == null ? "" : tsc.parameter;
                yUnit = tsc.units == null ? "" : tsc.units;
                dataElem.addContent((Content)new Element("y-parameter").setAttribute("unit", yUnit).addContent(yParameter));
                valuesElem = new Element("data").setAttribute("data-type", tsc.type);
                dataElem.addContent((Content)valuesElem);
                if (tsc.interval > 0) {
                    t.set(tsc.times[0]);
                    valuesElem.addContent((Content)new Element("start-time").addContent(t.getXMLDateTime(timezoneOffset)));
                    valuesElem.addContent((Content)new Element("interval").addContent(PlotSpecification.getXmlDuration(tsc.times[0], tsc.times[0] + tsc.interval)));
                    for (j = 0; j < tsc.numberValues; ++j) {
                        Element valueElem = new Element("value").addContent(Double.toString(tsc.values[j]));
                        valuesElem.addContent((Content)valueElem);
                        if (tsc.quality == null) continue;
                        valueElem.setAttribute("quality", Integer.toString(tsc.quality[j]));
                    }
                    continue;
                }
                for (j = 0; j < tsc.numberValues; ++j) {
                    pointElem = new Element("point");
                    valuesElem.addContent((Content)pointElem);
                    t.set(tsc.times[j]);
                    pointElem.addContent((Content)new Element("time").addContent(t.getXMLDateTime(timezoneOffset)));
                    pointElem.addContent((Content)new Element("value").addContent(Double.toString(tsc.values[j])));
                    if (tsc.quality == null) continue;
                    pointElem.setAttribute("quality", Integer.toString(tsc.quality[j]));
                }
                continue;
            }
            if (ds.dataset instanceof PairedDataSet) {
                String fullname;
                PairedDataContainer pdc = ((PairedDataSet)ds.dataset).getData();
                Element dataElem = new Element("xy").setAttribute("switch-x-y", Boolean.toString(pdc.switchXyAxis));
                datasetElem.addContent((Content)dataElem);
                String filename = pdc.fileName == null ? "" : pdc.fileName;
                String string = fullname = pdc.fullName == null ? "" : pdc.fullName;
                if (filename.length() + fullname.length() > 0) {
                    dataElem.addContent((Content)new Element("data-source").addContent(String.format("%s:%s", filename, fullname)));
                }
                String xParameter = pdc.xparameter == null ? "" : pdc.xparameter;
                String xUnit = pdc.xunits == null ? "" : pdc.xunits;
                dataElem.addContent((Content)new Element("x-parameter").setAttribute("unit", xUnit).addContent(xParameter));
                yParameter = pdc.yparameter == null ? "" : pdc.yparameter;
                yUnit = pdc.yunits == null ? "" : pdc.yunits;
                dataElem.addContent((Content)new Element("y-parameter").setAttribute("unit", yUnit).addContent(yParameter));
                valuesElem = new Element("data");
                dataElem.addContent((Content)valuesElem);
                for (j = 0; j < pdc.numberOrdinates; ++j) {
                    pointElem = new Element("point");
                    valuesElem.addContent((Content)pointElem);
                    if (ds.index == 0) {
                        pointElem.addContent((Content)new Element("x").addContent(Double.toString(pdc.xOrdinates[j])));
                    }
                    pointElem.addContent((Content)new Element("y").addContent(Double.toString(pdc.yOrdinates[ds.index][j])));
                }
                continue;
            }
            throw new IllegalArgumentException("Unexpected data set type: " + ds.dataset.getClass().getName());
        }
        return curveElems;
    }

    protected List<Element> buildAxisElems(Viewport viewport, boolean includeX1Axis) {
        String[] axisNames;
        Vector<Element> axisElems = new Vector<Element>();
        HashMap<String, Axis> axes = new HashMap<String, Axis>();
        HashMap<String, Scale> scales = new HashMap<String, Scale>();
        for (String axisName : axisNames = new String[]{"x1", "y1", "y2"}) {
            axes.put(axisName, viewport.getAxis(axisName));
        }
        Vector vpScales = viewport.getScaleVector();
        scales.put("x1", (Scale)vpScales.get(0));
        if (axes.get("y1") == null) {
            scales.put("y2", (Scale)vpScales.get(0));
        } else {
            scales.put("y1", (Scale)vpScales.get(0));
            if (axes.get("y2") != null) {
                scales.put("y2", (Scale)vpScales.get(1));
            }
        }
        for (String axisName : axisNames) {
            boolean expectedVisibility;
            String expectedText = null;
            int expectedRotation = 0;
            G2dData dataset = null;
            if (axes.get(axisName) == null || ((Axis)axes.get(axisName)).equals("x1") && !includeX1Axis) continue;
            AxisProp axisProp = ((Axis)axes.get(axisName)).getAxisProp();
            if (axisName.charAt(0) == 'x') {
                switch (axisProp.type) {
                    case 0: 
                    case 3: 
                    case 4: {
                        dataset = (G2dData)((G2dGlyph)viewport.getGlyphVector().get(0)).getG2dObject();
                        expectedText = dataset.getXAxisName().replaceAll("%S", dataset.xunits).trim();
                        expectedVisibility = true;
                        break;
                    }
                    default: {
                        expectedText = "";
                        expectedVisibility = false;
                        break;
                    }
                }
            } else {
                expectedRotation = 90;
                expectedVisibility = true;
                for (Object obj : viewport.getGlyphVector()) {
                    G2dGlyph glyph = (G2dGlyph)obj;
                    if (glyph.getScale() != scales.get(axisName)) continue;
                    dataset = (G2dData)glyph.getG2dObject();
                    expectedText = dataset.getYAxisName().replaceAll("%S", dataset.yunits).trim();
                }
            }
            Element axisElem = new Element(String.format("%s-axis", axisName));
            axisElems.add(axisElem);
            try {
                axisElem.addContent((Content)this.buildLabelElem(viewport.getAxisLabel(axisName), "label", PlotSpecification.makeList("expectedText,", expectedText, "expectedRotation", expectedRotation, "expectedVisibility", expectedVisibility)));
            }
            catch (IllegalAddException illegalAddException) {
                // empty catch block
            }
            try {
                axisElem.addContent((Content)this.buildTicsElem(viewport.getAxisTics(axisName)));
            }
            catch (IllegalAddException illegalAddException) {
                // empty catch block
            }
            try {
                axisElem.addContent((Content)this.buildScaleElem((Axis)axes.get(axisName), axisName, viewport));
            }
            catch (IllegalAddException illegalAddException) {
                // empty catch block
            }
            if (axisName.charAt(0) != 'y') continue;
            try {
                axisElem.addContent(this.buildCurveElems(viewport, (Scale)scales.get(axisName)));
            }
            catch (IllegalAddException illegalAddException) {
                // empty catch block
            }
        }
        return axisElems;
    }

    protected List<Element> buildAxisMarkerElems(Viewport viewport) {
        Vector<Element> axisMarkerElems = new Vector<Element>();
        HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
        List axisMarkers = viewport.getAxisMarkers();
        if (axisMarkers != null) {
            for (Object obj : axisMarkers) {
                G2dMarkerLine axisMarker = (G2dMarkerLine)obj;
                G2dMarkerProperties prop = axisMarker.getProperties();
                if (prop.labelFont == null) {
                    prop.labelFont = PlotSpecification.defaultAxisMarkerProp.labelFont;
                }
                isDefault.clear();
                isDefault.put("markerValue", prop.markerValue == PlotSpecification.defaultAxisMarkerProp.markerValue);
                isDefault.put("markerLabel", prop.markerLabel.equals(PlotSpecification.defaultAxisMarkerProp.markerLabel));
                isDefault.put("drawOnAxis", prop.drawOnAxis == PlotSpecification.defaultAxisMarkerProp.drawOnAxis);
                isDefault.put("lineColor", PlotSpecification.sameColor(prop.lineColor, PlotSpecification.defaultAxisMarkerProp.lineColor));
                isDefault.put("fillColor", PlotSpecification.sameColor(prop.fillColor, PlotSpecification.defaultAxisMarkerProp.fillColor));
                isDefault.put("drawLine", prop.drawLine == PlotSpecification.defaultAxisMarkerProp.drawLine);
                isDefault.put("drawLabel", prop.drawLabel == PlotSpecification.defaultAxisMarkerProp.drawLabel);
                isDefault.put("fillType", prop.fillType == PlotSpecification.defaultAxisMarkerProp.fillType);
                isDefault.put("fillPattern", prop.fillPattern == PlotSpecification.defaultAxisMarkerProp.fillPattern);
                isDefault.put("lineWidth", prop.lineWidth == PlotSpecification.defaultAxisMarkerProp.lineWidth);
                isDefault.put("lineStylePattern", PlotSpecification.sameArray(prop.lineStylePattern, PlotSpecification.defaultAxisMarkerProp.lineStylePattern));
                isDefault.put("labelPosition", prop.labelPosition == PlotSpecification.defaultAxisMarkerProp.labelPosition);
                isDefault.put("labelAlign", prop.labelAlign == PlotSpecification.defaultAxisMarkerProp.labelAlign);
                isDefault.put("editableProperties", prop.editableProperties == PlotSpecification.defaultAxisMarkerProp.editableProperties);
                isDefault.put("labelColor", PlotSpecification.sameColor(prop.labelColor, PlotSpecification.defaultAxisMarkerProp.labelColor));
                isDefault.put("labelFont", prop.labelFont.equals(PlotSpecification.defaultAxisMarkerProp.labelFont));
                isDefault.put("line", PlotSpecification.all(isDefault, "lineColor", "drawLine", "lineWidth", "lineStylePattern"));
                isDefault.put("fill", PlotSpecification.all(isDefault, "fillColor", "fillType", "fillPattern"));
                isDefault.put("label", PlotSpecification.all(isDefault, "markerLabel", "drawLabel", "labelPosition", "labelAlign", "labelColor", "labelFont"));
                Element axisMarkerElem = new Element("axis-marker");
                axisMarkerElems.add(axisMarkerElem);
                axisMarkerElem.addContent((Content)new Element("axis").addContent(prop.drawOnAxis == 0 ? "x1" : "y1"));
                axisMarkerElem.addContent((Content)new Element("value").addContent(Double.toString(prop.markerValue)));
                if (this.includeDefaults || !((Boolean)isDefault.get("line")).booleanValue()) {
                    Element lineElem = new Element("line");
                    axisMarkerElem.addContent((Content)lineElem);
                    if (prop.lineColor != null) {
                        lineElem.addContent((Content)this.buildColorElem(prop.lineColor, "color"));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("lineStylePattern")).booleanValue()) {
                        lineElem.addContent((Content)new Element("style").addContent(lineStyleNames.get(prop.lineStylePattern)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("lineWidth")).booleanValue()) {
                        lineElem.addContent((Content)new Element("width").addContent(Float.toString(prop.lineWidth)));
                    }
                    if (this.includeDefaults || !((Boolean)isDefault.get("drawLine")).booleanValue()) {
                        lineElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.drawLine)));
                    }
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("fill")).booleanValue()) {
                    Element fillElem = new Element("fill");
                    axisMarkerElem.addContent((Content)fillElem);
                    fillElem.addContent((Content)new Element("position").addContent(fillPositionNames.get(prop.fillType)));
                    if (prop.fillColor != null) {
                        fillElem.addContent((Content)this.buildColorElem(prop.fillColor, "color"));
                    }
                    fillElem.addContent((Content)new Element("pattern").addContent(fillPatternNames.get(prop.fillPattern)));
                }
                if (!this.includeDefaults && ((Boolean)isDefault.get("label")).booleanValue()) continue;
                Element labelElem = new Element("label");
                axisMarkerElem.addContent((Content)labelElem);
                labelElem.addContent((Content)new Element("text").addContent(prop.markerLabel));
                labelElem.addContent((Content)new Element("alignment").addContent(alignmentNames.get(prop.labelAlign)));
                labelElem.addContent((Content)new Element("position").addContent(labelPositionNames.get(prop.labelPosition)));
                if (!this.includeDefaults && ((Boolean)isDefault.get("labelFont")).booleanValue()) continue;
                Element fontElem = new Element("font");
                labelElem.addContent((Content)fontElem);
                fontElem.addContent((Content)new Element("family").addContent(prop.labelFont.getFamily()));
                StringBuilder sb = new StringBuilder();
                if (prop.labelFont.isPlain()) {
                    sb.append("plain");
                } else {
                    if (prop.labelFont.isBold()) {
                        sb.append("bold");
                    }
                    if (prop.labelFont.isItalic()) {
                        sb.append("italic");
                    }
                }
                fontElem.addContent((Content)new Element("style").addContent(sb.toString()));
                fontElem.addContent((Content)new Element("size").addContent(Integer.toString(prop.labelFont.getSize())));
                if (prop.labelColor == null) continue;
                fontElem.addContent((Content)this.buildColorElem(prop.labelColor, "color"));
            }
        }
        return axisMarkerElems;
    }

    protected List<Element> buildViewportElems(G2dDialog plot) {
        Vector<Element> viewportElems = new Vector<Element>();
        Vector viewports = plot.getViewports();
        GridBagLayout gbl = (GridBagLayout)plot.getPlotpanel().getLayout();
        Vector<Double> heights = new Vector<Double>(viewports.size());
        double total = 0.0;
        double minHeight = Double.POSITIVE_INFINITY;
        double maxHeight = Double.NEGATIVE_INFINITY;
        for (Object obj : viewports) {
            Viewport vp = (Viewport)obj;
            double height = gbl.getConstraints((Component)vp).weighty;
            if (height > maxHeight) {
                maxHeight = height;
            }
            if (height < minHeight) {
                minHeight = height;
            }
            heights.add(height);
            total += height;
        }
        Vector<Double> weights = new Vector<Double>(viewports.size());
        for (Double height : heights) {
            weights.add(100.0 * height / total);
        }
        HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
        for (int i = 0; i < viewports.size(); ++i) {
            Viewport vp = (Viewport)viewports.get(i);
            ViewportDrawProp prop = vp.getProperties();
            List<Element> axisElems = this.buildAxisElems(vp, i == viewports.size() - 1);
            isDefault.clear();
            isDefault.put("drawBorder", prop.drawBorder == PlotSpecification.defaultViewportProp.drawBorder);
            isDefault.put("borderColor", PlotSpecification.sameColor(prop.borderColor, PlotSpecification.defaultViewportProp.borderColor));
            isDefault.put("borderStyle", PlotSpecification.sameArray(prop.borderStyle, PlotSpecification.defaultViewportProp.borderStyle));
            isDefault.put("borderWeight", prop.borderWeight == PlotSpecification.defaultViewportProp.borderWeight);
            isDefault.put("drawBackground", prop.drawBackground == PlotSpecification.defaultViewportProp.drawBackground);
            isDefault.put("backgroundColor", PlotSpecification.sameColor(prop.backgroundColor, PlotSpecification.defaultViewportProp.backgroundColor));
            isDefault.put("viewportAlpha", prop.viewportAlpha == PlotSpecification.defaultViewportProp.viewportAlpha);
            isDefault.put("fillPattern", prop.fillPattern == PlotSpecification.defaultViewportProp.fillPattern);
            isDefault.put("border", PlotSpecification.all(isDefault, "drawBorder", "borderColor", "borderStyle", "borderWeight"));
            isDefault.put("background", PlotSpecification.all(isDefault, "drawBackground", "backgroundColor", "viewportAlpha", "fillPattern"));
            isDefault.put("weight", maxHeight - minHeight < 2.0);
            Element viewportElem = new Element("viewport").setAttribute("name", String.format("%d,1", i + 1));
            viewportElems.add(viewportElem);
            if (this.includeDefaults || !((Boolean)isDefault.get("weight")).booleanValue()) {
                viewportElem.setAttribute("weight", Double.toString((Double)weights.get(i)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("border")).booleanValue()) {
                Element borderElem = new Element("border");
                viewportElem.addContent((Content)borderElem);
                if (prop.borderColor != null) {
                    borderElem.addContent((Content)this.buildColorElem(prop.borderColor, "color"));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("borderWeight")).booleanValue()) {
                    borderElem.addContent((Content)new Element("width").addContent(Float.toString(prop.borderWeight)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("drawBorder")).booleanValue()) {
                    borderElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.drawBorder)));
                }
            }
            if ((this.includeDefaults || !((Boolean)isDefault.get("background")).booleanValue()) && prop.backgroundColor != null) {
                Element backgroundElem = new Element("background");
                viewportElem.addContent((Content)backgroundElem);
                Color color = new Color(prop.backgroundColor.getRed(), prop.backgroundColor.getGreen(), prop.backgroundColor.getBlue(), 255 - (int)((double)prop.viewportAlpha * 2.55 + 0.5));
                backgroundElem.addContent((Content)this.buildColorElem(color, "color"));
                if (this.includeDefaults || !((Boolean)isDefault.get("fillPattern")).booleanValue()) {
                    backgroundElem.addContent((Content)new Element("fill-pattern").addContent(fillPatternNames.get(prop.fillPattern)));
                }
                if (this.includeDefaults || !((Boolean)isDefault.get("drawBackground")).booleanValue()) {
                    backgroundElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.drawBackground)));
                }
            }
            for (Element axisElem : axisElems) {
                if (axisElem.getAttributes().size() + axisElem.getChildren().size() <= 0) continue;
                viewportElem.addContent((Content)axisElem);
            }
            try {
                viewportElem.addContent(this.buildAxisMarkerElems(vp));
                continue;
            }
            catch (IllegalAddException illegalAddException) {
                // empty catch block
            }
        }
        return viewportElems;
    }

    protected Element buildLegendElem(G2dDialog plot) {
        Element legendElem = null;
        LegendPanel legend = plot.getLegend();
        LegendPanelProp prop = legend == null ? defaultLegendProp : legend.getProperties();
        HashMap<String, Boolean> isDefault = new HashMap<String, Boolean>();
        isDefault.put("position", prop.legendPosition == PlotSpecification.defaultLegendProp.legendPosition);
        isDefault.put("title", prop.hasTitleText == PlotSpecification.defaultLegendProp.hasTitleText);
        isDefault.put("left", prop.hasLeftText == PlotSpecification.defaultLegendProp.hasLeftText);
        isDefault.put("right", prop.hasRightText == PlotSpecification.defaultLegendProp.hasRightText);
        isDefault.put("background", legend == null || legend.getBackground().equals(new JPanel().getBackground()));
        isDefault.put("visible", prop.legendVisible == PlotSpecification.defaultLegendProp.legendVisible);
        isDefault.put("legend", PlotSpecification.all(isDefault, "position", "title", "right", "left", "background", "visible"));
        if (this.includeDefaults || !((Boolean)isDefault.get("legend")).booleanValue()) {
            legendElem = new Element("legend");
            if (this.includeDefaults || !((Boolean)isDefault.get("position")).booleanValue()) {
                legendElem.addContent((Content)new Element("position").addContent(legendLocationNames.get(prop.legendPosition)));
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("title")).booleanValue()) {
                try {
                    legendElem.addContent((Content)this.buildLabelElem(legend.getTitleLabel(), "title", PlotSpecification.makeList("expectedVisibility", false)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("left")).booleanValue()) {
                try {
                    legendElem.addContent((Content)this.buildLabelElem(legend.getLeftLabel(), "left-block", PlotSpecification.makeList("expectedVisibility", false)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("right")).booleanValue()) {
                try {
                    legendElem.addContent((Content)this.buildLabelElem(legend.getRightLabel(), "right-block", PlotSpecification.makeList("expectedVisibility", false)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((this.includeDefaults || !((Boolean)isDefault.get("background")).booleanValue()) && legend != null && legend.getBackground() != null) {
                try {
                    legendElem.addContent((Content)this.buildColorElem(legend.getBackground(), "background"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.includeDefaults || !((Boolean)isDefault.get("visible")).booleanValue()) {
                legendElem.addContent((Content)new Element("visible").addContent(Boolean.toString(prop.legendVisible)));
            }
        }
        return legendElem;
    }

    protected Document buildPlotDoc(G2dDialog plot) throws IOException {
        Element titleElem;
        String name = plot.getTitle();
        G2dTitle title = plot.getPlotTitle();
        Dimension size = plot.getSize();
        G2dPanel plotPanel = plot.getPlotpanel();
        Color background = plotPanel.getBackground();
        int spacing = plotPanel.getHorizontalViewportSpacing();
        if (spacing < 0) {
            spacing = PlotSpecification.defaultPanelProp.viewportSpaceSize;
        }
        boolean useLineStyles = G2dDialog.getUseLineStyles();
        Element root = new Element("plot");
        Document doc = new Document(root);
        if (this.includeDefaults || !TextUtil.equals(name, null)) {
            root.setAttribute("name", name);
        }
        if (this.includeDefaults || size.width != 600) {
            root.setAttribute("width", Integer.toString(size.width));
        }
        if (this.includeDefaults || size.height != 500) {
            root.setAttribute("height", Integer.toString(size.height));
        }
        if (this.includeDefaults || spacing != PlotSpecification.defaultPanelProp.viewportSpaceSize) {
            root.setAttribute("spacing", Integer.toString(spacing));
        }
        root.setAttribute("use-default-line-styles", Boolean.toString(useLineStyles));
        if (background != null && (this.includeDefaults || !background.equals(new JPanel().getBackground()))) {
            root.addContent((Content)this.buildColorElem(background, "background"));
        }
        if ((this.includeDefaults || title != null && !PlotSpecification.sameProperties(title.getProperties(), defaultLabelProp)) && (titleElem = this.buildLabelElem(title, "title", PlotSpecification.makeList("expectedVisibility", false))) != null) {
            root.addContent((Content)titleElem);
        }
        try {
            root.addContent(this.buildViewportElems(plot));
        }
        catch (IllegalAddException illegalAddException) {
            // empty catch block
        }
        try {
            root.addContent((Content)this.buildLegendElem(plot));
        }
        catch (IllegalAddException illegalAddException) {
            // empty catch block
        }
        this.prune(root);
        return doc;
    }

    public G2dDialog buildPlot(File plotFile) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(plotFile));
        StringBuilder sb = new StringBuilder();
        String line = r.readLine();
        while (line != null) {
            sb.append(line);
            line = r.readLine();
        }
        r.close();
        return this.buildPlot(sb.toString());
    }

    public G2dDialog buildPlot(String plotText) throws Exception {
        G2dDialog plot = null;
        Document doc = null;
        if (plotText.startsWith("plot")) {
            doc = PlotSpecification.parsePlotSpecText(plotText);
        } else if (plotText.startsWith("<?xml") || plotText.startsWith("<plot")) {
            doc = new SAXBuilder().build((Reader)new StringReader(plotText));
        } else {
            throw new IllegalArgumentException("Text is neither plot specification text nor plot specification XML");
        }
        plot = this.buildPlot(doc);
        return plot;
    }

    protected G2dDialog buildPlot(Document plotDoc) throws Exception {
        G2dDialog plot = null;
        Element root = plotDoc.getRootElement();
        if (!root.getName().equals("plot")) {
            throw new IllegalArgumentException("Document does not have root element named \"plot\"");
        }
        List viewportElems = root.getChildren("viewport");
        Element titleElem = root.getChild("title");
        Element legendElem = root.getChild("legend");
        Element backgroundElem = root.getChild("background");
        String spacing = root.getAttributeValue("spacing");
        String width = root.getAttributeValue("width");
        String height = root.getAttributeValue("height");
        String name = root.getAttributeValue("name");
        String useLineStyles = root.getAttributeValue("use-default-line-sytles");
        String timeZone = root.getAttributeValue("time-zone");
        PlotLayout plotLayout = new PlotLayout();
        Map<String, Element> curveElementMap = this.buildViewportLayouts(plotLayout, viewportElems);
        plot = new G2dDialog();
        if (spacing != null) {
            plot.getPlotpanel().setHorizontalViewportSpacing(Integer.parseInt(spacing));
        }
        if (width != null && height != null) {
            plot.setSize(Integer.parseInt(width), Integer.parseInt(height));
        }
        if (name != null) {
            plot.setTitle(name);
        }
        plot.configurePlotLayout(plotLayout);
        if (timeZone != null) {
            TimeZone tz = PlotSpecification.getTimeZone(timeZone);
            if (tz == null) {
                logger.warning(String.format("Plot time zone \"%s\" is invalid, no time zone conversion will be performed", timeZone));
            } else {
                this.setTimeZone(tz);
            }
        }
        plot.initPlot();
        if (titleElem != null) {
            PlotSpecification.customizeTitle(plot, titleElem);
        }
        if (viewportElems != null && viewportElems.size() > 0) {
            PlotSpecification.customizeViewports(plot, viewportElems, curveElementMap);
        }
        if (legendElem != null) {
            PlotSpecification.customizeLegend(plot, legendElem);
        } else {
            PlotSpecification.updateLegend(plot);
        }
        if (backgroundElem != null) {
            String[] parts = TextUtil.split(PlotSpecification.getColorString(backgroundElem), ",", "L");
            plot.getPlotpanel().setBackground(new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3])));
        }
        for (Object obj : plot.getViewports()) {
            Viewport vp = (Viewport)obj;
            for (String axisName : Arrays.asList("x1", "y1", "y2")) {
                Axis axis = vp.getAxis(axisName);
                if (axis == null || axis.getScaleMax() != axis.getViewMax() || axis.getScaleMin() != axis.getViewMin()) continue;
                axis.unZoom();
            }
        }
        if ("true".equals(useLineStyles) || "1".equals(useLineStyles)) {
            plot.setUseLineStylesOn();
        } else {
            plot.setUseLineStylesOff();
        }
        Dimension size = plot.getSize();
        plot.setSize(1, 1);
        plot.setSize(size);
        return plot;
    }

    protected static void customizeTitle(G2dDialog plot, Element titleElem) {
        G2dPanel plotPanel = plot.getPlotpanel();
        if (plotPanel._title != null) {
            TitleDrawProp prop = plotPanel._title.getTitleProperties();
            if (titleElem != null) {
                String[] parts;
                Element textElem = titleElem.getChild("text");
                Element fontElem = titleElem.getChild("font");
                Element alignElem = titleElem.getChild("alignment");
                Element rotateElem = titleElem.getChild("rotation");
                Element iconElem = titleElem.getChild("iconpath");
                Element areaElem = titleElem.getChild("area");
                Element spacingElem = titleElem.getChild("spacing");
                Element showElem = titleElem.getChild("visible");
                if (textElem != null) {
                    prop.text = textElem.getTextTrim();
                }
                if (fontElem != null) {
                    Element famElem = fontElem.getChild("family");
                    Element styleElem = fontElem.getChild("style");
                    Element sizeElem = fontElem.getChild("size");
                    Element colorElem = fontElem.getChild("color");
                    Element sizesElem = fontElem.getChild("sizes");
                    if (famElem != null) {
                        prop.fontFamily = famElem.getTextTrim();
                    }
                    if (styleElem != null) {
                        prop.fontStyle = fontStyleNumbers.get(styleElem.getTextTrim());
                    }
                    if (sizeElem != null) {
                        prop.fontSize = Integer.parseInt(sizeElem.getTextTrim());
                        if (sizesElem != null) {
                            Element tinyElem = sizesElem.getChild("tiny");
                            Element minElem = sizesElem.getChild("min");
                            Element maxElem = sizesElem.getChild("max");
                            if (tinyElem != null) {
                                prop.tinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                            }
                            if (minElem != null) {
                                prop.minFontSize = Integer.parseInt(minElem.getTextTrim());
                            }
                            if (maxElem != null) {
                                prop.maxFontSize = Integer.parseInt(maxElem.getTextTrim());
                            }
                        }
                    }
                    if (colorElem != null) {
                        parts = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                        prop.textColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                    }
                }
                if (alignElem != null) {
                    prop.align = alignmentNumbers.get(alignElem.getTextTrim());
                }
                if (rotateElem != null) {
                    prop.rotation = Integer.parseInt(rotateElem.getTextTrim());
                }
                if (iconElem != null) {
                    prop.iconPath = iconElem.getTextTrim();
                }
                if (areaElem != null) {
                    Element colorElem;
                    Element borderElem = areaElem.getChild("border");
                    Element backgroundElem = areaElem.getChild("background");
                    if (borderElem != null) {
                        colorElem = borderElem.getChild("color");
                        Element styleElem = borderElem.getChild("style");
                        Element widthElem = borderElem.getChild("width");
                        Element bShowElem = borderElem.getChild("visible");
                        if (colorElem != null) {
                            String[] parts2 = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                            prop.borderColor = new Color(Integer.parseInt(parts2[0]), Integer.parseInt(parts2[1]), Integer.parseInt(parts2[2]), Integer.parseInt(parts2[3]));
                        }
                        if (styleElem != null) {
                            prop.borderStyle = lineStylePatterns.get(styleElem.getTextTrim());
                        }
                        if (widthElem != null) {
                            prop.borderWeight = Float.parseFloat(widthElem.getTextTrim());
                        }
                        if (bShowElem != null) {
                            String text = bShowElem.getTextTrim();
                            boolean bl = prop.drawBorder = "true".equals(text) || "1".equals(text);
                        }
                    }
                    if (backgroundElem != null) {
                        colorElem = backgroundElem.getChild("color");
                        Element patternElem = backgroundElem.getChild("fill-pattern");
                        Element bkShowElem = backgroundElem.getChild("visible");
                        if (colorElem != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                            prop.backgroundColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (patternElem != null) {
                            prop.fillPattern = fillPatternNumbers.get(patternElem.getTextTrim());
                        }
                        if (bkShowElem != null) {
                            String text = bkShowElem.getTextTrim();
                            boolean bl = prop.drawBackground = "true".equals(text) || "1".equals(text);
                        }
                    }
                }
                if (spacingElem != null) {
                    prop.space = Integer.parseInt(spacingElem.getTextTrim());
                }
                if (showElem != null) {
                    String text = showElem.getTextTrim();
                    prop.drawTitle = "true".equals(text) || "1".equals(text);
                }
            }
            plotPanel._title.setProperties(prop);
        }
    }

    protected static void customizeLegend(G2dDialog plot, Element legendElem) {
        LegendPanel legend = plot.getLegend();
        if (legend != null) {
            String[] parts;
            Element bkShowElem;
            Element patternElem;
            String[] parts2;
            Element bShowElem;
            Element widthElem;
            Element styleElem;
            Element colorElem;
            Element backgroundElem;
            Element borderElem;
            Element maxElem;
            Element minElem;
            Element tinyElem;
            Element sizesElem;
            Element colorElem2;
            Element sizeElem;
            Element styleElem2;
            Element famElem;
            String[] parts3;
            boolean visible;
            String text;
            Element showElem;
            Element spacingElem;
            Element areaElem;
            Element iconElem;
            Element rotateElem;
            Element alignElem;
            Element fontElem;
            Element textElem;
            LegendPanelProp prop = legend.getProperties();
            Element lPosElem = legendElem.getChild("position");
            Element titleElem = legendElem.getChild("title");
            Element leftElem = legendElem.getChild("left-block");
            Element rightElem = legendElem.getChild("right-block");
            Element lBkgElem = legendElem.getChild("background");
            Element lShowElem = legendElem.getChild("visible");
            if (lPosElem != null) {
                plot.setLegendLocation(lPosElem.getTextTrim());
                prop = legend.getProperties();
            }
            if (lShowElem != null) {
                String text2 = lShowElem.getTextTrim();
                plot.getPlotpanel().setLegendVisible("true".equals(text2) || "1".equals(text2));
                prop = legend.getProperties();
            }
            if (lBkgElem != null) {
                plot.setLegendBackground(PlotSpecification.getColorString(lBkgElem));
                prop = legend.getProperties();
            }
            if (titleElem != null) {
                textElem = titleElem.getChild("text");
                fontElem = titleElem.getChild("font");
                alignElem = titleElem.getChild("alignment");
                rotateElem = titleElem.getChild("rotation");
                iconElem = titleElem.getChild("iconpath");
                areaElem = titleElem.getChild("area");
                spacingElem = titleElem.getChild("spacing");
                showElem = titleElem.getChild("visible");
                if (showElem != null) {
                    text = showElem.getTextTrim();
                    prop.titleTextProp.showLabel = visible = "true".equals(text) || "1".equals(text);
                    prop.hasTitleText = visible;
                    if (textElem != null) {
                        prop.titleTextProp.text = textElem.getTextTrim();
                    }
                    if (fontElem != null) {
                        parts3 = TextUtil.split(PlotSpecification.getFontString(fontElem), ",", "L");
                        prop.titleTextProp.font = new Font(parts3[0], (int)fontStyleNumbers.get(parts3[1]), Integer.parseInt(parts3[2]));
                        famElem = fontElem.getChild("family");
                        styleElem2 = fontElem.getChild("style");
                        sizeElem = fontElem.getChild("size");
                        colorElem2 = fontElem.getChild("color");
                        sizesElem = fontElem.getChild("sizes");
                        if (famElem != null) {
                            prop.titleTextProp.fontFamily = famElem.getTextTrim();
                        }
                        if (styleElem2 != null) {
                            prop.titleTextProp.fontStyle = fontStyleNumbers.get(styleElem2.getTextTrim());
                        }
                        if (sizeElem != null) {
                            prop.titleTextProp.fontSize = Integer.parseInt(sizeElem.getTextTrim());
                            if (sizesElem != null) {
                                tinyElem = sizesElem.getChild("tiny");
                                minElem = sizesElem.getChild("min");
                                maxElem = sizesElem.getChild("max");
                                if (tinyElem != null) {
                                    prop.titleTextProp.tinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                                }
                                if (minElem != null) {
                                    prop.titleTextProp.minFontSize = Integer.parseInt(minElem.getTextTrim());
                                }
                                if (maxElem != null) {
                                    prop.titleTextProp.maxFontSize = Integer.parseInt(maxElem.getTextTrim());
                                }
                            }
                        }
                        if (colorElem2 != null) {
                            parts3 = TextUtil.split(PlotSpecification.getColorString(colorElem2), ",", "L");
                            prop.titleTextProp.textColor = new Color(Integer.parseInt(parts3[0]), Integer.parseInt(parts3[1]), Integer.parseInt(parts3[2]), Integer.parseInt(parts3[3]));
                        }
                    }
                    if (alignElem != null) {
                        prop.titleTextProp.align = alignmentNumbers.get(alignElem.getTextTrim());
                    }
                    if (rotateElem != null) {
                        prop.titleTextProp.rotation = Integer.parseInt(rotateElem.getTextTrim());
                    }
                    if (iconElem != null) {
                        prop.titleTextProp.iconPath = iconElem.getTextTrim();
                    }
                    if (areaElem != null) {
                        borderElem = areaElem.getChild("border");
                        backgroundElem = areaElem.getChild("background");
                        if (borderElem != null) {
                            colorElem = borderElem.getChild("color");
                            styleElem = borderElem.getChild("style");
                            widthElem = borderElem.getChild("width");
                            bShowElem = borderElem.getChild("visible");
                            if (colorElem != null) {
                                parts2 = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.titleTextProp.borderColor = new Color(Integer.parseInt(parts2[0]), Integer.parseInt(parts2[1]), Integer.parseInt(parts2[2]), Integer.parseInt(parts2[3]));
                            }
                            if (styleElem != null) {
                                prop.titleTextProp.borderStyle = lineStylePatterns.get(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                prop.titleTextProp.borderWeight = Float.parseFloat(widthElem.getTextTrim());
                            }
                            if (bShowElem != null) {
                                text = bShowElem.getTextTrim();
                                boolean bl = prop.titleTextProp.drawBorder = "true".equals(text) || "1".equals(text);
                            }
                        }
                        if (backgroundElem != null) {
                            colorElem = backgroundElem.getChild("color");
                            patternElem = backgroundElem.getChild("fill-pattern");
                            bkShowElem = backgroundElem.getChild("visible");
                            if (colorElem != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.titleTextProp.backgroundColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (patternElem != null) {
                                prop.titleTextProp.fillPattern = fillPatternNumbers.get(patternElem.getTextTrim());
                            }
                            if (bkShowElem != null) {
                                text = bkShowElem.getTextTrim();
                                boolean bl = prop.titleTextProp.drawBackground = "true".equals(text) || "1".equals(text);
                            }
                        }
                    }
                    if (spacingElem != null) {
                        prop.titleTextProp.space = Integer.parseInt(spacingElem.getTextTrim());
                    }
                }
            }
            if (leftElem != null) {
                textElem = leftElem.getChild("text");
                fontElem = leftElem.getChild("font");
                alignElem = leftElem.getChild("alignment");
                rotateElem = leftElem.getChild("rotation");
                iconElem = leftElem.getChild("iconpath");
                areaElem = leftElem.getChild("area");
                spacingElem = leftElem.getChild("spacing");
                showElem = leftElem.getChild("visible");
                if (showElem != null) {
                    text = showElem.getTextTrim();
                    prop.leftTextProp.showLabel = visible = "true".equals(text) || "1".equals(text);
                    prop.hasLeftText = visible;
                    if (textElem != null) {
                        prop.leftTextProp.text = textElem.getTextTrim();
                    }
                    if (fontElem != null) {
                        parts3 = TextUtil.split(PlotSpecification.getFontString(fontElem), ",", "L");
                        prop.leftTextProp.font = new Font(parts3[0], (int)fontStyleNumbers.get(parts3[1]), Integer.parseInt(parts3[2]));
                        famElem = fontElem.getChild("family");
                        styleElem2 = fontElem.getChild("style");
                        sizeElem = fontElem.getChild("size");
                        colorElem2 = fontElem.getChild("color");
                        sizesElem = fontElem.getChild("sizes");
                        if (famElem != null) {
                            prop.leftTextProp.fontFamily = famElem.getTextTrim();
                        }
                        if (styleElem2 != null) {
                            prop.leftTextProp.fontStyle = fontStyleNumbers.get(styleElem2.getTextTrim());
                        }
                        if (sizeElem != null) {
                            prop.leftTextProp.fontSize = Integer.parseInt(sizeElem.getTextTrim());
                            if (sizesElem != null) {
                                tinyElem = sizesElem.getChild("tiny");
                                minElem = sizesElem.getChild("min");
                                maxElem = sizesElem.getChild("max");
                                if (tinyElem != null) {
                                    prop.leftTextProp.tinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                                }
                                if (minElem != null) {
                                    prop.leftTextProp.minFontSize = Integer.parseInt(minElem.getTextTrim());
                                }
                                if (maxElem != null) {
                                    prop.leftTextProp.maxFontSize = Integer.parseInt(maxElem.getTextTrim());
                                }
                            }
                        }
                        if (colorElem2 != null) {
                            parts3 = TextUtil.split(PlotSpecification.getColorString(colorElem2), ",", "L");
                            prop.leftTextProp.textColor = new Color(Integer.parseInt(parts3[0]), Integer.parseInt(parts3[1]), Integer.parseInt(parts3[2]), Integer.parseInt(parts3[3]));
                        }
                    }
                    if (alignElem != null) {
                        prop.leftTextProp.align = alignmentNumbers.get(alignElem.getTextTrim());
                    }
                    if (rotateElem != null) {
                        prop.leftTextProp.rotation = Integer.parseInt(rotateElem.getTextTrim());
                    }
                    if (iconElem != null) {
                        prop.leftTextProp.iconPath = iconElem.getTextTrim();
                    }
                    if (areaElem != null) {
                        borderElem = areaElem.getChild("border");
                        backgroundElem = areaElem.getChild("background");
                        if (borderElem != null) {
                            colorElem = borderElem.getChild("color");
                            styleElem = borderElem.getChild("style");
                            widthElem = borderElem.getChild("width");
                            bShowElem = borderElem.getChild("visible");
                            if (colorElem != null) {
                                parts2 = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.leftTextProp.borderColor = new Color(Integer.parseInt(parts2[0]), Integer.parseInt(parts2[1]), Integer.parseInt(parts2[2]), Integer.parseInt(parts2[3]));
                            }
                            if (styleElem != null) {
                                prop.leftTextProp.borderStyle = lineStylePatterns.get(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                prop.leftTextProp.borderWeight = Float.parseFloat(widthElem.getTextTrim());
                            }
                            if (bShowElem != null) {
                                text = bShowElem.getTextTrim();
                                boolean bl = prop.leftTextProp.drawBorder = "true".equals(text) || "1".equals(text);
                            }
                        }
                        if (backgroundElem != null) {
                            colorElem = backgroundElem.getChild("color");
                            patternElem = backgroundElem.getChild("fill-pattern");
                            bkShowElem = backgroundElem.getChild("visible");
                            if (colorElem != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.leftTextProp.backgroundColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (patternElem != null) {
                                prop.leftTextProp.fillPattern = fillPatternNumbers.get(patternElem.getTextTrim());
                            }
                            if (bkShowElem != null) {
                                text = bkShowElem.getTextTrim();
                                boolean bl = prop.leftTextProp.drawBackground = "true".equals(text) || "1".equals(text);
                            }
                        }
                    }
                    if (spacingElem != null) {
                        prop.leftTextProp.space = Integer.parseInt(spacingElem.getTextTrim());
                    }
                }
            }
            if (rightElem != null) {
                textElem = rightElem.getChild("text");
                fontElem = rightElem.getChild("font");
                alignElem = rightElem.getChild("alignment");
                rotateElem = rightElem.getChild("rotation");
                iconElem = rightElem.getChild("iconpath");
                areaElem = rightElem.getChild("area");
                spacingElem = rightElem.getChild("spacing");
                showElem = rightElem.getChild("visible");
                if (showElem != null) {
                    text = showElem.getTextTrim();
                    prop.rightTextProp.showLabel = visible = "true".equals(text) || "1".equals(text);
                    prop.hasRightText = visible;
                    if (textElem != null) {
                        prop.rightTextProp.text = textElem.getTextTrim();
                    }
                    if (fontElem != null) {
                        parts3 = TextUtil.split(PlotSpecification.getFontString(fontElem), ",", "L");
                        prop.rightTextProp.font = new Font(parts3[0], (int)fontStyleNumbers.get(parts3[1]), Integer.parseInt(parts3[2]));
                        famElem = fontElem.getChild("family");
                        styleElem2 = fontElem.getChild("style");
                        sizeElem = fontElem.getChild("size");
                        colorElem2 = fontElem.getChild("color");
                        sizesElem = fontElem.getChild("sizes");
                        if (famElem != null) {
                            prop.rightTextProp.fontFamily = famElem.getTextTrim();
                        }
                        if (styleElem2 != null) {
                            prop.rightTextProp.fontStyle = fontStyleNumbers.get(styleElem2.getTextTrim());
                        }
                        if (sizeElem != null) {
                            prop.rightTextProp.fontSize = Integer.parseInt(sizeElem.getTextTrim());
                            if (sizesElem != null) {
                                tinyElem = sizesElem.getChild("tiny");
                                minElem = sizesElem.getChild("min");
                                maxElem = sizesElem.getChild("max");
                                if (tinyElem != null) {
                                    prop.rightTextProp.tinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                                }
                                if (minElem != null) {
                                    prop.rightTextProp.minFontSize = Integer.parseInt(minElem.getTextTrim());
                                }
                                if (maxElem != null) {
                                    prop.rightTextProp.maxFontSize = Integer.parseInt(maxElem.getTextTrim());
                                }
                            }
                        }
                        if (colorElem2 != null) {
                            parts3 = TextUtil.split(PlotSpecification.getColorString(colorElem2), ",", "L");
                            prop.rightTextProp.textColor = new Color(Integer.parseInt(parts3[0]), Integer.parseInt(parts3[1]), Integer.parseInt(parts3[2]), Integer.parseInt(parts3[3]));
                        }
                    }
                    if (alignElem != null) {
                        prop.rightTextProp.align = alignmentNumbers.get(alignElem.getTextTrim());
                    }
                    if (rotateElem != null) {
                        prop.rightTextProp.rotation = Integer.parseInt(rotateElem.getTextTrim());
                    }
                    if (iconElem != null) {
                        prop.rightTextProp.iconPath = iconElem.getTextTrim();
                    }
                    if (areaElem != null) {
                        borderElem = areaElem.getChild("border");
                        backgroundElem = areaElem.getChild("background");
                        if (borderElem != null) {
                            colorElem = borderElem.getChild("color");
                            styleElem = borderElem.getChild("style");
                            widthElem = borderElem.getChild("width");
                            bShowElem = borderElem.getChild("visible");
                            if (colorElem != null) {
                                parts2 = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.rightTextProp.borderColor = new Color(Integer.parseInt(parts2[0]), Integer.parseInt(parts2[1]), Integer.parseInt(parts2[2]), Integer.parseInt(parts2[3]));
                            }
                            if (styleElem != null) {
                                prop.rightTextProp.borderStyle = lineStylePatterns.get(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                prop.rightTextProp.borderWeight = Float.parseFloat(widthElem.getTextTrim());
                            }
                            if (bShowElem != null) {
                                text = bShowElem.getTextTrim();
                                boolean bl = prop.rightTextProp.drawBorder = "true".equals(text) || "1".equals(text);
                            }
                        }
                        if (backgroundElem != null) {
                            colorElem = backgroundElem.getChild("color");
                            patternElem = backgroundElem.getChild("fill-pattern");
                            bkShowElem = backgroundElem.getChild("visible");
                            if (colorElem != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(colorElem), ",", "L");
                                prop.rightTextProp.backgroundColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (patternElem != null) {
                                prop.rightTextProp.fillPattern = fillPatternNumbers.get(patternElem.getTextTrim());
                            }
                            if (bkShowElem != null) {
                                text = bkShowElem.getTextTrim();
                                boolean bl = prop.rightTextProp.drawBackground = "true".equals(text) || "1".equals(text);
                            }
                        }
                    }
                    if (spacingElem != null) {
                        prop.rightTextProp.space = Integer.parseInt(spacingElem.getTextTrim());
                    }
                }
            }
            PlotSpecification.updateLegend(plot, prop);
        }
    }

    protected static void customizeViewports(G2dDialog plot, List<Element> viewportElems, Map<String, Element> curveElementMap) {
        int viewportCount = Math.min(viewportElems.size(), plot.getViewports().size());
        Element elem = null;
        Element childElem = null;
        String text = null;
        for (int i = 0; i < viewportCount; ++i) {
            Element colorElem;
            Object alignElem;
            Viewport vp = plot.getViewport(i);
            Element viewportElem = viewportElems.get(i);
            elem = viewportElem.getChild("border");
            if (elem != null) {
                childElem = elem.getChild("color");
                if (childElem != null) {
                    vp.setBorderColor(PlotSpecification.getColorString(childElem));
                }
                if ((childElem = elem.getChild("style")) != null) {
                    logger.info("Setting viewport border style is not supported.");
                }
                if ((childElem = elem.getChild("width")) != null) {
                    vp.setBorderWeight(Float.parseFloat(childElem.getTextTrim()));
                }
                if ((childElem = elem.getChild("visible")) != null) {
                    text = childElem.getTextTrim();
                    vp.setBorderVisible(text.equals("true") || text.equals("1"));
                }
            }
            if ((elem = viewportElem.getChild("background")) != null) {
                childElem = elem.getChild("color");
                if (childElem != null) {
                    vp.setBackground(PlotSpecification.getColorString(childElem));
                }
                if ((childElem = elem.getChild("fill-pattern")) != null) {
                    vp.setFillPattern(childElem.getTextTrim());
                }
                if ((childElem = elem.getChild("visible")) != null) {
                    text = childElem.getTextTrim();
                    vp.setBackgroundVisible(text.equals("true") || text.equals("1"));
                }
            }
            for (String axisName : Arrays.asList("x1", "y1", "y2")) {
                Element scaleElem;
                AxisTics tics;
                Element ticsElem;
                Element colorElem2;
                Axis axis;
                Element axisElem = viewportElem.getChild(String.format("%s-axis", axisName));
                if (axisElem == null || (axis = vp.getAxis(axisName)) == null) continue;
                Element labelElem = axisElem.getChild("label");
                if (labelElem != null) {
                    G2dLabel label = vp.getAxisLabel(axisName);
                    if (label == null) {
                        G2dPanel plotPanel = plot.getPlotpanel();
                        label = new G2dLabel(plotPanel, 1);
                        if (axisName.equals("x1")) {
                            ((ViewportLinkRecord)plotPanel._viewportLinkTable.get((Object)vp)).x1label = label;
                        } else if (axisName.equals("y1")) {
                            ((ViewportLinkRecord)plotPanel._viewportLinkTable.get((Object)vp)).y1label = label;
                        } else if (axisName.equals("y2")) {
                            ((ViewportLinkRecord)plotPanel._viewportLinkTable.get((Object)vp)).y2label = label;
                        }
                    }
                    Element textElem = labelElem.getChild("text");
                    Element fontElem = labelElem.getChild("font");
                    alignElem = labelElem.getChild("alignment");
                    Element rotateElem = labelElem.getChild("rotation");
                    Element iconElem = labelElem.getChild("iconpath");
                    Element areaElem = labelElem.getChild("area");
                    Element spacingElem = labelElem.getChild("spacing");
                    Element showElem = labelElem.getChild("visible");
                    if (textElem != null) {
                        label.setText(textElem.getTextTrim());
                    }
                    if (fontElem != null) {
                        colorElem2 = fontElem.getChild("color");
                        Element sizeElem = fontElem.getChild("size");
                        Element sizesElem = fontElem.getChild("sizes");
                        label.setFont(PlotSpecification.getFontString(fontElem));
                        if (colorElem2 != null) {
                            label.setForeground(PlotSpecification.getColorString(colorElem2));
                        }
                        if (sizeElem != null) {
                            label.setFontSize(Integer.parseInt(sizeElem.getTextTrim()));
                            if (sizesElem != null) {
                                Element tinyElem = sizesElem.getChild("tiny");
                                Element minElem = sizesElem.getChild("min");
                                Element maxElem = sizesElem.getChild("max");
                                if (tinyElem != null && minElem != null && maxElem != null) {
                                    label.setFontSizes(Integer.parseInt(sizeElem.getTextTrim()), Integer.parseInt(tinyElem.getTextTrim()), Integer.parseInt(minElem.getTextTrim()), Integer.parseInt(maxElem.getTextTrim()));
                                }
                            }
                        }
                    }
                    if (alignElem != null) {
                        label.setAlignment(alignElem.getTextTrim());
                    }
                    if (rotateElem != null) {
                        label.setRotation(Integer.parseInt(rotateElem.getTextTrim()));
                    }
                    if (iconElem != null) {
                        label.setIcon(iconElem.getTextTrim());
                    }
                    if (areaElem != null) {
                        Element colorElem3;
                        Element borderElem = labelElem.getChild("border");
                        Element backgroundElem = labelElem.getChild("background");
                        if (borderElem != null) {
                            colorElem3 = borderElem.getChild("color");
                            Element styleElem = borderElem.getChild("style");
                            Element widthElem = borderElem.getChild("width");
                            Element showElem1 = borderElem.getChild("visible");
                            if (colorElem3 != null) {
                                label.setBorderColor(PlotSpecification.getColorString(colorElem3));
                            }
                            if (styleElem != null) {
                                label.setBorderStyle(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                label.setBorderWeight(Float.parseFloat(widthElem.getTextTrim()));
                            }
                            if (showElem1 != null) {
                                text = showElem1.getTextTrim();
                                label.setBorderVisible(text.equals("true") || text.equals("1"));
                            }
                        }
                        if (backgroundElem != null) {
                            colorElem3 = borderElem.getChild("color");
                            Element patternElem = borderElem.getChild("fill-pattern");
                            Element showElem2 = borderElem.getChild("visible");
                            if (colorElem3 != null) {
                                label.setBackground(PlotSpecification.getColorString(colorElem3));
                            }
                            if (patternElem != null) {
                                label.setFillPattern(patternElem.getTextTrim());
                            }
                            if (showElem2 != null) {
                                text = showElem2.getTextTrim();
                                label.setBackgroundVisible(text.equals("true") || text.equals("1"));
                            }
                        }
                    }
                    if (spacingElem != null) {
                        label.setSpacing(Integer.parseInt(spacingElem.getTextTrim()));
                    }
                    if (showElem != null) {
                        text = showElem.getTextTrim();
                        label.setVisible(text.equals("true") || text.equals("1"));
                    }
                }
                if ((ticsElem = axisElem.getChild("tics")) != null && (tics = vp.getAxisTics(axisName)) != null) {
                    AxisTicsDrawProp prop = tics.getProperties();
                    for (String category : Arrays.asList("major", "minor")) {
                        Element maxElem;
                        Element minElem;
                        Element tinyElem;
                        String[] parts;
                        Element categoryElem = ticsElem.getChild(category);
                        text = categoryElem.getAttributeValue("show-labels");
                        boolean showLabels = !"false".equals(text) && !"0".equals(text);
                        text = categoryElem.getAttributeValue("show-marks");
                        boolean showMarks = !"false".equals(text) && !"0".equals(text);
                        String fontString = PlotSpecification.getFontString(categoryElem);
                        colorElem2 = categoryElem.getChild("color");
                        Element sizesElem = categoryElem.getChild("sizes");
                        Element lengthElem = categoryElem.getChild("mark-lenth");
                        if (category.equals("major")) {
                            prop.drawMajorTicLabels = showLabels;
                            prop.drawMajorTics = showMarks;
                            parts = TextUtil.split(fontString.toLowerCase(), ",", "L");
                            if (!"".equals(parts[0])) {
                                prop.majorTicFontFamily = TextUtil.toTitleCase(parts[0]);
                            }
                            if (parts[1].indexOf("bold") != -1) {
                                prop.majorTicFontStyle |= 1;
                            }
                            if (parts[1].indexOf("italic") != -1) {
                                prop.majorTicFontStyle |= 2;
                            }
                            if (colorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(colorElem2), ",", "L");
                                prop.axisTicColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (sizesElem != null) {
                                tinyElem = sizesElem.getChild("tiny");
                                minElem = sizesElem.getChild("min");
                                maxElem = sizesElem.getChild("max");
                                if (tinyElem != null) {
                                    prop.majorTicTinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                                }
                                if (minElem != null) {
                                    prop.majorTicMinFontSize = Integer.parseInt(minElem.getTextTrim());
                                }
                                if (maxElem != null) {
                                    prop.majorTicMaxFontSize = Integer.parseInt(maxElem.getTextTrim());
                                }
                            }
                            if (lengthElem == null) continue;
                            prop.majorTicLength = Integer.parseInt(lengthElem.getTextTrim());
                            continue;
                        }
                        prop.drawMinorTicLabels = showLabels;
                        prop.drawMinorTics = showMarks;
                        parts = TextUtil.split(fontString.toLowerCase(), ",", "L");
                        if (!"".equals(parts[0])) {
                            prop.minorTicFontFamily = TextUtil.toTitleCase(parts[0]);
                        }
                        if (parts[1].indexOf("bold") != -1) {
                            prop.minorTicFontStyle |= 1;
                        }
                        if (parts[1].indexOf("italic") != -1) {
                            prop.minorTicFontStyle |= 2;
                        }
                        if (colorElem2 != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(colorElem2), ",", "L");
                            prop.minorTicLabelColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (sizesElem != null) {
                            tinyElem = sizesElem.getChild("tiny");
                            minElem = sizesElem.getChild("min");
                            maxElem = sizesElem.getChild("max");
                            if (tinyElem != null) {
                                prop.minorTicTinyFontSize = Integer.parseInt(tinyElem.getTextTrim());
                            }
                            if (minElem != null) {
                                prop.minorTicMinFontSize = Integer.parseInt(minElem.getTextTrim());
                            }
                            if (maxElem != null) {
                                prop.minorTicMaxFontSize = Integer.parseInt(maxElem.getTextTrim());
                            }
                        }
                        if (lengthElem == null) continue;
                        prop.minorTicLength = Integer.parseInt(lengthElem.getTextTrim());
                    }
                    tics.setProperties(prop);
                }
                if ((scaleElem = axisElem.getChild("scale")) != null) {
                    Element linearElem = scaleElem.getChild("linear");
                    Element logarithmicElem = scaleElem.getChild("logarithmic");
                    Element probabilityElem = scaleElem.getChild("probability");
                    Element datetimeElem = scaleElem.getChild("datetime");
                    Element durationElem = scaleElem.getChild("duration");
                    Element scaleTypeElem = null;
                    if (linearElem != null) {
                        scaleTypeElem = linearElem;
                    } else if (logarithmicElem != null) {
                        scaleTypeElem = logarithmicElem;
                    } else if (probabilityElem != null) {
                        scaleTypeElem = probabilityElem;
                    } else if (datetimeElem != null) {
                        scaleTypeElem = datetimeElem;
                    } else if (durationElem != null) {
                        scaleTypeElem = durationElem;
                    }
                    if (scaleTypeElem != null) {
                        if (linearElem != null || logarithmicElem != null || probabilityElem != null) {
                            Element scaleMinElem = scaleTypeElem.getChild("scale-minimum");
                            Element scaleMaxElem = scaleTypeElem.getChild("scale-maximum");
                            Element viewMinElem = scaleTypeElem.getChild("view-minimum");
                            Element viewMaxElem = scaleTypeElem.getChild("view-maximum");
                            Element minorIntvElem = scaleTypeElem.getChild("minor-tic-interval");
                            if (scaleMinElem != null) {
                                boolean auto;
                                axis.setMinimumLimit(Double.parseDouble(scaleMinElem.getTextTrim()));
                                text = scaleMinElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticMinimumOff();
                                }
                            }
                            if (scaleMaxElem != null) {
                                boolean auto;
                                axis.setMaximumLimit(Double.parseDouble(scaleMaxElem.getTextTrim()));
                                text = scaleMaxElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticMaximumOff();
                                }
                            }
                            if (viewMinElem != null) {
                                boolean auto;
                                axis.setActualMinimumValue(Double.parseDouble(viewMinElem.getTextTrim()));
                                text = viewMinElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticViewMinimumOff();
                                }
                            }
                            if (viewMaxElem != null) {
                                boolean auto;
                                axis.setActualMaximumValue(Double.parseDouble(viewMaxElem.getTextTrim()));
                                text = viewMaxElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticViewMaximumOff();
                                }
                            }
                            if (minorIntvElem != null) {
                                axis.setMinorTicInterval(Float.parseFloat(minorIntvElem.getTextTrim()));
                            }
                        } else {
                            HecTime t = null;
                            HecTime baseTime = null;
                            if (datetimeElem != null) {
                                t = new HecTime();
                            } else {
                                baseTime = new HecTime();
                                baseTime.set("01Jan3000 0000");
                            }
                            Element scaleMinElem = scaleTypeElem.getChild("scale-minimum");
                            Element scaleMaxElem = scaleTypeElem.getChild("scale-maximum");
                            Element viewMinElem = scaleTypeElem.getChild("view-minimum");
                            Element viewMaxElem = scaleTypeElem.getChild("view-maximum");
                            Element levelCountElem = scaleTypeElem.getChild("label-level-count");
                            if (scaleMinElem != null) {
                                boolean auto;
                                if (datetimeElem == null) {
                                    t = PlotSpecification.addDuration(baseTime, scaleMinElem.getTextTrim());
                                } else {
                                    t.setXML(scaleMinElem.getTextTrim());
                                }
                                axis.setMinimumLimit(t.value());
                                text = scaleMinElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticMinimumOff();
                                }
                            }
                            if (scaleMaxElem != null) {
                                boolean auto;
                                if (datetimeElem == null) {
                                    t = PlotSpecification.addDuration(baseTime, scaleMaxElem.getTextTrim());
                                } else {
                                    t.setXML(scaleMaxElem.getTextTrim());
                                }
                                axis.setMaximumLimit(t.value());
                                text = scaleMaxElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticMaximumOff();
                                }
                            }
                            if (viewMinElem != null) {
                                boolean auto;
                                if (datetimeElem == null) {
                                    t = PlotSpecification.addDuration(baseTime, viewMinElem.getTextTrim());
                                } else {
                                    t.setXML(viewMinElem.getTextTrim());
                                }
                                axis.setActualMinimumValue(t.value());
                                text = viewMinElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticViewMinimumOff();
                                }
                            }
                            if (viewMaxElem != null) {
                                boolean auto;
                                if (datetimeElem == null) {
                                    t = PlotSpecification.addDuration(baseTime, viewMaxElem.getTextTrim());
                                } else {
                                    t.setXML(viewMaxElem.getTextTrim());
                                }
                                axis.setActualMaximumValue(t.value());
                                text = viewMaxElem.getAttributeValue("use-automatic");
                                boolean bl = auto = !"false".equals(text) && !"0".equals(text);
                                if (!auto) {
                                    axis.setAutomaticViewMaximumOff();
                                }
                            }
                            if (levelCountElem != null) {
                                int count = Integer.parseInt(levelCountElem.getTextTrim());
                                axis.setNumberOfTicLabelLayers(count);
                                axis.setNumTicLabelLevels(count);
                            }
                        }
                    }
                }
                for (Object obj : vp.getGlyphVector()) {
                    Element showElem;
                    Element fColorElem;
                    Element lColorElem;
                    Element sizeElem;
                    Element styleElem;
                    Element showElem2;
                    G2dLine curve;
                    G2dGlyph glyph = (G2dGlyph)obj;
                    G2dObject dataset = glyph.getG2dObject();
                    TimeSeriesContainer tsc = null;
                    PairedDataContainer pdc = null;
                    Element curveElem = null;
                    if (dataset instanceof TimeSeriesDataSet) {
                        tsc = ((TimeSeriesDataSet)dataset).getData();
                        curveElem = curveElementMap.get(tsc.fullName);
                    } else {
                        if (!(dataset instanceof PairedDataSet)) continue;
                        pdc = ((PairedDataSet)dataset).getData();
                        curveElem = curveElementMap.get(pdc.fullName);
                    }
                    if (curveElem == null || (curve = glyph.getLine()) == null) continue;
                    curve.setProperties(defaultLineProp);
                    G2dLineProperties prop = curve.getProperties();
                    Element lineElem = curveElem.getChild("line");
                    Element fillElem = curveElem.getChild("fill");
                    Element stepElem = curveElem.getChild("step-style");
                    Element interpElem = curveElem.getChild("interpolate-missing");
                    Element mSymbElem = curveElem.getChild("missing-symbols");
                    Element pSymbElem = curveElem.getChild("point-symbols");
                    Element qSymbElem = curveElem.getChild("quality-symbols");
                    Element labelElem1 = curveElem.getChild("label");
                    Element legendElem = curveElem.getChild("legend-item");
                    Element showElem1 = curveElem.getChild("visible");
                    Element showElem22 = curveElem.getChild("show-in-legend");
                    if (lineElem != null) {
                        Element colorElem4 = lineElem.getChild("color");
                        Element styleElem2 = lineElem.getChild("style");
                        Element widthElem = lineElem.getChild("width");
                        showElem2 = lineElem.getChild("visible");
                        if (colorElem4 != null) {
                            String[] parts = TextUtil.split(PlotSpecification.getColorString(colorElem4), ",", "L");
                            prop._lineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                            prop._lineTransparency = 100 - (int)((double)Float.parseFloat(parts[3]) / 2.55 + 0.5);
                        }
                        if (styleElem2 != null) {
                            prop._lineStylePattern = lineStylePatterns.get(styleElem2.getTextTrim());
                        }
                        if (widthElem != null) {
                            prop._lineWidth = Float.parseFloat(widthElem.getTextTrim());
                        }
                        if (showElem2 != null) {
                            text = showElem2.getTextTrim();
                            boolean bl = prop._drawLine = "true".equals(text) || "1".equals(text);
                        }
                    }
                    if (fillElem != null) {
                        Element positionElem = fillElem.getChild("position");
                        Element colorElem5 = fillElem.getChild("color");
                        Element patternElem = fillElem.getChild("pattern");
                        if (positionElem != null) {
                            prop._fillType = fillPositionNumbers.get(positionElem.getTextTrim());
                        }
                        if (colorElem5 != null) {
                            String[] parts = TextUtil.split(PlotSpecification.getColorString(colorElem5), ",", "L");
                            prop._fillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                            prop._fillTransparency = 100 - (int)((double)Float.parseFloat(parts[3]) / 2.55 + 0.5);
                        }
                        if (patternElem != null) {
                            prop._fillPattern = fillPatternNumbers.get(patternElem.getTextTrim());
                        }
                    }
                    if (stepElem != null) {
                        prop._lineStepStyle = lineStepStyleNumbers.get(stepElem.getTextTrim());
                    }
                    if (interpElem != null) {
                        text = interpElem.getTextTrim();
                        boolean bl = prop._interpolateMissing = "true".equals(text) || "1".equals(text);
                    }
                    if (mSymbElem != null) {
                        String[] parts;
                        styleElem = mSymbElem.getChild("style");
                        sizeElem = mSymbElem.getChild("size");
                        lColorElem = mSymbElem.getChild("line-color");
                        fColorElem = mSymbElem.getChild("fill-color");
                        showElem = mSymbElem.getChild("visible");
                        if (styleElem != null) {
                            prop._placeholderSymbolType = symbolTypeNumbers.get(styleElem.getTextTrim());
                        }
                        if (sizeElem != null) {
                            prop._placeholderSymbolSize = Float.parseFloat(sizeElem.getTextTrim());
                        }
                        if (lColorElem != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(lColorElem), ",", "L");
                            prop._placeholderPointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (fColorElem != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(fColorElem), ",", "L");
                            prop._placeholderPointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (showElem != null) {
                            text = showElem.getTextTrim();
                            boolean bl = prop._drawMissingData = "true".equals(text) || "1".equals(text);
                        }
                    }
                    if (pSymbElem != null) {
                        String[] parts;
                        styleElem = pSymbElem.getChild("style");
                        sizeElem = pSymbElem.getChild("size");
                        lColorElem = pSymbElem.getChild("line-color");
                        fColorElem = pSymbElem.getChild("fill-color");
                        Element offsetElem = pSymbElem.getChild("offset");
                        Element skipElem = pSymbElem.getChild("skip");
                        Element showElem3 = pSymbElem.getChild("visible");
                        if (styleElem != null) {
                            prop._symbolType = symbolTypeNumbers.get(styleElem.getTextTrim());
                        }
                        if (sizeElem != null) {
                            prop._symbolSize = Float.parseFloat(sizeElem.getTextTrim());
                        }
                        if (lColorElem != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(lColorElem), ",", "L");
                            prop._pointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (fColorElem != null) {
                            parts = TextUtil.split(PlotSpecification.getColorString(fColorElem), ",", "L");
                            prop._pointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                        }
                        if (offsetElem != null) {
                            prop._ptOffset = Integer.parseInt(offsetElem.getText());
                        }
                        if (skipElem != null) {
                            prop._numPtsSkip = Integer.parseInt(skipElem.getTextTrim());
                        }
                        if (showElem3 != null) {
                            text = showElem3.getTextTrim();
                            boolean bl = prop._drawPoints = "true".equals(text) || "1".equals(text);
                        }
                    }
                    if (qSymbElem != null) {
                        String[] parts;
                        Element fColorElem2;
                        Element lColorElem2;
                        Element sizeElem2;
                        Element styleElem3;
                        Element vqSymbElem = qSymbElem.getChild("valid");
                        Element qqSymbElem = qSymbElem.getChild("questionable");
                        Element rqSymbElem = qSymbElem.getChild("rejected");
                        Element mqSymbElem = qSymbElem.getChild("missing");
                        showElem = qSymbElem.getChild("visible");
                        if (vqSymbElem != null) {
                            styleElem3 = vqSymbElem.getChild("style");
                            sizeElem2 = vqSymbElem.getChild("size");
                            lColorElem2 = vqSymbElem.getChild("line-color");
                            fColorElem2 = vqSymbElem.getChild("fill-color");
                            if (styleElem3 != null) {
                                prop._okSymbolType = symbolTypeNumbers.get(styleElem3.getTextTrim());
                            }
                            if (sizeElem2 != null) {
                                prop._okSymbolSize = Float.parseFloat(sizeElem2.getTextTrim());
                            }
                            if (lColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(lColorElem2), ",", "L");
                                prop._okPointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (fColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(fColorElem2), ",", "L");
                                prop._okPointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                        }
                        if (qqSymbElem != null) {
                            styleElem3 = qqSymbElem.getChild("style");
                            sizeElem2 = qqSymbElem.getChild("size");
                            lColorElem2 = qqSymbElem.getChild("line-color");
                            fColorElem2 = qqSymbElem.getChild("fill-color");
                            if (styleElem3 != null) {
                                prop._questionableSymbolType = symbolTypeNumbers.get(styleElem3.getTextTrim());
                            }
                            if (sizeElem2 != null) {
                                prop._questionableSymbolSize = Float.parseFloat(sizeElem2.getTextTrim());
                            }
                            if (lColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(lColorElem2), ",", "L");
                                prop._questionablePointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (fColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(fColorElem2), ",", "L");
                                prop._questionablePointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                        }
                        if (rqSymbElem != null) {
                            styleElem3 = rqSymbElem.getChild("style");
                            sizeElem2 = rqSymbElem.getChild("size");
                            lColorElem2 = rqSymbElem.getChild("line-color");
                            fColorElem2 = rqSymbElem.getChild("fill-color");
                            if (styleElem3 != null) {
                                prop._rejectedSymbolType = symbolTypeNumbers.get(styleElem3.getTextTrim());
                            }
                            if (sizeElem2 != null) {
                                prop._rejectedSymbolSize = Float.parseFloat(sizeElem2.getTextTrim());
                            }
                            if (lColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(lColorElem2), ",", "L");
                                prop._rejectedPointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (fColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(fColorElem2), ",", "L");
                                prop._rejectedPointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                        }
                        if (mqSymbElem != null) {
                            styleElem3 = mqSymbElem.getChild("style");
                            sizeElem2 = mqSymbElem.getChild("size");
                            lColorElem2 = mqSymbElem.getChild("line-color");
                            fColorElem2 = mqSymbElem.getChild("fill-color");
                            if (styleElem3 != null) {
                                prop._missingSymbolType = symbolTypeNumbers.get(styleElem3.getTextTrim());
                            }
                            if (sizeElem2 != null) {
                                prop._missingSymbolSize = Float.parseFloat(sizeElem2.getTextTrim());
                            }
                            if (lColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(lColorElem2), ",", "L");
                                prop._missingPointLineColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                            if (fColorElem2 != null) {
                                parts = TextUtil.split(PlotSpecification.getColorString(fColorElem2), ",", "L");
                                prop._missingPointFillColor = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                            }
                        }
                        if (showElem != null) {
                            text = showElem.getTextTrim();
                            boolean bl = prop._drawQualityData = "true".equals(text) || "1".equals(text);
                        }
                    }
                    if (labelElem1 != null) {
                        Element textElem = labelElem1.getChild("text");
                        Element alignElem2 = labelElem1.getChild("alignment");
                        Element posElem = labelElem1.getChild("position");
                        showElem2 = labelElem1.getChild("visible");
                        if (textElem != null) {
                            prop._label = textElem.getTextTrim();
                        }
                        if (alignElem2 != null) {
                            prop.setLabelAlignment(alignmentNumbers.get(alignElem2.getTextTrim()));
                        }
                        if (posElem != null) {
                            prop.setLabelPosition(labelPositionNumbers.get(posElem.getTextTrim()));
                        }
                        if (showElem2 != null) {
                            text = showElem2.getTextTrim();
                            prop.setHasLabel("true".equals(text) || "1".equals(text));
                        }
                    }
                    if (legendElem != null) {
                        LegendItemContainer legendItemContainer = plot.getLegend()._itemContainer;
                        int legendItemCount = legendItemContainer.numLegendItems();
                        Vector<LegendItem> legendItems = new Vector<LegendItem>();
                        for (int j = 0; j < legendItemCount; ++j) {
                            LegendItem legendItem = legendItemContainer.getLegendItem(i);
                            if (legendItem.m_glyph != glyph) continue;
                            legendItems.add(legendItem);
                        }
                        for (LegendItem legendItem : legendItems) {
                            G2dLabel label = legendItem.label;
                            if (label == null) continue;
                            Element textElem = legendElem.getChild("text");
                            Element fontElem = legendElem.getChild("font");
                            Element alignElem3 = legendElem.getChild("alignment");
                            Element rotateElem = legendElem.getChild("rotation");
                            Element iconElem = legendElem.getChild("iconpath");
                            Element areaElem = legendElem.getChild("area");
                            Element spacingElem = legendElem.getChild("spacing");
                            Element showElem4 = legendElem.getChild("visible");
                            if (tsc != null) {
                                if (textElem != null) {
                                    label.setText(textElem.getTextTrim());
                                }
                            } else {
                                label.setText(pdc.labels[legendItem.m_curveIndex]);
                            }
                            if (fontElem != null) {
                                Element colorElem6 = fontElem.getChild("color");
                                Element sizeElem3 = fontElem.getChild("size");
                                Element sizesElem = fontElem.getChild("sizes");
                                label.setFont(PlotSpecification.getFontString(fontElem));
                                if (colorElem6 != null) {
                                    label.setForeground(PlotSpecification.getColorString(colorElem6));
                                }
                                if (sizeElem3 != null) {
                                    label.setFontSize(Integer.parseInt(sizeElem3.getTextTrim()));
                                    if (sizesElem != null) {
                                        Element tinyElem = sizesElem.getChild("tiny");
                                        Element minElem = sizesElem.getChild("min");
                                        Element maxElem = sizesElem.getChild("max");
                                        if (tinyElem != null && minElem != null && maxElem != null) {
                                            label.setFontSizes(Integer.parseInt(sizeElem3.getTextTrim()), Integer.parseInt(tinyElem.getTextTrim()), Integer.parseInt(minElem.getTextTrim()), Integer.parseInt(maxElem.getTextTrim()));
                                        }
                                    }
                                }
                            }
                            if (alignElem3 != null) {
                                label.setAlignment(alignElem3.getTextTrim());
                            }
                            if (rotateElem != null) {
                                label.setRotation(Integer.parseInt(rotateElem.getTextTrim()));
                            }
                            if (iconElem != null) {
                                label.setIcon(iconElem.getTextTrim());
                            }
                            if (areaElem != null) {
                                Element colorElem7;
                                Element borderElem = areaElem.getChild("border");
                                Element backgroundElem = areaElem.getChild("background");
                                if (borderElem != null) {
                                    colorElem7 = borderElem.getChild("color");
                                    Element styleElem4 = borderElem.getChild("style");
                                    Element widthElem = borderElem.getChild("width");
                                    Element bShowElem = borderElem.getChild("visible");
                                    if (colorElem7 != null) {
                                        label.setBorderColor(PlotSpecification.getColorString(colorElem7));
                                    }
                                    if (styleElem4 != null) {
                                        label.setBorderStyle(styleElem4.getTextTrim());
                                    }
                                    if (widthElem != null) {
                                        label.setBorderWeight(Float.parseFloat(widthElem.getTextTrim()));
                                    }
                                    if (bShowElem != null) {
                                        text = bShowElem.getTextTrim();
                                        label.setBorderVisible("true".equals(text) || "1".equals(text));
                                    }
                                }
                                if (backgroundElem != null) {
                                    colorElem7 = borderElem.getChild("color");
                                    Element patternElem = borderElem.getChild("fill-pattern");
                                    Element bShowElem = borderElem.getChild("visible");
                                    if (colorElem7 != null) {
                                        label.setBackground(PlotSpecification.getColorString(colorElem7));
                                    }
                                    if (patternElem != null) {
                                        label.setFillPattern(patternElem.getTextTrim());
                                    }
                                    if (bShowElem != null) {
                                        text = bShowElem.getTextTrim();
                                        label.setBackgroundVisible("true".equals(text) || "1".equals(text));
                                    }
                                }
                            }
                            if (spacingElem != null) {
                                label.setSpacing(Integer.parseInt(spacingElem.getTextTrim()));
                            }
                            if (showElem4 == null) continue;
                            text = showElem4.getTextTrim();
                            label.setVisible("true".equals(text) || "1".equals(text));
                        }
                    }
                    if (showElem1 != null) {
                        text = showElem1.getTextTrim();
                        curve.setVisible("true".equals(text) || "1".equals(text));
                    }
                    if (showElem22 != null) {
                        text = showElem22.getTextTrim();
                        glyph.setLegendItemsVisible("true".equals(text) || "1".equals(text));
                    }
                    curve.setProperties(prop);
                }
                for (String category : Arrays.asList("major", "minor")) {
                    for (String direction : Arrays.asList("x", "y")) {
                        Element gridElem = viewportElem.getChild(String.format("%s-%s-grid", category, direction));
                        if (gridElem == null) continue;
                        colorElem = gridElem.getChild("color");
                        Element styleElem = gridElem.getChild("style");
                        Element widthElem = gridElem.getChild("width");
                        Element showElem = gridElem.getChild("visible");
                        if (category.equals("major")) {
                            if (direction.equals("x")) {
                                if (colorElem != null) {
                                    vp.setMajorGridXColor(PlotSpecification.getColorString(colorElem));
                                }
                                if (styleElem != null) {
                                    vp.setMajorGridXStyle(styleElem.getTextTrim());
                                }
                                if (widthElem != null) {
                                    vp.setMajorGridXWidth(Float.parseFloat(widthElem.getTextTrim()));
                                }
                                if (showElem == null) continue;
                                text = showElem.getTextTrim();
                                vp.setMajorGridXVisible("true".equals(text) || "1".equals(text));
                                continue;
                            }
                            if (colorElem != null) {
                                vp.setMajorGridYColor(PlotSpecification.getColorString(colorElem));
                            }
                            if (styleElem != null) {
                                vp.setMajorGridYStyle(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                vp.setMajorGridYWidth(Float.parseFloat(widthElem.getTextTrim()));
                            }
                            if (showElem == null) continue;
                            text = showElem.getTextTrim();
                            vp.setMajorGridYVisible("true".equals(text) || "1".equals(text));
                            continue;
                        }
                        if (direction.equals("x")) {
                            if (colorElem != null) {
                                vp.setMinorGridXColor(PlotSpecification.getColorString(colorElem));
                            }
                            if (styleElem != null) {
                                vp.setMinorGridXStyle(styleElem.getTextTrim());
                            }
                            if (widthElem != null) {
                                vp.setMinorGridXWidth(Float.parseFloat(widthElem.getTextTrim()));
                            }
                            if (showElem == null) continue;
                            text = showElem.getTextTrim();
                            vp.setMinorGridXVisible("true".equals(text) || "1".equals(text));
                            continue;
                        }
                        if (colorElem != null) {
                            vp.setMinorGridYColor(PlotSpecification.getColorString(colorElem));
                        }
                        if (styleElem != null) {
                            vp.setMinorGridYStyle(styleElem.getTextTrim());
                        }
                        if (widthElem != null) {
                            vp.setMinorGridYWidth(Float.parseFloat(widthElem.getTextTrim()));
                        }
                        if (showElem == null) continue;
                        text = showElem.getTextTrim();
                        vp.setMinorGridYVisible("true".equals(text) || "1".equals(text));
                    }
                }
            }
            for (String obj : viewportElem.getChildren("axis-marker")) {
                Element markerElem = (Element)obj;
                Element labelElem1 = markerElem.getChild("label");
                Element lineElem = markerElem.getChild("line");
                Element fillElem = markerElem.getChild("fill");
                AxisMarkerDescription marker = new AxisMarkerDescription();
                marker.axis = markerElem.getChild("axis").getTextTrim();
                marker.value = markerElem.getChild("value").getTextTrim();
                if (labelElem1 != null) {
                    Element textElem = labelElem1.getChild("text");
                    alignElem = labelElem1.getChild("alignment");
                    Element posElem = labelElem1.getChild("position");
                    Element fontElem = labelElem1.getChild("font");
                    Element showElem = labelElem1.getChild("visible");
                    if (textElem != null) {
                        marker.labelText = textElem.getTextTrim();
                    }
                    if (alignElem != null) {
                        marker.labelAlignment = alignElem.getTextTrim();
                    }
                    if (posElem != null) {
                        marker.labelPosition = posElem.getTextTrim();
                    }
                    if (fontElem != null) {
                        marker.labelFont = PlotSpecification.getFontString(fontElem);
                        colorElem = fontElem.getChild("color");
                        if (colorElem != null) {
                            marker.labelColor = PlotSpecification.getColorString(colorElem);
                        }
                    }
                    if (showElem != null) {
                        text = showElem.getTextTrim();
                        boolean bl = marker.drawLabel = "true".equals(text) || "1".equals(text);
                    }
                }
                if (lineElem != null) {
                    Element colorElem8 = lineElem.getChild("color");
                    Element styleElem = lineElem.getChild("style");
                    Element widthElem = lineElem.getChild("width");
                    Element showElem = lineElem.getChild("visible");
                    if (colorElem8 != null) {
                        marker.lineColor = PlotSpecification.getColorString(colorElem8);
                    }
                    if (styleElem != null) {
                        marker.lineStyle = styleElem.getTextTrim();
                    }
                    if (widthElem != null) {
                        marker.lineWidth = Float.parseFloat(widthElem.getTextTrim());
                    }
                    if (showElem != null) {
                        text = showElem.getTextTrim();
                        boolean bl = marker.drawLine = "true".equals(text) || "1".equals(text);
                    }
                }
                if (fillElem != null) {
                    Element posElem = fillElem.getChild("position");
                    Element colorElem9 = fillElem.getChild("color");
                    Element patternElem = fillElem.getChild("pattern");
                    if (posElem != null) {
                        marker.fillStyle = posElem.getTextTrim();
                    }
                    if (colorElem9 != null) {
                        marker.fillColor = PlotSpecification.getColorString(colorElem9);
                    }
                    if (patternElem != null) {
                        marker.fillPattern = patternElem.getTextTrim();
                    }
                }
                vp.addAxisMarker(marker);
            }
        }
    }

    protected static void updateLegend(G2dDialog plot) {
        PlotSpecification.updateLegend(plot, null);
    }

    protected static void updateLegend(G2dDialog plot, LegendPanelProp legendProps) {
        G2dPanel plotPanel = plot.getPlotpanel();
        LegendPanel legend = plotPanel.getLegendPanel();
        if (legend != null) {
            if (legendProps == null) {
                legendProps = legend.getProperties();
            }
            legend._glyphVector.clear();
            legend._viewportVector.clear();
            legend._itemContainer.removeAllItems();
            legend.removeAll();
            legend.setProperties(legendProps);
            for (Object obj : plotPanel._viewportVector) {
                legend.addViewport((Viewport)obj);
            }
            legend._itemContainer.resetConstraints();
            plotPanel.moveLegendToPosition(legend._legendPosition);
            plotPanel.setLegendVisible(legendProps.legendVisible);
            legend.refreshLegendItems();
        }
        plotPanel.revalidate();
        plotPanel.paintGfx();
    }

    protected static String getFontString(Element fontElem) {
        return PlotSpecification.getFontString(fontElem, null);
    }

    protected static String getFontString(Element fontElem, List<?> options) {
        Element elem;
        String fontString = null;
        String style = "plain";
        int size = PlotSpecification.defaultLabelProp.fontSize;
        if (options != null) {
            for (int i = 0; i < options.size() / 2; ++i) {
                String key = (String)options.get(i);
                if (key.equals("style")) {
                    style = (String)options.get(i + 1);
                    continue;
                }
                if (key.equals("size")) {
                    size = (Integer)options.get(i + 1);
                    continue;
                }
                throw new IllegalArgumentException("Invalid option key specified: " + key);
            }
        }
        if ((elem = fontElem.getChild("family")) == null) {
            throw new IllegalArgumentException("Invalid font element: no family specified");
        }
        String family = elem.getTextTrim();
        elem = fontElem.getChild("style");
        if (elem != null) {
            style = elem.getTextTrim();
        }
        if ((elem = fontElem.getChild("size")) != null) {
            size = Integer.parseInt(elem.getTextTrim());
        }
        fontString = TextUtil.join(",", family, style, Integer.toString(size));
        return fontString;
    }

    protected static String getColorString(Element colorElem) {
        return PlotSpecification.getColorString(colorElem, "black");
    }

    protected static String getColorString(Element colorElem, String defaultValue) {
        String colorString = defaultValue;
        if (colorElem != null) {
            boolean error;
            String transparencyText;
            String colorText;
            block17: {
                int alpha = 255;
                colorText = colorElem.getTextTrim();
                transparencyText = colorElem.getAttributeValue("percent-transparent");
                if (transparencyText != null) {
                    alpha = 255 - (int)((double)Float.parseFloat(transparencyText) * 2.55 + 0.5);
                }
                error = true;
                if (colorText != null) {
                    if (colorText.startsWith("#")) {
                        if (colorText.length() == 7) {
                            try {
                                int r = Integer.parseInt(colorText.substring(1, 3), 16);
                                int g = Integer.parseInt(colorText.substring(3, 5), 16);
                                int b = Integer.parseInt(colorText.substring(5, 7), 16);
                                colorString = String.format("%d,%d,%d,%d", r, g, b, alpha);
                                break block16;
                            }
                            catch (Throwable t) {
                            }
                        }
                    } else if (colorText.toLowerCase().startsWith("r=")) {
                        String[] parts = TextUtil.split(colorText, ",", "L");
                        if (parts.length == 3 && parts[1].startsWith("g=") && parts[2].startsWith("b=")) {
                            try {
                                int r = Integer.parseInt(TextUtil.split(parts[0], "=", "L")[1]);
                                int g = Integer.parseInt(TextUtil.split(parts[1], "=", "L")[1]);
                                int b = Integer.parseInt(TextUtil.split(parts[2], "=", "L")[1]);
                                colorString = String.format("%d,%d,%d,%d", r, g, b, alpha);
                                break block16;
                            }
                            catch (Throwable t) {
                            }
                        }
                    } else {
                        block16: {
                            colorString = colorText;
                        }
                        try {
                            Color c2 = RmaColor.parseColorString(colorString);
                            colorString = String.format("%d,%d,%d,%d", c2.getRed(), c2.getGreen(), c2.getBlue(), alpha);
                            RmaColor.parseColorString(colorString);
                        }
                        catch (Throwable t) {
                            break block17;
                        }
                        error = false;
                    }
                }
            }
            if (error) {
                throw new IllegalArgumentException(String.format("Element has invalid color text: %s (transparency = %s)", colorText == null ? "<NULL>" : colorText, transparencyText == null ? "<NULL>" : transparencyText));
            }
        }
        return colorString;
    }

    protected Map<String, Element> buildViewportLayouts(PlotLayout plotLayout, List<Element> viewportElems) throws Exception {
        HashMap<String, Element> curveElementMap = new HashMap<String, Element>();
        ViewportLayout viewportLayout = null;
        for (Element viewportElem : viewportElems) {
            String weight = viewportElem.getAttributeValue("weight");
            viewportLayout = weight == null ? plotLayout.addViewport() : plotLayout.addViewport(Double.parseDouble(weight));
            Element axisElem = viewportElem.getChild("y1-axis");
            if (axisElem != null) {
                this.buildCurveLayouts(viewportLayout, "Y1", axisElem.getChildren("curve"), curveElementMap);
            }
            if ((axisElem = viewportElem.getChild("y2-axis")) == null) continue;
            this.buildCurveLayouts(viewportLayout, "Y2", axisElem.getChildren("curve"), curveElementMap);
        }
        return curveElementMap;
    }

    protected void buildCurveLayouts(ViewportLayout viewportLayout, String axisName, List<?> curveElems, Map<String, Element> elementMap) throws Exception {
        int curveCount = curveElems.size();
        boolean[] processed = new boolean[curveCount];
        Arrays.fill(processed, false);
        String openDssFilename = null;
        DSSFile dssFile = null;
        String curDbConName = null;
        Connection dbCon = null;
        Statement getUnitStmt = null;
        Statement getTsStmt = null;
        ResultSet rs = null;
        for (int i = 0; i < curveCount; ++i) {
            String quality;
            String dataType;
            TimeSeriesContainer tsc;
            Element yParamElem;
            HecTime t;
            if (processed[i]) continue;
            Element curveElem = (Element)curveElems.get(i);
            String curveName = curveElem.getAttributeValue("name");
            Element dataElem = curveElem.getChild("data");
            String curveId = curveElem.getAttributeValue("id");
            String curveDataStr = this.getCurveData(curveId).trim();
            if (curveDataStr != null) {
                Document tempDoc = null;
                String[] parts = TextUtil.split(curveId, ",");
                for (int j = 0; j < parts.length; ++j) {
                    parts[j] = parts[j].trim();
                }
                String axisElemName = String.format("%s-axis", parts[2]);
                StringBuilder sb = new StringBuilder();
                if (curveDataStr.charAt(0) == '<') {
                    sb.append(String.format("<plot><viewport name=\"%s,%s\"><%s><curve id=\"%s\">", parts[0], parts[1], axisElemName, curveId));
                    sb.append(curveDataStr);
                    sb.append(String.format("</curve></%s></viewport></plot>", axisElemName));
                    tempDoc = new SAXBuilder().build((Reader)new StringReader(sb.toString()));
                } else {
                    sb.append(String.format("plot viewport name %s,%s %s curve id %s ", parts[0], parts[1], axisElemName, curveId));
                    sb.append(curveDataStr);
                    tempDoc = PlotSpecification.parsePlotSpecText(sb.toString());
                }
                Element tempRootElem = tempDoc.getRootElement();
                Element tempViewportElem = tempRootElem.getChild("viewport");
                Element tempAxisElem = tempViewportElem.getChild(axisElemName);
                Element tempCurveElem = tempAxisElem.getChild("curve");
                dataElem = tempCurveElem.getChild("data");
            }
            Element xyElem = dataElem.getChild("xy");
            Element irregularElem = dataElem.getChild("irregular");
            Element regularElem = dataElem.getChild("regular");
            Element referenceElem = dataElem.getChild("reference");
            if (xyElem != null) {
                Object nextXyElem;
                Vector<Integer> curvesToProcess = new Vector<Integer>();
                Vector<String> curveNames = new Vector<String>();
                curvesToProcess.add(i);
                curveNames.add(curveName);
                for (int j = i + 1; j < curveCount && (nextXyElem = ((Element)curveElems.get(j)).getChild("data").getChild("xy")) != null && nextXyElem.getChild("data").getChild("point").getChild("x") == null; ++j) {
                    processed[j] = true;
                    curvesToProcess.add(j);
                    curveNames.add(((Element)curveElems.get(j)).getAttributeValue("name"));
                }
                PairedDataContainer pdc = new PairedDataContainer();
                pdc.numberCurves = curvesToProcess.size();
                pdc.yOrdinates = new double[pdc.numberCurves][];
                pdc.labelsUsed = false;
                nextXyElem = curveNames.iterator();
                while (nextXyElem.hasNext()) {
                    String name = (String)nextXyElem.next();
                    if (name == null) continue;
                    pdc.labelsUsed = true;
                    break;
                }
                if (pdc.labelsUsed) {
                    pdc.labels = new String[pdc.numberCurves];
                }
                for (int j = 0; j < pdc.numberCurves; ++j) {
                    if (pdc.labelsUsed) {
                        pdc.labels[j] = (String)curveNames.get(j);
                    }
                    List pointElems = ((Element)curveElems.get((Integer)curvesToProcess.get(j))).getChild("data").getChild("xy").getChild("data").getChildren("point");
                    if (j == 0) {
                        pdc.numberOrdinates = pointElems.size();
                        pdc.xOrdinates = new double[pdc.numberOrdinates];
                        for (int k = 0; k < pdc.numberOrdinates; ++k) {
                            pdc.xOrdinates[k] = Double.parseDouble(((Element)pointElems.get(k)).getChild("x").getTextTrim());
                        }
                    }
                    pdc.yOrdinates[j] = new double[pdc.numberOrdinates];
                    for (int k = 0; k < pdc.numberOrdinates; ++k) {
                        pdc.yOrdinates[j][k] = Double.parseDouble(((Element)pointElems.get(k)).getChild("y").getTextTrim());
                    }
                }
                pdc.switchXyAxis = "true".equals(xyElem.getAttributeValue("switch-x-y"));
                Element xParamElem = xyElem.getChild("x-parameter");
                pdc.xparameter = xParamElem.getTextTrim();
                pdc.xunits = xParamElem.getAttributeValue("unit");
                Element yParamElem2 = xyElem.getChild("y-parameter");
                pdc.yparameter = yParamElem2.getTextTrim();
                pdc.yunits = yParamElem2.getAttributeValue("unit");
                String dataSource = xyElem.getChild("data-source").getTextTrim();
                int pos = dataSource.indexOf(58);
                if (pos == 1) {
                    pos = dataSource.indexOf(58, 2);
                }
                if (pos != -1) {
                    pdc.fileName = dataSource.substring(0, pos);
                    pdc.fullName = dataSource.substring(pos + 1);
                }
                if (TextUtil.equals(pdc.fullName, null)) {
                    pdc.fullName = Integer.toHexString(pdc.hashCode());
                }
                elementMap.put(pdc.fullName, curveElem);
                viewportLayout.addCurve(axisName, pdc);
                continue;
            }
            if (irregularElem != null) {
                t = new HecTime();
                yParamElem = irregularElem.getChild("y-parameter");
                Element irDataElem = irregularElem.getChild("data");
                tsc = new TimeSeriesContainer();
                tsc.parameter = yParamElem.getTextTrim();
                tsc.units = yParamElem.getAttributeValue("unit");
                tsc.interval = 0;
                PlotSpecification.setTscFromDataSource(tsc, irregularElem.getChild("data-source").getTextTrim());
                dataType = irDataElem.getAttributeValue("data-type");
                if (dataType != null) {
                    tsc.type = dataType;
                }
                List pointElems = irDataElem.getChildren("point");
                tsc.numberValues = pointElems.size();
                tsc.times = new int[tsc.numberValues];
                tsc.values = new double[tsc.numberValues];
                tsc.quality = null;
                for (int j = 0; j < tsc.numberValues; ++j) {
                    Element pointElem = (Element)pointElems.get(j);
                    if (j == 0 && (quality = pointElem.getAttributeValue("quality")) != null) {
                        tsc.quality = new int[tsc.numberValues];
                    }
                    t.setXML(pointElem.getChild("time").getTextTrim());
                    tsc.times[j] = t.value();
                    Element valueElem = pointElem.getChild("value");
                    tsc.values[j] = Double.parseDouble(valueElem.getTextTrim());
                    if (tsc.quality == null) continue;
                    tsc.quality[j] = Integer.parseInt(valueElem.getAttributeValue("quality"));
                }
                tsc.startTime = tsc.times[0];
                tsc.endTime = tsc.times[tsc.numberValues - 1];
                if (TextUtil.equals(tsc.fullName, null)) {
                    tsc.fullName = Integer.toHexString(tsc.hashCode());
                }
                elementMap.put(tsc.fullName, curveElem);
                viewportLayout.addCurve(axisName, tsc);
                continue;
            }
            if (regularElem != null) {
                t = new HecTime();
                yParamElem = regularElem.getChild("y-parameter");
                Element rDataElem = regularElem.getChild("data");
                tsc = new TimeSeriesContainer();
                tsc.parameter = yParamElem.getTextTrim();
                tsc.units = yParamElem.getAttributeValue("unit");
                tsc.interval = 0;
                PlotSpecification.setTscFromDataSource(tsc, regularElem.getChild("data-source").getTextTrim());
                dataType = rDataElem.getAttributeValue("data-type");
                if (dataType != null) {
                    tsc.type = dataType;
                }
                t.setXML(rDataElem.getChild("start-time").getTextTrim());
                tsc.startTime = t.value();
                tsc.interval = PlotSpecification.getMinutes(rDataElem.getChild("interval").getTextTrim());
                List valueElems = rDataElem.getChildren("value");
                tsc.numberValues = valueElems.size();
                tsc.times = new int[tsc.numberValues];
                tsc.values = new double[tsc.numberValues];
                tsc.quality = null;
                for (int j = 0; j < tsc.numberValues; ++j) {
                    tsc.times[j] = t.value();
                    t.addMinutes(tsc.interval);
                    Element valueElem = (Element)valueElems.get(j);
                    tsc.values[j] = Double.parseDouble(valueElem.getTextTrim());
                    if (j == 0 && (quality = valueElem.getAttributeValue("quality")) != null) {
                        tsc.quality = new int[tsc.numberValues];
                    }
                    if (tsc.quality == null) continue;
                    tsc.quality[j] = Integer.parseInt(valueElem.getAttributeValue("quality"));
                }
                tsc.endTime = tsc.times[tsc.numberValues - 1];
                if (TextUtil.equals(tsc.fullName, null)) {
                    tsc.fullName = Integer.toHexString(tsc.hashCode());
                }
                elementMap.put(tsc.fullName, curveElem);
                viewportLayout.addCurve(axisName, tsc);
                continue;
            }
            if (referenceElem == null) continue;
            String dataSourceName = referenceElem.getChild("data-source").getTextTrim();
            Element timeWindowElem = referenceElem.getChild("time-window");
            StringBuilder warning = new StringBuilder();
            HecTime startTime = new HecTime();
            HecTime endTime = new HecTime();
            HecTime dummyTime = new HecTime();
            String timeZoneStr = null;
            startTime.showTimeAsBeginningOfDay(true);
            endTime.showTimeAsBeginningOfDay(true);
            DataContainer dc = null;
            TimeSeriesContainer tsc2 = null;
            PairedDataContainer pdc = null;
            if (timeWindowElem != null) {
                Matcher m = null;
                String startTimeStr = timeWindowElem.getAttributeValue("start-time");
                String endTimeStr = timeWindowElem.getAttributeValue("end-time");
                timeZoneStr = timeWindowElem.getAttributeValue("timezone");
                if (timeZoneStr != null) {
                    boolean validId = false;
                    for (String id : TimeZone.getAvailableIDs()) {
                        if (!id.equals(timeZoneStr)) continue;
                        validId = true;
                        break;
                    }
                    if (!validId) {
                        throw new Exception("Invalid time zone " + timeZoneStr + ", must be valid Java time zone ID");
                    }
                }
                if (startTimeStr != null) {
                    m = reXmlTime.matcher(startTimeStr);
                    if (m.matches()) {
                        if (m.group(6) == null) {
                            startTime.setXML(startTimeStr + ":00");
                        } else {
                            startTime.setXML(startTimeStr);
                        }
                    } else if (-1 == HecTime.getTimeWindow(startTimeStr + ", t", startTime, dummyTime)) {
                        startTime.setUndefined();
                        throw new Exception("Invalid start time: " + startTimeStr);
                    }
                }
                if (endTimeStr != null) {
                    m = reXmlTime.matcher(endTimeStr);
                    if (m.matches()) {
                        if (m.group(6) == null) {
                            endTime.setXML(endTimeStr + ":00");
                        } else {
                            endTime.setXML(endTimeStr);
                        }
                    } else if (-1 == HecTime.getTimeWindow("t, " + endTimeStr, dummyTime, endTime)) {
                        endTime.setUndefined();
                        throw new Exception("Invalid end time: " + endTimeStr);
                    }
                }
                if (startTime.isDefined() != endTime.isDefined()) {
                    warning.append("\nIncomplete time window specified, ignoring.");
                    startTime.setUndefined();
                    endTime.setUndefined();
                }
            }
            int pos = PlotSpecification.dataSourceSeparatorPos(dataSourceName);
            if (PlotSpecification.isCwmsDbDataSource(dataSourceName)) {
                int j;
                String[] parts;
                if (!startTime.isDefined()) {
                    throw new Exception("A valid time window is required to retrieve data from a CWMS database.");
                }
                String dbConName = dataSourceName.substring(0, pos).trim();
                String tsid = dataSourceName.substring(pos + 1).trim();
                String unit = null;
                switch (dbConName.charAt(dbConName.length() - 1)) {
                    case ')': {
                        dbConName = dbConName.substring(dbConName.indexOf(40) + 1, dbConName.length() - 1);
                        break;
                    }
                    case 'B': 
                    case 'E': 
                    case 'b': 
                    case 'e': {
                        dbConName = "";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected code branch.");
                    }
                }
                if (curDbConName == null || !dbConName.equalsIgnoreCase(curDbConName)) {
                    if (dbCon != null) {
                        if (getUnitStmt != null) {
                            getUnitStmt.close();
                            getUnitStmt = null;
                        }
                        if (getTsStmt != null) {
                            getTsStmt.close();
                            getTsStmt = null;
                        }
                        dbCon.close();
                    }
                    if (dbConName.length() == 0) {
                        dbCon = (Connection)Reflection.getMethod("wcds.dbi.client.JdbcConnection", "getConnection", Reflection.emptyParamTypes).invoke(null, Reflection.emptyParams);
                    } else {
                        parts = TextUtil.split(dbConName, ",");
                        switch (parts.length) {
                            case 2: {
                                dbCon = (Connection)Reflection.getMethod("wcds.dbi.client.JdbcConnection", "getConnection", "java.lang.String", "java.lang.String").invoke(null, parts[0].trim(), parts[1].trim());
                                break;
                            }
                            case 3: {
                                dbCon = (Connection)Reflection.getMethod("wcds.dbi.client.JdbcConnection", "getConnection", "java.lang.String", "java.lang.String", "java.lang.String").invoke(null, "jdbc:oracle:thin:@" + parts[0].trim(), parts[1].trim(), parts[2].trim());
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(String.format("Illegal data source name: %s", dataSourceName));
                            }
                        }
                    }
                    if (dbCon == null) {
                        throw new Exception("Unable to connect using data source " + dataSourceName);
                    }
                }
                if ((parts = TextUtil.split(tsid, ".")).length != 6) {
                    throw new IllegalArgumentException(String.format("Illegal CWMS time series identifier: %s", tsid));
                }
                pos = parts[5].indexOf(59);
                if (pos == -1) {
                    if (getUnitStmt == null) {
                        getUnitStmt = dbCon.prepareCall("begin :1 := cwms_display.retrieve_user_unit_f(:2); end;");
                    }
                    getUnitStmt.registerOutParameter(1, 12);
                    getUnitStmt.setString(2, parts[1]);
                    try {
                        getUnitStmt.execute();
                        unit = getUnitStmt.getString(1);
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().contains("INVALID_PARAM_ID") && parts[1].contains("-")) {
                            getUnitStmt.setString(2, TextUtil.split(parts[1], "-")[0]);
                            getUnitStmt.execute();
                            unit = getUnitStmt.getString(1);
                        }
                    }
                } else {
                    unit = parts[5].substring(pos + 1);
                    if (unit.length() == 0) {
                        throw new Exception("Unit not found after unit separator on tsid " + tsid);
                    }
                    parts[5] = parts[5].substring(0, pos);
                    tsid = TextUtil.join(".", parts);
                }
                if (getTsStmt == null) {
                    getTsStmt = dbCon.prepareStatement("select *  from table(cwms_ts.retrieve_ts_out_tab(:1,:2,to_date(:3, 'dd Mon yyyy, hh24:mi'),to_date(:4, 'dd Mon yyyy, hh24:mi'),:5,'T')) order by date_time");
                }
                getTsStmt.setString(1, tsid);
                getTsStmt.setString(2, unit);
                getTsStmt.setString(3, startTime.dateAndTime(7));
                getTsStmt.setString(4, endTime.dateAndTime(7));
                getTsStmt.setString(5, timeZoneStr == null ? "UTC" : timeZoneStr);
                rs = getTsStmt.executeQuery();
                ArrayList<Timestamp> times = new ArrayList<Timestamp>();
                ArrayList<Double> values = new ArrayList<Double>();
                ArrayList<Integer> qualities = new ArrayList<Integer>();
                Timestamp ts = null;
                while (rs.next()) {
                    ts = rs.getTimestamp(1);
                    if (rs.wasNull()) continue;
                    times.add(ts);
                    values.add(rs.getDouble(2));
                    qualities.add(rs.getInt(3));
                }
                rs.close();
                if (times.size() == 0) {
                    warning.append("\nNo data returned for " + dataSourceName);
                    return;
                }
                tsc2 = new TimeSeriesContainer();
                PlotSpecification.setTscFromDataSource(tsc2, dataSourceName);
                tsc2.numberValues = times.size();
                tsc2.times = new int[tsc2.numberValues];
                tsc2.values = new double[tsc2.numberValues];
                tsc2.quality = new int[tsc2.numberValues];
                tsc2.units = unit;
                Calendar cal = Calendar.getInstance();
                for (j = 0; j < tsc2.numberValues; ++j) {
                    cal.setTimeInMillis(((Timestamp)times.get(j)).getTime());
                    dummyTime.setYearMonthDay(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11) * 60 + cal.get(12));
                    tsc2.times[j] = dummyTime.value();
                    tsc2.values[j] = (Double)values.get(j);
                    tsc2.quality[j] = (Integer)qualities.get(j);
                }
                tsc2.startTime = tsc2.times[0];
                tsc2.endTime = tsc2.times[tsc2.numberValues - 1];
                if (tsc2.interval != 0) {
                    for (j = 1; j < tsc2.numberValues; ++j) {
                        if (tsc2.times[j] - tsc2.times[j - 1] == tsc2.interval) continue;
                        tsc2.interval = 0;
                        break;
                    }
                }
                dc = tsc2;
            } else {
                pos = dataSourceName.indexOf(58);
                if (pos == 1) {
                    pos = dataSourceName.indexOf(58, 2);
                }
                if (pos == -1) {
                    throw new IllegalArgumentException(String.format("Illegal data source name: %s", dataSourceName));
                }
                String dssFilename = dataSourceName.substring(0, pos);
                String dssPathname = dataSourceName.substring(pos + 1);
                if (openDssFilename == null || !dssFilename.equals(openDssFilename)) {
                    if (dssFile != null) {
                        dssFile.done();
                    }
                    dssFile = HecDss.open(dssFilename, true);
                    openDssFilename = dssFilename;
                }
                if (startTime.isDefined()) {
                    dssFile.setTimeWindow(startTime.dateAndTime(4), endTime.dateAndTime(4));
                }
                dc = ((HecDss)dssFile).get(dssPathname);
            }
            if (dc instanceof TimeSeriesContainer) {
                tsc2 = (TimeSeriesContainer)dc;
                TimeZone plotTz = this.getTimeZone();
                if (plotTz != null) {
                    if (timeZoneStr == null) {
                        warning.append("\nNo time zone specified. Data will be plotted unconverted");
                    } else {
                        TimeZone dataTz = TimeZone.getTimeZone(timeZoneStr);
                        if (!dataTz.hasSameRules(plotTz)) {
                            Calendar plotCal = Calendar.getInstance(plotTz);
                            Calendar dataCal = Calendar.getInstance(dataTz);
                            HecTime t2 = new HecTime();
                            for (int j = 0; j < tsc2.numberValues; ++j) {
                                t2.set(tsc2.times[j]);
                                dataCal.set(t2.year(), t2.month() - 1, t2.day(), t2.hour(), t2.minute(), t2.second());
                                plotCal.setTimeInMillis(dataCal.getTimeInMillis());
                                t2.setYearMonthDay(plotCal.get(1), plotCal.get(2) + 1, plotCal.get(5), plotCal.get(11) * 60 + plotCal.get(12));
                                tsc2.times[j] = t2.value();
                            }
                            t2.set(tsc2.startTime);
                            dataCal.set(t2.year(), t2.month() - 1, t2.day(), t2.hour(), t2.minute(), t2.second());
                            plotCal.setTimeInMillis(dataCal.getTimeInMillis());
                            t2.setYearMonthDay(plotCal.get(1), plotCal.get(2) + 1, plotCal.get(5), plotCal.get(11) * 60 + plotCal.get(12));
                            tsc2.startTime = t2.value();
                            t2.set(tsc2.endTime);
                            dataCal.set(t2.year(), t2.month() - 1, t2.day(), t2.hour(), t2.minute(), t2.second());
                            plotCal.setTimeInMillis(dataCal.getTimeInMillis());
                            t2.setYearMonthDay(plotCal.get(1), plotCal.get(2) + 1, plotCal.get(5), plotCal.get(11) * 60 + plotCal.get(12));
                            tsc2.endTime = t2.value();
                        }
                    }
                } else if (timeZoneStr != null) {
                    warning.append("\nTime zone ignored: no plot time zone set");
                }
                elementMap.put(tsc2.fullName, curveElem);
                viewportLayout.addCurve(axisName, tsc2);
                continue;
            }
            if (dc instanceof PairedDataContainer) {
                pdc = (PairedDataContainer)dc;
                for (int j = i + 1; j < curveCount; ++j) {
                    processed[j] = true;
                }
                elementMap.put(pdc.fullName, curveElem);
                viewportLayout.addCurve(axisName, pdc);
                continue;
            }
            throw new IllegalArgumentException(String.format("Don't know how to handle data type %s", dc.getClass().getName()));
        }
        if (dssFile != null) {
            dssFile.done();
        }
    }

    protected static int dataSourceSeparatorPos(String dataSourceName) {
        int pos = -1;
        if (dataSourceName.toLowerCase().startsWith("cwmsdb")) {
            pos = 6;
        }
        if (pos == -1 || ":(".indexOf(dataSourceName.charAt(pos)) == -1) {
            pos = dataSourceName.indexOf(58);
            if (pos == 1) {
                pos = dataSourceName.indexOf(58, 2);
            }
        } else if (dataSourceName.charAt(pos) == '(') {
            Pattern reSep = Pattern.compile("[)]\\s*([:])");
            Matcher m = reSep.matcher(dataSourceName);
            if (m.find(pos)) {
                pos = m.start(1);
                while (m.find(pos)) {
                    pos = m.start(1);
                }
            } else {
                pos = -1;
            }
        }
        return pos;
    }

    protected static boolean isCwmsDbDataSource(String dataSourceName) {
        int pos = -1;
        if (dataSourceName.toLowerCase().startsWith("cwmsdb")) {
            pos = 6;
        }
        return pos != -1 && ":(".indexOf(dataSourceName.charAt(pos)) != -1;
    }

    protected static int parseInt(String intString, int intDefault) {
        int answer = intDefault;
        try {
            answer = Integer.parseInt(intString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    protected static long parseTimeIntervalString(String timeInterval) {
        String num = null;
        String type = null;
        if (timeInterval == null) {
            return -1L;
        }
        if ((timeInterval = timeInterval.trim()).equals("") || timeInterval.equals(" ")) {
            return -1L;
        }
        char[] chr = timeInterval.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (Character.isDigit(chr[i])) continue;
            num = timeInterval.substring(0, i);
            type = timeInterval.substring(i);
            break;
        }
        type = type.toUpperCase();
        type = type.trim();
        long factor = -1L;
        int number = PlotSpecification.parseInt(num, -1);
        if (type.startsWith("S")) {
            factor = 1000L;
        } else if (type.startsWith("MI")) {
            factor = 60000L;
        } else if (type.startsWith("H")) {
            factor = 3600000L;
        } else if (type.startsWith("D")) {
            factor = 86400000L;
        } else if (type.startsWith("W")) {
            factor = 604800000L;
        } else if (type.startsWith("MO")) {
            factor = -1702967296L;
        } else if (type.startsWith("Y")) {
            factor = 1471228928L;
        }
        if (number >= 0 && factor >= 0L) {
            return (long)number * factor;
        }
        return -1L;
    }

    protected static void setTscFromDataSource(TimeSeriesContainer tsc, String dataSourceName) throws DataSetIllegalArgumentException {
        int pos = PlotSpecification.dataSourceSeparatorPos(dataSourceName);
        tsc.fullName = dataSourceName.substring(pos + 1);
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid data source name: " + dataSourceName);
        }
        String[] parts = null;
        if (PlotSpecification.isCwmsDbDataSource(dataSourceName)) {
            parts = TextUtil.split(dataSourceName.substring(0, pos), "(");
            tsc.fileName = parts[0];
            if (parts.length > 1 && (parts = TextUtil.split(parts[1], ",")).length == 3) {
                tsc.fileName = tsc.fileName + ":" + parts[0];
            }
            if ((parts = TextUtil.split(tsc.fullName, ".")).length != 6) {
                throw new IllegalArgumentException("Invalid TSID in data source: " + tsc.fullName);
            }
            pos = parts[0].indexOf(45);
            if (pos == -1) {
                tsc.location = parts[0];
                tsc.subLocation = null;
            } else {
                tsc.location = parts[0].substring(0, pos);
                tsc.subLocation = parts[0].substring(pos + 1);
            }
            pos = parts[1].indexOf(45);
            if (pos == -1) {
                tsc.parameter = parts[1];
                tsc.subParameter = null;
            } else {
                tsc.parameter = parts[1].substring(0, pos);
                tsc.subParameter = parts[1].substring(pos + 1);
            }
            tsc.type = parts[2];
            tsc.interval = new Interval(parts[3]).getMinutes();
            pos = parts[5].indexOf(59);
            if (pos != -1) {
                parts[5] = parts[5].substring(0, pos);
                tsc.fullName = TextUtil.join(".", parts);
            }
            tsc.version = parts[5];
        } else {
            tsc.type = "INST-VAL";
            tsc.fileName = dataSourceName.substring(0, pos);
            parts = TextUtil.split(tsc.fullName, "/");
            if (parts.length != 8) {
                throw new IllegalArgumentException("Invalid DSS pathname in data source: " + tsc.fullName);
            }
            tsc.watershed = parts[1];
            pos = parts[2].indexOf(45);
            if (pos == -1) {
                tsc.location = parts[2];
                tsc.subLocation = null;
            } else {
                tsc.location = parts[2].substring(0, pos);
                tsc.subLocation = parts[2].substring(pos + 1);
            }
            pos = parts[3].indexOf(45);
            if (pos == -1) {
                tsc.parameter = parts[3];
                tsc.subParameter = null;
            } else {
                tsc.parameter = parts[3].substring(0, pos);
                tsc.subParameter = parts[3].substring(pos + 1);
            }
            tsc.interval = parts[5].toUpperCase().startsWith("IR-") ? 0 : (int)(PlotSpecification.parseTimeIntervalString(parts[5]) / 60000L);
            tsc.version = parts[6];
        }
    }

    protected static String quote(String str) {
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        return str.indexOf(32) == -1 ? str : "\"" + str + "\"";
    }

    protected static String getPlotText(DataContainer dc) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (dc instanceof TimeSeriesContainer) {
            String fullname;
            HecTime t = new HecTime();
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            int timezoneOffset = tsc.timeZoneRawOffset / 60000;
            sb.append("data ").append(tsc.interval > 0 ? "regular" : "irregular");
            String filename = tsc.fileName == null ? "" : tsc.fileName;
            String string = fullname = tsc.fullName == null ? "" : tsc.fullName;
            if (filename.length() + fullname.length() > 0) {
                sb.append(" data-source ").append(String.format("%s:%s", PlotSpecification.quote(filename), PlotSpecification.quote(fullname)));
            }
            String yParameter = tsc.parameter == null ? "" : tsc.parameter;
            String yUnit = tsc.units == null ? "" : tsc.units;
            sb.append(" y-parameter unit ").append(PlotSpecification.quote(yUnit)).append(" ").append(PlotSpecification.quote(yParameter));
            sb.append(" data data-type ").append(PlotSpecification.quote(tsc.type));
            if (tsc.interval > 0) {
                t.set(tsc.times[0]);
                sb.append(" start-time ").append(t.getXMLDateTime(timezoneOffset));
                sb.append(" interval ").append(PlotSpecification.getHecDuration(tsc.interval));
                for (int i = 0; i < tsc.numberValues; ++i) {
                    if (tsc.quality == null) {
                        sb.append(" value ").append(tsc.values[i]);
                    }
                    if (tsc.quality == null) continue;
                    sb.append(" value quality ").append(tsc.quality[i]).append(" ").append(tsc.values[i]);
                }
            } else {
                for (int i = 0; i < tsc.numberValues; ++i) {
                    sb.append(" point");
                    t.set(tsc.times[i]);
                    sb.append(" time ").append(t.getXMLDateTime(timezoneOffset));
                    if (tsc.quality == null) {
                        sb.append(" value ").append(tsc.values[i]);
                    }
                    if (tsc.quality == null) continue;
                    sb.append(" value quality ").append(tsc.quality[i]).append(" ").append(tsc.values[i]);
                }
            }
        } else {
            throw new Exception(String.format("Method not valid for %s objects", dc.getClass().getName()));
        }
        return sb.toString();
    }

    protected static boolean all(Map<String, Boolean> map, String ... keys) {
        boolean allTrue;
        block2: {
            allTrue = false;
            for (String key : keys) {
                if (map.containsKey(key)) {
                    if (map.get(key).booleanValue()) continue;
                    break block2;
                }
                throw new IllegalArgumentException(String.format("The map has no key named \"%s\"", key));
            }
            allTrue = true;
        }
        return allTrue;
    }

    protected static boolean sameArray(float[] a1, float[] a2) {
        boolean same;
        block6: {
            block8: {
                block7: {
                    same = false;
                    if (a1 == null || a1.length <= 0) break block7;
                    if (a2 == null || a2.length == 0 || a1.length != a2.length) break block6;
                    for (int i = 0; i < a1.length; ++i) {
                        if (a1[i] == a2[i]) {
                            continue;
                        }
                        break block6;
                    }
                    break block8;
                }
                if (a2 != null && a2.length > 0) break block6;
            }
            same = true;
        }
        return same;
    }

    protected static boolean sameColor(Color c1, Color c2) {
        boolean same = c1 == null != (c2 == null) ? false : (c1 == null ? false : c1.equals(c2));
        return same;
    }

    protected static List<?> makeList(Object ... objs) {
        return Arrays.asList(objs);
    }

    protected static ColorInfo getColorInfo(Color color) {
        String[] values = new String[]{String.format("0%x", color.getRed()), String.format("0%x", color.getGreen()), String.format("0%x", color.getBlue())};
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length() <= 2) continue;
            values[i] = values[i].substring(1);
        }
        String colorStr = String.format("#%s%s%s", values[0], values[1], values[2]);
        String colorName = colorNames.get(colorStr);
        int transparency = 255 - color.getAlpha();
        ColorInfo ci = new ColorInfo(colorName == null ? colorStr : colorName, transparency);
        return ci;
    }

    protected static String getXmlDurationFromMinutes(int start, int end) {
        String duration = "PT0M";
        if (start != end) {
            boolean negative;
            boolean bl = negative = end < start;
            if (negative) {
                int temp = start;
                start = end;
                end = temp;
            }
            HecTime t = new HecTime();
            t.set(start);
            Calendar cStart = Calendar.getInstance();
            cStart.setTimeInMillis(t.getTimeInMillis());
            t.set(end);
            Calendar cEnd = Calendar.getInstance();
            cEnd.setTimeInMillis(t.getTimeInMillis());
            int yr = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 86400000L / 366L);
            cStart.add(1, yr);
            while (true) {
                if (cStart.after(cEnd)) {
                    cStart.add(1, -1);
                    --yr;
                    break;
                }
                cStart.add(1, 1);
                ++yr;
            }
            int mo = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 86400000L / 31L);
            cStart.add(2, mo);
            while (true) {
                if (cStart.after(cEnd)) {
                    cStart.add(2, -1);
                    --mo;
                    break;
                }
                cStart.add(2, 1);
                ++mo;
            }
            int da = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 86400000L);
            cStart.add(5, da);
            int hr = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 3600000L);
            cStart.add(11, hr);
            int mi = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 60000L);
            cStart.add(12, mi);
            int se = (int)((cEnd.getTimeInMillis() - cStart.getTimeInMillis()) / 1000L);
            cStart.add(13, se);
            StringBuilder sb = new StringBuilder(negative ? "-P" : "P");
            if (yr > 0) {
                sb.append(String.format("%dY", yr));
            }
            if (mo > 0) {
                sb.append(String.format("%dM", mo));
            }
            if (da > 0) {
                sb.append(String.format("%dD", da));
            }
            if (hr + mi + se > 0) {
                sb.append("T");
                if (hr > 0) {
                    sb.append(String.format("%dH", hr));
                }
                if (mi > 0) {
                    sb.append(String.format("%dM", mi));
                }
                if (se > 0) {
                    sb.append(String.format("%dS", se));
                }
            }
            duration = sb.toString();
        }
        return duration;
    }

    protected static String getXmlDurationFromHecDuration(String hecDuration) {
        int start = Integer.MIN_VALUE;
        int end = Integer.MIN_VALUE;
        Matcher m = reHecDuration.matcher(hecDuration);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid HEC duration: " + hecDuration);
        }
        int num = Integer.parseInt(m.group(1));
        String unit = m.group(2).toUpperCase();
        if (unit.equals("MIN")) {
            start = 0;
            end = num;
        } else {
            HecTime t1 = new HecTime();
            HecTime t2 = new HecTime();
            HecTime.getTimeWindow(String.format("T, T+%d%s", num, unit.substring(0, 1)), t1, t2);
            start = t1.value();
            end = t2.value();
        }
        return PlotSpecification.getXmlDurationFromMinutes(start, end);
    }

    protected static String[] getAttributeNames(Element element) {
        List attributes = element.getAttributes();
        Object[] attributeNames = new String[attributes.size()];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = ((Attribute)attributes.get(i)).getName();
        }
        Arrays.sort(attributeNames);
        return attributeNames;
    }

    public static List<String> getElementLines(Element element, String indent, int level) {
        Vector<String> lines;
        block25: {
            String prefix = indent == null ? "" : indent;
            StringBuilder sb = new StringBuilder();
            if (indent != null && indent.length() > 0) {
                for (int i = 0; i < level; ++i) {
                    sb.append(indent);
                }
                prefix = sb.toString();
            }
            Vector<String> pathParts = new Vector<String>();
            for (Element lastElem = element; lastElem != null; lastElem = lastElem.getParentElement()) {
                pathParts.add(lastElem.getName());
            }
            sb.setLength(0);
            ListIterator it = pathParts.listIterator(pathParts.size());
            while (it.hasPrevious()) {
                sb.append("/").append((String)it.previous());
            }
            String path = sb.toString();
            if (!xmlElementTypes.containsKey(path)) {
                throw new IllegalArgumentException("Invalid element path: " + path);
            }
            lines = new Vector<String>();
            sb.setLength(0);
            if (path.endsWith("/xy/data/point")) {
                sb.append(prefix);
                Element xElem = element.getChild("x");
                if (xElem != null) {
                    sb.append(xElem.getTextTrim());
                }
                sb.append(",").append(element.getChild("y").getTextTrim());
                lines.add(sb.toString());
            } else if (path.endsWith("/regular/data/start-time")) {
                HecTime t = new HecTime();
                t.setXML(element.getTextTrim());
                lines.add(String.format("%sstart-time \"%s\"", prefix, t.dateAndTime(4)));
            } else if (path.endsWith("regular/data/interval")) {
                lines.add(String.format("%sinterval %s", prefix, PlotSpecification.getHecDuration(element.getTextTrim())));
            } else if (path.endsWith("/regular/data/value")) {
                lines.add(String.format("%s%s", prefix, PlotSpecification.getValue(element.getTextTrim())));
            } else if (path.endsWith("/irregular/data/point")) {
                HecTime t = new HecTime();
                t.setXML(element.getChild("time").getTextTrim());
                String v = PlotSpecification.getValue(element.getChild("value").getTextTrim());
                lines.add(String.format("%s\"%s\",%s", prefix, t.dateAndTime(4), v));
            } else {
                for (String extremumType : Arrays.asList("scale", "view")) {
                    for (String extremum : Arrays.asList("minumum", "maximum")) {
                        if (!path.endsWith(String.format("/scale/datetime/%s-%s", extremumType, extremum))) continue;
                        sb.append(prefix).append(element.getName());
                        for (String name : PlotSpecification.getAttributeNames(element)) {
                            String value = element.getAttributeValue(name);
                            if (value.length() == 0 || value.split("\\s").length > 1) {
                                value = String.format("\"%s\"", value);
                            }
                            sb.append(String.format(" %s %s", name, value));
                        }
                        HecTime t = new HecTime();
                        t.setXML(element.getTextTrim());
                        sb.append(String.format(" \"%s\"", t.dateAndTime(4)));
                        lines.add(sb.toString());
                        break block25;
                    }
                }
                sb.append(prefix).append(element.getName());
                String text = element.getTextTrim();
                if (text != null && text.length() > 0) {
                    if (text.indexOf(35) != -1 || text.split("\\s").length > 1) {
                        text = String.format("\"%s\"", text);
                    }
                    sb.append(" ").append(text);
                }
                for (String name : PlotSpecification.getAttributeNames(element)) {
                    String value = element.getAttributeValue(name);
                    if (value.length() == 0 || value.indexOf(35) != -1 || value.split("\\s").length > 1) {
                        value = String.format("\"%s\"", value);
                    }
                    sb.append(String.format(" %s %s", name, value));
                }
                lines.add(sb.toString());
                for (Object obj : element.getChildren()) {
                    lines.addAll(PlotSpecification.getElementLines((Element)obj, indent, level + 1));
                }
            }
        }
        return lines;
    }

    protected static String prepareLines(String lines) {
        char[] chars = lines.toCharArray();
        Character quoteChar = null;
        boolean inComment = false;
        int lineNumber = 1;
        block9: for (int i = 0; i < chars.length; ++i) {
            if (inComment) {
                switch (chars[i]) {
                    case '\n': {
                        inComment = false;
                        ++lineNumber;
                        break;
                    }
                    default: {
                        chars[i] = 32;
                        break;
                    }
                }
                continue;
            }
            switch (chars[i]) {
                case '\"': 
                case '\'': {
                    if (i != 0 && chars[i - 1] == '\\') continue block9;
                    if (quoteChar != null) {
                        if (chars[i] != quoteChar.charValue()) continue block9;
                        quoteChar = null;
                        continue block9;
                    }
                    quoteChar = Character.valueOf(chars[i]);
                    continue block9;
                }
                case ' ': {
                    if (quoteChar == null) continue block9;
                    chars[i] = '\u0000';
                    continue block9;
                }
                case '#': {
                    if (quoteChar != null) continue block9;
                    inComment = true;
                    chars[i] = 32;
                    continue block9;
                }
                case '\n': {
                    if (quoteChar != null) {
                        throw new IllegalArgumentException("Text has unterminated quote on line " + lineNumber);
                    }
                    ++lineNumber;
                }
            }
        }
        return new String(chars);
    }

    protected static String prepareWord(String word) {
        Character quoteChar = null;
        int start = -1;
        char[] chars = word.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\u0000': {
                    chars[i] = 32;
                    continue block4;
                }
                case '\"': 
                case '\\': {
                    if (i != 0 && chars[i - 1] == '\\') continue block4;
                    if (quoteChar != null) {
                        if (chars[i] != quoteChar.charValue()) continue block4;
                        quoteChar = null;
                        chars[i] = '\u0000';
                        chars[start] = '\u0000';
                        continue block4;
                    }
                    quoteChar = Character.valueOf(chars[i]);
                    start = i;
                }
            }
        }
        if (quoteChar != null) {
            throw new IllegalArgumentException("Word has unterminated quote: " + word);
        }
        return new String(chars).replaceAll("\\x00", "");
    }

    protected static Element wordsToElement(Deque<String> words, Parent parent, String startingPath) {
        if (startingPath == null) {
            startingPath = "";
        }
        StringBuilder path = new StringBuilder(startingPath);
        String item = words.removeFirst();
        path.append("/").append(item);
        Element element = new Element(item);
        LinkedList<String> dataWords = new LinkedList<String>();
        List<String> attributeNames = null;
        String[] names = xmlTypeAttributes.get(xmlElementTypes.get(path.toString()));
        attributeNames = names == null ? Arrays.asList(new String[0]) : Arrays.asList(names);
        boolean done = false;
        while (words.size() > 0 && !done) {
            HecTime t;
            if (words.size() > 0 && attributeNames.contains(words.getFirst())) {
                while (words.size() > 0 && attributeNames.contains(words.getFirst())) {
                    String name = PlotSpecification.prepareWord(words.removeFirst());
                    String value = PlotSpecification.prepareWord(words.removeFirst());
                    element.setAttribute(name, value);
                }
            } else if (words.size() > 0 && xmlElementTypes.containsKey(String.format("%s/%s", path.toString(), words.getFirst()))) {
                Element child = PlotSpecification.wordsToElement(words, (Parent)element, path.toString());
                if (child != null) {
                    element.addContent((Content)child);
                }
            } else if (words.size() > 0) {
                String[] pathWords = TextUtil.split(path.toString(), "/", "L");
                for (int i = pathWords.length - 2; i != -1; --i) {
                    String testPath = TextUtil.join("/", Arrays.copyOf(pathWords, i + 1));
                    names = xmlTypeAttributes.get(xmlElementTypes.get(testPath));
                    if (names != null && Arrays.asList(names).contains(words.getFirst())) {
                        done = true;
                        break;
                    }
                    if (!xmlElementTypes.containsKey(String.format("%s/%s", testPath, words.getFirst()))) continue;
                    done = true;
                    break;
                }
                if (!done) {
                    dataWords.addLast(PlotSpecification.prepareWord(words.removeFirst()));
                    if (path.toString().endsWith("/curve/data/regular/data/interval")) {
                        try {
                            while (true) {
                                Double.parseDouble(words.getFirst());
                                dataWords.addLast(PlotSpecification.getValue(words.removeFirst()));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            done = true;
                        }
                    }
                }
            }
            if (dataWords.size() <= 0) continue;
            if (path.toString().endsWith("/curve/data/xy/data")) {
                while (dataWords.size() > 0) {
                    String word = (String)dataWords.removeFirst();
                    Element pointElem = new Element("point");
                    element.addContent((Content)pointElem);
                    String[] parts = TextUtil.split(word, ",", "L");
                    if (parts[0].length() > 0) {
                        pointElem.addContent((Content)new Element("x").addContent(parts[0]));
                    }
                    pointElem.addContent((Content)new Element("y").addContent(parts[1]));
                }
                continue;
            }
            if (path.toString().endsWith("/curve/data/regular/data/start-time")) {
                t = new HecTime();
                t.set((String)dataWords.removeFirst());
                element.addContent(t.getXMLDateTime(0));
                continue;
            }
            if (path.toString().endsWith("/curve/data/regular/data/interval")) {
                element.addContent(PlotSpecification.getXmlDuration((String)dataWords.removeFirst()));
                ((Element)parent).addContent((Content)element);
                while (dataWords.size() > 0) {
                    ((Element)parent).addContent((Content)new Element("value").addContent((String)dataWords.removeFirst()));
                }
                element = null;
                continue;
            }
            if (path.toString().endsWith("/curve/data/irregular/data")) {
                t = new HecTime();
                while (dataWords.size() > 0) {
                    String word = (String)dataWords.removeFirst();
                    int pos = word.lastIndexOf(44);
                    String timeStr = word.substring(0, pos);
                    String val = word.substring(pos + 1);
                    t.set(timeStr);
                    Element pointElem = new Element("point");
                    element.addContent((Content)pointElem);
                    pointElem.addContent((Content)new Element("time").addContent(t.getXMLDateTime(0)));
                    pointElem.addContent((Content)new Element("value").addContent(PlotSpecification.getValue(val)));
                }
                continue;
            }
            if (path.toString().endsWith("/scale/datetime/scale-minimum") || path.toString().endsWith("/scale/datetime/scale-maximum") || path.toString().endsWith("/scale/datetime/view-minimum") || path.toString().endsWith("/scale/datetime/view-maximum")) {
                t = new HecTime((String)dataWords.removeFirst());
                element.addContent(t.getXMLDateTime(0));
                continue;
            }
            element.addContent(TextUtil.join(" ", dataWords.toArray(new String[0])));
            dataWords.clear();
        }
        return element;
    }

    protected static TimeZone getTimeZone(String timeZone) {
        TimeZone tz;
        if (validUtcIds.size() == 0) {
            for (String id : TimeZone.getAvailableIDs()) {
                if (!TimeZone.getTimeZone(id).hasSameRules(tzUtc)) continue;
                validUtcIds.add(id);
            }
        }
        if ((tz = TimeZone.getTimeZone(timeZone)).hasSameRules(tzUtc) && !validUtcIds.contains(timeZone)) {
            tz = null;
        }
        return tz;
    }

    protected static Document parsePlotSpecText(String text) {
        text = PlotSpecification.prepareLines(text.trim());
        LinkedList<String> words = new LinkedList<String>();
        words.addAll(Arrays.asList(TextUtil.split(text.replaceAll("\\s+", " "), " ", "L")));
        return new Document(PlotSpecification.wordsToElement(words, null, null));
    }

    protected void prune(Element element) {
        List children = element.getChildren();
        Element[] child = new Element[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            child[i] = (Element)children.get(i);
        }
        for (Element c2 : child) {
            this.prune(c2);
            if (c2.getAttributes().size() + c2.getContentSize() != 0) continue;
            c2.detach();
        }
    }

    static {
        xmlTypeAttributes.put("auto-datetime-t", new String[]{"use-automatic"});
        xmlTypeAttributes.put("auto-duration-t", new String[]{"use-automatic"});
        xmlTypeAttributes.put("auto-linear-t", new String[]{"use-automatic"});
        xmlTypeAttributes.put("auto-logarithmic-t", new String[]{"use-automatic"});
        xmlTypeAttributes.put("auto-probability-t", new String[]{"use-automatic"});
        xmlTypeAttributes.put("axis-tics-category-t", new String[]{"show-labels", "show-marks"});
        xmlTypeAttributes.put("color-t", new String[]{"percent-transparent"});
        xmlTypeAttributes.put("curve-t", new String[]{"id", "name"});
        xmlTypeAttributes.put("datetime-scale-t", new String[]{"reverse"});
        xmlTypeAttributes.put("duration-scale-t", new String[]{"reverse"});
        xmlTypeAttributes.put("irregular-time-series-t", new String[]{"data-type"});
        xmlTypeAttributes.put("legend-icon-t", new String[]{"position"});
        xmlTypeAttributes.put("linear-scale-t", new String[]{"reverse"});
        xmlTypeAttributes.put("logarithmic-scale-t", new String[]{"reverse"});
        xmlTypeAttributes.put("parameter-t", new String[]{"unit"});
        xmlTypeAttributes.put("plot-t", new String[]{"name", "width", "height", "spacing", "use-default-line-styles"});
        xmlTypeAttributes.put("probability-scale-t", new String[]{"reverse"});
        xmlTypeAttributes.put("regular-time-series-t", new String[]{"data-type"});
        xmlTypeAttributes.put("timeseries-type-t", new String[]{"data-type"});
        xmlTypeAttributes.put("timewindow-t", new String[]{"start-time", "end-time", "timezone"});
        xmlTypeAttributes.put("viewport-t", new String[]{"name", "weight"});
        xmlTypeAttributes.put("xy-dataset-t", new String[]{"switch-x-y"});
        xmlElementTypes.put("/plot", "plot-t");
        xmlElementTypes.put("/plot/background", "color-t");
        xmlElementTypes.put("/plot/legend", "legend-t");
        xmlElementTypes.put("/plot/legend/background", "color-t");
        xmlElementTypes.put("/plot/legend/left-block", "label-t");
        xmlElementTypes.put("/plot/legend/left-block/alignment", "alignment-t");
        xmlElementTypes.put("/plot/legend/left-block/area", "bordered-area-t");
        xmlElementTypes.put("/plot/legend/left-block/area/background", "background-t");
        xmlElementTypes.put("/plot/legend/left-block/area/background/color", "color-t");
        xmlElementTypes.put("/plot/legend/left-block/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/legend/left-block/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/legend/left-block/area/border", "border-t");
        xmlElementTypes.put("/plot/legend/left-block/area/border/color", "color-t");
        xmlElementTypes.put("/plot/legend/left-block/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/legend/left-block/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/legend/left-block/area/border/width", "float");
        xmlElementTypes.put("/plot/legend/left-block/font", "font-t");
        xmlElementTypes.put("/plot/legend/left-block/font/color", "font-color-t");
        xmlElementTypes.put("/plot/legend/left-block/font/family", "string");
        xmlElementTypes.put("/plot/legend/left-block/font/size", "font-size-t");
        xmlElementTypes.put("/plot/legend/left-block/font/sizes", "");
        xmlElementTypes.put("/plot/legend/left-block/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/legend/left-block/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/legend/left-block/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/legend/left-block/font/style", "font-style-t");
        xmlElementTypes.put("/plot/legend/left-block/iconpath", "string");
        xmlElementTypes.put("/plot/legend/left-block/rotation", "rotation-t");
        xmlElementTypes.put("/plot/legend/left-block/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/legend/left-block/text", "string");
        xmlElementTypes.put("/plot/legend/left-block/visible", "boolean");
        xmlElementTypes.put("/plot/legend/position", "legend-location-t");
        xmlElementTypes.put("/plot/legend/right-block", "label-t");
        xmlElementTypes.put("/plot/legend/right-block/alignment", "alignment-t");
        xmlElementTypes.put("/plot/legend/right-block/area", "bordered-area-t");
        xmlElementTypes.put("/plot/legend/right-block/area/background", "background-t");
        xmlElementTypes.put("/plot/legend/right-block/area/background/color", "color-t");
        xmlElementTypes.put("/plot/legend/right-block/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/legend/right-block/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/legend/right-block/area/border", "border-t");
        xmlElementTypes.put("/plot/legend/right-block/area/border/color", "color-t");
        xmlElementTypes.put("/plot/legend/right-block/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/legend/right-block/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/legend/right-block/area/border/width", "float");
        xmlElementTypes.put("/plot/legend/right-block/font", "font-t");
        xmlElementTypes.put("/plot/legend/right-block/font/color", "font-color-t");
        xmlElementTypes.put("/plot/legend/right-block/font/family", "string");
        xmlElementTypes.put("/plot/legend/right-block/font/size", "font-size-t");
        xmlElementTypes.put("/plot/legend/right-block/font/sizes", "");
        xmlElementTypes.put("/plot/legend/right-block/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/legend/right-block/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/legend/right-block/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/legend/right-block/font/style", "font-style-t");
        xmlElementTypes.put("/plot/legend/right-block/iconpath", "string");
        xmlElementTypes.put("/plot/legend/right-block/rotation", "rotation-t");
        xmlElementTypes.put("/plot/legend/right-block/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/legend/right-block/text", "string");
        xmlElementTypes.put("/plot/legend/right-block/visible", "boolean");
        xmlElementTypes.put("/plot/legend/title", "label-t");
        xmlElementTypes.put("/plot/legend/title/alignment", "alignment-t");
        xmlElementTypes.put("/plot/legend/title/area", "bordered-area-t");
        xmlElementTypes.put("/plot/legend/title/area/background", "backgrounded-t");
        xmlElementTypes.put("/plot/legend/title/area/background/color", "color-t");
        xmlElementTypes.put("/plot/legend/title/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/legend/title/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/legend/title/area/border", "bordered-t");
        xmlElementTypes.put("/plot/legend/title/area/border/color", "color-t");
        xmlElementTypes.put("/plot/legend/title/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/legend/title/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/legend/title/area/border/width", "float");
        xmlElementTypes.put("/plot/legend/title/font", "font-t");
        xmlElementTypes.put("/plot/legend/title/font/color", "font-color-t");
        xmlElementTypes.put("/plot/legend/title/font/family", "string");
        xmlElementTypes.put("/plot/legend/title/font/size", "font-size-t");
        xmlElementTypes.put("/plot/legend/title/font/sizes", "");
        xmlElementTypes.put("/plot/legend/title/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/legend/title/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/legend/title/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/legend/title/font/style", "font-style-t");
        xmlElementTypes.put("/plot/legend/title/iconpath", "string");
        xmlElementTypes.put("/plot/legend/title/rotation", "rotation-t");
        xmlElementTypes.put("/plot/legend/title/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/legend/title/text", "string");
        xmlElementTypes.put("/plot/legend/title/visible", "boolean");
        xmlElementTypes.put("/plot/legend/visible", "boolean");
        xmlElementTypes.put("/plot/title", "label-t");
        xmlElementTypes.put("/plot/title/alignment", "alignment-t");
        xmlElementTypes.put("/plot/title/area", "bordered-area-t");
        xmlElementTypes.put("/plot/title/area/background", "background-t");
        xmlElementTypes.put("/plot/title/area/background/color", "color-t");
        xmlElementTypes.put("/plot/title/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/title/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/title/area/border", "border-t");
        xmlElementTypes.put("/plot/title/area/border/color", "color-t");
        xmlElementTypes.put("/plot/title/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/title/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/title/area/border/width", "float");
        xmlElementTypes.put("/plot/title/font", "font-t");
        xmlElementTypes.put("/plot/title/font/color", "font-color-t");
        xmlElementTypes.put("/plot/title/font/family", "string");
        xmlElementTypes.put("/plot/title/font/size", "font-size-t");
        xmlElementTypes.put("/plot/title/font/sizes", "");
        xmlElementTypes.put("/plot/title/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/title/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/title/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/title/font/style", "font-style-t");
        xmlElementTypes.put("/plot/title/iconpath", "string");
        xmlElementTypes.put("/plot/title/rotation", "rotation-t");
        xmlElementTypes.put("/plot/title/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/title/text", "string");
        xmlElementTypes.put("/plot/title/visible", "boolean");
        xmlElementTypes.put("/plot/viewport", "viewport-t");
        xmlElementTypes.put("/plot/viewport/axis-marker", "axis-marker-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/axis", "axis-name-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/fill", "fill-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/fill/color", "color-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/fill/pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/fill/position", "fill-poistion-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label", "marker-label-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font", "font-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/family", "string");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/position", "line-position-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/text", "string");
        xmlElementTypes.put("/plot/viewport/axis-marker/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/axis-marker/line", "line-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/line/color", "color-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/line/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/axis-marker/line/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/axis-marker/line/width", "float");
        xmlElementTypes.put("/plot/viewport/axis-marker/value", "string");
        xmlElementTypes.put("/plot/viewport/background", "background-t");
        xmlElementTypes.put("/plot/viewport/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/border", "border-t");
        xmlElementTypes.put("/plot/viewport/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/border/width", "float");
        xmlElementTypes.put("/plot/viewport/major-x-grid", "line-t");
        xmlElementTypes.put("/plot/viewport/major-x-grid/color", "color-t");
        xmlElementTypes.put("/plot/viewport/major-x-grid/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/major-x-grid/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/major-x-grid/width", "float");
        xmlElementTypes.put("/plot/viewport/major-y-grid", "line-t");
        xmlElementTypes.put("/plot/viewport/major-y-grid/color", "color-t");
        xmlElementTypes.put("/plot/viewport/major-y-grid/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/major-y-grid/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/major-y-grid/width", "float");
        xmlElementTypes.put("/plot/viewport/minor-x-grid", "line-t");
        xmlElementTypes.put("/plot/viewport/minor-x-grid/color", "color-t");
        xmlElementTypes.put("/plot/viewport/minor-x-grid/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/minor-x-grid/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/minor-x-grid/width", "float");
        xmlElementTypes.put("/plot/viewport/minor-y-grid", "line-t");
        xmlElementTypes.put("/plot/viewport/minor-y-grid/color", "color-t");
        xmlElementTypes.put("/plot/viewport/minor-y-grid/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/minor-y-grid/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/minor-y-grid/width", "float");
        xmlElementTypes.put("/plot/viewport/x1-axis", "");
        xmlElementTypes.put("/plot/viewport/x1-axis/label", "label-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area", "bordered-area-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/background", "background-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/border", "border-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/area/border/width", "float");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font", "font-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/family", "string");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/iconpath", "string");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/rotation", "rotation-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/text", "string");
        xmlElementTypes.put("/plot/viewport/x1-axis/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale", "scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime", "datetime-scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/label-level-count", "datetime-scale-label-level-count-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/major-tic-interval", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/minor-tic-interval", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/scale-maximum", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/scale-minimum", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/view-maximum", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/datetime/view-minimum", "auto-datetime-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration", "duration-scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/major-tic-interval", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/minor-tic-interval", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/scale-maximum", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/scale-minimum", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/view-maximum", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/duration/view-minimum", "auto-duration-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear", "linear-scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/major-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/minor-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/scale-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/scale-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/view-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/linear/view-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic", "logarithmic-scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/major-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/minor-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/scale-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/scale-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/view-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/logarithmic/view-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability", "probability-scale-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/major-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/minor-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/scale-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/scale-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/view-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/scale/probability/view-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics", "axis-tics-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/family", "string");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/sizes", "");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/major/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/family", "string");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/sizes", "");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/x1-axis/tics/minor/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve", "curve-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data", "dataset-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular", "irregular-dataset-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/data", "irregular-time-series-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/data/point", "time-series-point-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/data/point/time", "dateTime");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/data/point/value", "double");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/irregular/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/reference", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/reference/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/reference/time-window", "timewindow-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular", "regular-dataset-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/data", "regular-time-series-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/data/interval", "duration");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/data/start-time", "dateTime");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/data/value", "double");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/regular/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy", "xy-dataset-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/data", "xy-points-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/data/point", "xy-point-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/data/point/x", "double");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/data/point/y", "double");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/x-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/data/xy/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/fill", "fill-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/fill/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/fill/pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/fill/position", "fill-poistion-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/interpolate-missing", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/label", "curve-label-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/label/position", "line-position-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/label/text", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item", "label-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area", "bordered-area-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/background", "background-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/border", "border-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/area/border/width", "float");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font", "font-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/family", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/iconpath", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/rotation", "rotation-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/text", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/legend-item/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/line", "line-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/line/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/line/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/line/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/line/width", "float");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols", "missing-symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/missing-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols", "point-symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/offset", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/skip", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/point-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols", "quality-symbols-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/missing", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/missing/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/missing/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/missing/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/missing/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/questionable", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/questionable/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/questionable/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/questionable/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/questionable/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/rejected", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/rejected/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/rejected/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/rejected/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/rejected/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/valid", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/valid/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/valid/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/valid/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/valid/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/quality-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/show-in-legend", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/step-style", "step-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/curve/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/label", "label-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area", "bordered-area-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/background", "background-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/border", "border-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/area/border/width", "float");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font", "font-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/family", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/iconpath", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/rotation", "rotation-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/text", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale", "scale-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear", "linear-scale-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/major-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/minor-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/scale-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/scale-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/view-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/linear/view-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic", "logarithmic-scale-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/major-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/minor-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/scale-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/scale-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/view-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/logarithmic/view-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability", "probability-scale-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/major-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/minor-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/scale-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/scale-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/view-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/scale/probability/view-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics", "axis-tics-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/family", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/sizes", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/major/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/family", "string");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/sizes", "");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y1-axis/tics/minor/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve", "curve-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data", "dataset-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular", "irregular-dataset-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/data", "irregular-time-series-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/data/point", "time-series-point-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/data/point/time", "dateTime");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/data/point/value", "double");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/irregular/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/reference", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/reference/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/reference/time-window", "timewindow-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular", "regular-dataset-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/data", "regular-time-series-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/data/interval", "duration");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/data/start-time", "dateTime");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/data/value", "double");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/regular/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy", "xy-dataset-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/data", "xy-points-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/data/point", "xy-point-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/data/point/x", "double");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/data/point/y", "double");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/data-source", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/x-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/data/xy/y-parameter", "parameter-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/fill", "fill-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/fill/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/fill/pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/fill/position", "fill-poistion-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/interpolate-missing", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/label", "curve-label-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/label/position", "line-position-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/label/text", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item", "label-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area", "bordered-area-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/background", "background-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/border", "border-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/area/border/width", "float");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font", "font-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/family", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/iconpath", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/rotation", "rotation-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/text", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/legend-item/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/line", "line-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/line/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/line/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/line/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/line/width", "float");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols", "missing-symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/missing-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols", "point-symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/offset", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/skip", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/point-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols", "quality-symbols-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/missing", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/missing/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/missing/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/missing/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/missing/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/questionable", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/questionable/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/questionable/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/questionable/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/questionable/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/rejected", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/rejected/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/rejected/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/rejected/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/rejected/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/valid", "symbol-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/valid/fill-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/valid/line-color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/valid/size", "symbol-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/valid/style", "symbol-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/quality-symbols/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/show-in-legend", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/step-style", "step-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/curve/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/label", "label-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/alignment", "alignment-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area", "bordered-area-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/background", "background-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/background/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/background/fill-pattern", "fill-pattern-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/background/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/border", "border-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/border/color", "color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/border/style", "line-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/border/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/area/border/width", "float");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font", "font-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/family", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/sizes", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/font/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/iconpath", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/rotation", "rotation-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/spacing", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/text", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/label/visible", "boolean");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale", "scale-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear", "linear-scale-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/major-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/minor-tic-interval", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/scale-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/scale-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/view-maximum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/linear/view-minimum", "auto-linear-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic", "logarithmic-scale-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/major-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/minor-tic-interval", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/scale-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/scale-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/view-maximum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/logarithmic/view-minimum", "auto-logarithmic-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability", "probability-scale-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/major-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/minor-tic-interval", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/scale-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/scale-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/view-maximum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/scale/probability/view-minimum", "auto-probability-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics", "axis-tics-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/family", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/sizes", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/major/style", "font-style-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor", "axis-tics-category-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/color", "font-color-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/family", "string");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/mark-length", "nonNegativeInteger");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/size", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/sizes", "");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/sizes/max", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/sizes/min", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/sizes/tiny", "font-size-t");
        xmlElementTypes.put("/plot/viewport/y2-axis/tics/minor/style", "font-style-t");
        lineStyleNames.put(RmaDrawConst.SOLID_STYLE_PATTERN, "solid");
        lineStyleNames.put(RmaDrawConst.DASH_STYLE_PATTERN, "dash");
        lineStyleNames.put(RmaDrawConst.DOT_STYLE_PATTERN, "dot");
        lineStyleNames.put(RmaDrawConst.DASHDOT_STYLE_PATTERN, "dash dot");
        lineStyleNames.put(RmaDrawConst.DASHDOTDOT_STYLE_PATTERN, "dash dot-dot");
        for (float[] pattern : lineStyleNames.keySet()) {
            lineStylePatterns.put(lineStyleNames.get(pattern), pattern);
        }
        lineStepStyleNames.put(0, "normal");
        lineStepStyleNames.put(1, "step");
        lineStepStyleNames.put(3, "cubic");
        for (Integer number : lineStepStyleNames.keySet()) {
            lineStepStyleNumbers.put(lineStepStyleNames.get(number), number);
        }
        fillPatternNames.put(0, "solid");
        fillPatternNames.put(1, "horizontal");
        fillPatternNames.put(2, "vertical");
        fillPatternNames.put(3, "bdiagonal");
        fillPatternNames.put(4, "fdiagonal");
        fillPatternNames.put(5, "cross");
        fillPatternNames.put(6, "diagonal cross");
        for (Integer number : fillPatternNames.keySet()) {
            fillPatternNumbers.put(fillPatternNames.get(number), number);
        }
        alignmentNames.put(0, "left");
        alignmentNames.put(1, "center");
        alignmentNames.put(2, "right");
        for (Integer number : alignmentNames.keySet()) {
            alignmentNumbers.put(alignmentNames.get(number), number);
        }
        fillPositionNames.put(0, "none");
        fillPositionNames.put(1, "above");
        fillPositionNames.put(2, "below");
        for (Integer number : fillPositionNames.keySet()) {
            fillPositionNumbers.put(fillPositionNames.get(number), number);
        }
        labelPositionNames.put(0, "above");
        labelPositionNames.put(1, "below");
        labelPositionNames.put(2, "none");
        for (Integer number : labelPositionNames.keySet()) {
            labelPositionNumbers.put(labelPositionNames.get(number), number);
        }
        fontStyleNames.put(0, "plain");
        fontStyleNames.put(1, "bold");
        fontStyleNames.put(2, "italic");
        fontStyleNames.put(3, "bolditalic");
        for (Integer number : fontStyleNames.keySet()) {
            fontStyleNumbers.put(fontStyleNames.get(number), number);
        }
        legendLocationNames.put(0, "bottom");
        legendLocationNames.put(1, "right");
        legendLocationNames.put(5, "separate window");
        legendLocationNames.put(6, "viewport upper left");
        legendLocationNames.put(7, "viewport upper right");
        for (Integer number : legendLocationNames.keySet()) {
            legendLocationNumbers.put(legendLocationNames.get(number), number);
        }
        axisTypeNames.put(0, "linear");
        axisTypeNames.put(1, "datetime");
        axisTypeNames.put(2, "duration");
        axisTypeNames.put(3, "logarithmic");
        axisTypeNames.put(4, "probability");
        for (Integer number : axisTypeNames.keySet()) {
            axisTypeNumbers.put(axisTypeNames.get(number), number);
        }
        symbolTypeNames.put(0, "square");
        symbolTypeNames.put(1, "circle");
        symbolTypeNames.put(2, "triangle");
        symbolTypeNames.put(3, "triangle2");
        symbolTypeNames.put(4, "diamond");
        symbolTypeNames.put(5, "hourglass");
        symbolTypeNames.put(6, "open square");
        symbolTypeNames.put(7, "open circle");
        symbolTypeNames.put(8, "open triangle");
        symbolTypeNames.put(9, "open triangle2");
        symbolTypeNames.put(10, "open diamond");
        symbolTypeNames.put(11, "open hourglass");
        symbolTypeNames.put(12, "plus square");
        symbolTypeNames.put(13, "plus circle");
        symbolTypeNames.put(14, "hash triangle");
        symbolTypeNames.put(15, "hash triangle2");
        symbolTypeNames.put(16, "plus diamond");
        symbolTypeNames.put(17, "x square");
        symbolTypeNames.put(18, "x circle");
        symbolTypeNames.put(19, "x triangle");
        symbolTypeNames.put(20, "x triangle2");
        symbolTypeNames.put(21, "hash diamond");
        symbolTypeNames.put(22, "backslash square");
        symbolTypeNames.put(23, "forwardslash square");
        symbolTypeNames.put(24, "pipe square");
        symbolTypeNames.put(25, "hash square");
        symbolTypeNames.put(26, "pipe diamond");
        symbolTypeNames.put(27, "x");
        symbolTypeNames.put(28, "plus");
        symbolTypeNames.put(29, "backslash");
        symbolTypeNames.put(30, "forwardslash");
        symbolTypeNames.put(31, "hash");
        symbolTypeNames.put(32, "pipe");
        symbolTypeNames.put(33, "asterisk");
        for (Integer number : symbolTypeNames.keySet()) {
            symbolTypeNumbers.put(symbolTypeNames.get(number), number);
        }
        for (String prefix : Arrays.asList("dark", "light", "")) {
            for (String baseColor : Arrays.asList("red", "blue", "cyan", "green", "magenta", "pink", "yellow", "orange", "purple", "white", "black")) {
                String colorName = String.format("%s%s", prefix, baseColor);
                Color color = RmaColor.parseColorString(colorName);
                String[] values = new String[]{String.format("0%x", color.getRed()), String.format("0%x", color.getGreen()), String.format("0%x", color.getBlue())};
                for (int i = 0; i < values.length; ++i) {
                    if (values[i].length() <= 2) continue;
                    values[i] = values[i].substring(1);
                }
                String colorStr = String.format("#%s%s%s", values[0], values[1], values[2]);
                colorNames.put(colorStr, colorName);
            }
        }
        PlotSpecification.defaultPanelProp.viewportSpaceSize = 5;
        PlotSpecification.defaultLabelProp.text = "";
        for (G2dLabelDrawProp prop : Arrays.asList(PlotSpecification.defaultLegendProp.titleTextProp, PlotSpecification.defaultLegendProp.leftTextProp, PlotSpecification.defaultLegendProp.rightTextProp)) {
            prop.text = "";
            prop.fontSize = 12;
            prop.tinyFontSize = 8;
            prop.minFontSize = 8;
            prop.maxFontSize = 16;
            prop.align = 1;
        }
    }

    protected static class ColorInfo {
        public String colorStr = null;
        public int transparency = Integer.MIN_VALUE;

        public ColorInfo(String colorStr, int transparency) {
            this.colorStr = colorStr;
            this.transparency = transparency;
        }
    }
}

