/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dPanelProp;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.ModelVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Vector;

public class PlotType {
    public static final String PLOT_TYPE_FILE_EXT = ".plotType";
    private String _name;
    private String _description;
    private Vector _plotVariables = new Vector();
    private G2dPanelProp _panelProp;

    public PlotType() {
    }

    public PlotType(Vector variables, G2dPanelProp props) {
        this.setPlotVariables(variables);
        this.setPanelProperties(props);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public void setPlotVariables(Vector variables) {
        this._plotVariables = variables;
    }

    public void setPanelProperties(G2dPanelProp props) {
        this._panelProp = props;
    }

    public Vector getPlotVariables() {
        return this._plotVariables;
    }

    public G2dPanelProp getPanelProperties() {
        return this._panelProp;
    }

    public boolean writeFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        try {
            BufferedWriter writer = file.getBufferedWriter();
            if (writer == null) {
                return false;
            }
            writer.write("PlotType Begin");
            writer.newLine();
            writer.newLine();
            if (this._plotVariables != null) {
                for (int i = 0; i < this._plotVariables.size(); ++i) {
                    ModelVariable pv = (ModelVariable)this._plotVariables.get(i);
                    if (pv == null) continue;
                    pv.write(writer);
                    writer.newLine();
                }
            }
            if (this._panelProp != null) {
                writer.write("Panel Begin");
                writer.newLine();
                this._panelProp.writeProperties(writer);
            }
            writer.newLine();
            writer.write("PlotType End");
            writer.newLine();
            writer.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("writeFile: Error writing " + id.getPath() + " Error:" + e);
            return false;
        }
    }

    public boolean readFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        boolean b = this.readFile(file.getBufferedReader());
        if (!b) {
            System.out.println("failed to read plottype file " + id.getPath());
        }
        return b;
    }

    public boolean readFile(BufferedReader reader) {
        boolean validFile = false;
        if (reader == null) {
            return false;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("PlotType Begin")) continue;
                validFile = true;
                break;
            }
            if (validFile) {
                while ((line = reader.readLine()) != null && !line.startsWith("PlotType End")) {
                    if (line.startsWith("ModelVariable Begin")) {
                        ModelVariable pv = new ModelVariable();
                        if (!pv.read(reader)) continue;
                        this._plotVariables.add(pv);
                        continue;
                    }
                    if (!line.startsWith("Panel Begin")) continue;
                    this._panelProp = new G2dPanelProp();
                    this._panelProp.readProperties(reader);
                    this._panelProp.legendProp.legendItemPropVec.clear();
                }
            } else {
                System.out.println("PlotType File isn't a valid Plot Type File");
                reader.close();
                return false;
            }
            reader.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("readFile: Error reading plottype file Error:" + e);
            e.printStackTrace();
            return false;
        }
    }
}

