/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dSymbolRenderer;
import hec.gfx2d.SamplePanel;
import hec.gfx2d.Symbol;
import hec.gfx2d.components.ComponentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaIntegerJSpinBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;

public class PointPropertiesPanel
extends JPanel
implements ActionListener,
ComponentPanel {
    String title = "Name";
    G2dLineProperties _properties = null;
    JColorChooser _colorChooser;
    Object[] lineCustomColor = new Object[]{Color.white, "Custom"};
    Object[] pLineCustomColor = new Object[]{Color.white, "Custom"};
    Object[] pFillCustomColor = new Object[]{Color.white, "Custom"};
    Object[] fillCustomColor = new Object[]{Color.white, "Custom"};
    JLabel pointTitleLabel = new JLabel(this.title);
    JPanel pointStylePanel = new JPanel(new GridBagLayout());
    JLabel pointStyleLabel = new JLabel("Style:");
    JLabel pointFillColorLabel = new JLabel("Fill Color:");
    JLabel pointLineColorLabel = new JLabel("Line Color:");
    RmaJComboBox pointStyleCombo = new RmaJComboBox();
    RmaJColorComboBox pointFillColorCombo = new RmaJColorComboBox();
    RmaJColorComboBox pointLineColorCombo = new RmaJColorComboBox();
    RmaIntegerJSpinBox sizeSpinBox = new RmaIntegerJSpinBox();
    JLabel pointSizeLabel = new JLabel("Size:");
    SamplePanel samplePanel = new SamplePanel();

    PointPropertiesPanel(String titl) {
        this();
        this.setTitle(titl);
    }

    public PointPropertiesPanel() {
        super(new GridBagLayout());
        this.setToolTipText("");
        this.add((Component)this.pointStylePanel, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointStyleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointStyleCombo, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointLineColorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointLineColorCombo, new GridBagConstraints(1, 3, 1, 2, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointFillColorLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointFillColorCombo, new GridBagConstraints(1, 4, 1, 2, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointSizeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.sizeSpinBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 5, 0));
        this.sizeSpinBox.setMaximum(45);
        this.sizeSpinBox.setMinimum(1);
        this.sizeSpinBox.setValue(10);
        this.pointLineColorCombo.setSelectedColor(Color.blue);
        this.pointFillColorCombo.setSelectedColor(Color.blue);
        Integer[] symbolTypes = new Integer[Symbol.numSymbols()];
        for (int i = 0; i < Symbol.numSymbols(); ++i) {
            symbolTypes[i] = new Integer(i);
        }
        DefaultComboBoxModel<Integer> comboModel = new DefaultComboBoxModel<Integer>(symbolTypes);
        this.pointStyleCombo.setModel(comboModel);
        this.pointStyleCombo.setRenderer(new G2dSymbolRenderer(Color.blue, Color.blue));
        boolean enabled = true;
        this.pointSizeLabel.setEnabled(enabled);
        this.sizeSpinBox.setEnabled(enabled);
        this.pointLineColorCombo.addActionListener(this);
        this.pointFillColorCombo.addActionListener(this);
        this.pointStyleCombo.addActionListener(this);
        this.sizeSpinBox.addActionListener(this);
        this.sizeSpinBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PointPropertiesPanel.this.samplePanel.repaint();
            }
        });
        this.pointStyleCombo.setModifiable(true);
        this.pointFillColorCombo.setModifiable(true);
        this.pointLineColorCombo.setModifiable(true);
    }

    public void setTitle(String titl) {
        this.title = titl;
        this.pointTitleLabel.setText(this.title);
    }

    @Override
    public void setComponentsEnabled(boolean b) {
        this.pointStyleLabel.setEnabled(b);
        this.pointFillColorLabel.setEnabled(b);
        this.pointLineColorLabel.setEnabled(b);
        this.pointStyleCombo.setEnabled(b);
        this.pointFillColorCombo.setEnabled(b);
        this.pointLineColorCombo.setEnabled(b);
        this.sizeSpinBox.setEnabled(b);
        this.pointSizeLabel.setEnabled(b);
    }

    public void setData(G2dLineProperties prop) {
        this._properties = prop;
        if (this._properties == null) {
            return;
        }
        this.pointStyleCombo.setSelectedItem(new Integer(this._properties.getSymbolType()));
        this.sizeSpinBox.setValue((int)this._properties.getSymbolSize());
        this.selectColorItem(this.pointFillColorCombo, this._properties.getPointFillColor());
        this.selectColorItem(this.pointLineColorCombo, this._properties.getPointLineColor());
    }

    private void selectColorItem(JComboBox combo, Color c2) {
        int i;
        boolean found = false;
        Object[] colorObj = null;
        DefaultComboBoxModel cm = (DefaultComboBoxModel)combo.getModel();
        int nitems = combo.getItemCount();
        if (c2 == null) {
            for (i = 0; i < nitems; ++i) {
                colorObj = (Object[])cm.getElementAt(i);
                if (colorObj[0] != null) continue;
                combo.setSelectedIndex(i);
                return;
            }
        }
        for (i = 0; i < nitems; ++i) {
            colorObj = (Object[])cm.getElementAt(i);
            if (!((Color)colorObj[0]).equals(c2)) continue;
            found = true;
            break;
        }
        if (!found) {
            colorObj[0] = c2;
        }
        combo.setSelectedItem(colorObj);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.pointLineColorCombo) {
            this.pointLineColorComboChanged();
        } else if (o == this.pointFillColorCombo) {
            this.pointFillColorComboChanged();
        } else if (o == this.pointStyleCombo) {
            this.pointStyleComboChanged();
        } else if (o == this.sizeSpinBox) {
            this.sizeSpinBoxChanged();
        }
    }

    private void sizeSpinBoxChanged() {
    }

    private void pointStyleComboChanged() {
    }

    private void pointLineColorComboChanged() {
        Object[] item = (Object[])this.pointLineColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.pLineCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new pointLineCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setBackgroundColor((Color)item[0]);
        this.pointStyleCombo.repaint();
    }

    private void pointFillColorComboChanged() {
        Object[] item = (Object[])this.pointFillColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.pFillCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new pointFillCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setForegroundColor((Color)item[0]);
        this.pointStyleCombo.repaint();
    }

    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        int symbolType = (Integer)this.pointStyleCombo.getSelectedItem();
        this._properties.setSymbolType(symbolType);
        this._properties.setSymbolFillColor((Color)((Object[])this.pointFillColorCombo.getSelectedItem())[0]);
        this._properties.setSymbolLineColor((Color)((Object[])this.pointLineColorCombo.getSelectedItem())[0]);
        this._properties.setSymbolSize(this.sizeSpinBox.getValue());
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            return "<html>Panel Class:" + this.getClass().getName() + "<br>Size:" + this.getSize() + "</html>";
        }
        return null;
    }

    private JColorChooser getColorChooser() {
        if (this._colorChooser == null) {
            this._colorChooser = new JColorChooser();
        }
        return this._colorChooser;
    }

    public G2dLineProperties getData() {
        this.savePanel();
        return this._properties;
    }

    class pointLineCustomColorOKListener
    implements ActionListener {
        pointLineCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PointPropertiesPanel.this.pLineCustomColor[0] = PointPropertiesPanel.this.getColorChooser().getColor();
            PointPropertiesPanel.this.pointLineColorCombo.repaint();
            PointPropertiesPanel.this.repaint();
        }
    }

    class pointFillCustomColorOKListener
    implements ActionListener {
        pointFillCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PointPropertiesPanel.this.pFillCustomColor[0] = PointPropertiesPanel.this.getColorChooser().getColor();
            PointPropertiesPanel.this.pointFillColorCombo.repaint();
            PointPropertiesPanel.this.repaint();
        }
    }
}

