/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.Margin;
import hec.gfx2d.PageSetupJDialog;
import hec.gfx2d.PrintProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.PrintPreview;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.postscript.PSGr2;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFGraphics;

public class PrintMultipleJDialog
extends RmaJDialog
implements ActionListener,
ChangeListener,
ButtonCmdPanelListener,
Printable,
Pageable {
    private int _numPagesTall = 1;
    private int _numPagesWide = 1;
    PageFormat _pageFormat = null;
    PrintProperties _printProperties = new PrintProperties();
    JMenuBar jmb = new JMenuBar();
    JPanel jSelectionPanel = new JPanel(new GridBagLayout());
    JPanel jPagePanel = new JPanel(new GridBagLayout());
    JSlider jPageWideSlider = new JSlider(0, 9, 0);
    JSlider jPageHeightSlider = new JSlider(0, 9, 0);
    JLabel jAvailablePlotsLbl = new JLabel("Available Plots");
    JLabel jSelectedPlotsLbl = new JLabel("Selected Plots");
    JLabel jNumPagesWideLbl = new JLabel("Number Across");
    JLabel jNumPagesTallLbl = new JLabel("Number Down");
    RmaJList jAvailablePlotsList = new RmaJList();
    RmaJList jSelectedPlotsList = new RmaJList();
    RmaListModel jSelectedListModel = new RmaListModel(true);
    RmaListModel jAvailableListModel = new RmaListModel(true);
    RmaJIntegerField jNumPagesWideTxt = new RmaJIntegerField();
    RmaJIntegerField jNumPagesTallTxt = new RmaJIntegerField();
    SwatchPanel pageOrientationPanel = new SwatchPanel();
    TitledBorder titledBorder = new TitledBorder("Plots Per Page 1");
    ButtonCmdPanel cmdPanel = new ButtonCmdPanel(132);
    boolean fComponentsAdjusted = false;
    MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == PrintMultipleJDialog.this.jAvailablePlotsList) {
                    int index = PrintMultipleJDialog.this.jAvailablePlotsList.locationToIndex(e.getPoint());
                    PrintMultipleJDialog.this.selectPlot();
                } else if (e.getSource() == PrintMultipleJDialog.this.jSelectedPlotsList) {
                    int index = PrintMultipleJDialog.this.jSelectedPlotsList.locationToIndex(e.getPoint());
                    PrintMultipleJDialog.this.deselectPlot();
                }
            }
        }
    };

    public PrintMultipleJDialog(Frame parent) {
        super(parent);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(430, 350);
        this.setTitle("Print Multiple");
        this.getContentPane().add((Component)this.jSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jSelectionPanel.setBorder(new EtchedBorder(1));
        this.jSelectionPanel.add((Component)this.jAvailablePlotsLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jSelectionPanel.add((Component)this.jSelectedPlotsLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        JScrollPane scrollPane = new JScrollPane(this.jAvailablePlotsList);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.jSelectionPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 5, 5, 0), 0, 0));
        scrollPane = new JScrollPane(this.jSelectedPlotsList);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.jSelectionPanel.add((Component)scrollPane, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 5, 5, 5), 0, 0));
        this.jNumPagesWideTxt.setEditable(false);
        this.jNumPagesWideTxt.setText("1");
        this.jNumPagesTallTxt.setEditable(false);
        this.jNumPagesTallTxt.setText("1");
        this.getContentPane().add((Component)this.jPagePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 0, 5), 0, 5));
        this.jPagePanel.add((Component)this.jNumPagesWideLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPagePanel.add((Component)this.jNumPagesWideTxt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 20, 0));
        this.jPagePanel.add((Component)this.jPageWideSlider, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.jPagePanel.add((Component)this.jNumPagesTallLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPagePanel.add((Component)this.jNumPagesTallTxt, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 20, 0));
        this.jPagePanel.add((Component)this.jPageHeightSlider, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.jPagePanel.add((Component)this.pageOrientationPanel, new GridBagConstraints(2, 0, 1, 4, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPagePanel.setBorder(this.titledBorder);
        this.getContentPane().add((Component)this.cmdPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        JMenu jm = new JMenu("File");
        jm.setMnemonic('F');
        JMenuItem jmi = new JMenuItem("Save As ...", 65);
        jmi.addActionListener(this);
        jmi = new JMenuItem("Page Setup", 83);
        jmi.addActionListener(this);
        jm.add(jmi);
        jmi = new JMenuItem("Print Preview", 80);
        jmi.addActionListener(this);
        jm.add(jmi);
        this.jmb.add(jm);
        this.setJMenuBar(this.jmb);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.jPageHeightSlider.addChangeListener(this);
        this.jPageWideSlider.addChangeListener(this);
        this.cmdPanel.addCmdPanelListener(this);
        this.jAvailablePlotsList.addMouseListener(this.mouseListener);
        this.jSelectedPlotsList.addMouseListener(this.mouseListener);
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public PrintMultipleJDialog(String title) {
        this();
        this.setTitle(title);
    }

    public PrintMultipleJDialog() {
        this((Frame)null);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new PrintMultipleJDialog().setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
            this.initDialog();
        }
        super.setVisible(b);
    }

    void PrintMultipleJDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)obj;
            String arg = menuItem.getLabel();
            if (arg.equals("Page Setup")) {
                this.pageSetup();
            } else if (arg.equals("Print Preview")) {
                this.printPreview();
            } else if (arg.equals("Save As ...")) {
                this.saveAs();
            }
        }
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent e) {
        int id = e.getID();
        if (id == 128) {
            this.ButtonPrint_ActionPerformed();
        } else if (id == 4) {
            this.ButtonCancel_ActionPerformed();
        }
    }

    private void selectPlot() {
        Object[] o = this.jAvailablePlotsList.getSelectedValues();
        if (o != null || o.length < 1) {
            this.jSelectedListModel.addElements(o);
            this.jAvailableListModel.removeElements(o);
        }
    }

    private void deselectPlot() {
        Object[] o = this.jSelectedPlotsList.getSelectedValues();
        if (o != null || o.length < 1) {
            this.jAvailableListModel.addElements(o);
            this.jSelectedListModel.removeElements(o);
        }
    }

    private void ButtonPrint_ActionPerformed() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            this._pageFormat = prnJob.defaultPage();
            this._pageFormat.setOrientation(this._printProperties.getLayout());
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double pageIWidth = pageFormat.getImageableWidth();
        double pageIHeight = pageFormat.getImageableHeight();
        double pageHeight = pageFormat.getHeight();
        double pageWidth = pageFormat.getWidth();
        double marginX = this._numPagesWide == 0 ? 0 : 50 / this._numPagesWide;
        double marginY = this._numPagesTall == 0 ? 0 : 50 / this._numPagesWide;
        if (this.jSelectedListModel.size() == 0) {
            return 1;
        }
        boolean pageNum = false;
        int plotsPerPage = this._numPagesWide * this._numPagesTall;
        if (this._printProperties.usePlotFrame()) {
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawRect((int)imageableX, (int)imageableY, (int)pageIWidth, (int)pageIHeight);
            g.setColor(oldColor);
        }
        if (this._printProperties.usePageNumber()) {
            int fontHeight = g.getFontMetrics().getHeight();
            int fontDescent = g.getFontMetrics().getDescent();
            String printDateStr = new Date().toString().substring(4);
            String pageStr = "Page: " + (pageIndex + 1);
            int pageStrLen = g.getFontMetrics().stringWidth(pageStr);
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            Margin m = this._printProperties.getMargins();
            g.drawString(printDateStr, (int)imageableX + 2, (int)(pageHeight - m.getBottomMargin() * 72.0 - (double)fontDescent));
            g.drawString("Page: " + (pageIndex + 1), (int)(pageWidth / 2.0 - (double)(pageStrLen / 2)), (int)(pageHeight - m.getBottomMargin() * 72.0 - (double)fontDescent));
            g.setColor(oldColor);
            pageIHeight -= (double)fontHeight;
        }
        for (int i = pageIndex * plotsPerPage; i < this.jSelectedListModel.size() && i < pageIndex * plotsPerPage + plotsPerPage; ++i) {
            int x = i % this._numPagesWide;
            int y = i / this._numPagesWide - pageIndex * this._numPagesTall;
            double subImageableWidth = pageIWidth / (double)this._numPagesWide;
            double subImageableHeight = pageIHeight / (double)this._numPagesTall;
            Paper paper = new Paper();
            double origX = (double)x * subImageableWidth + imageableX;
            double origY = subImageableHeight * (double)y + imageableY;
            double iWidthY = subImageableHeight - marginY;
            double iWidthX = subImageableWidth - marginX;
            double pWidth = pageWidth / (double)this._numPagesWide;
            double pHeight = pageHeight / (double)this._numPagesTall;
            paper.setSize(iWidthX, iWidthY);
            paper.setImageableArea(origX, origY, iWidthX, iWidthY);
            PageFormat pgFmt = new PageFormat();
            pgFmt.setPaper(paper);
            Graphics tempG = g.create();
            G2dDialog dlg = (G2dDialog)this.jSelectedListModel.elementAt(i);
            dlg.useLocalPageSettings(false);
            dlg.print(tempG, pgFmt, 0);
            tempG.dispose();
            dlg.useLocalPageSettings(true);
        }
        return 0;
    }

    @Override
    public PageFormat getPageFormat(int pageNum) {
        this._pageFormat.setOrientation(this._printProperties.getLayout());
        Margin margin = this._printProperties.getMargins();
        Paper paper = new Paper();
        double imageableX = margin.getLeftMargin() * 72.0;
        double imageableY = margin.getTopMargin() * 72.0;
        double imageableW = paper.getWidth() - (margin.getLeftMargin() + margin.getRightMargin()) * 72.0;
        double imageableH = paper.getHeight() - (margin.getTopMargin() + margin.getBottomMargin()) * 72.0;
        paper.setImageableArea(imageableX, imageableY, imageableW, imageableH);
        this._pageFormat.setPaper(paper);
        return this._pageFormat;
    }

    @Override
    public Printable getPrintable(int pageNum) {
        return this;
    }

    @Override
    public int getNumberOfPages() {
        int numPlotsPerPage;
        int numDocs = this.jSelectedListModel.size();
        if (numDocs % (numPlotsPerPage = this._numPagesTall * this._numPagesWide) == 0) {
            return numDocs / numPlotsPerPage;
        }
        int numPages = numDocs / numPlotsPerPage + 1;
        return numPages;
    }

    public void saveAs() {
        if (this._pageFormat == null) {
            this._pageFormat = new PageFormat();
        }
        RMAFilenameFilter wmfFileFilter = new RMAFilenameFilter("wmf", "Windows Metafile (*.wmf)");
        RMAFilenameFilter psFileFilter = new RMAFilenameFilter("ps", "Postscript (*.ps)");
        RMAFilenameFilter jpegFileFilter = new RMAFilenameFilter(new String[]{"jpg", "jpeg"}, "JPEG (*.jpg, *.jpeg)");
        RMAFilenameFilter dxfFileFilter = new RMAFilenameFilter("dxf", "Autocad (*.dxf)");
        JFileChooser chooser = new JFileChooser();
        if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
            chooser.addChoosableFileFilter(wmfFileFilter);
        }
        chooser.addChoosableFileFilter(psFileFilter);
        chooser.addChoosableFileFilter(jpegFileFilter);
        chooser.addChoosableFileFilter(dxfFileFilter);
        int state = chooser.showSaveDialog(this);
        File file = chooser.getSelectedFile();
        if (state == 1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file!", "File Error", 0);
            return;
        }
        RMAFilenameFilter ff = (RMAFilenameFilter)chooser.getFileFilter();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        this._pageFormat = prnJob.defaultPage();
        if (ff.equals(psFileFilter)) {
            this.saveToPostscript(file);
        } else if (ff.equals(wmfFileFilter)) {
            this.saveToMetafile(file);
        } else if (ff.equals(jpegFileFilter)) {
            this.saveToJpeg(file);
        } else if (ff.equals(dxfFileFilter)) {
            JOptionPane.showMessageDialog(this, "This File Format is not Supported Yet!", "Format Error", 0);
        }
    }

    private void saveToMetafile(File file) {
        WMF wmf = new WMF();
        WMFGraphics g = new WMFGraphics(wmf, (int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight(), Color.black, Color.lightGray);
        try {
            this.print(g, this._pageFormat, 0);
            String path = file.getPath();
            if (path.indexOf(".wmf") == -1) {
                path = path.concat(".wmf");
            }
            FileOutputStream out = new FileOutputStream(path);
            wmf.writePlaceableWMF(out, 0, 0, (int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight(), Toolkit.getDefaultToolkit().getScreenResolution());
            out.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void saveToPostscript(File file) {
        try {
            StringWriter sw = new StringWriter();
            PSGr2 postscript = new PSGr2(sw);
            this.print(postscript, this._pageFormat, 0);
            String path = file.getPath();
            if (path.indexOf(".ps") == -1) {
                path = path.concat(".ps");
            }
            PrintWriter pw = new PrintWriter(new FileWriter(path));
            pw.println(sw.toString());
            pw.println("showpage");
            pw.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void saveToJpeg(File file) {
        BufferedImage bImage = new BufferedImage((int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight(), 1);
        Graphics2D g = bImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this._pageFormat.getWidth(), (int)this._pageFormat.getHeight());
        try {
            this.print(g, this._pageFormat, 0);
            String path = file.getPath();
            if (path.indexOf(".jpg") == -1 && path.indexOf(".jpeg") == -1) {
                path = path.concat(".jpg");
            }
            FileOutputStream out = new FileOutputStream(path);
            ImageIO.write((RenderedImage)bImage, "JPG", out);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void pageSetup() {
        PageSetupJDialog dlg = new PageSetupJDialog(this, true);
        dlg.setPrintProperties(this._printProperties);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        this._printProperties = dlg.getPrintProperties();
    }

    public void printPreview() {
        if (this._pageFormat == null) {
            this._pageFormat = new PageFormat();
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                PrintMultipleJDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                Window window = SwingUtilities.windowForComponent(PrintMultipleJDialog.this);
                Frame frame = null;
                if (window instanceof Frame) {
                    frame = (Frame)window;
                }
                new PrintPreview(frame, (Printable)PrintMultipleJDialog.this, PrintMultipleJDialog.this.getTitle() + " preview");
                PrintMultipleJDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    private void ButtonCancel_ActionPerformed() {
        this.setVisible(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        if (slider == this.jPageHeightSlider) {
            this.updatePagesTall(slider.getValue());
        } else if (slider == this.jPageWideSlider) {
            this.updatePagesWide(slider.getValue());
        }
    }

    private void updatePagesTall(int height) {
        this.pageOrientationPanel.setNumPagesTall(height);
        this._numPagesTall = height + 1;
        this.titledBorder.setTitle("Plots Per Page " + this._numPagesTall * this._numPagesWide);
        this.jNumPagesTallTxt.setText(Integer.toString(this._numPagesTall));
        this.jPagePanel.repaint();
    }

    private void updatePagesWide(int width) {
        this.pageOrientationPanel.setNumPagesWide(width);
        this._numPagesWide = width + 1;
        this.titledBorder.setTitle("Plots Per Page " + this._numPagesTall * this._numPagesWide);
        this.jNumPagesWideTxt.setText(Integer.toString(this._numPagesWide));
        this.jPagePanel.repaint();
    }

    private void initDialog() {
        Vector openDialogs = G2dDialog.getVisibleDialogs();
        Object[] objList = new Object[openDialogs.size()];
        openDialogs.copyInto(objList);
        this.jAvailableListModel.removeAllElements();
        this.jSelectedListModel.removeAllElements();
        this.jAvailableListModel.addElements(objList);
        this.jAvailablePlotsList.setModel(this.jAvailableListModel);
        this.jSelectedPlotsList.setModel(this.jSelectedListModel);
    }

    class SwatchPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;
        protected int numPagesWide = 0;
        protected int numPagesTall = 0;
        private Color BACKGROUND_COLOR = UIManager.getColor("TableHeader.background");
        private Color[][] colorArray = new Color[][]{{Color.blue, Color.blue, Color.blue, Color.blue, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red}, {Color.blue, Color.blue, Color.blue, Color.blue, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white}, {Color.blue, Color.blue, Color.blue, Color.blue, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red}, {Color.blue, Color.blue, Color.blue, Color.blue, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white}, {Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red}, {Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white}, {Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red}, {Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white}, {Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red, Color.red}, {Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white, Color.white}};

        public SwatchPanel() {
            this.initValues();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        protected void initValues() {
            this.swatchSize = new Dimension(10, 10);
            this.numSwatches = new Dimension(10, 10);
            this.gap = new Dimension(1, 1);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int row = 0; row < this.numSwatches.height; ++row) {
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = column * (this.swatchSize.width + this.gap.width);
                    int y = row * (this.swatchSize.height + this.gap.height);
                    g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                    g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.width - 1);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            return new Dimension(x, y);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int x, int y) {
            int column = x / (this.swatchSize.width + this.gap.width);
            int row = y / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            if (column > this.numPagesWide) {
                return this.BACKGROUND_COLOR;
            }
            if (row > this.numPagesTall) {
                return this.BACKGROUND_COLOR;
            }
            return Color.blue;
        }

        public void setNumPagesWide(int x) {
            if (x < 0 || x >= this.numSwatches.width) {
                return;
            }
            this.numPagesWide = x;
            this.repaint();
        }

        public void setNumPagesTall(int y) {
            if (y < 0 || y >= this.numSwatches.height) {
                return;
            }
            this.numPagesTall = y;
            this.repaint();
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PrintMultipleJDialog.this) {
                PrintMultipleJDialog.this.PrintMultipleJDialog_WindowClosing(event);
            }
        }
    }
}

