/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.Margin;
import java.awt.print.PageFormat;
import java.util.prefs.Preferences;

public class PrintProperties {
    private Margin _margin = null;
    private int _layout = 1;
    private boolean _pageNumbers = false;
    private boolean _plotFrame = false;

    public PrintProperties() {
        PageFormat pageFormat = new PageFormat();
        double leftMargin = pageFormat.getImageableX() / 72.0;
        double topMargin = pageFormat.getImageableY() / 72.0;
        double bottomMargin = (pageFormat.getHeight() - (pageFormat.getImageableHeight() + pageFormat.getImageableY())) / 72.0;
        double rightMargin = (pageFormat.getWidth() - (pageFormat.getImageableWidth() + pageFormat.getImageableX())) / 72.0;
        this._margin = new Margin(topMargin, leftMargin, bottomMargin, rightMargin);
    }

    public void setLayout(int format) {
        if (format != 1 && format != 0 && format != 2) {
            return;
        }
        this._layout = format;
    }

    public int getLayout() {
        return this._layout;
    }

    public void setMargins(Margin m) {
        if (m == null) {
            return;
        }
        this._margin = m;
    }

    public Margin getMargins() {
        return this._margin;
    }

    public boolean usePlotFrame() {
        return this._plotFrame;
    }

    public boolean usePageNumber() {
        return this._pageNumbers;
    }

    public void setUsePlotFrame(boolean frame) {
        this._plotFrame = frame;
    }

    public void setUsePageNumbers(boolean numbers) {
        this._pageNumbers = numbers;
    }

    public void saveToPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.putInt("layout", this._layout);
        preferences.putBoolean("pageNumbers", this._pageNumbers);
        preferences.putBoolean("plotFrame", this._plotFrame);
    }

    public void loadFromPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this._layout = preferences.getInt("layout", this._layout);
        this._pageNumbers = preferences.getBoolean("pageNumbers", this._pageNumbers);
        this._plotFrame = preferences.getBoolean("plotFrame", this._plotFrame);
    }
}

