/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisIterator;
import hec.geometry.AxisProp;
import hec.geometry.ProbabilityAxis;
import hec.geometry.ProbabilityAxisIterator;
import hec.geometry.ScaleProperties;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dAxisLabelPropertiesPanel;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.ProbabilityScalePropertiesPanel;
import hec.gfx2d.ScalePropertiesPanel;
import hec.gfx2d.Viewport;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.util.RMAIO;

public class ProbabilityAxisTics
extends AxisTics {
    public ProbabilityAxisTics(G2dPanel p, ProbabilityAxis ax, Viewport vp, int align) {
        super(p, ax, vp, align);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editProperties() {
        Cursor oldCursor = this.getCursor();
        G2dPropertiesDlg dlg = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.axisPanel = new G2dAxisPropertiesPanel(){

                @Override
                public void fillPanel() {
                    super.fillPanel();
                    this.jMinorTicMarkCheckBox.setSelected(false);
                    this.jMinorTicMarkCheckBox.setEnabled(false);
                }
            };
            this.scalePanel = new ProbabilityScalePropertiesPanel();
            this.labelPanel = new G2dAxisLabelPropertiesPanel();
            AxisLabel label = this.getG2dPanel().getViewportAxisLabel(this._viewport, this.translateFromAlignmentToAxisPosition(this._alignment));
            if (label != null) {
                this.labelPanel.setData(label.getProperties());
                this.labelPanel.setLabelText(label.getText());
            }
            this.axisPanel.setData(this._drawProp);
            AxisProp prop = this._axis.getAxisProp();
            if (this._alignment == 1 || this._alignment == 0) {
                prop.isReversed = !prop.isReversed;
            }
            prop.isDefaultLimits = false;
            this.scalePanel.setData(prop);
            this.axisPanel.setName("Tics");
            Window w = SwingUtilities.windowForComponent(this);
            dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel});
            if (dlg == null) {
                return;
            }
            dlg.setTitle(this._viewport.getName() + " - Axis " + this._axis.getName() + " Properties");
            dlg.addOKListener(new PropertiesOKListener(this.scalePanel));
        }
        finally {
            this.setCursor(oldCursor);
        }
        dlg.setVisible(true);
    }

    @Override
    protected void drawAxisLabelsBottom(Graphics g, FontMetrics metrics, int ioff, int space, Rectangle rc) {
        AxisIterator iterObj;
        int lastLabelPos = this._axis.isReversed() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastLabelWidth = 0;
        g.setColor(this._drawProp.axisTicColor);
        double val = this._axis.getActMax() / this._axis.getThousScale();
        String xtxt = RMAIO.setPrecision2(val, this._axis.getSigFig());
        int delx = Math.abs(this._axis.w2l(this._axis.getMajorTic()) - this._axis.w2l(0.0));
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        if (!((iterObj = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip)) instanceof ProbabilityAxisIterator)) {
            System.out.println("drawAxisLabelsBottom:Expecting ProbabilityAxisIterator got " + iterObj != null ? iterObj.getClass().getName() : null);
            return;
        }
        ProbabilityAxisIterator iter = (ProbabilityAxisIterator)iterObj;
        DecimalFormat df = new DecimalFormat();
        while (iter.next()) {
            double maLocalValue = ma.w2lE(iter.getValue());
            int ix = ioff + (int)maLocalValue;
            if (ix < ioff || ix > ioff + this._viewport.getWidth()) continue;
            df.setMaximumFractionDigits(this._axis.getSigFig());
            int idx = ((ProbabilityAxis)ma).getIndexFor(iter.getValue());
            String txt = ((ProbabilityAxis)this._axis).getValueStringAt(idx);
            if (txt == null) {
                txt = iter.getValueString();
            }
            df.format(this._axis.l2wE(maLocalValue) / this._axis.getThousScale());
            int iy = rc.height - this._drawProp.majorTicLength - space - metrics.getMaxDescent();
            int labelWidth = metrics.stringWidth(txt);
            if (!this._axis.isReversed()) {
                if (lastLabelPos + lastLabelWidth / 2 + 2 >= ix - labelWidth / 2) continue;
                Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
                lastLabelPos = ix;
                lastLabelWidth = labelWidth;
                continue;
            }
            if (lastLabelPos - lastLabelWidth / 2 - 2 <= ix + labelWidth / 2) continue;
            Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
            lastLabelPos = ix;
            lastLabelWidth = labelWidth;
        }
    }

    @Override
    protected void drawAxisLabelsTop(Graphics g, FontMetrics metrics, int ioff, int space, Rectangle rc) {
        int lastLabelPos = this._axis.isReversed() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastLabelWidth = 0;
        g.setColor(this._drawProp.axisTicColor);
        double val = this._axis.getActMax() / this._axis.getThousScale();
        String xtxt = RMAIO.setPrecision2(val, this._axis.getSigFig());
        int delx = Math.abs(this._axis.w2l(this._axis.getMajorTic()) - this._axis.w2l(0.0));
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        AxisIterator iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
        DecimalFormat df = new DecimalFormat();
        while (iter.next()) {
            double maLocalValue = ma.w2lE(iter.getValue());
            int ix = ioff + (int)maLocalValue;
            if (ix < ioff || ix > ioff + this._viewport.getWidth()) continue;
            df.setMaximumFractionDigits(this._axis.getSigFig());
            String txt = iter.getValueString();
            int iy = this._drawProp.majorTicLength + space + metrics.getMaxAscent();
            int labelWidth = metrics.stringWidth(txt);
            if (!this._axis.isReversed()) {
                if (lastLabelPos + lastLabelWidth / 2 + 2 >= ix - labelWidth / 2) continue;
                Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
                lastLabelPos = ix;
                lastLabelWidth = labelWidth;
                continue;
            }
            if (lastLabelPos - lastLabelWidth / 2 - 2 <= ix + labelWidth / 2) continue;
            Gfx2dDrawUtil.drawString(this, g, txt, ix - labelWidth / 2, iy);
            lastLabelPos = ix;
            lastLabelWidth = labelWidth;
        }
    }

    class PropertiesOKListener
    implements ActionListener {
        private ScalePropertiesPanel _scalePanel = null;

        public PropertiesOKListener(ScalePropertiesPanel scalePanel) {
            this._scalePanel = scalePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScaleProperties prop = this._scalePanel.getData();
            double vmin = 0.0;
            double vmax = 0.0;
            double max = 0.0;
            double min = 0.0;
            max = prop.isAutomaticMax() ? 0.9999 : prop.getMaxScaleValue();
            min = prop.isAutomaticMin() ? 1.0E-4 : prop.getMinScaleValue();
            prop.setMaxScaleValue(max);
            prop.setMinScaleValue(min);
            vmax = prop.isAutomaticViewMax() ? 0.9999 : prop.getActualMaxScaleValue();
            double d = vmin = prop.isAutomaticViewMin() ? 1.0E-4 : prop.getActualMinScaleValue();
            if (vmax > max) {
                vmax = max;
            }
            if (vmin < min) {
                vmin = min;
            }
            prop.setActualMaxScaleValue(vmax);
            prop.setActualMinScaleValue(vmin);
            AxisProp aprop = new AxisProp((AxisProp)prop);
            aprop.isReversed = ProbabilityAxisTics.this._alignment == 1 || ProbabilityAxisTics.this._alignment == 0 ? !prop.isReversed() : prop.isReversed();
            ProbabilityAxisTics.this._axis.setAxisProp(aprop);
            ProbabilityAxisTics.this._parent.invalidate();
            ProbabilityAxisTics.this._parent.doLayout();
            ProbabilityAxisTics.this._parent.paintGfx();
            ProbabilityAxisTics.this.repaint();
            if (ProbabilityAxisTics.this._alignment == 1 || ProbabilityAxisTics.this._alignment == 0) {
                prop.setReversed(!aprop.isReversed());
            }
            this._scalePanel.refresh();
        }
    }
}

