/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.DefaultRatingFunction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class RatingFunctionEditor
extends RmaJDialog {
    boolean m_canceled = false;
    RmaJTable m_table = null;

    public RatingFunctionEditor(JFrame parent, boolean modal, String title) {
        super((Frame)parent, modal);
        this.setTitle(title);
        this.buildControls();
    }

    public RatingFunctionEditor(JDialog parent, boolean modal, String title) {
        super((Dialog)parent, modal);
        this.setTitle(title);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        RmaGridBagConstraints rgb = new RmaGridBagConstraints();
        this.m_table = new RmaJTable(this, (Object[])new String[]{"X", "Y"}){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(200, 225);
            }
        };
        this.m_table.setPrecision(3);
        this.m_table.setNumRows(10);
        this.m_table.setDoubleCellEditor(true);
        JScrollPane sp = new JScrollPane(this.m_table);
        rgb.set(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0);
        this.getContentPane().add((Component)sp, rgb);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        rgb.set(0, 2, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS5555, 0, 0);
        this.getContentPane().add((Component)cmdPanel, rgb);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        RatingFunctionEditor.this.m_canceled = false;
                        RatingFunctionEditor.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        RatingFunctionEditor.this.m_canceled = true;
                        RatingFunctionEditor.this.setVisible(false);
                    }
                }
            }
        });
    }

    public boolean isCanceled() {
        return this.m_canceled;
    }

    public void fillForm(DefaultRatingFunction f) {
        double[] baseValues = f.getBaseValues();
        double[] ratedValues = f.getRatedValues();
        if (baseValues == null || ratedValues == null) {
            return;
        }
        int size = baseValues.length > ratedValues.length ? baseValues.length : ratedValues.length;
        for (int i = 0; i < size; ++i) {
            if (i < baseValues.length) {
                this.m_table.setCell(new Double(baseValues[i]), i, 1);
            }
            if (i >= ratedValues.length) continue;
            this.m_table.setCell(new Double(ratedValues[i]), i, 0);
        }
    }

    public double[][] saveForm() {
        Object cellVal1;
        Object cellVal0;
        Vector row;
        int z;
        RmaTableModel model = (RmaTableModel)this.m_table.getModel();
        Vector rows = model.getDataVector();
        int npts = 0;
        for (z = 0; z < rows.size(); ++z) {
            row = (Vector)rows.elementAt(z);
            cellVal0 = row.elementAt(0);
            cellVal1 = row.elementAt(1);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal1 == null || cellVal1.equals("")) continue;
            ++npts;
        }
        double[][] value = new double[2][npts];
        for (z = 0; z < npts; ++z) {
            row = (Vector)rows.elementAt(z);
            cellVal0 = row.elementAt(0);
            cellVal1 = row.elementAt(1);
            value[0][z] = RMAIO.parseDouble(cellVal0, Double.NEGATIVE_INFINITY);
            value[1][z] = RMAIO.parseDouble(cellVal1, Double.NEGATIVE_INFINITY);
        }
        return value;
    }

    public static void main(String[] args) {
        RatingFunctionEditor rfe = new RatingFunctionEditor(new JFrame(), true, "");
        rfe.pack();
        rfe.setLocation(200, 200);
        rfe.setVisible(true);
    }
}

