/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalRect;
import hec.gfx2d.TextObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class RotatedText
extends TextObject {
    int _x;
    int _y;
    double _angle;
    int _offset;

    public RotatedText() {
    }

    public RotatedText(String txt, int x, int y, double angle, int offset, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._angle = angle;
        this._offset = offset;
    }

    @Override
    public LocalRect getBounds() {
        if (this._bounds == null) {
            double ca = Math.cos(-this._angle);
            double sa = Math.sin(-this._angle);
            int lt = (int)((double)this._x - (double)this._strwidth / 2.0 * ca + ((double)this._offset - (double)this._h / 2.0) * sa);
            int lb = (int)((double)this._x - (double)this._strwidth / 2.0 * ca + ((double)this._offset + (double)this._h / 2.0) * sa);
            int rt = (int)((double)this._x + (double)this._strwidth / 2.0 * ca + ((double)this._offset - (double)this._h / 2.0) * sa);
            int rb = (int)((double)this._x + (double)this._strwidth / 2.0 * ca + ((double)this._offset + (double)this._h / 2.0) * sa);
            int tl = (int)((double)this._y - (double)this._strwidth / 2.0 * sa + ((double)this._offset - (double)this._h / 2.0) * ca);
            int tr = (int)((double)this._y + (double)this._strwidth / 2.0 * sa + ((double)this._offset - (double)this._h / 2.0) * ca);
            int bl = (int)((double)this._y - (double)this._strwidth / 2.0 * sa + ((double)this._offset + (double)this._h / 2.0) * ca);
            int br = (int)((double)this._y + (double)this._strwidth / 2.0 * sa + ((double)this._offset + (double)this._h / 2.0) * ca);
            int l = Math.min(lt, Math.min(lb, Math.min(rt, rb)));
            int r = Math.max(lt, Math.max(lb, Math.max(rt, rb)));
            int t = Math.min(tl, Math.min(tr, Math.min(bl, br)));
            int b = Math.max(tl, Math.max(tr, Math.max(bl, br)));
            this._bounds = new LocalRect(l, t, r, b);
        }
        return this._bounds;
    }

    @Override
    public boolean intersects(TextObject obj) {
        if (this._bounds == null) {
            this.getBounds();
        }
        return this._bounds.intersects(obj.getBounds());
    }

    @Override
    public void draw(Graphics g) {
        if (this._text == null) {
            return;
        }
        g.setFont(this._font);
        g.setColor(this._fgcolor);
        double ca = Math.cos(this._angle);
        double sa = Math.sin(this._angle);
        int xt = (int)((double)this._x - (double)this._offset * sa);
        int yt = (int)((double)this._y + (double)this._offset * ca);
        AffineTransform at = new AffineTransform();
        ((Graphics2D)g).translate(xt, yt);
        ((Graphics2D)g).rotate(this._angle);
        Color oldColor = g.getColor();
        g.setColor(Color.white);
        if (this._bounds == null) {
            this.getBounds();
        }
        g.fillRect(-this._strwidth / 2, 0, this._bounds.width(), -this._bounds.height());
        g.setColor(Color.blue);
        g.drawRect(-this._strwidth / 2, 0, this._bounds.width(), -this._bounds.height());
        g.setColor(oldColor);
        ((Graphics2D)g).drawString(this._text, -this._strwidth / 2, 0);
        at.setToIdentity();
        ((Graphics2D)g).setTransform(at);
    }
}

