/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dBackgroundPropertiesPanel;
import hec.gfx2d.G2dNoneCustomPanel;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.SimpleLinePropertiesPanel;
import hec.gfx2d.components.CheckBoxPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import rma.swing.EnabledJPanel;
import rma.util.FillPatternFactory;

public class SamplePanel
extends EnabledJPanel
implements LabelLayoutConstants {
    int strLen = 0;
    String _sampleText;
    String _position = "Center";
    String _align = "Left";
    int _textSize = 10;
    G2dNoneCustomPanel _noneCustomPanel;
    G2dBackgroundPropertiesPanel _backgroundPropPanel;
    SimpleLinePropertiesPanel _borderPropPanel;
    boolean _drawLine = false;
    private CheckBoxPanel _checkBoxPanel;
    private Color _foreground = Color.BLACK;

    public SamplePanel() {
        this.setName("Sample");
        this.setBorder(BorderFactory.createTitledBorder("Sample"));
    }

    public void setNoneCustomPanel(G2dNoneCustomPanel panel) {
        this._noneCustomPanel = panel;
    }

    public void setCheckBoxPanel(CheckBoxPanel panel) {
        this._checkBoxPanel = panel;
    }

    public void setBackgroundPropPanel(G2dBackgroundPropertiesPanel panel) {
        this._backgroundPropPanel = panel;
        if (this._backgroundPropPanel != null) {
            this._backgroundPropPanel.setSamplePanel(this);
        }
    }

    public void setBorderPropPanel(SimpleLinePropertiesPanel panel) {
        this._borderPropPanel = panel;
        if (this._borderPropPanel != null) {
            this._borderPropPanel.setSamplePanel(this);
        }
    }

    public void setDrawLine(boolean drawLine) {
        this._drawLine = drawLine;
    }

    public void setTextAlignment(String alignment) {
        if (!("Left".equals(alignment) || "Center".equals(alignment) || "Right".equals(alignment))) {
            return;
        }
        this._align = alignment;
        this.repaint();
    }

    public void setTextPosition(String position) {
        if (!("Above".equals(position) || "Center".equals(position) || "Below".equals(position))) {
            return;
        }
        this._position = position;
        this.repaint();
    }

    public void setTextSize(int size) {
        if (size < 0) {
            return;
        }
        this._textSize = size;
        this.repaint();
    }

    public void setSampleText(String text) {
        this._sampleText = text;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.shouldPaintText()) {
            Dimension d = this.getSize();
            if (this._drawLine) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            return;
        }
        Color oldColor = g.getColor();
        Dimension d = this.getSize();
        if (this._backgroundPropPanel != null && this._backgroundPropPanel.isCustomEnabled()) {
            g.setColor(this._backgroundPropPanel.getBackgroundColor());
            Paint oldPaint = ((Graphics2D)g).getPaint();
            Composite oldAC = ((Graphics2D)g).getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, this._backgroundPropPanel.getAlpha());
            ((Graphics2D)g).setComposite(ac);
            ((Graphics2D)g).setPaint(FillPatternFactory.createFillPattern(this._backgroundPropPanel.getBackgroundFill(), this._backgroundPropPanel.getBackgroundColor()));
            g.fillRect(15, 20, d.width - 30, d.height - 30);
            ((Graphics2D)g).setPaint(oldPaint);
            ((Graphics2D)g).setComposite(oldAC);
        } else {
            g.setColor(Color.white);
            g.fillRect(15, 20, d.width - 30, d.height - 30);
        }
        if (this._borderPropPanel != null && this._borderPropPanel.isCustomEnabled()) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            g2d.setColor(this._borderPropPanel.getLineColor());
            BasicStroke bs = new BasicStroke(this._borderPropPanel.getLineWidth(), 0, 0, 10.0f, this._borderPropPanel.getLineStyle(), 0.0f);
            g2d.setStroke(bs);
            g2d.drawRect(14, 19, d.width - 29, d.height - 29);
            g2d.setStroke(oldStroke);
        }
        g.setColor(this._foreground);
        if (this._sampleText != null) {
            g.setFont(this.getSampleFont());
            this.strLen = g.getFontMetrics().stringWidth(this._sampleText);
        }
        if (this._position.equals("Above") && this._align.equals("Left")) {
            this.drawAboveLeft(g);
        } else if (this._position.equals("Above") && this._align.equals("Center")) {
            this.drawAboveCenter(g);
        } else if (this._position.equals("Above") && this._align.equals("Right")) {
            this.drawAboveRight(g);
        } else if (this._position.equals("Below") && this._align.equals("Left")) {
            this.drawBelowLeft(g);
        } else if (this._position.equals("Below") && this._align.equals("Center")) {
            this.drawBelowCenter(g);
        } else if (this._position.equals("Below") && this._align.equals("Right")) {
            this.drawBelowRight(g);
        } else if (this._position.equals("Center") && this._align.equals("Center")) {
            this.drawCenterCenter(g);
        } else if (this._position.equals("Center") && this._align.equals("Right")) {
            this.drawCenterRight(g);
        } else if (this._position.equals("Center") && this._align.equals("Left")) {
            this.drawCenterLeft(g);
        }
        g.setColor(oldColor);
    }

    public void setTextForeground(Color foreground) {
        if (foreground == null) {
            this._foreground = Color.BLACK;
            return;
        }
        this._foreground = foreground;
    }

    private boolean shouldPaintText() {
        return !(this._checkBoxPanel != null ? !this._checkBoxPanel.isSelected() : this._noneCustomPanel != null && !this._noneCustomPanel.jNoneRadio.isSelected());
    }

    private void drawAboveLeft(Graphics g) {
        int offset = 15;
        if (this._borderPropPanel != null) {
            offset = (int)((float)offset + this._borderPropPanel.getLineWidth());
        }
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, offset, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }
    }

    private void drawAboveCenter(Graphics g) {
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }
    }

    private void drawAboveRight(Graphics g) {
        int offset = 15;
        if (this._borderPropPanel != null) {
            offset = (int)((float)offset + this._borderPropPanel.getLineWidth());
        }
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width - offset - this.strLen, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }
    }

    private void drawBelowLeft(Graphics g) {
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        this.drawString(g, this._sampleText, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent());
    }

    private void drawBelowCenter(Graphics g) {
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }
    }

    private void drawBelowRight(Graphics g) {
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }
    }

    private void drawCenterRight(Graphics g) {
        int offset = 15;
        if (this._borderPropPanel != null) {
            offset = (int)((float)offset + this._borderPropPanel.getLineWidth());
        }
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width - 12 - this.strLen, d.height / 2 + 2);
            g.drawLine(d.width - 10 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width - offset - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private void drawCenterCenter(Graphics g) {
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, d.width / 2 - this.strLen / 2 - 2, d.height / 2 + 2);
            g.drawLine(d.width / 2 + this.strLen / 2 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private void drawCenterLeft(Graphics g) {
        int offset = 15;
        if (this._borderPropPanel != null) {
            offset = (int)((float)offset + this._borderPropPanel.getLineWidth());
        }
        Dimension d = this.getSize();
        if (this._drawLine) {
            g.drawLine(5, d.height / 2 + 2, 8, d.height / 2 + 2);
            g.drawLine(10 + this.strLen + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
        }
        if (this._sampleText != null) {
            this.drawString(g, this._sampleText, offset, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private Font getSampleFont() {
        Font f = this.getFont();
        Font newF = new Font(f.getName(), f.getStyle(), this._textSize);
        return newF;
    }

    private void drawString(Graphics g, String text, int offset, int pos) {
        Dimension d = this.getSize();
        g.setClip(15, 20, d.width - 30, d.height - 30);
        String[] lines = text.split("\\n");
        int nLines = lines.length;
        int fntHeight = g.getFontMetrics().getHeight();
        pos -= nLines / 2 * fntHeight;
        for (String line : lines) {
            Gfx2dDrawUtil.drawString(this, g, line, offset, pos);
            pos += fntHeight;
        }
    }
}

