/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleArrayGlyph;
import rma.util.RMAConst;

public class SimpleArray
extends G2dData
implements G2dObject {
    public double[] xdata;
    public double[] ydata;
    int _xAxisType = 0;
    int _yAxisType = 0;
    boolean m_notifyObservers = true;

    public SimpleArray() {
        this.name = "Simple Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xdata = new double[100];
        this.ydata = new double[100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[i] = Math.PI * (double)i / 20.0;
            this.ydata[i] = 5.0 * Math.sin(this.xdata[i]);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    public void setXAxisName(String xName) {
        this.xunits = xName;
    }

    public void setYAxisName(String yName) {
        this.yunits = yName;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    public void setData(double[] xd, double[] yd) {
        this.xdata = xd;
        this.ydata = yd;
        this.bounds = null;
        if (this.m_notifyObservers) {
            this.setChanged();
            this.notifyObservers("reset data");
            this.clearChanged();
        }
    }

    public void setNotifyObservers(boolean b) {
        this.m_notifyObservers = b;
    }

    public boolean doesNotifyObservers() {
        return this.m_notifyObservers;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this.bounds == null) {
            for (int s = 0; s < this.xdata.length; ++s) {
                if (!RMAConst.isValidValue(this.xdata[s]) || !RMAConst.isValidValue(this.ydata[s])) continue;
                this.bounds = new WorldRect(this.xdata[s], this.ydata[s], this.xdata[s], this.ydata[s]);
                break;
            }
            for (int i = s + 1; i < this.xdata.length; ++i) {
                if (RMAConst.isValidValue(this.xdata[i])) {
                    if (this.bounds.w > this.xdata[i]) {
                        this.bounds.w = this.xdata[i];
                    } else if (this.bounds.e < this.xdata[i]) {
                        this.bounds.e = this.xdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this.ydata[i])) continue;
                if (this.bounds.s > this.ydata[i]) {
                    this.bounds.s = this.ydata[i];
                    continue;
                }
                if (!(this.bounds.n < this.ydata[i])) continue;
                this.bounds.n = this.ydata[i];
            }
        }
        return this.bounds;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleArray.class, SimpleArrayGlyph.class);
    }
}

