/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.SimpleArray;
import hec.gfx2d.SimpleBarArray;
import hec.gfx2d.Viewport;
import java.awt.Graphics;
import java.awt.Rectangle;
import rma.util.RMAConst;

public class SimpleArrayGlyph
extends G2dGlyph {
    SimpleArray _obj;

    public SimpleArrayGlyph(Viewport view, SimpleArray map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        G2dLineProperties prop = this._line.getProperties();
        prop._drawPoints = true;
        prop._symbolSize = 3.0f;
        this._line.setProperties(prop);
    }

    @Override
    public void draw(Graphics g) {
        int i;
        int xmin = Math.min(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymax = Math.max(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        int xmax = Math.max(this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMin()), this._scale.getAxis(0).w2l(this._scale.getAxis(0).getActMax()));
        int ymin = Math.min(this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMax()), this._scale.getAxis(1).w2l(this._scale.getAxis(1).getActMin()));
        Rectangle rect = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        double[] dxarray = new double[10000];
        double[] dyarray = new double[10000];
        for (int ioff = 0; ioff < this._obj.xdata.length; ioff += i) {
            int imax = this._obj.xdata.length;
            int icnt = 0;
            for (i = 0; i < imax - ioff; ++i) {
                double dx = this._obj.xdata[i + ioff];
                double dy = this._obj.ydata[i + ioff];
                if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                    ++i;
                    break;
                }
                ++icnt;
                if (this._obj instanceof SimpleBarArray) {
                    SimpleArrayGlyph.xarray[i] = this._scale.e2x(dx);
                    SimpleArrayGlyph.yarray[i] = this._scale.n2y(dy);
                    continue;
                }
                dxarray[i] = dx;
                dyarray[i] = dy;
            }
            if (this._obj instanceof SimpleBarArray) {
                this._polygon.setPolygonData(xarray, yarray, icnt);
                this._polygon.drawPolygon(g, rect);
                continue;
            }
            this._line.setLineData(dxarray, dyarray, icnt);
            this._line.drawLine(g, rect);
        }
    }
}

