/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleArray;
import hec.gfx2d.SimpleArrayGlyph;
import rma.util.RMAConst;

public class SimpleBarArray
extends SimpleArray
implements G2dObject {
    public SimpleBarArray() {
        this.name = "Simple Bar Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        boolean _xAxisType = true;
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    @Override
    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    @Override
    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    @Override
    public void setData(double[] xd, double[] yd) {
        this.ydata = yd;
        this.xdata = xd;
        this.getBounds();
        if (this.xdata != null) {
            this.xdata = this.fixXdata(xd);
        }
        if (this.ydata != null) {
            this.ydata = this.fixYdata(yd);
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    double[] fixYdata(double[] yData) {
        double[] newYdata = new double[yData.length * 2 + 2];
        int rows = 0;
        newYdata[rows++] = this.bounds.s;
        for (int i = 0; i < yData.length; ++i) {
            newYdata[rows++] = yData[i];
            newYdata[rows++] = yData[i];
        }
        newYdata[rows++] = this.bounds.s;
        return newYdata;
    }

    double[] fixXdata(double[] xData) {
        double[] newXdata = new double[xData.length * 2 + 2];
        int rows = 0;
        for (int i = 0; i < xData.length; ++i) {
            newXdata[rows++] = xData[i];
            newXdata[rows++] = xData[i];
        }
        newXdata[rows] = newXdata[rows - 1];
        newXdata[++rows] = newXdata[rows - 1];
        ++rows;
        return newXdata;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(this.xdata[0], this.ydata[0], this.xdata[0], this.ydata[0]);
            for (int i = 1; i < this.xdata.length; ++i) {
                if (RMAConst.isValidValue(this.xdata[i])) {
                    if (this.bounds.w > this.xdata[i]) {
                        this.bounds.w = this.xdata[i];
                    } else if (this.bounds.e < this.xdata[i]) {
                        this.bounds.e = this.xdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this.ydata[i])) continue;
                if (this.bounds.s > this.ydata[i]) {
                    this.bounds.s = this.ydata[i];
                    continue;
                }
                if (!(this.bounds.n < this.ydata[i])) continue;
                this.bounds.n = this.ydata[i];
            }
        }
        return this.bounds;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleBarArray.class, SimpleArrayGlyph.class);
    }
}

