/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleJTableGlyph;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.PairedDataContainer;
import javax.swing.table.TableModel;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableData
extends G2dData
implements G2dObject {
    public double[][] xdata;
    public double[][] ydata;
    int[] _rowData;
    public int _startRow = 0;
    int _xAxisType = 0;
    int _yAxisType = 0;
    String[] _curveNames = null;
    RmaJTable _table;
    int _xCol;
    int _yCol;
    private double undef = -3.4028234663852886E38;
    private HecTime htime = new HecTime();
    private String pdcYUnits;
    private String pdcXUnits;
    boolean _addToPairedDataRev = true;

    public SimpleJTableData() {
        this.name = "Simple Table Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xdata = new double[1][100];
        this.ydata = new double[1][100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[0][i] = Math.PI * (double)i / 20.0;
            this.ydata[0][i] = 5.0 * Math.sin(this.xdata[0][i]);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    @Override
    public int getCurveCount() {
        if (this.xdata == null || this.ydata == null) {
            return 0;
        }
        return this.xdata.length > this.ydata.length ? this.xdata.length : this.ydata.length;
    }

    public String getCurveName(int curveIdx) {
        if (this._curveNames == null) {
            return null;
        }
        if (curveIdx < 0 || curveIdx >= this._curveNames.length) {
            return null;
        }
        return this._curveNames[curveIdx];
    }

    public void clearData() {
        this.xdata = null;
        this.ydata = null;
        this.setChanged();
        this.notifyObservers(this.getDataResetType());
    }

    public void setMultipleColumnData(RmaJTable tbl, int[] xCol, int[] yCol) {
        if (tbl != null & xCol != null & yCol != null) {
            this.xdata = new double[xCol.length][0];
            this.ydata = new double[yCol.length][0];
            int nrows = tbl.getRowCount();
            int icnt = 0;
            int maxTableColumn = xCol.length > yCol.length ? xCol.length : yCol.length;
            this._rowData = new int[maxTableColumn];
            this._curveNames = new String[maxTableColumn];
            for (int zz = 0; zz < maxTableColumn; ++zz) {
                int yIdx;
                int xColIndex = zz < xCol.length ? zz : -1;
                int yColIndex = zz < yCol.length ? zz : -1;
                double xtmpval = 0.0;
                double ytmpval = 0.0;
                double[] xtmp = new double[nrows];
                double[] ytmp = new double[nrows];
                icnt = 0;
                int row = 0;
                for (row = 0; row < nrows; ++row) {
                    if (xColIndex > -1) {
                        xtmpval = this.parseValue(tbl.getCell(row, xCol[xColIndex]), this._xAxisType);
                    }
                    if (yColIndex > -1) {
                        ytmpval = this.parseValue(tbl.getCell(row, yCol[yColIndex]), this._yAxisType);
                    }
                    if (RMAConst.isValidValue(xtmpval)) {
                        xtmp[row] = xtmpval;
                    }
                    if (RMAConst.isValidValue(ytmpval)) {
                        ytmp[row] = ytmpval;
                    }
                    if (!RMAConst.isValidValue(xtmpval) || !RMAConst.isValidValue(ytmpval)) continue;
                    ++icnt;
                }
                if (xColIndex > -1) {
                    this.xdata[xColIndex] = xtmp;
                }
                if (yColIndex > -1) {
                    this.ydata[yColIndex] = ytmp;
                }
                this._rowData[zz] = icnt > this._rowData[zz] ? icnt : this._rowData[zz];
                TableModel tm = tbl.getModel();
                if (tm instanceof RmaTableModelInterface) {
                    int paramId;
                    if (xColIndex > -1 && (paramId = ((RmaTableModelInterface)tm).getColumnParameter(xCol[xColIndex])) != -1) {
                        super.setXParameterId(paramId);
                    }
                    if (yColIndex > -1 && (paramId = ((RmaTableModelInterface)tm).getColumnParameter(yCol[yColIndex])) != -1) {
                        super.setYParameterId(paramId);
                    }
                    this.setUnitSystem(((RmaTableModelInterface)tm).getUnitSystem());
                }
                int xIdx = xColIndex == -1 ? xCol.length - 1 : xColIndex;
                int n = yIdx = yColIndex == -1 ? yCol.length - 1 : yColIndex;
                if (xCol[xIdx] >= tm.getColumnCount() || yCol[yIdx] >= tm.getColumnCount()) continue;
                String xlabel = tm.getColumnName(xCol[xIdx]);
                String ylabel = tm.getColumnName(yCol[yIdx]);
                xlabel = this.stripUnitsFromLabel(xlabel);
                ylabel = this.stripUnitsFromLabel(ylabel);
                this.name = xlabel + "-" + ylabel;
                this._curveNames[zz] = xlabel + "-" + ylabel;
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem(this.getXParameterId(), this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem(this.getYParameterId(), this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers(this.getDataResetType());
        this.clearChanged();
    }

    public void setData(RmaJTable tbl, int[] xCol, int[] yCol) {
        int yRows = Integer.MAX_VALUE;
        if (tbl != null) {
            this.xdata = new double[1][tbl.getRowCount()];
            int temp = this.fillData(tbl, this.xdata[0], yCol, this._xAxisType);
            int xRows = temp < yRows ? temp : yRows;
            this.ydata = new double[1][tbl.getRowCount()];
            temp = this.fillData(tbl, this.ydata[0], yCol, this._yAxisType);
            yRows = temp < yRows ? temp : yRows;
            this._rowData = new int[1];
            this._rowData[0] = yRows < xRows ? yRows : xRows;
            TableModel tm = tbl.getModel();
            if (tm instanceof RmaTableModelInterface) {
                int paramId = ((RmaTableModelInterface)tm).getColumnParameter(xCol[0]);
                if (paramId != -1) {
                    super.setXParameterId(paramId);
                }
                if ((paramId = ((RmaTableModelInterface)tm).getColumnParameter(yCol[0])) != -1) {
                    super.setYParameterId(paramId);
                }
                this.setUnitSystem(((RmaTableModelInterface)tm).getUnitSystem());
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem(this.getXParameterId(), this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem(this.getYParameterId(), this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers(this.getDataResetType());
        this.clearChanged();
    }

    public void setData(RmaJTable tbl, int xCol, int yCol) {
        if (tbl != null) {
            int row;
            this._table = tbl;
            int nrows = tbl.getRowCount();
            this._xCol = xCol;
            this._yCol = yCol;
            double[] xtmp = new double[nrows];
            double[] ytmp = new double[nrows];
            int icnt = 0;
            for (row = 0; row < nrows; ++row) {
                xtmp[row] = this.parseValue(tbl.getCell(row, xCol), this._xAxisType);
                ytmp[row] = this.parseValue(tbl.getCell(row, yCol), this._yAxisType);
                if (!RMAConst.isValidValue(xtmp[row]) || !RMAConst.isValidValue(ytmp[row])) continue;
                ++icnt;
            }
            this.xdata = new double[1][icnt];
            this.ydata = new double[1][icnt];
            int istart = 0;
            int iend = nrows;
            icnt = 0;
            this._rowData = new int[1];
            this._curveNames = new String[1];
            for (row = istart; row < iend; ++row) {
                if (!RMAConst.isValidValue(xtmp[row]) || !RMAConst.isValidValue(ytmp[row])) continue;
                this.xdata[0][icnt] = xtmp[row];
                this.ydata[0][icnt] = ytmp[row];
                ++icnt;
            }
            this._rowData[0] = icnt;
            TableModel tm = tbl.getModel();
            if (tm instanceof RmaTableModelInterface) {
                int paramId = ((RmaTableModelInterface)tm).getColumnParameter(xCol);
                if (paramId != -1) {
                    super.setXParameterId(paramId);
                }
                if ((paramId = ((RmaTableModelInterface)tm).getColumnParameter(yCol)) != -1) {
                    super.setYParameterId(paramId);
                }
                this.setUnitSystem(((RmaTableModelInterface)tm).getUnitSystem());
            }
            if (xCol < tm.getColumnCount() && yCol < tm.getColumnCount()) {
                String xlabel = tm.getColumnName(xCol);
                String ylabel = tm.getColumnName(yCol);
                xlabel = this.stripUnitsFromLabel(xlabel);
                ylabel = this.stripUnitsFromLabel(ylabel);
                this.name = xlabel + "-" + ylabel;
                this._curveNames[0] = this.name;
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem(this.getXParameterId(), this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem(this.getYParameterId(), this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers(this.getDataResetType());
        this.clearChanged();
    }

    public String getDataResetType() {
        return "reset data";
    }

    protected String stripUnitsFromLabel(String labelString) {
        int idx = labelString.indexOf("(%S)");
        if (idx < 0) {
            return labelString;
        }
        String newLabel = labelString.substring(0, idx).trim();
        return newLabel;
    }

    protected double parseValue(Object dataObj, int axisType) {
        double val;
        block9: {
            val = this.undef;
            try {
                if (dataObj.toString().trim().equals("")) break block9;
                if (axisType == 1 || axisType == 2) {
                    try {
                        if (dataObj instanceof HecTimeArray) {
                            this.htime = new HecTime(((HecTimeArray)dataObj).element(0));
                        } else {
                            int t = RMAIO.parseInt(dataObj.toString());
                            if (t == Integer.MIN_VALUE) {
                                this.htime.set(dataObj.toString());
                            } else {
                                this.htime.set(t);
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.htime.set(dataObj.toString());
                    }
                    val = this.htime.value();
                    break block9;
                }
                val = axisType == 3 ? RMAIO.parseDouble(dataObj) : RMAIO.parseDouble(dataObj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val;
    }

    public void setXDataElement(int xPos, double data) {
        if (this.xdata.length == 0 || xPos >= this.xdata[0].length) {
            return;
        }
        this.xdata[0][xPos] = data;
    }

    public void setYDataElement(int yPos, double data) {
        if (this.ydata.length == 0 || yPos >= this.ydata[0].length) {
            return;
        }
        this.ydata[0][yPos] = data;
    }

    public void setStartRow(int row) {
        this._startRow = row;
    }

    public int getStartRow() {
        return this._startRow;
    }

    int fillData(RmaJTable tbl, double[] dataArray, int[] col, int axisType) {
        Object dataObj = null;
        int rows = 0;
        HecTime ht = null;
        if (axisType == 1 || axisType == 2) {
            ht = new HecTime();
        }
        for (int i = this._startRow; i < tbl.getRowCount(); ++i) {
            try {
                dataObj = tbl.getCell(i, col[0]);
                for (int colIdx = 1; colIdx < col.length; ++colIdx) {
                    dataObj = dataObj.toString() + " " + tbl.getCell(i, col[colIdx]).toString();
                }
                if (dataObj.toString().trim().equals("")) continue;
                if (axisType == 1 || axisType == 2) {
                    try {
                        int t = RMAIO.parseInt(dataObj.toString());
                        if (t == Integer.MIN_VALUE) {
                            ht.set(dataObj.toString());
                        } else {
                            ht.set(t);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        ht.set(dataObj.toString());
                    }
                    dataArray[rows++] = ht.value();
                    continue;
                }
                double d = RMAIO.parseDouble(dataObj);
                dataArray[rows++] = d;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rows;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this._rowData == null) {
            return null;
        }
        if (this.bounds == null) {
            if (this._rowData.length <= 0) {
                return null;
            }
            if (this.ydata.length == 0 || this.ydata[0].length == 0) {
                return null;
            }
            if (this.xdata.length == 0 || this.xdata[0].length == 0) {
                return null;
            }
            this.bounds = this.ydata[0][0] < 0.0 || this.xdata[0][0] < 0.0 ? new WorldRect(this.xdata[0][0], this.ydata[0][0], 0.0, 0.0) : new WorldRect(this.xdata[0][0], this.ydata[0][0], this.xdata[0][0], this.ydata[0][0]);
            int maxRow = this.getMaxRow();
            for (int i = 1; i < maxRow; ++i) {
                int zz;
                for (zz = 0; zz < this.xdata.length; ++zz) {
                    if (!RMAConst.isValidValue(this.xdata[zz][i])) continue;
                    if (this.bounds.w > this.xdata[zz][i]) {
                        this.bounds.w = this.xdata[zz][i];
                        continue;
                    }
                    if (!(this.bounds.e < this.xdata[zz][i])) continue;
                    this.bounds.e = this.xdata[zz][i];
                }
                for (zz = 0; zz < this.ydata.length; ++zz) {
                    if (!RMAConst.isValidValue(this.ydata[zz][i])) continue;
                    if (this.bounds.s > this.ydata[zz][i]) {
                        this.bounds.s = this.ydata[zz][i];
                        continue;
                    }
                    if (!(this.bounds.n < this.ydata[zz][i])) continue;
                    this.bounds.n = this.ydata[zz][i];
                }
            }
        }
        return this.bounds;
    }

    private int getMaxRow() {
        int maxRow = 0;
        for (int j = 0; j < this._rowData.length; ++j) {
            maxRow = maxRow < this._rowData[j] ? this._rowData[j] : maxRow;
        }
        return maxRow;
    }

    public void setCurveNames(String[] names) {
        for (int i = 0; i < this._curveNames.length; ++i) {
            if (i >= names.length) continue;
            this._curveNames[i] = names[i];
        }
    }

    public PairedDataContainer getPairedDataContainer() {
        String xunits;
        String yunits;
        double[][] pdYData = null;
        double[] pdXData = null;
        if (this._addToPairedDataRev) {
            pdYData = this.xdata;
            pdXData = this.ydata[0];
            yunits = this.pdcXUnits;
            xunits = this.pdcYUnits;
        } else {
            pdYData = this.ydata;
            pdXData = this.xdata[0];
            yunits = this.pdcYUnits;
            xunits = this.pdcXUnits;
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        pairedDataContainer.numberOrdinates = this.getMaxRow();
        pairedDataContainer.numberCurves = this.getCurveCount();
        pairedDataContainer.xOrdinates = new double[pairedDataContainer.numberOrdinates];
        pairedDataContainer.yOrdinates = new double[pairedDataContainer.numberCurves][pairedDataContainer.numberOrdinates];
        for (int z = 0; z < pairedDataContainer.numberOrdinates; ++z) {
            if (z >= pdXData.length) continue;
            pairedDataContainer.xOrdinates[z] = pdXData[z];
        }
        for (int j = 0; j < pdYData.length; ++j) {
            for (int i = 0; i < pairedDataContainer.numberOrdinates; ++i) {
                if (i >= pdYData[j].length) continue;
                pairedDataContainer.yOrdinates[j][i] = pdYData[j][i];
            }
        }
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.labels = new String[pairedDataContainer.numberCurves];
        for (int i = 0; i < pairedDataContainer.labels.length; ++i) {
            pairedDataContainer.labels[0] = this.getCurveName(i);
        }
        pairedDataContainer.xunits = xunits;
        pairedDataContainer.yunits = yunits;
        pairedDataContainer.xtype = "UNT";
        pairedDataContainer.ytype = "UNT";
        pairedDataContainer.xprecision = -1;
        pairedDataContainer.yprecision = -1;
        return pairedDataContainer;
    }

    public void addToPairedDataContainerReveresed(boolean rev) {
        this._addToPairedDataRev = rev;
    }

    public int addToPairedDataContainer(PairedDataContainer pairedDataContainer) {
        System.out.println("Compare PDC.xunits=" + pairedDataContainer.xunits + "  TO this.pcdYUnits=" + this.pdcYUnits);
        if (!pairedDataContainer.xunits.equals(this.pdcYUnits)) {
            return -1;
        }
        double[][] pdYData = null;
        double[] pdXData = null;
        if (this._addToPairedDataRev) {
            pdYData = this.xdata;
            pdXData = this.ydata[0];
        } else {
            pdYData = this.ydata;
            pdXData = this.xdata[0];
        }
        HecDoubleArray local = new HecDoubleArray(pdXData);
        HecDoubleArray remote = new HecDoubleArray(pairedDataContainer.xOrdinates);
        HecDoubleArray combined = remote.merge(local);
        int total = combined.numberElements();
        double[][] values = new double[pairedDataContainer.numberCurves + pdYData.length][total];
        double[] newX = combined.getDoubleArray();
        int icount = 0;
        int jcount = 0;
        for (int z = 0; z < pdYData.length; ++z) {
            for (int i = 0; i < total; ++i) {
                if (newX[i] == pairedDataContainer.xOrdinates[icount]) {
                    for (int j = 0; j < pairedDataContainer.numberCurves; ++j) {
                        values[j][i] = pairedDataContainer.yOrdinates[j][icount];
                    }
                    ++icount;
                }
                if (newX[i] != pdXData[jcount]) continue;
                values[pairedDataContainer.numberCurves + z][i] = pdYData[z][jcount];
                ++jcount;
            }
        }
        pairedDataContainer.xOrdinates = newX;
        pairedDataContainer.yOrdinates = values;
        String[] newLabels = new String[pairedDataContainer.numberCurves + 1];
        for (int j = 0; j < pairedDataContainer.numberCurves; ++j) {
            newLabels[j] = pairedDataContainer.labels[j];
        }
        newLabels[pairedDataContainer.numberCurves] = this.name;
        pairedDataContainer.labels = newLabels;
        ++pairedDataContainer.numberCurves;
        return 0;
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this.getMaxRow() == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        int maxRow = this.getMaxRow();
        for (int zz = 0; zz < this.xdata.length; ++zz) {
            for (int ii = 0; ii < this.ydata.length; ++ii) {
                for (int z = 0; z < maxRow; ++z) {
                    if (closestPt == null) {
                        closestPt = new WorldPt(this.xdata[zz][0], this.ydata[ii][0]);
                    }
                    x1 = this.xdata[zz][z];
                    y1 = this.ydata[ii][z];
                    double dx = pt.e - x1;
                    double dy = pt.n - y1;
                    if (dx == 0.0 && dy == 0.0) {
                        return pt;
                    }
                    double tmp = Math.sqrt(dx * dx + dy * dy);
                    if (!(tmp < dist)) continue;
                    dist = tmp;
                    closestPt.init(x1, y1);
                }
            }
        }
        return closestPt;
    }

    RmaJTable getRmaJTable() {
        return this._table;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleJTableData.class, SimpleJTableGlyph.class);
    }
}

