/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.SimpleJTableData;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableGlyph
extends G2dGlyph
implements TableChangeListener {
    SimpleJTableData _obj;
    double[] xarray = new double[10000];
    double[] yarray = new double[10000];
    protected boolean _firstDraw = true;

    public SimpleJTableGlyph(Viewport view, SimpleJTableData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
    }

    @Override
    protected void buildLineArray() {
        super.buildLineArray();
        for (int i = 0; this._g2dObject != null && i < this._g2dObject.getCurveCount(); ++i) {
            this._lineArray[i].setName(((SimpleJTableData)this._g2dObject).getCurveName(i));
            this._lineArray[i].setLineLabel(this._lineArray[i].getName());
        }
    }

    @Override
    public void draw(Graphics g) {
        int i;
        if (this._lineArray == null || this._lineArray.length != this._obj.getCurveCount()) {
            this.buildLineArray();
        }
        boolean imax = false;
        boolean ioff = false;
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        if (this._obj._rowData == null) {
            return;
        }
        if (this._firstDraw && this._obj._table != null) {
            this._obj._table.addTableChangeListener(this);
            this._firstDraw = false;
        }
        Rectangle rect = this.getVisibleRect();
        for (i = 0; i < this._lineArray.length; ++i) {
            this._lineArray[i].clearLineData();
        }
        int number = 0;
        int xDataIndex = 0;
        int yDataIndex = 0;
        for (int j = 0; j < this._obj.getCurveCount(); ++j) {
            xDataIndex = j < this._obj.xdata.length ? j : this._obj.xdata.length - 1;
            yDataIndex = j < this._obj.ydata.length ? j : this._obj.ydata.length - 1;
            number = 0;
            for (i = 0; i < this._obj._rowData[j]; ++i) {
                double dx = this._obj.xdata[xDataIndex][i];
                double dy = this._obj.ydata[yDataIndex][i];
                if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                    if (number > 0) {
                        this._lineArray[j].addLineData(this.xarray, this.yarray, number);
                        number = 0;
                    }
                } else {
                    this.xarray[number] = dx;
                    this.yarray[number] = dy;
                    ++number;
                }
                if (number < 10000) continue;
                this._lineArray[j].addLineData(this.xarray, this.yarray, number);
                number = 0;
            }
            if (number <= 0) continue;
            this._lineArray[j].addLineData(this.xarray, this.yarray, number);
        }
        for (i = 0; i < this._obj.getCurveCount(); ++i) {
            this._lineArray[i].drawLine(g, rect);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        LocalPt rpt;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (rpt = this._line.getNearestDataPt(pt)) != null) {
            double xval = this._scale.x2e(rpt.x);
            double yval = this._scale.y2n(rpt.y);
            WorldPt wp = new WorldPt(xval, yval);
            if ((wp = this._obj.getNearestDataPt(wp)) == null) {
                return null;
            }
            try {
                if (this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0) {
                    yval = Units.convertUnits(wp.n, this._obj.getYParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                    if (this._obj.getXAxisType() != 1 && this._obj.getXParameterId() != -1) {
                        xval = Units.convertUnits(wp.e, this._obj.getXParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                    }
                } else {
                    yval = wp.n;
                    xval = wp.e;
                }
            }
            catch (DataSetException dataSetException) {
                // empty catch block
            }
            if (this._obj.getXAxisType() != 1) {
                return new String("[" + RMAIO.setPrecision2(xval, 2) + "," + Double.toString(yval) + "]");
            }
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            this._scale.convertDataTime(hTime);
            String yvalstr = RMAIO.setPrecision2(yval, 2);
            return new String("[" + hTime.dateAndTime() + " ," + yvalstr + "]");
        }
        return null;
    }

    @Override
    public void tableDataChanged(TableUpdateEvent event) {
        if (this._obj._table != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleJTableGlyph.this._obj.setData(SimpleJTableGlyph.this._obj._table, SimpleJTableGlyph.this._obj._xCol, SimpleJTableGlyph.this._obj._yCol);
                    SimpleJTableGlyph.this._viewport.paintGfx();
                }
            });
        }
    }
}

