/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleJTableSeasonalGlyph;
import hec.heclib.util.HecTime;
import rma.swing.RmaJTable;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableSeasonalData
extends G2dData
implements G2dObject {
    public static final double UNDEF_DBL = -901.1;
    public double[] xdata;
    public double[] ydata;
    public int _rows = 0;
    public int _startRow = 0;
    int _yRows;
    int _xRows;
    int _xAxisType = 0;
    int _yAxisType = 0;

    public SimpleJTableSeasonalData() {
        this.name = "Simple Table Seasonal Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xdata = new double[100];
        this.ydata = new double[100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[i] = Math.PI * (double)i / 20.0;
            this.ydata[i] = 5.0 * Math.sin(this.xdata[i]);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    public void setData(RmaJTable tbl, int[] xCol, int[] yCol) {
        boolean[] defaultValues = new boolean[2];
        if (tbl != null) {
            double defValue = -901.1;
            this.xdata = new double[tbl.getRowCount()];
            this.ydata = new double[tbl.getRowCount()];
            this._xRows = this.fillData(tbl, this.xdata, xCol, this._xAxisType, false, defaultValues);
            this._yRows = this.fillData(tbl, this.ydata, yCol, this._yAxisType, true, defaultValues);
            if (defaultValues[1]) {
                defValue = this.getDefYValue(this.ydata[this._yRows - 1], defaultValues[0] ? this.ydata[1] : this.ydata[0], this.xdata[this._xRows - 1], defaultValues[1] ? this.xdata[this._xRows - 2] : this.xdata[this._xRows - 1], defaultValues[0] ? this.xdata[1] : this.xdata[0], this.xdata[0]);
                this.ydata[this._yRows++] = defValue;
                if (defaultValues[0]) {
                    this.ydata[0] = defValue;
                }
            }
            if (defaultValues[0]) {
                this.ydata[0] = defValue != -901.1 ? defValue : (defValue = this.getDefYValue(this.ydata[this._yRows - 1], this.ydata[1], this.xdata[this._xRows - 1], this.xdata[this._xRows - 1], this.xdata[1], this.xdata[0]));
            }
            this._rows = this._yRows < this._xRows ? this._yRows : this._xRows;
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setData(RmaJTable tbl, int xCol, int yCol) {
        boolean[] defaultValues = new boolean[2];
        if (tbl != null) {
            this.xdata = new double[tbl.getRowCount()];
            this.ydata = new double[tbl.getRowCount()];
            if (this._yAxisType == 1 || this._yAxisType == 2) {
                this._xRows = this.fillData(tbl, this.xdata, xCol, this._xAxisType, defaultValues);
                this._yRows = this.fillData(tbl, this.ydata, yCol, this._yAxisType, defaultValues);
            } else {
                this._yRows = this.fillData(tbl, this.ydata, yCol, this._yAxisType, defaultValues);
                this._xRows = this.fillData(tbl, this.xdata, xCol, this._xAxisType, defaultValues);
            }
            this._rows = this._yRows < this._xRows ? this._yRows : this._xRows;
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setXDataElement(int xPos, double data) {
        if (xPos >= this.xdata.length) {
            return;
        }
        this.xdata[xPos] = data;
    }

    public void setYDataElement(int yPos, double data) {
        if (yPos >= this.ydata.length) {
            return;
        }
        this.ydata[yPos] = data;
    }

    public void setStartRow(int row) {
        this._startRow = row;
    }

    public int getStartRow() {
        return this._startRow;
    }

    int fillData(RmaJTable tbl, double[] dataArray, int col, int axisType, boolean[] defaultValues) {
        Object dataObj;
        int rows = 1;
        HecTime ht = null;
        double defValue = -901.1;
        if (axisType == 1 || axisType == 2) {
            ht = new HecTime();
            dataObj = tbl.getCell(this._startRow, col);
            try {
                int t = RMAIO.parseInt(dataObj.toString());
                if (t == Integer.MIN_VALUE) {
                    ht.set(dataObj.toString());
                } else {
                    ht.set(t);
                }
            }
            catch (NumberFormatException nfe) {
                ht.set(dataObj.toString());
            }
            if (ht.month() != 1 && ht.day() != 1 && ht.hour() != 0 && ht.minute() != 0) {
                ht.set("01Jan 0000");
                defaultValues[0] = true;
                dataArray[rows++] = ht.value();
            }
        } else if (defaultValues[0]) {
            ++rows;
        }
        for (int i = this._startRow; i < tbl.getRowCount(); ++i) {
            try {
                dataObj = tbl.getCell(i, col);
                if (dataObj.toString().trim().equals("")) continue;
                if (axisType == 1 || axisType == 2) {
                    try {
                        int t = RMAIO.parseInt(dataObj.toString());
                        if (t == Integer.MIN_VALUE) {
                            ht.set(dataObj.toString());
                        } else {
                            ht.set(t);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        ht.set(dataObj.toString());
                    }
                    dataArray[rows++] = ht.value();
                    continue;
                }
                dataArray[rows++] = RMAIO.parseDouble(dataObj);
                continue;
            }
            catch (Exception e) {
                System.out.println("ouch. " + e);
            }
        }
        if (axisType == 1 || axisType == 2) {
            ht.setMinutes(dataArray[rows - 1]);
            if (ht.month() != 12 && ht.day() != 31 && ht.hour() != 24 && ht.minute() != 0) {
                ht.set("31Dec 2400");
                defaultValues[1] = true;
                dataArray[rows++] = ht.value();
            }
        }
        return rows;
    }

    int fillData(RmaJTable tbl, double[] dataArray, int[] col, int axisType, boolean isX, boolean[] defaultValues) {
        int colIdx;
        Object dataObj = null;
        double defValue = -901.1;
        int rows = 0;
        HecTime ht = null;
        if (axisType == 1 || axisType == 2) {
            ht = new HecTime();
            dataObj = tbl.getCell(this._startRow, col[0]);
            for (colIdx = 1; colIdx < col.length; ++colIdx) {
                dataObj = dataObj.toString() + " " + tbl.getCell(this._startRow, col[colIdx]).toString();
            }
            try {
                int t = RMAIO.parseInt(dataObj.toString());
                if (t == Integer.MIN_VALUE) {
                    ht.set(dataObj.toString());
                } else {
                    ht.set(t);
                }
            }
            catch (NumberFormatException nfe) {
                ht.set(dataObj.toString());
            }
            if (ht.month() != 1 || ht.day() != 1 || ht.hour() != 0 || ht.minute() != 0) {
                ht.set("01Jan 0000");
                defaultValues[0] = true;
                dataArray[rows++] = ht.value();
            }
        } else if (defaultValues[0]) {
            ++rows;
        }
        for (int i = this._startRow; i < tbl.getRowCount(); ++i) {
            try {
                dataObj = tbl.getCell(i, col[0]);
                for (colIdx = 1; colIdx < col.length; ++colIdx) {
                    dataObj = dataObj.toString() + " " + tbl.getCell(i, col[colIdx]).toString();
                }
                if (dataObj.toString().trim().equals("")) continue;
                if (axisType == 1 || axisType == 2) {
                    try {
                        int t = RMAIO.parseInt(dataObj.toString());
                        if (t == Integer.MIN_VALUE) {
                            ht.set(dataObj.toString());
                        } else {
                            ht.set(t);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        ht.set(dataObj.toString());
                    }
                    dataArray[rows++] = ht.value();
                    continue;
                }
                double dbl = RMAIO.parseDouble(dataObj.toString(), -901.1);
                dataArray[rows++] = dbl;
                continue;
            }
            catch (Exception e) {
                System.out.println("ouch2. " + e);
            }
        }
        if (axisType == 1 || axisType == 2) {
            ht.setMinutes(dataArray[rows - 1]);
            if (ht.month() != 12 || ht.day() != 31 || ht.hour() != 24 || ht.minute() != 0) {
                ht.set("31Dec 2400");
                defaultValues[1] = true;
                dataArray[rows++] = ht.value();
            }
        }
        return rows;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(this.xdata[0], this.ydata[0], this.xdata[0], this.ydata[0]);
            for (int i = 1; i < this._rows; ++i) {
                if (RMAConst.isValidValue(this.xdata[i])) {
                    if (this.bounds.w > this.xdata[i]) {
                        this.bounds.w = this.xdata[i];
                    } else if (this.bounds.e < this.xdata[i]) {
                        this.bounds.e = this.xdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this.ydata[i]) || this.ydata[i] == -901.1) continue;
                if (this.bounds.s > this.ydata[i]) {
                    this.bounds.s = this.ydata[i];
                }
                if (!(this.bounds.n < this.ydata[i])) continue;
                this.bounds.n = this.ydata[i];
            }
        }
        return this.bounds;
    }

    private double getDefYValue(double pYlast, double pYfirst, double pXend, double pXlast, double pXfirst, double pXstart) {
        double a = pYfirst - pYlast;
        double b = pXend - pXlast;
        double c2 = pXfirst - pXstart;
        return pYlast + a * b / (b + c2);
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this._xRows == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this._xRows; ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt(this.xdata[0], this.ydata[0]);
            }
            x1 = this.xdata[z];
            y1 = this.ydata[z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleJTableSeasonalData.class, SimpleJTableSeasonalGlyph.class);
    }
}

