/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.SimpleJTableSeasonalData;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableSeasonalGlyph
extends G2dGlyph {
    SimpleJTableSeasonalData _obj;

    public SimpleJTableSeasonalGlyph(Viewport view, SimpleJTableSeasonalData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
    }

    @Override
    public void draw(Graphics g) {
        int i;
        int imax = 0;
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        for (int ioff = 0; ioff < this._obj._rows; ioff += i) {
            imax = 0;
            for (i = 0; i < this._obj._rows; ++i) {
                if (!RMAConst.isValidValue(this._obj.xdata[i + ioff]) || !RMAConst.isValidValue(this._obj.ydata[i + ioff])) {
                    ++i;
                    break;
                }
                xarray[i] = this._obj.xdata[i + ioff];
                yarray[i] = this._obj.ydata[i + ioff];
                ++imax;
            }
            this._line.setLineData(xarray, yarray, imax);
            this._line.drawLine(g, rect);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        LocalPt rpt;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (rpt = this._line.getNearestDataPt(pt)) != null) {
            double xval = this._scale.getAxis(0).l2w(rpt.x);
            double yval = this._scale.getAxis(1).l2w(rpt.y);
            WorldPt wp = new WorldPt(xval, yval);
            if ((wp = this._obj.getNearestDataPt(wp)) == null) {
                return null;
            }
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            Object date = hTime.date(4);
            date = ((String)date).substring(0, ((String)date).length() - 4) + " " + hTime.time();
            try {
                double yVal = Units.convertUnits(wp.n, this._obj.getXParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                return new String("[" + (String)date + " ," + RMAIO.setPrecision2(yVal, 2) + "]");
            }
            catch (DataSetException exp) {
                return new String("[" + (String)date + " ," + RMAIO.setPrecision2(wp.n, 2) + "]");
            }
        }
        return null;
    }
}

