/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleJTableStepGlyph;
import hec.heclib.util.HecTime;
import javax.swing.table.TableModel;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableStepData
extends G2dData
implements G2dObject {
    public static final double UNDEF_DBL = -901.1;
    public double[] xdata;
    public double[] ydata;
    public int _rows = 0;
    public int _startRow = 0;
    int _xAxisType = 0;
    int _yAxisType = 0;
    boolean _wrap = false;

    public SimpleJTableStepData() {
        this.name = "Simple Table Step Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xdata = new double[100];
        this.ydata = new double[100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[i] = Math.PI * (double)i / 20.0;
            this.ydata[i] = 5.0 * Math.sin(this.xdata[i]);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    public void setWrap(boolean b) {
        this._wrap = b;
    }

    public void setData(RmaJTable tbl, int[] xCol, int[] yCol) {
        if (tbl != null) {
            int xRows;
            this.xdata = new double[tbl.getRowCount()];
            this.ydata = new double[tbl.getRowCount()];
            int yRows = this.fillData(tbl, this.ydata, yCol, this._yAxisType, true);
            this._rows = yRows < (xRows = this.fillData(tbl, this.xdata, xCol, this._xAxisType, false)) ? yRows : xRows;
            TableModel tm = tbl.getModel();
            if (tm instanceof RmaTableModelInterface) {
                int paramId = ((RmaTableModelInterface)tm).getColumnParameter(xCol[0]);
                if (paramId != -1) {
                    super.setXParameterId(paramId);
                }
                if ((paramId = ((RmaTableModelInterface)tm).getColumnParameter(yCol[0])) != -1) {
                    super.setYParameterId(paramId);
                }
                this.setUnitSystem(((RmaTableModelInterface)tm).getUnitSystem());
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setData(RmaJTable tbl, int xCol, int yCol) {
        if (tbl != null) {
            TableModel tm;
            int npts;
            double year_minutes;
            int xRows;
            if (tbl.getModel() instanceof RmaTableModelInterface) {
                int paramId = ((RmaTableModelInterface)tbl.getModel()).getColumnParameter(yCol);
                this.setYParameterId(paramId);
                paramId = ((RmaTableModelInterface)tbl.getModel()).getColumnParameter(xCol);
                this.setXParameterId(paramId);
            }
            this.xdata = new double[tbl.getRowCount() * 2];
            this.ydata = new double[tbl.getRowCount() * 2];
            int yRows = this.fillData(tbl, this.ydata, yCol, this._yAxisType, false);
            int n = this._rows = yRows < (xRows = this.fillData(tbl, this.xdata, xCol, this._xAxisType, true)) ? yRows : xRows;
            if (this._xAxisType == 1 && this._rows > 0 && this.xdata[0] + (year_minutes = 525600.0) > this.xdata[(npts = this._rows++) - 1]) {
                double[] tmparray = new double[npts + 1];
                System.arraycopy(this.xdata, 0, tmparray, 0, npts);
                this.xdata = tmparray;
                tmparray = new double[npts + 2];
                System.arraycopy(this.ydata, 0, tmparray, 0, npts);
                this.ydata = tmparray;
                this.xdata[npts] = this.xdata[0] + year_minutes;
                this.ydata[npts] = this.ydata[npts - 1];
            }
            if ((tm = tbl.getModel()) instanceof RmaTableModelInterface) {
                int paramId = ((RmaTableModelInterface)tm).getColumnParameter(xCol);
                if (paramId != -1) {
                    super.setXParameterId(paramId);
                }
                if ((paramId = ((RmaTableModelInterface)tm).getColumnParameter(yCol)) != -1) {
                    super.setYParameterId(paramId);
                }
                this.setUnitSystem(((RmaTableModelInterface)tm).getUnitSystem());
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void clearData() {
        this.xdata = null;
        this.ydata = null;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setXDataElement(int xPos, double data) {
        if (xPos >= this.xdata.length) {
            return;
        }
        this.xdata[xPos] = data;
    }

    public void setYDataElement(int yPos, double data) {
        if (yPos >= this.ydata.length) {
            return;
        }
        this.ydata[yPos] = data;
    }

    public void setStartRow(int row) {
        this._startRow = row;
    }

    public int getStartRow() {
        return this._startRow;
    }

    protected int fillData(RmaJTable tbl, double[] dataArray, int col, int axisType, boolean isX) {
        int rows = 0;
        HecTime ht = null;
        if (axisType == 1) {
            ht = new HecTime();
        }
        for (int i = this._startRow; i < tbl.getRowCount(); ++i) {
            try {
                double dbl;
                Object dataObj = tbl.getCell(i, col);
                if (dataObj.toString().trim().equals("")) continue;
                if (axisType == 1) {
                    try {
                        int t = RMAIO.parseInt(dataObj.toString());
                        if (t == Integer.MIN_VALUE) {
                            ht.set(dataObj.toString());
                        } else {
                            ht.set(t);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        ht.set(dataObj.toString());
                    }
                    dbl = ht.value();
                    dataArray[rows++] = dbl;
                    if (!isX) continue;
                    if (rows > 1) {
                        dataArray[rows++] = dbl;
                        continue;
                    }
                    if (rows <= 1) continue;
                    dataArray[rows++] = dbl;
                    continue;
                }
                dbl = RMAIO.parseDouble(dataObj.toString(), -901.1);
                dataArray[rows++] = dbl;
                if (isX) {
                    dataArray[rows++] = dbl;
                    continue;
                }
                dataArray[rows++] = dbl;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rows;
    }

    int fillData(RmaJTable tbl, double[] dataArray, int[] col, int axisType, boolean isX) {
        Object dataObj = null;
        int rows = 0;
        HecTime ht = null;
        if (axisType == 1) {
            ht = new HecTime();
        }
        for (int i = this._startRow; i < tbl.getRowCount(); ++i) {
            try {
                double dbl;
                dataObj = tbl.getCell(i, col[0]);
                for (int colIdx = 1; colIdx < col.length; ++colIdx) {
                    dataObj = dataObj.toString() + " " + tbl.getCell(i, col[colIdx]).toString();
                }
                if (dataObj.toString().trim().equals("")) continue;
                if (axisType == 1) {
                    try {
                        int t = RMAIO.parseInt(dataObj.toString());
                        if (t == Integer.MIN_VALUE) {
                            ht.set(dataObj.toString());
                        } else {
                            ht.set(t);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        ht.set(dataObj.toString());
                    }
                    dbl = ht.value();
                    dataArray[rows++] = dbl;
                    if (isX) {
                        dataArray[rows++] = dbl;
                        continue;
                    }
                    if (rows <= 1) continue;
                    dataArray[rows++] = dbl;
                    continue;
                }
                dbl = RMAIO.parseDouble(dataObj.toString(), -901.1);
                dataArray[rows++] = dbl;
                if (isX) {
                    dataArray[rows++] = dbl;
                    continue;
                }
                if (rows <= 1) continue;
                dataArray[rows++] = dbl;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rows;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this._rows > this.xdata.length) {
            this._rows = this.xdata.length;
        }
        if (this._rows > this.ydata.length) {
            this._rows = this.ydata.length;
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(this.xdata[0], this.ydata[0], this.xdata[0], this.ydata[0]);
            for (int i = 1; i < this._rows; ++i) {
                if (RMAConst.isValidValue(this.xdata[i])) {
                    if (this.bounds.w > this.xdata[i]) {
                        this.bounds.w = this.xdata[i];
                    } else if (this.bounds.e < this.xdata[i]) {
                        this.bounds.e = this.xdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this.ydata[i]) || this.ydata[i] == -901.1) continue;
                if (this.bounds.s > this.ydata[i]) {
                    this.bounds.s = this.ydata[i];
                    continue;
                }
                if (!(this.bounds.n < this.ydata[i])) continue;
                this.bounds.n = this.ydata[i];
            }
        }
        return this.bounds;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleJTableStepData.class, SimpleJTableStepGlyph.class);
    }
}

