/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.SimpleJTableStepData;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableStepGlyph
extends G2dGlyph {
    SimpleJTableStepData _obj;

    public SimpleJTableStepGlyph(Viewport view, SimpleJTableStepData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
    }

    @Override
    public void draw(Graphics g) {
        Rectangle rect = this.getVisibleRect();
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        int imax = 0;
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        int i = 0;
        for (int j = 0; j < this._obj._rows; ++j) {
            double dx = this._obj.xdata[j];
            double dy = this._obj.ydata[j];
            if (dy == -901.1) {
                ++j;
                break;
            }
            if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                ++j;
                break;
            }
            xarray[i] = dx;
            yarray[i] = dy;
            ++imax;
            ++i;
        }
        this._line.clearLineData();
        if (imax > 0) {
            this._line.setLineData(xarray, yarray, imax);
        }
        this._line.drawLine(g, rect);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestDataPt(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            double xval = wp.e;
            HecTime hTime = new HecTime();
            hTime.setMinutes(xval);
            String yval = RMAIO.setPrecision2(wp.n, 2);
            return new String("[" + hTime.dateAndTime() + " ," + yval + "]");
        }
        return null;
    }
}

