/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLinePatternRenderer;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLineWidthRenderer;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.table.RmaColorRenderer;

public class SimpleLinePropertiesPanel
extends DefaultJPanel
implements ActionListener,
ComponentPanel {
    Object[] customColor = new Object[]{Color.white, "Custom"};
    JColorChooser _colorChooser;
    protected JPanel _samplePanel = null;
    CheckBoxPanel noneCustomPanel;
    JLabel colorLabel = new JLabel("Color:");
    JLabel styleLabel = new JLabel("Style:");
    protected JLabel weightLabel = new JLabel("Weight:");
    RmaJColorComboBox jColorCombo = new RmaJColorComboBox();
    RmaJComboBox jStyleCombo = new RmaJComboBox();
    protected RmaJComboBox jWeightCombo = new RmaJComboBox();

    public SimpleLinePropertiesPanel() {
        this("Draw Border");
    }

    public SimpleLinePropertiesPanel(String checkBoxLabel) {
        super(new GridBagLayout());
        this.buildControls(checkBoxLabel);
        this.addListeners();
    }

    protected void buildControls(String checkBoxLabel) {
        this.noneCustomPanel = new CheckBoxPanel(checkBoxLabel);
        this.add((Component)this.noneCustomPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.colorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 15, 0, 0), 0, 0));
        this.add((Component)this.styleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 15, 0, 0), 0, 0));
        this.add((Component)this.weightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.insets(5, 15, 5, 0), 0, 0));
        this.add((Component)this.jColorCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jStyleCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jWeightCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this.jColorCombo.setSelectedColor(Color.blue);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{new float[]{50.0f}, G2dLineProperties.DASH_STYLE_PATTERN, G2dLineProperties.DOT_STYLE_PATTERN, G2dLineProperties.DASHDOT_STYLE_PATTERN, G2dLineProperties.DASHDOTDOT_STYLE_PATTERN});
        this.jStyleCombo.setModel(comboModel);
        this.jStyleCombo.setRenderer(new G2dLinePatternRenderer(Color.blue));
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Float(1.0f), new Float(2.0f), new Float(3.0f), new Float(4.0f), new Float(5.0f), new Float(6.0f), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f)});
        this.jWeightCombo.setModel(comboModel);
        this.jWeightCombo.setRenderer(new G2dLineWidthRenderer(Color.blue));
    }

    protected void addListeners() {
        this.noneCustomPanel.addComponentPanel(this);
        this.jColorCombo.addActionListener(this);
        this.jWeightCombo.addActionListener(this);
        this.jStyleCombo.addActionListener(this);
        this.jColorCombo.setModifiable(true);
        this.jStyleCombo.setModifiable(true);
        this.jWeightCombo.setModifiable(true);
        this.setComponentsEnabled(this.noneCustomPanel.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.jColorCombo) {
            this.colorCombo_ActionPerfomred();
        } else if (obj == this.jWeightCombo) {
            this.weightCombo_ActionPerformed();
        } else if (obj == this.jStyleCombo) {
            this.styleCombo_ActionPerformed();
        }
    }

    private JColorChooser getColorChooser() {
        if (this._colorChooser == null) {
            this._colorChooser = new JColorChooser();
        }
        return this._colorChooser;
    }

    private void styleCombo_ActionPerformed() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    private void weightCombo_ActionPerformed() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    private void colorCombo_ActionPerfomred() {
        Object[] item = (Object[])this.jColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.customColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new customColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dLinePatternRenderer)this.jStyleCombo.getRenderer()).setColor((Color)item[0]);
        ((G2dLineWidthRenderer)this.jWeightCombo.getRenderer()).setColor((Color)item[0]);
        this.jStyleCombo.repaint();
        this.jWeightCombo.repaint();
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this.colorLabel.setEnabled(enabled);
        this.styleLabel.setEnabled(enabled);
        this.weightLabel.setEnabled(enabled);
        this.jColorCombo.setEnabled(enabled);
        this.jStyleCombo.setEnabled(enabled);
        this.jWeightCombo.setEnabled(enabled);
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.noneCustomPanel.setEnabled(enabled);
        if (!enabled) {
            this.setComponentsEnabled(enabled);
        } else {
            this.setComponentsEnabled(this.noneCustomPanel.isSelected());
        }
    }

    public Color getLineColor() {
        Object[] item = (Object[])this.jColorCombo.getSelectedItem();
        return (Color)item[0];
    }

    public void setLineColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this.jColorCombo.removeActionListener(this);
        boolean found = false;
        Object[] colorObj = null;
        DefaultComboBoxModel cm = (DefaultComboBoxModel)this.jColorCombo.getModel();
        for (int i = 0; i < this.jColorCombo.getItemCount(); ++i) {
            colorObj = (Object[])cm.getElementAt(i);
            if (!((Color)colorObj[0]).equals(c2)) continue;
            found = true;
            break;
        }
        if (!found) {
            colorObj[0] = c2;
        }
        this.jColorCombo.setSelectedItem(colorObj);
        ((G2dLinePatternRenderer)this.jStyleCombo.getRenderer()).setColor((Color)colorObj[0]);
        ((G2dLineWidthRenderer)this.jWeightCombo.getRenderer()).setColor((Color)colorObj[0]);
        this.jStyleCombo.repaint();
        this.jWeightCombo.repaint();
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
        this.jColorCombo.addActionListener(this);
    }

    public float getLineWidth() {
        Float f = (Float)this.jWeightCombo.getSelectedItem();
        return f.floatValue();
    }

    public void setLineWidth(float f) {
        Float fl = new Float(f);
        this.jWeightCombo.setSelectedItem(fl);
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    public void setLineStyle(float[] style) {
        float[] fArray;
        if (style == null) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = 50.0f;
        } else {
            fArray = style;
        }
        this.jStyleCombo.setSelectedItem(fArray);
    }

    public float[] getLineStyle() {
        float[] style = (float[])this.jStyleCombo.getSelectedItem();
        if (style.length == 1 && style[0] == 50.0f) {
            return null;
        }
        return style;
    }

    public void setSamplePanel(JPanel s) {
        this._samplePanel = s;
    }

    @Deprecated
    public void setCustomEnabled(boolean enabled) {
        this.noneCustomPanel.setSelected(enabled);
    }

    public void setSelected(boolean selected) {
        this.noneCustomPanel.setSelected(selected);
    }

    @Deprecated
    public boolean isCustomEnabled() {
        return this.noneCustomPanel.isSelected();
    }

    public boolean isSelected() {
        return this.noneCustomPanel.isSelected();
    }

    @Override
    public void fillPanel() {
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        return true;
    }

    public void clearPanel() {
        this.jStyleCombo.setSelectedIndex(0);
        this.jColorCombo.setSelectedIndex(0);
        this.jWeightCombo.setSelectedIndex(0);
        this.noneCustomPanel.setSelected(false);
    }

    public void setCheckBoxVisible(boolean visible) {
        this.noneCustomPanel.setVisible(visible);
    }

    public void setRendererColorNames(boolean b) {
        ((RmaColorRenderer)this.jColorCombo.getRenderer()).setRenderColorName(b);
    }

    class customColorOKListener
    implements ActionListener {
        customColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleLinePropertiesPanel.this.customColor[0] = SimpleLinePropertiesPanel.this.getColorChooser().getColor();
            SimpleLinePropertiesPanel.this.jColorCombo.repaint();
            SimpleLinePropertiesPanel.this.repaint();
        }
    }
}

