/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimplePairedValuesDataGlyph;
import hec.model.PairedValues;
import rma.util.RMAConst;

public class SimplePairedValuesData
extends G2dData
implements G2dObject {
    public double[] xdata;
    public double[] ydata;
    public double[] xdataOrg;
    public double[] ydataOrg;
    int _xAxisType = 0;
    int _yAxisType = 0;
    protected PairedValues _pv;
    protected String _interpolationType = "linear";
    boolean _plotXvsY = false;
    boolean _loaded = false;

    public SimplePairedValuesData() {
        this(true);
    }

    public SimplePairedValuesData(boolean createDefaults) {
        this.name = "Simple Table Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        if (createDefaults) {
            this.createDefaultData();
        }
    }

    protected void createDefaultData() {
        this.xdata = new double[100];
        this.ydata = new double[100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[i] = i;
            this.ydata[i] = 5.0 * Math.sin(Math.PI * (double)i / 20.0);
        }
    }

    @Override
    public String getXAxisName() {
        return this.xunits;
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    @Override
    public int getXAxisType() {
        return this._xAxisType;
    }

    @Override
    public int getYAxisType() {
        return this._yAxisType;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    public void setData(double[] xd, double[] yd) {
        if (xd == null || yd == null) {
            return;
        }
        this.xdata = xd;
        this.ydata = yd;
        this.bounds = null;
        if (!this.calcPlotArrays()) {
            System.out.println("ERROR <SimplePairedValuesData.setData(PairedValues)> : Error calculating new plot arrays");
            return;
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setData(PairedValues pv) {
        this._pv = pv;
        if (this._pv == null || this._pv.getXArray() == null || this._pv.getXArray().length < 1) {
            return;
        }
        this.xdata = this._pv.getXArray();
        this.ydata = this._pv.getYArray();
        this.setUnitSystem(this._pv.getUnitSystem());
        this.bounds = null;
        if (!this.calcPlotArrays()) {
            System.out.println("ERROR <SimplePairedValuesData.setData(PairedValues)> : Error calculating new plot arrays");
            return;
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void resetData() {
        this.xdata = null;
        this.ydata = null;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setInterpolationType(String interpType) {
        if (interpType.equalsIgnoreCase("linear") || interpType.equalsIgnoreCase("step") || interpType.equalsIgnoreCase("cubic")) {
            this._interpolationType = interpType;
        }
    }

    public void setPlotXvsY(boolean tf) {
        this._plotXvsY = tf;
    }

    public boolean calcPlotArrays() {
        if (this._pv == null) {
            return false;
        }
        if (this._plotXvsY) {
            this.xdata = this._pv.getYArray();
            this.ydata = this._pv.getXArray();
            this.setXParameterId(this._pv.getParametersIds()[1]);
            this.setYParameterId(this._pv.getParametersIds()[0]);
        } else {
            this.xdata = this._pv.getXArray();
            this.ydata = this._pv.getYArray();
            this.setXParameterId(this._pv.getParametersIds()[0]);
            this.setYParameterId(this._pv.getParametersIds()[1]);
        }
        this.xdataOrg = this.xdata;
        this.ydataOrg = this.ydata;
        if (this.xdata == null || this.xdata.length < 1 || this.ydata == null) {
            return false;
        }
        int npts = this.xdata.length;
        double[] pXarray = null;
        double[] pYarray = null;
        int numPts = 0;
        if (this._interpolationType.equalsIgnoreCase("linear")) {
            numPts = npts;
            pXarray = new double[numPts];
            pYarray = new double[numPts];
            System.arraycopy(this.xdata, 0, pXarray, 0, npts);
            System.arraycopy(this.ydata, 0, pYarray, 0, npts);
        } else if (this._interpolationType.equalsIgnoreCase("step")) {
            numPts = npts * 2 - 1;
            pXarray = new double[numPts];
            pYarray = new double[numPts];
            if (this._plotXvsY) {
                for (int i = 0; i < npts - 1; ++i) {
                    pXarray[i * 2] = this.xdata[i];
                    pYarray[i * 2] = this.ydata[i];
                    pXarray[i * 2 + 1] = this.xdata[i];
                    pYarray[i * 2 + 1] = this.ydata[i + 1];
                }
                pXarray[numPts - 1] = this.xdata[npts - 1];
                pYarray[numPts - 1] = this.ydata[npts - 1];
            } else {
                for (int i = 0; i < npts - 1; ++i) {
                    pXarray[i * 2] = this.xdata[i];
                    pYarray[i * 2] = this.ydata[i];
                    pXarray[i * 2 + 1] = this.xdata[i + 1];
                    pYarray[i * 2 + 1] = this.ydata[i];
                }
                pXarray[numPts - 1] = this.xdata[npts - 1];
                pYarray[numPts - 1] = this.ydata[npts - 1];
            }
        } else if (this._interpolationType.equalsIgnoreCase("cubic")) {
            numPts = 101;
            pXarray = new double[numPts];
            pYarray = new double[numPts];
            if (this._plotXvsY) {
                double dy = (this.ydata[npts - 1] - this.ydata[0]) / (double)(numPts - 1);
                for (int i = 0; i < numPts; ++i) {
                    double yval;
                    pYarray[i] = yval = this.ydata[0] + (double)i * dy;
                    pXarray[i] = this._pv.interpolateValueCubicSpline(yval);
                }
            } else {
                double dx = (this.xdata[npts - 1] - this.xdata[0]) / (double)(numPts - 1);
                for (int i = 0; i < numPts; ++i) {
                    double xval;
                    pXarray[i] = xval = this.xdata[0] + (double)i * dx;
                    pYarray[i] = this._pv.interpolateValueCubicSpline(xval);
                }
            }
        } else {
            return false;
        }
        this.xdata = pXarray;
        this.ydata = pYarray;
        return true;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null || this.xdata.length < 1 || this.ydata.length < 1) {
            return null;
        }
        if (this.bounds == null) {
            this.bounds = new WorldRect(this.xdata[0], this.ydata[0], this.xdata[0], this.ydata[0]);
            for (int i = 1; i < this.xdata.length; ++i) {
                if (RMAConst.isValidValue(this.xdata[i])) {
                    if (this.bounds.w > this.xdata[i]) {
                        this.bounds.w = this.xdata[i];
                    } else if (this.bounds.e < this.xdata[i]) {
                        this.bounds.e = this.xdata[i];
                    }
                }
                if (!RMAConst.isValidValue(this.ydata[i])) continue;
                if (this.bounds.s > this.ydata[i]) {
                    this.bounds.s = this.ydata[i];
                    continue;
                }
                if (!(this.bounds.n < this.ydata[i])) continue;
                this.bounds.n = this.ydata[i];
            }
        }
        return this.bounds;
    }

    static {
        G2dGlyphFactory.addMapping(SimplePairedValuesData.class, SimplePairedValuesDataGlyph.class);
    }
}

