/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.SimpleSeasonalDataGlyph;
import hec.io.TimeSeriesContainer;
import hec.model.Interpolate;
import hec.model.SeasonalRecord;
import rma.util.RMAConst;

public class SimpleSeasonalData
extends G2dData
implements G2dObject {
    public int[] tdata;
    public double[] ydata;
    public int[] tdataOrg;
    public double[] ydataOrg;
    public String xtype;
    public String ytype;
    protected SeasonalRecord _sr;
    protected String _interpolationType = "linear";
    protected int _nyears = 1;
    boolean _loaded = false;
    transient int _interpInterval = -2;
    boolean _successfullCalculation = true;

    public SimpleSeasonalData() {
        this.name = "Seasonal Data";
        this.xunits = "Minutes";
        this.yunits = "yunits";
    }

    @Override
    public String getXAxisName() {
        return "Minutes";
    }

    @Override
    public String getYAxisName() {
        return this.yunits;
    }

    @Override
    public int getXAxisType() {
        return 2;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    public void setData(int[] td, double[] yd) {
        if (td == null || yd == null) {
            return;
        }
        this.tdata = td;
        this.ydata = yd;
        this.bounds = null;
        this.calcPlotArrays();
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setData(SeasonalRecord sr) {
        this._sr = sr;
        if (this._sr == null || this._sr.getTimeArray() == null || this._sr.getTimeArray().length < 2) {
            return;
        }
        this.tdata = this._sr.getTimeArray();
        this.ydata = this._sr.getDataArray();
        this.setUnitSystem(this._sr.getUnitSystem());
        this.setGmtOffset(this._sr.getGmtOffset());
        this.setYParameterId(this._sr.getParameterId());
        this.calcPlotArrays();
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setInterpolationType(String interpType) {
        if (interpType.equalsIgnoreCase("linear") || interpType.equalsIgnoreCase("step") || interpType.equalsIgnoreCase("cubic")) {
            this._interpolationType = interpType;
        }
    }

    public void setPlotYears(int n) {
        this._nyears = n;
    }

    public boolean calcPlotArrays() {
        int istrt;
        int t0;
        if (this._sr == null) {
            return false;
        }
        int[] tarray = this._sr.getTimeArray();
        double[] darray = this._sr.getDataArray();
        if (tarray == null || tarray.length < 2 || darray == null) {
            this._successfullCalculation = false;
            return false;
        }
        int npts = tarray.length;
        int nyears = this._sr.getYears();
        if (nyears < 1) {
            this._successfullCalculation = false;
            return false;
        }
        if (this._nyears < 1) {
            this._nyears = 1;
        }
        if (this._nyears < nyears) {
            this._nyears = nyears;
        }
        int[] pTimeArray = null;
        double[] pDataArray = null;
        int numPts = 0;
        int endtime = tarray[0] + this._nyears * 365 * 1440;
        for (t0 = 0; t0 < endtime; t0 += nyears * 1440 * 365) {
            for (int i = 0; i < npts - 1 && tarray[i] + t0 <= endtime; ++i) {
                ++numPts;
            }
        }
        if (this._interpolationType.equalsIgnoreCase("linear")) {
            pTimeArray = new int[numPts];
            pDataArray = new double[numPts];
            istrt = 0;
            t0 = 0;
            while (t0 < endtime) {
                for (int i = 0; i < npts && istrt + i <= numPts - 1; ++i) {
                    pTimeArray[istrt + i] = tarray[i] + t0;
                    pDataArray[istrt + i] = darray[i];
                }
                t0 += nyears * 1440 * 365;
                istrt += npts - 1;
            }
        } else if (this._interpolationType.equalsIgnoreCase("step")) {
            numPts = numPts * 2 - 2;
            pTimeArray = new int[numPts];
            pDataArray = new double[numPts];
            istrt = 0;
            t0 = 0;
            while (t0 < endtime) {
                for (int i = 0; i < npts - 1 && istrt + 2 * i <= numPts - 2; ++i) {
                    pTimeArray[istrt + 2 * i] = tarray[i] + t0;
                    pDataArray[istrt + 2 * i] = darray[i];
                    pTimeArray[istrt + 2 * i + 1] = tarray[i + 1] + t0;
                    pDataArray[istrt + 2 * i + 1] = darray[i];
                }
                t0 += nyears * 1440 * 365;
                istrt += 2 * (npts - 1);
            }
        } else if (this._interpolationType.equalsIgnoreCase("cubic")) {
            numPts = 101;
            pTimeArray = new int[numPts];
            pDataArray = new double[numPts];
            for (int i = 0; i < numPts; ++i) {
                int tim;
                pTimeArray[i] = tim = tarray[0] + i * (endtime - tarray[0]) / (numPts - 1);
                pDataArray[i] = this._sr.interpolateValueCubicSpline(pTimeArray[i]);
            }
        } else {
            this._successfullCalculation = false;
            return false;
        }
        this.tdata = pTimeArray;
        this.ydata = pDataArray;
        this.tdataOrg = tarray;
        this.ydataOrg = darray;
        this._successfullCalculation = true;
        return true;
    }

    public boolean calculationsSuccessful() {
        return this._successfullCalculation;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.tdata == null || this.ydata == null) {
            return null;
        }
        if (this.tdata.length == 0 || this.ydata.length == 0) {
            return null;
        }
        if (this.bounds == null) {
            for (int k = 0; k < this.ydata.length; ++k) {
                if (!RMAConst.isValidValue(this.tdata[k]) || !RMAConst.isValidValue(this.ydata[k])) continue;
                this.bounds = new WorldRect(this.tdata[k], this.ydata[k], this.tdata[k], this.ydata[k]);
                break;
            }
            for (int i = k + 1; i < this.ydata.length; ++i) {
                double dx = this.tdata[i];
                double dy = this.ydata[i];
                if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) continue;
                if (this.bounds.w > dx) {
                    this.bounds.w = dx;
                } else if (this.bounds.e < dx) {
                    this.bounds.e = dx;
                }
                if (this.bounds.s > dy) {
                    this.bounds.s = dy;
                    continue;
                }
                if (!(this.bounds.n < dy)) continue;
                this.bounds.n = dy;
            }
        }
        return this.bounds;
    }

    public double interpolateValue(int interpTime) {
        double value = Double.NEGATIVE_INFINITY;
        if (this.tdata == null || this.tdata.length < 2) {
            return value;
        }
        int k = this.findInterval(interpTime);
        if (k < 0) {
            return value;
        }
        if (k >= this.tdata.length - 1) {
            return this.ydata[this.tdata.length - 1];
        }
        double fact = (double)(interpTime - this.tdata[k]) / (double)(this.tdata[k + 1] - this.tdata[k]);
        value = fact * (this.ydata[k + 1] - this.ydata[k]) + this.ydata[k];
        return value;
    }

    public void resetData() {
        this.tdata = null;
        this.ydata = null;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    private int findInterval(int iterpTime) {
        if (this.tdata.length < 2) {
            return -1;
        }
        int imax = this.tdata.length - 1;
        if (this._interpInterval == imax && iterpTime > this.tdata[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || iterpTime < this.tdata[this._interpInterval] || iterpTime > this.tdata[this._interpInterval + 1]) {
            this._interpInterval = Interpolate.bisearch(this.tdata, iterpTime, this.tdata.length);
        }
        if (this._interpInterval < 0 && this._interpInterval > imax) {
            System.out.println(" SeasonalRecord linear interpolation outside interval ");
            System.out.println(" rundate = " + iterpTime + "  interpInterval = " + this._interpInterval);
            return -1;
        }
        return this._interpInterval;
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this.tdata.length; ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt(this.tdata[0], this.ydata[0]);
            }
            x1 = this.tdata[z];
            y1 = this.ydata[z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    public TimeSeriesContainer getTimeSeriesContainer() {
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        timeSeriesContainer.numberValues = this.tdata.length;
        timeSeriesContainer.values = this.ydata;
        timeSeriesContainer.times = this.tdata;
        timeSeriesContainer.quality = null;
        timeSeriesContainer.startTime = this.tdata[0];
        timeSeriesContainer.endTime = this.tdata[timeSeriesContainer.numberValues - 1];
        timeSeriesContainer.precision = -2;
        timeSeriesContainer.interval = 0;
        timeSeriesContainer.units = this.yunits;
        timeSeriesContainer.type = this.ytype != null ? this.ytype : "";
        timeSeriesContainer.subLocation = "";
        timeSeriesContainer.parameter = "";
        timeSeriesContainer.subParameter = "";
        return timeSeriesContainer;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleSeasonalData.class, SimpleSeasonalDataGlyph.class);
    }
}

