/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.SimpleSeasonalData;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleSeasonalDataGlyph
extends G2dGlyph {
    SimpleSeasonalData _obj;

    public SimpleSeasonalDataGlyph(Viewport view, SimpleSeasonalData map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        G2dLineProperties prop = this._line.getProperties();
        prop._drawPoints = true;
        prop._symbolSize = 3.0f;
        this._line.setProperties(prop);
    }

    @Override
    public void draw(Graphics g) {
        boolean imax = false;
        boolean ioff = false;
        if (this._obj.tdata == null || this._obj.ydata == null) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        this._line.clearLineData();
        int number = 0;
        double[] dxarray = new double[10000];
        double[] dyarray = new double[10000];
        for (int i = 0; i < this._obj.tdata.length; ++i) {
            double dx = this._obj.tdata[i];
            double dy = this._obj.ydata[i];
            if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                if (number > 0) {
                    this._line.addLineData(dxarray, dyarray, number);
                    number = 0;
                }
            } else {
                dxarray[number] = dx;
                dyarray[number] = dy;
                ++number;
            }
            if (number < 10000) continue;
            this._line.addLineData(dxarray, dyarray, number);
            number = 0;
        }
        if (number > 0) {
            this._line.addLineData(dxarray, dyarray, number);
        }
        this._line.drawLine(g, rect);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt)) {
            LocalPt rpt = this._line.getNearestDataPt(pt);
            WorldPt wp = new WorldPt();
            double distance = this._line.getNearestDataPt(pt, wp);
            if (distance != Double.NEGATIVE_INFINITY) {
                int julianDay = (int)this._scale.getAxis(0).l2w(rpt.x) / 1440;
                String xvalstr = HecTime.juldat(julianDay, 4);
                xvalstr = xvalstr.substring(0, xvalstr.length() - 4);
                try {
                    double yVal = this._obj.getYParameterId() == -1 || !Units.isValidUnitsSystem(this._obj.getUnitSystem()) || !Units.isValidUnitsSystem(this._scale.getDisplayUnitSystem()) ? wp.n : Units.convertUnits(wp.n, this._obj.getYParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem());
                    return new String("[" + xvalstr + " ," + RMAIO.setPrecision2(yVal, 0) + "]");
                }
                catch (DataSetException exp) {
                    return new String("[" + xvalstr + " ," + RMAIO.setPrecision2(wp.n, 0) + "]");
                }
            }
        }
        return null;
    }
}

