/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisProp;
import hec.geometry.ScaleProperties;
import hec.geometry.SeasonalAxis;
import hec.geometry.SeasonalAxisIterator;
import hec.geometry.TSAxis;
import hec.geometry.TSAxisIterator;
import hec.geometry.WorldRect;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dAxisLabelPropertiesPanel;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.TsAxisScalePropertiesPanel;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.util.RMAIO;

public class TSAxisTics
extends AxisTics
implements Observer {
    TsAxisScalePropertiesPanel scalePanel = null;
    TSAxis _tsaxis = null;

    public TSAxisTics(G2dPanel p, TSAxis ax, Viewport vp, int align) {
        super(p, ax, vp, align);
        this._tsaxis = ax;
    }

    @Override
    protected void buildMenu(Container c2) {
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.addActionListener(new G2dComponent.EditPropertyListener());
        c2.add(jm);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Axis && arg == "COMPUTED_SCALE" && this.isVisible()) {
            this.paintGfx();
        }
        if (o instanceof Axis && arg == "NEW_ZOOM") {
            this.invalidate();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension defaultDim = super.getPreferredSizeLocal();
        Dimension dim = new Dimension(defaultDim);
        int sz = (int)((double)this._drawProp.getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
        int g2dResolution = this._parent.getDeviceResoultion();
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if ((double)sz < (double)this._drawProp.getMajorTicMinFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMinFontSize() * scl);
        }
        if ((double)sz > (double)this._drawProp.getMajorTicMaxFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMaxFontSize() * scl);
        }
        String name = this._drawProp.getMajorTicFontFamily();
        String fname = name + "-PLAIN-" + Integer.toString(sz);
        Font font = G2dFont.newFont(fname, 0, sz);
        int space = 2;
        FontMetrics metrics = this.getFontMetrics(font);
        if (this._alignment == 0 || this._alignment == 1) {
            double thscl = this._tsaxis.getThousScale();
            int sigfig = this._tsaxis.getSigFig();
            dim.width = (this._drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE);
            int istart = (int)Math.ceil(this._tsaxis.getMin() / this._tsaxis.getMajorTic());
            for (double val = (double)istart * this._tsaxis.getMajorTic(); val <= this._tsaxis.getMax(); val += this._tsaxis.getMajorTic()) {
                double aval = val / thscl;
                String txt = RMAIO.setPrecision(aval, sigfig);
                int iw = (this._drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE) + metrics.stringWidth(txt);
                if (dim.width >= iw) continue;
                dim.width = iw;
            }
            dim.height = 25;
        } else {
            dim.width = 25;
            int numlayers = 2;
            if (this._tsaxis.getNumTicLabelLevels() >= 0) {
                numlayers = this._tsaxis.getNumTicLabelLevels();
                int units = this._tsaxis.getTicUnits();
                if (units == 525600) {
                    numlayers = 1;
                }
            } else {
                this._tsaxis.setNumTicLabelLevels(numlayers);
            }
            dim.height = (this._drawProp.majorTicLength + space * 3) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE) + metrics.getHeight() * numlayers;
        }
        return dim;
    }

    @Override
    public void paintGfx(Graphics g) {
        int style;
        String name;
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.blue);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
        if (this._tsaxis == null) {
            return;
        }
        Font font = g.getFont();
        int sz = (int)((double)this._drawProp.getMajorTicFontSize() * this._parent.getFontScl() + 0.5);
        int g2dResolution = this._parent.getDeviceResoultion();
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if ((double)sz < (double)this._drawProp.getMajorTicMinFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMinFontSize() * scl);
        }
        if ((double)sz > (double)this._drawProp.getMajorTicMaxFontSize() * scl) {
            sz = (int)((double)this._drawProp.getMajorTicMaxFontSize() * scl);
        }
        if ((font = G2dFont.newFont(name = this._drawProp.getMajorTicFontFamily(), style = this._drawProp.getMajorTicFontStyle(), sz)) != null) {
            g.setFont(font);
        }
        if (this._alignment == 0) {
            this.drawTicsLeft(g);
        } else if (this._alignment == 1) {
            this.drawTicsRight(g);
        } else if (this._alignment == 2) {
            this.drawTicsTop(g);
        } else if (this._alignment == 3) {
            this.drawTicsBottom(g);
        }
        if (this.scalePanel != null && this.scalePanel.isVisible()) {
            this.scalePanel.refresh();
        }
    }

    @Override
    protected void drawTicsRight(Graphics g) {
    }

    @Override
    protected void drawTicsLeft(Graphics g) {
        double val;
        int istart;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.y - rc.y;
        double thscl = this._tsaxis.getThousScale();
        int sigfig = this._tsaxis.getSigFig();
        if (this._drawProp.drawMajorTics) {
            istart = (int)Math.ceil(this._tsaxis.getActMin() / this._tsaxis.getMajorTic());
            g.setColor(this._drawProp.axisTicColor);
            for (val = (double)istart * this._tsaxis.getMajorTic(); val <= this._tsaxis.getActMax(); val += this._tsaxis.getMajorTic()) {
                int ix = ioff + this._tsaxis.w2l(val);
                g.drawLine(rc.width, ix, rc.width - this._drawProp.majorTicLength, ix);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            istart = (int)Math.ceil(this._tsaxis.getActMin() / this._tsaxis.getMajorTic());
            g.setColor(this._drawProp.axisTicColor);
            HecTime time = new HecTime();
            int dely = Math.abs(this._tsaxis.w2l(this._tsaxis.getMajorTic()) - this._tsaxis.w2l(0.0));
            int iskip = metrics.getHeight() / dely + 1;
            for (val = (double)istart * this._tsaxis.getMajorTic(); val <= this._tsaxis.getActMax(); val += (double)iskip * this._tsaxis.getMajorTic()) {
                int iy = ioff + this._tsaxis.w2l(val);
                time.setMinutes(val);
                String txt = this.getTicString(val);
                int ix = rc.width - this._drawProp.majorTicLength - space - metrics.stringWidth(txt);
                Gfx2dDrawUtil.drawString(this, g, txt, ix, iy + metrics.getMaxAscent() / 2);
            }
        }
        if (this._drawProp.drawMinorTics) {
            istart = (int)Math.ceil(this._tsaxis.getActMin() / this._tsaxis.getMinorTic());
            g.setColor(this._drawProp.axisTicColor);
            for (val = (double)istart * this._tsaxis.getMajorTic(); val <= this._tsaxis.getActMax(); val += this._tsaxis.getMinorTic()) {
                int ix = ioff + this._tsaxis.w2l(val);
                g.drawLine(rc.width, ix, rc.width - this._drawProp.majorTicLength, ix);
            }
        }
    }

    @Override
    protected void drawTicsTop(Graphics g) {
        int ix;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.x - rc.x;
        int g2dResolution = this._parent.getDeviceResoultion();
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        boolean DRAW_AS_RANGE = false;
        TSAxisIterator iter = (TSAxisIterator)AxisFactory.createAxisIterator(ma, ma.getMajorTic());
        double interval = iter.getInterval();
        String xtxt = iter.getValueString();
        int xtxtwidth = metrics.stringWidth(xtxt);
        while (iter.next()) {
            String txt = iter.getValueString();
            int txtwidth = metrics.stringWidth(txt);
            if (txtwidth <= xtxtwidth) continue;
            xtxt = txt;
            xtxtwidth = txtwidth;
        }
        int delx = iter.getLocalInterval();
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        if (interval == (double)this._tsaxis.getTicUnits() && (double)iskip == 1.0 && this._tsaxis.getTicUnits() != 10080 && this._tsaxis.getTicUnits() != 60) {
            DRAW_AS_RANGE = true;
        }
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter.reset();
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff) continue;
                g.drawLine(ix, 0, ix, (DRAW_AS_RANGE ? 3 : 1) * this._drawProp.majorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE));
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            int units2;
            int units;
            g.setColor(this._drawProp.axisTicColor);
            iter.reset();
            iter.setInterval(this._tsaxis.getMajorTic() * (double)iskip);
            iter.setPeriodPosition(DRAW_AS_RANGE ? -3 : -1);
            while (iter.next()) {
                String txt = iter.getValueString();
                int ticLocation = ioff + iter.getLocalValue();
                int ix2 = ticLocation;
                if (ix2 < ioff) continue;
                int txtWidth = metrics.stringWidth(txt);
                if (DRAW_AS_RANGE && ix2 + txtWidth / 2 > ioff + vprc.width) {
                    int tempIx = ioff + vprc.width - txtWidth;
                    if (tempIx <= ticLocation) continue;
                    ix2 = tempIx;
                }
                int iy = (this._drawProp.majorTicLength + space) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE) + metrics.getMaxAscent();
                if (!iter.getGoAgain()) continue;
                Gfx2dDrawUtil.drawString(this, g, txt, ix2 - txtWidth / 2, iy);
            }
            if (!(this._tsaxis.getNumTicLabelLevels() < 2 || units == (units2 = (units = this._tsaxis.getTicUnits()) == 1 || units == 60 ? 1440 : (units == 1440 || units == 10080 ? 43920 : 525600)) || this._tsaxis instanceof SeasonalAxis && units2 == 525600)) {
                TSAxisIterator iter2 = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, (double)units2, units2, -1) : new TSAxisIterator(this._tsaxis, (double)units2, units2, -1);
                ArrayList<Integer> seperatorLocations = new ArrayList<Integer>();
                while (iter2.next()) {
                    int ix3 = ioff + iter2.getLocalValue();
                    if (ix3 < ioff) continue;
                    int iy = (this._drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE) + metrics.getHeight();
                    g.drawLine(ix3, iy, ix3, iy + metrics.getHeight());
                    seperatorLocations.add(ix3);
                }
                iter2 = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, (double)units2, units2, -3) : new TSAxisIterator(this._tsaxis, (double)units2, units2, -3);
                int endOfLastLabel = Integer.MIN_VALUE;
                int intv = iter2.getLocalInterval();
                while (iter2.next()) {
                    String txt = this._tsaxis instanceof SeasonalAxis ? iter2.getValueString() : iter2.getValueStringLong();
                    int width = metrics.stringWidth(txt);
                    int ix4 = ioff + iter2.getLocalValue();
                    if (ix4 < ioff) {
                        if (ioff - ix4 > intv / 2 - width) continue;
                        ix4 = ioff + width / 2;
                    }
                    boolean adjustedIx = false;
                    if (ix4 + width > ioff + vprc.width) {
                        if (ix4 - (ioff + vprc.width) > intv / 2 - width) continue;
                        ix4 = this.getWidth() - width - 1;
                        adjustedIx = true;
                    }
                    int iy = (this._drawProp.majorTicLength + space * 2) * (g2dResolution / G2dResolutionConst.PRINTER_SCALE) + metrics.getHeight() + metrics.getMaxAscent();
                    if (ix4 - width <= endOfLastLabel) continue;
                    int drawX = ix4;
                    if (!adjustedIx && (drawX = ix4 - width / 2) < 0) {
                        drawX = 0;
                    }
                    boolean intersects = false;
                    for (int i = 0; i < seperatorLocations.size(); ++i) {
                        int sepLocation = (Integer)seperatorLocations.get(i);
                        if (drawX >= sepLocation || sepLocation > drawX + width) continue;
                        intersects = true;
                        break;
                    }
                    if (intersects) continue;
                    Gfx2dDrawUtil.drawString(this, g, txt, drawX, iy);
                    endOfLastLabel = ix4 + width / 2;
                }
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter = (TSAxisIterator)AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff) continue;
                g.drawLine(ix, 0, ix, this._drawProp.minorTicLength * (g2dResolution / G2dResolutionConst.PRINTER_SCALE));
            }
        }
    }

    @Override
    protected void drawTicsBottom(Graphics g) {
        int ix;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.x - rc.x;
        Axis ma = this._viewport.getMasterAxis(0);
        if (ma == null) {
            ma = this._axis;
        }
        boolean DRAW_AS_RANGE = false;
        TSAxisIterator iter = (TSAxisIterator)AxisFactory.createAxisIterator(ma, ma.getMajorTic());
        double interval = iter.getInterval();
        String xtxt = iter.getValueString();
        int xtxtwidth = metrics.stringWidth(xtxt);
        while (iter.next()) {
            String txt = iter.getValueString();
            int txtwidth = metrics.stringWidth(txt);
            if (txtwidth <= xtxtwidth) continue;
            xtxt = txt;
            xtxtwidth = txtwidth;
        }
        int delx = iter.getLocalInterval();
        int iskip = (int)((double)metrics.stringWidth(xtxt) * 1.1 / (double)delx + 1.0);
        if (interval == (double)this._tsaxis.getTicUnits() && (double)iskip == 1.0 && this._tsaxis.getTicUnits() != 10080 && this._tsaxis.getTicUnits() != 60) {
            DRAW_AS_RANGE = true;
        }
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter = (TSAxisIterator)AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff) continue;
                g.drawLine(ix, rc.y, ix, rc.y - this._drawProp.majorTicLength * (DRAW_AS_RANGE ? 3 : 1));
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            int units2;
            int units;
            g.setColor(this._drawProp.axisTicColor);
            iter = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, this._tsaxis.getMajorTic()) : new TSAxisIterator(this._tsaxis, this._tsaxis.getMajorTic());
            iter.setInterval(this._tsaxis.getMajorTic() * (double)iskip);
            iter.setPeriodPosition(DRAW_AS_RANGE ? -3 : -1);
            while (iter.next()) {
                String txt = iter.getValueString();
                int ticLocation = ioff + iter.getLocalValue();
                int ix2 = ticLocation;
                if (ix2 < ioff) continue;
                int txtWidth = metrics.stringWidth(txt);
                if (DRAW_AS_RANGE && ix2 + txtWidth / 2 > ioff + vprc.width) {
                    int tempIx = ioff + vprc.width - txtWidth;
                    if (tempIx <= ticLocation) continue;
                    ix2 = tempIx;
                }
                int iy = this._drawProp.majorTicLength + space + (metrics.getHeight() - metrics.getMaxAscent());
                Gfx2dDrawUtil.drawString(this, g, txt, ix2 - txtWidth / 2, rc.y - iy);
            }
            if (!(this._tsaxis.getNumTicLabelLevels() < 2 || units == (units2 = (units = this._tsaxis.getTicUnits()) == 1 || units == 60 ? 1440 : (units == 1440 || units == 10080 ? 43920 : 525600)) || this._tsaxis instanceof SeasonalAxis && units2 == 525600)) {
                TSAxisIterator iter2 = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, (double)units2, units2, -1) : new TSAxisIterator(this._tsaxis, (double)units2, units2, -1);
                ArrayList<Integer> seperatorLocations = new ArrayList<Integer>();
                while (iter2.next()) {
                    int ix3 = ioff + iter2.getLocalValue();
                    if (ix3 < ioff) continue;
                    int iy = this._drawProp.majorTicLength + space * 2 + metrics.getHeight();
                    g.drawLine(ix3, 0, ix3, metrics.getHeight());
                    seperatorLocations.add(ix3);
                }
                iter2 = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, (double)units2, units2, -3) : new TSAxisIterator(this._tsaxis, (double)units2, units2, -3);
                int endOfLastLabel = Integer.MIN_VALUE;
                boolean allLevel2LabelsDrawn = true;
                int intv = iter2.getLocalInterval();
                while (iter2.next()) {
                    String txt = this._tsaxis instanceof SeasonalAxis ? iter2.getValueString() : iter2.getValueStringLong();
                    int txtWidth = metrics.stringWidth(txt);
                    int halfwidth = txtWidth / 2;
                    int ix4 = ioff + iter2.getLocalValue();
                    if (ix4 < ioff) {
                        if (ioff - ix4 > intv / 2 - txtWidth) continue;
                        ix4 = ioff + txtWidth / 2;
                    }
                    boolean adjustedIx = false;
                    if (ix4 + txtWidth > ioff + vprc.width) {
                        if (ix4 - (ioff + vprc.width) > intv / 2 - txtWidth) continue;
                        ix4 = this.getWidth() - txtWidth - 1;
                        adjustedIx = true;
                    }
                    int iy = this._drawProp.majorTicLength + space * 2 + metrics.getHeight() + metrics.getMaxAscent();
                    if (ix4 - txtWidth <= endOfLastLabel) continue;
                    int drawX = ix4;
                    if (!adjustedIx && (drawX = ix4 - txtWidth / 2) < 0) {
                        drawX = 0;
                    }
                    boolean intersects = false;
                    for (int i = 0; i < seperatorLocations.size(); ++i) {
                        int sepLocation = (Integer)seperatorLocations.get(i);
                        if (drawX >= sepLocation || sepLocation > drawX + txtWidth) continue;
                        intersects = true;
                        break;
                    }
                    if (intersects) continue;
                    Gfx2dDrawUtil.drawString(this, g, txt, drawX, metrics.getAscent());
                    endOfLastLabel = ix4 + txtWidth / 2;
                }
                iter2 = this._tsaxis instanceof SeasonalAxis ? new SeasonalAxisIterator(this._tsaxis, (double)units2, units2, -1) : new TSAxisIterator(this._tsaxis, (double)units2, units2, -1);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter = (TSAxisIterator)AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix < ioff) continue;
                g.drawLine(ix, rc.y, ix, rc.y - this._drawProp.minorTicLength);
            }
        }
    }

    String getTicString(double val) {
        int ticunit = this._tsaxis.getTicUnits();
        HecTime time = new HecTime();
        time.setMinutes(val);
        String txt = ticunit == 1 ? time.hourMinutes() : (ticunit == 60 ? time.hourMinutes() : (ticunit == 1440 ? time.date(4) : (ticunit == 10080 ? time.date(4) : (ticunit == 43920 ? time.date(4) : (ticunit == 525600 ? time.date(4) : "")))));
        return txt;
    }

    @Override
    public void editProperties() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        AxisLabel label = this._viewport.getAxisLabel(this.getName());
        this.axisPanel = new G2dAxisPropertiesPanel();
        this.labelPanel = new G2dAxisLabelPropertiesPanel();
        this.scalePanel = new TsAxisScalePropertiesPanel();
        this.axisPanel.setData(this._drawProp);
        AxisProp prop = this._axis.getAxisProp();
        prop.max = this._axis.getMax();
        prop.min = this._axis.getMin();
        prop.actmax = this._axis.getActMax();
        prop.actmin = this._axis.getActMin();
        prop.numTicLabelLayers = this._axis.getNumTicLabelLevels();
        prop.isDefaultLimits = false;
        this.scalePanel.setData(prop);
        if (label != null) {
            this.labelPanel.setData(label.getProperties());
            this.labelPanel.setLabelText(label.getText());
        }
        this.axisPanel.setName("Tics");
        G2dPropertiesDlg dlg = null;
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Axis Properties", new DefaultJPanel[]{this.scalePanel, this.labelPanel, this.axisPanel});
        if (dlg == null) {
            return;
        }
        dlg.setTitle(this._viewport.getName() + " - Axis " + this._axis.getName() + " Properties");
        dlg.addOKListener(new PropertiesOKListener());
        if (label == null) {
            dlg.setTabEnabled(1, false);
        }
        this.setCursor(oldCursor);
        dlg.setVisible(true);
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj instanceof G2dPropertiesDlg) {
                ScaleProperties prop = TSAxisTics.this.scalePanel.getData();
                double max = prop.getMaxScaleValue();
                double min = prop.getMinScaleValue();
                double vmin = 0.0;
                double vmax = 0.0;
                if (prop.isAutomaticMax() || prop.isAutomaticMin()) {
                    WorldRect b = TSAxisTics.this.getMaxBounds();
                    if (prop.isAutomaticMin()) {
                        double d = min = TSAxisTics.this._alignment == 1 || TSAxisTics.this._alignment == 0 ? b.s : b.w;
                    }
                    if (prop.isAutomaticMax()) {
                        max = TSAxisTics.this._alignment == 1 || TSAxisTics.this._alignment == 0 ? b.n : b.e;
                    }
                }
                vmax = prop.isAutomaticViewMax() ? max : prop.getActualMaxScaleValue();
                vmin = prop.isAutomaticViewMin() ? min : prop.getActualMinScaleValue();
                prop.setMaxScaleValue(max);
                prop.setMinScaleValue(min);
                prop.setActualMaxScaleValue(vmax);
                prop.setActualMinScaleValue(vmin);
                AxisProp aprop = new AxisProp((AxisProp)prop);
                aprop.isReversed = TSAxisTics.this._alignment == 1 || TSAxisTics.this._alignment == 0 ? !prop.isReversed() : prop.isReversed();
                TSAxisTics.this._axis.setAxisProp(aprop);
                TSAxisTics.this._axis.setWorldExtents(min, max);
                if (!prop.isAutomaticViewMin() || !prop.isAutomaticViewMax()) {
                    TSAxisTics.this._axis.zoomIn(vmin, vmax);
                }
                TSAxisTics.this._parent.invalidate();
                TSAxisTics.this._parent.doLayout();
                TSAxisTics.this._parent.paintGfx();
                TSAxisTics.this.repaint();
                if (TSAxisTics.this._alignment == 1 || TSAxisTics.this._alignment == 0) {
                    prop.setReversed(!aprop.isReversed());
                }
                TSAxisTics.this.scalePanel.refresh();
            }
        }
    }
}

