/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.TimeSeriesGlyph;
import hec.heclib.util.HecTime;
import hec.heclib.util.Unit;
import hec.io.TimeSeriesContainer;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import rma.util.RMAConst;

public class TimeSeriesDataSetBase
extends G2dData
implements G2dObject {
    public TimeSeriesContainer _timeSeries = null;
    public long[] times;
    public double[] ydata;
    public int numberValues;
    public int startIdx;
    public int endIdx;
    public String xtype;
    public String ytype;
    boolean _loaded = false;
    boolean _visible = true;
    boolean _endOfPeriodData = true;

    public TimeSeriesDataSetBase(TimeSeriesContainer timeSeriesContainer) {
        this.setData(timeSeriesContainer);
    }

    public void setEndOfPeriodData(boolean b) {
        this._endOfPeriodData = b;
        this.setChanged();
        this.notifyObservers("update data");
    }

    public boolean isEndOfPeriodData() {
        return this._endOfPeriodData;
    }

    public TimeSeriesContainer getData() {
        return this._timeSeries;
    }

    public void setData(TimeSeriesContainer timeSeriesContainer) {
        if (timeSeriesContainer == null) {
            return;
        }
        this._timeSeries = timeSeriesContainer;
        int length = this._timeSeries.times != null ? this._timeSeries.times.length : 0;
        this.times = new long[length];
        this.ydata = new double[length];
        if (length > 0) {
            for (int i = 0; i < this.times.length; ++i) {
                long tsTimeValue = this._timeSeries.times[i];
                this.times[i] = tsTimeValue * ((long)this._timeSeries.timeGranularitySeconds / 60L) + (long)this._timeSeries.julianBaseDate * 24L * 60L;
            }
        }
        this.ydata = this._timeSeries.values;
        this.numberValues = this._timeSeries.numberValues;
        this.name = this._timeSeries.getShortName();
        this.xunits = "min";
        this.xtype = "time";
        this.yunits = this._timeSeries.units;
        if (this.yunits == null) {
            this.yunits = "";
        }
        this.ytype = "ytype";
        this.bounds = null;
        if (this.yunits.equalsIgnoreCase("FEET")) {
            this.yunits = "ft";
        }
        if (Units.getUnitsForAlias(this.yunits) != null) {
            this.yunits = Units.getUnitsForAlias(this.yunits);
        }
        if (this._timeSeries.timeZoneID != null && !this._timeSeries.timeZoneID.equals("")) {
            super.setGmtOffset(this._timeSeries.timeZoneRawOffset / 3600000);
        }
        try {
            Parameter param = new Parameter(this._timeSeries.parameter);
            int paramId = param.getParameterId();
            if (paramId != -1) {
                this.setYParameterId(paramId);
            }
        }
        catch (DataSetIllegalArgumentException param) {
            // empty catch block
        }
        String units = Units.getUnitsForAlias(this._timeSeries.units);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem("English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem("SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        this.setChanged();
        this.notifyObservers("reset data");
    }

    @Override
    public double[] getXValues() {
        double[] values = new double[this.times.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.times[i];
        }
        return values;
    }

    @Override
    public double[] getYValues(int curveNum) {
        return this.ydata;
    }

    public int size() {
        return this._timeSeries != null ? this._timeSeries.numberValues : 0;
    }

    @Override
    public String getXAxisName() {
        return "Minutes";
    }

    @Override
    public String getYAxisName() {
        if (this.getUnitSystem() == 0 || this.getYParameterId() == -1) {
            if ((this.yunits == null || this.yunits.length() < 1 || this.yunits.equalsIgnoreCase("undef")) && this._timeSeries != null) {
                return this._timeSeries.parameter;
            }
            return this.yunits;
        }
        Object parameterdString = Parameter.getParamString(this.getYParameterId());
        if (TimeSeriesDataSetBase.useDisplayUnits()) {
            parameterdString = (String)parameterdString + " (%S) ";
        } else {
            String units = null;
            if (this._timeSeries != null && this._timeSeries.units != null) {
                units = Units.getUnitsForAlias(this._timeSeries.units);
                if (units == null) {
                    units = this._timeSeries.units;
                }
            } else {
                units = "";
            }
            parameterdString = (String)parameterdString + " (" + units + ")";
        }
        return parameterdString;
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    public void setVisible(boolean tf) {
        this._visible = tf;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void load() {
        if (this._loaded) {
            return;
        }
        this._loaded = true;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this._timeSeries == null) {
            return null;
        }
        if (this.bounds == null) {
            for (int k = 0; k < this.numberValues; ++k) {
                double d2;
                double d1;
                if (!RMAConst.isValidValue(this.times[k])) continue;
                if (this.hasDefaultMaxYValue()) {
                    d1 = this.getDefaultMaxYValue();
                } else {
                    if (!RMAConst.isValidValue(this.ydata[k])) continue;
                    d1 = this.ydata[k];
                }
                if (this.hasDefaultMinYValue()) {
                    d2 = this.getDefaultMinYValue();
                } else {
                    if (!RMAConst.isValidValue(this.ydata[k])) continue;
                    d2 = this.ydata[k];
                }
                this.bounds = new WorldRect(this.times[k], d1, this.times[k], d2);
                break;
            }
            if (this.numberValues == 0) {
                this.bounds = new WorldRect(this._timeSeries.startTime, 0.0, this._timeSeries.endTime, 10.0);
            } else {
                if (this.bounds == null) {
                    this.bounds = new WorldRect(this._timeSeries.startTime, 0.0, this._timeSeries.endTime, 10.0);
                }
                this.bounds.w = this.times[0];
                this.bounds.e = this.times[this.times.length - 1];
                if (this._timeSeries.type != null && this._timeSeries.type.length() > 0 && !this._timeSeries.type.toUpperCase().startsWith("INST")) {
                    HecTime time0 = new HecTime(1);
                    time0.setMinutes(this.times[0]);
                    time0.increment(-1, (int)this.getInterval());
                    this.bounds.w = time0.value();
                }
                for (int i = k + 1; i < this.numberValues; ++i) {
                    double dy = this.ydata[i];
                    if (!RMAConst.isValidValue(dy)) continue;
                    if (this.bounds.s > dy) {
                        this.bounds.s = dy;
                        continue;
                    }
                    if (!(this.bounds.n < dy)) continue;
                    this.bounds.n = dy;
                }
            }
        }
        return this.bounds;
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this.times == null || this.times.length == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this.times.length; ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt(this.times[0], this.ydata[0]);
            }
            x1 = this.times[z];
            y1 = this.ydata[z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeSeriesDataSetBase)) {
            return false;
        }
        TimeSeriesDataSetBase baseObj = (TimeSeriesDataSetBase)obj;
        boolean baseObjNameEquals = baseObj.getName().equalsIgnoreCase(this.getName());
        boolean timeSeriesFileNameEquals = false;
        if (baseObj._timeSeries == this._timeSeries) {
            timeSeriesFileNameEquals = true;
        } else if (baseObj._timeSeries != null && this._timeSeries != null) {
            timeSeriesFileNameEquals = Objects.equals(baseObj._timeSeries.getFullName(), this._timeSeries.getFullName()) && Objects.equals(baseObj._timeSeries.fileName, this._timeSeries.fileName);
        }
        return timeSeriesFileNameEquals && baseObjNameEquals;
    }

    public double getInterval() {
        return this.times.length > 1 ? (double)(this.times[1] - this.times[0]) : (this._timeSeries != null ? (double)this._timeSeries.interval : 0.0);
    }

    @Override
    public Optional<ZoneId> getDataZoneId() {
        return Optional.ofNullable(this._timeSeries != null ? this._timeSeries.getTimeZoneID() : null).map(TimeZone::getTimeZone).map(TimeZone::toZoneId);
    }

    static {
        G2dGlyphFactory.addMapping(TimeSeriesDataSetBase.class, TimeSeriesGlyph.class);
    }
}

