/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.Symbol;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeSeriesDataSetBase;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Observable;
import rma.util.RMAIO;

public class TimeSeriesGlyph
extends G2dGlyph {
    TimeSeriesDataSetBase _obj;

    public TimeSeriesGlyph(Viewport view, TimeSeriesDataSet map, Scale scl) {
        this(view, (TimeSeriesDataSetBase)map, scl);
    }

    public TimeSeriesGlyph(Viewport view, TimeSeriesDataSetBase map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        this._lineArray[0] = this._line = this.createG2dLine();
        this._line.setScale(scl);
        this._line.setName(map.getName());
        this._line.setGlyph(this);
        this._line.clearLineData();
        ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(this._obj.times, this._obj.ydata, this._obj._timeSeries.quality);
        if (map._timeSeries.type.toUpperCase().startsWith("PER")) {
            ((G2dTimeSeriesLine)this._line).setLineStepStyle("step");
        }
    }

    @Override
    protected G2dLine createG2dLine() {
        return new G2dTimeSeriesLine();
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        if (this._obj == null || !this._obj.isVisible()) {
            return false;
        }
        return super.objectPopupMenu(pt, modifiers);
    }

    @Override
    public void draw(Graphics g) {
        if (this._obj == null || !this._obj.isVisible()) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        String periodStepStyle = this._obj.isEndOfPeriodData() ? "EOP" : "BOP";
        this._line.setPeriodStepStyle(periodStepStyle);
        this._line.setStepInterval(this._obj.getInterval());
        this._line.drawLine(g, rect);
    }

    public void drawLegendPict(Graphics g, Dimension dim) {
        G2dLineProperties prop = this._line.getProperties();
        Stroke oldStroke = null;
        if (prop.drawLine()) {
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(new BasicStroke(prop.getLineWidth(), prop._endStyle, 0, 10.0f, prop.getLinePattern(), 0.0f));
            }
            Color oldColor = g.getColor();
            g.setColor(prop.getLineColor());
            g.drawLine(1, dim.height / 2, dim.width - 2, dim.height / 2);
            if (g instanceof Graphics2D && oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
            g.setColor(oldColor);
        }
        if (prop.drawPoints()) {
            int resolution = ((G2dPanel)this._viewport.getParent()).getDeviceResoultion();
            Symbol.draw2(g, dim.width / 2, dim.height / 2, prop.getSymbolType(), prop.getPointLineColor(), prop.getPointFillColor(), 4.0f, resolution);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        if (this._obj == null || !this._obj.isVisible()) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestLocation(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            this._scale.convertDataTime(hTime);
            String xvalstr = hTime.dateAndTime();
            try {
                double yVal = this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0 ? Units.convertUnits(wp.n, this._obj.getYParameterId(), this._obj.getUnitSystem(), this._scale.getDisplayUnitSystem()) : wp.n;
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2(yVal, 2) + "]</html>";
            }
            catch (DataSetException exp) {
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2(wp.n, 2) + "]</html>";
            }
        }
        return null;
    }

    public WorldPt findPoint(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        if (this._obj == null || !this._obj.isVisible()) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestLocation(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            return wp;
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("reset data".equals(arg)) {
            ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(this._obj.times, this._obj.ydata, this._obj._timeSeries.quality);
        }
        super.update(o, arg);
    }
}

