/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Scale;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerLine;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.TimeWindowPlotData;
import hec.gfx2d.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class TimeWindowPlotGlyph
extends G2dGlyph {
    TimeWindowPlotData m_obj;
    G2dMarkerLine m_markerLine;

    public TimeWindowPlotGlyph(Viewport view, TimeWindowPlotData map, Scale scl) {
        super(view, map, scl);
        this.m_obj = map;
        G2dMarkerProperties prop = new G2dMarkerProperties();
        prop.drawLine = true;
        prop.markerValue = this.m_obj.getTimeWindow().getStartTime().value();
        prop.drawOnAxis = 0;
        prop.lineColor = Color.black;
        prop.markerLabel = this.m_obj.name != null ? this.m_obj.name : "";
        prop.drawLabel = false;
        prop.lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
        this.m_markerLine = new G2dMarkerLine(prop, scl);
        this.m_markerLine.setViewport(this.getViewport());
    }

    @Override
    public void draw(Graphics g) {
        double max = this._scale.getAxis(0).getActMax();
        double min = this._scale.getAxis(0).getActMin();
        int value = this.m_obj.getTimeWindow().getStartTime().value();
        this.m_markerLine.drawLine(g, this.getVisibleRect());
    }

    @Override
    public WorldRect getBounds() {
        return null;
    }

    @Override
    public void drawLegendPict(Graphics g, int lineIndex, Dimension dim) {
        Stroke oldStroke = null;
        Color oldColor = g.getColor();
        g.setColor(this.m_markerLine.getProperties().lineColor);
        oldStroke = ((Graphics2D)g).getStroke();
        G2dLineProperties prop2 = new G2dLineProperties();
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, G2dLineProperties.DASH_STYLE_PATTERN, 0.0f));
        g.drawLine(1, dim.height / 2, dim.width - 2, dim.height / 2);
        g.setColor(oldColor);
        ((Graphics2D)g).setStroke(oldStroke);
    }

    @Override
    public String getName() {
        String name = this.m_obj.getName();
        return name != null ? name : "";
    }
}

