/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.TitleDrawProp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TitlePanel
extends G2dComponent {
    String _text;
    TitleDrawProp _drawProp = new TitleDrawProp();

    public TitlePanel(G2dPanel p, String txt) {
        this._parent = p;
        this._text = txt;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension dim = new Dimension();
        Graphics g = this.getGraphics();
        if (g == null || this._text == null || this._text.length() == 0) {
            dim.width = 25;
            dim.height = 25;
            return dim;
        }
        Font font = g.getFont();
        int sz = (int)((double)this._drawProp._fontSize * this._parent.getFontScl() + 0.5);
        if (sz < 9) {
            sz = 8;
        }
        if (sz > 16) {
            sz = 16;
        }
        String fname = font.getName();
        String fn = fname + "-PLAIN-" + Integer.toString(sz);
        font = G2dFont.newFont(fname, 0, sz);
        if (font != null) {
            g.setFont(font);
        }
        String name = this._text;
        FontMetrics metrics = g.getFontMetrics();
        int w = metrics.stringWidth(name);
        int h = metrics.getHeight();
        int space = 2;
        dim.width = w + 2 * space;
        dim.height = h + 2 * space;
        return dim;
    }

    @Override
    public void paintGfx(Graphics g) {
        if (this._text == null || this._text.length() == 0) {
            return;
        }
        Dimension dim = this.getSize();
        Font font = g.getFont();
        int sz = (int)((double)this._drawProp._fontSize * this._parent.getFontScl() + 0.5);
        if (sz < 9) {
            sz = 8;
        }
        if (sz > 18) {
            sz = 18;
        }
        String fname = font.getName();
        String fn = fname + "-PLAIN-" + Integer.toString(sz);
        font = G2dFont.newFont(fname, 0, sz);
        if (font != null) {
            g.setFont(font);
        }
        FontMetrics metrics = g.getFontMetrics();
        String name = this._text;
        int w = metrics.stringWidth(name);
        int h = metrics.getHeight();
        int space = 2;
        g.setColor(Color.black);
        while (w > dim.width && --sz >= 6 && (font = G2dFont.newFont(fname, 0, sz)) != null) {
            g.setFont(font);
            metrics = g.getFontMetrics();
            w = metrics.stringWidth(name);
            h = metrics.getHeight();
        }
        Gfx2dDrawUtil.drawString(this, g, name, space + dim.width / 2 - w / 2, h - space);
    }
}

