/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.ScaleProperties;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.ScalePropertiesPanel;
import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarExField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class TsAxisScalePropertiesPanel
extends DefaultJPanel
implements ScalePropertiesPanel {
    private static String TS_MIN = new String("Min");
    private static String TS_HOUR = new String("Hour");
    private static String TS_DAY = new String("Day");
    private static String TS_MONTH = new String("Month");
    private static String TS_YEAR = new String("Year");
    String[] UNITS = new String[]{TS_MIN, TS_HOUR, TS_DAY, TS_MONTH, TS_YEAR};
    Integer[] LEVELS = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
    protected ScaleProperties _properties = null;
    RmaJCalendarField jMaxDateTxt = new RmaJCalendarExField(true);
    RmaJCalendarField jMinDateTxt = new RmaJCalendarExField(true);
    RmaJCalendarField jViewMaxDateTxt = new RmaJCalendarExField(true);
    RmaJCalendarField jViewMinDateTxt = new RmaJCalendarExField(true);
    RmaJ24HourTimeField jMaxTimeTxt = new RmaJ24HourTimeField();
    RmaJ24HourTimeField jMinTimeTxt = new RmaJ24HourTimeField();
    RmaJ24HourTimeField jViewMaxTimeTxt = new RmaJ24HourTimeField();
    RmaJ24HourTimeField jViewMinTimeTxt = new RmaJ24HourTimeField();
    RmaJCheckBox jAutoMaxAxisValueCheck = new RmaJCheckBox("Maximum:");
    RmaJCheckBox jAutoMinAxisValueCheck = new RmaJCheckBox("Minimum:");
    RmaJCheckBox jAutoMaxViewCheck = new RmaJCheckBox("View Maximum:");
    RmaJCheckBox jAutoMinViewCheck = new RmaJCheckBox("View Minimum:");
    RmaJCheckBox jViewRangeCheck = new RmaJCheckBox("View Range:");
    RmaJCheckBox jReverseAxisCheck = new RmaJCheckBox("Reverse Axis");
    JLabel jAutoLabel = new JLabel("Auto");
    JLabel jDateLabel = new JLabel("Date");
    JLabel jTimeLabel = new JLabel("Time");
    JLabel jNumLevelsLabel = new JLabel("Number of Label Levels");
    JComboBox jNumLevelsCombo = new JComboBox<Integer>(this.LEVELS);
    RmaJComboBox jUnitComboBox = new RmaJComboBox<String>(this.UNITS);
    RmaJDecimalField jViewRangeTxt = new RmaJDecimalField();

    public TsAxisScalePropertiesPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Scale");
        JPanel backPanel = new JPanel(new GridBagLayout());
        this.add((Component)backPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(0, 0, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jDateLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jTimeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.jAutoMaxAxisValueCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinAxisValueCheck, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMaxViewCheck, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinViewCheck, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jViewRangeCheck, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jMaxDateTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jMaxTimeTxt, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 0, 5), 10, 0));
        backPanel.add((Component)this.jMinDateTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jMinTimeTxt, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 0, 5), 10, 0));
        backPanel.add((Component)this.jViewMaxDateTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jViewMaxTimeTxt, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 0, 5), 10, 0));
        backPanel.add((Component)this.jViewMinDateTxt, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jViewMinTimeTxt, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 0, 5), 10, 0));
        backPanel.add((Component)this.jViewRangeTxt, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jUnitComboBox, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.jNumLevelsLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jNumLevelsCombo, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jReverseAxisCheck, new GridBagConstraints(0, 7, 3, 1, 0.0, 1.0, 18, 0, RmaInsets.insets(0, 5, 5, 0), 0, 0));
        this.jAutoMaxAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMaxViewCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinViewCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jViewRangeCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jReverseAxisCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMaxAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxAxisValueCheck, this.jMaxDateTxt));
        this.jAutoMaxAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxAxisValueCheck, this.jMaxTimeTxt));
        this.jAutoMinAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinAxisValueCheck, this.jMinDateTxt));
        this.jAutoMinAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinAxisValueCheck, this.jMinTimeTxt));
        this.jAutoMaxViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxViewCheck, this.jViewMaxDateTxt));
        this.jAutoMaxViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxViewCheck, this.jViewMaxTimeTxt));
        this.jAutoMinViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinViewCheck, this.jViewMinDateTxt));
        this.jAutoMinViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinViewCheck, this.jViewMinTimeTxt));
        this.jViewRangeCheck.addItemListener(this);
    }

    @Override
    public void setData(ScaleProperties prop) {
        this._properties = prop;
    }

    @Override
    public ScaleProperties getData() {
        return this._properties;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        HecTime maxTime = new HecTime();
        HecTime minTime = new HecTime();
        HecTime minVTime = new HecTime();
        HecTime maxVTime = new HecTime();
        maxTime.setMinutes(this._properties.getMaxScaleValue());
        minTime.setMinutes(this._properties.getMinScaleValue());
        maxVTime.setMinutes(this._properties.getActualMaxScaleValue());
        minVTime.setMinutes(this._properties.getActualMinScaleValue());
        this.jAutoMaxAxisValueCheck.setSelected(this._properties.isAutomaticMax());
        this.jMaxDateTxt.setText(maxTime.date(4));
        this.jMaxTimeTxt.setText(RMAIO.removeChar(maxTime.time(), ':'));
        this.jAutoMinAxisValueCheck.setSelected(this._properties.isAutomaticMin());
        this.jMinDateTxt.setText(minTime.date(4));
        this.jMinTimeTxt.setText(RMAIO.removeChar(minTime.time(), ':'));
        this.jAutoMinViewCheck.setSelected(this._properties.isAutomaticViewMin());
        this.jViewMinDateTxt.setText(minVTime.date(4));
        this.jViewMinTimeTxt.setText(RMAIO.removeChar(minVTime.time(), ':'));
        this.jAutoMaxViewCheck.setSelected(this._properties.isAutomaticViewMax());
        this.jViewMaxDateTxt.setText(maxVTime.date(4));
        this.jViewMaxTimeTxt.setText(RMAIO.removeChar(maxVTime.time(), ':'));
        this.jNumLevelsCombo.setSelectedItem(new Integer(this._properties.getNumTicLevels()));
        this.jReverseAxisCheck.setSelected(this._properties.isReversed());
        this.jMaxDateTxt.setEditable(!this._properties.isAutomaticMax());
        this.jMaxTimeTxt.setEditable(!this._properties.isAutomaticMax());
        this.jMinDateTxt.setEditable(!this._properties.isAutomaticMin());
        this.jMinTimeTxt.setEditable(!this._properties.isAutomaticMin());
        this.jViewMaxDateTxt.setEditable(!this._properties.isAutomaticViewMax());
        this.jViewMaxTimeTxt.setEditable(!this._properties.isAutomaticViewMax());
        this.jViewMinDateTxt.setEditable(!this._properties.isAutomaticViewMin());
        this.jViewMinTimeTxt.setEditable(!this._properties.isAutomaticViewMin());
    }

    public boolean validatePanel() {
        String errorMsg = "";
        boolean error = false;
        RmaJTextField field = null;
        if (!this.jMaxDateTxt.isValid(false) || this.jMaxDateTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid maximum axis date";
            error = true;
            field = this.jMaxDateTxt;
        }
        if (!this.jMaxTimeTxt.isValid(false) || this.jMaxTimeTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid maximum axis time";
            error = true;
            field = this.jMaxTimeTxt;
        }
        if (!this.jMinDateTxt.isValid(false) || this.jMinDateTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid minimum axis date";
            error = true;
            field = this.jMinDateTxt;
        }
        if (!this.jMinTimeTxt.isValid(false) || this.jMinTimeTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid minimum axis time";
            error = true;
            field = this.jMinTimeTxt;
        }
        if (!this.jViewMaxDateTxt.isValid(false) || this.jViewMaxDateTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid view maximum date";
            error = true;
            field = this.jViewMaxDateTxt;
        }
        if (!this.jViewMaxTimeTxt.isValid(false) || this.jViewMaxTimeTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid view maximum time";
            error = true;
            field = this.jViewMaxTimeTxt;
        }
        if (!this.jViewMinDateTxt.isValid(false) || this.jViewMinDateTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid view minimum date";
            error = true;
            field = this.jViewMinDateTxt;
        }
        if (!this.jViewMinTimeTxt.isValid(false) || this.jViewMinTimeTxt.getText().length() < 1) {
            errorMsg = "Please enter a valid view minimum time";
            error = true;
            field = this.jViewMinTimeTxt;
        }
        if (error) {
            RMAIO.postError(this, errorMsg);
            field.requestFocus();
        }
        return !error;
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        if (!this.validatePanel()) {
            return false;
        }
        HecTime time = new HecTime(this.jMaxDateTxt.getText(), this.jMaxTimeTxt.getText());
        this._properties.setAutomaticMax(this.jAutoMaxAxisValueCheck.isSelected());
        this._properties.setMaxScaleValue(time.getMinutes());
        time = new HecTime(this.jMinDateTxt.getText(), this.jMinTimeTxt.getText());
        this._properties.setAutomaticMin(this.jAutoMinAxisValueCheck.isSelected());
        this._properties.setMinScaleValue(time.getMinutes());
        time = new HecTime(this.jViewMinDateTxt.getText(), this.jViewMinTimeTxt.getText());
        this._properties.setAutomaticViewMin(this.jAutoMinViewCheck.isSelected());
        this._properties.setActualMinScaleValue(time.getMinutes());
        if (!this.jViewRangeCheck.isSelected()) {
            time = new HecTime(this.jViewMaxDateTxt.getText(), this.jViewMaxTimeTxt.getText());
            this._properties.setAutomaticViewMax(this.jAutoMaxViewCheck.isSelected());
            this._properties.setActualMaxScaleValue(time.getMinutes());
        } else {
            int range = this.getRangeInMinutes();
            time.add(range);
            this._properties.setAutomaticViewMax(false);
            this._properties.setActualMaxScaleValue(time.getMinutes());
        }
        Integer i = (Integer)this.jNumLevelsCombo.getSelectedItem();
        this._properties.setNumTicLevels(i);
        this._properties.setReversed(this.jReverseAxisCheck.isSelected());
        return true;
    }

    private int getRangeInMinutes() {
        String rUnits = (String)this.jUnitComboBox.getSelectedItem();
        int multiplier = (int)this.jViewRangeTxt.getValue();
        int numMinutes = 1;
        if (rUnits.equals(TS_MIN)) {
            numMinutes = 1;
        } else if (rUnits.equals(TS_HOUR)) {
            numMinutes = 60;
        } else if (rUnits.equals(TS_DAY)) {
            numMinutes = 1440;
        } else if (rUnits.equals(TS_MONTH)) {
            numMinutes = 43200;
        } else if (rUnits.equals(TS_YEAR)) {
            numMinutes = 524160;
        }
        return numMinutes * multiplier;
    }

    @Override
    public void refresh() {
        this.fillPanel();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj == this.jViewRangeCheck) {
            this.ViewRangeCheck_ItemStateChanged();
        }
    }

    private void ViewRangeCheck_ItemStateChanged() {
        boolean selected = this.jViewRangeCheck.isSelected();
        this.jAutoMaxViewCheck.setEnabled(!selected);
        this.jViewMaxDateTxt.setEditable(!selected && !this.jAutoMaxViewCheck.isSelected());
        this.jViewMaxTimeTxt.setEditable(!selected && !this.jAutoMaxViewCheck.isSelected());
    }

    public static void main(String[] args) {
        G2dPropertiesDlg dialog = new G2dPropertiesDlg((Frame)null, false, "", new DefaultJPanel[]{new G2dAxisPropertiesPanel(), new TsAxisScalePropertiesPanel()});
        dialog.setVisible(true);
    }

    private class TextFieldStateUpdater
    implements ActionListener {
        RmaJTextField m_textField = null;
        RmaJCheckBox m_checkBox = null;

        public TextFieldStateUpdater(RmaJCheckBox checkBox, RmaJTextField tf) {
            this.m_checkBox = checkBox;
            this.m_textField = tf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_textField.setEditable(!this.m_checkBox.isSelected());
        }
    }
}

