/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisIterator;
import hec.geometry.DataObjectRating;
import hec.geometry.LocalPt;
import hec.geometry.LocalRect;
import hec.geometry.LogAxis;
import hec.geometry.RatingFunction;
import hec.geometry.Scale;
import hec.geometry.TSAxis;
import hec.geometry.WorldRect;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisMarkerDescription;
import hec.gfx2d.AxisTics;
import hec.gfx2d.DataType;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.DefaultVeiwportLegendRenderer;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dEditComponent;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerLine;
import hec.gfx2d.G2dMarkerPoint;
import hec.gfx2d.G2dMarkerPointProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPointerComponent;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.G2dViewportEditComponent;
import hec.gfx2d.G2dViewportPropertiesPanel;
import hec.gfx2d.G2dZoomComponent;
import hec.gfx2d.GfxTextObject;
import hec.gfx2d.NewMarkerPointDialog;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.PanelDropTarget;
import hec.gfx2d.PopupPlotMouseAdapter;
import hec.gfx2d.ViewportDragTarget;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.ViewportDropTarget;
import hec.gfx2d.ViewportLayer;
import hec.gfx2d.ViewportLegendRenderer;
import hec.gfx2d.dss.G2dDssTimeSeriesCollection;
import hec.gfx2d.stats.StatisticsGlyph;
import hec.heclib.util.HecTime;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.LineBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaColor;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJMenuLabel;
import rma.util.FillPatternFactory;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class Viewport
extends G2dComponent
implements Observer,
G2dZoomComponent,
G2dPointerComponent,
G2dEditComponent,
G2dViewportEditComponent {
    ViewportLegendRenderer mLegendRegenderer = new DefaultVeiwportLegendRenderer();
    Vector _scaleVector = new Vector();
    ViewportDrawProp _drawProp = new ViewportDrawProp();
    Vector _glyphVector = new Vector();
    Color _gridX = new Color(174, 174, 174);
    Color _gridY = new Color(174, 174, 174);
    Color _backgroundDiabled = Color.lightGray;
    Hashtable _masterAxisTable = new Hashtable();
    LocalPt m_mouseClickPt = null;
    private MouseInputHandler _mouseListener;
    protected Vector<G2dMarkerLine> _markerLines = new Vector();
    protected Vector<G2dMarkerPoint> _markerPoints = new Vector();
    protected BufferedImage _doubleBuffer = null;
    protected boolean _dirtyBuffer = true;
    protected boolean _isDoubleBuffer = true;
    List _graphLabelList = new ArrayList();
    boolean _dragEnabled = false;
    JLayeredPane _layerdPane;
    private boolean _showingStats = true;
    List<ViewportLayer<?>> viewportLayers = new ArrayList();
    PanelDropTarget dropTarget = null;
    PlotLayerPanel _plotLayer;

    public Viewport() {
        this.init();
    }

    public Viewport(G2dPanel p) {
        super(p);
        this.init();
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        if (this.dropTarget != null) {
            this.dropTarget.setTransferHandler(newHandler);
        }
    }

    public void addComponentLayer(final ViewportLayer<?> layer) {
        Objects.requireNonNull(layer, "Undefined ViewportLayer in Viewport.addCompoonentLayer");
        Objects.requireNonNull(layer.getComponent(), "Undefined Component defined in ViewportLayer");
        Dimension size = ((Component)layer.getComponent()).getSize();
        if (size == null || size.width == 0 && size.height == 0) {
            layer.computePreferredSize();
        }
        Object component = layer.getComponent();
        ViewportLayerMouseAdapter adapter = new ViewportLayerMouseAdapter((G2dComponent)layer.getComponent());
        ((G2dComponent)component).setG2dPanel(this._parent);
        ((Component)component).addMouseMotionListener(adapter);
        ((Component)component).addMouseListener(adapter);
        this.viewportLayers.add(layer);
        layer.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("Location")) {
                this.computeLayerBounds(this._layerdPane.getBounds(), layer);
            }
        });
        ((Component)component).addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Viewport.this.computeLayerBounds(Viewport.this._layerdPane.getBounds(), layer);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Viewport.this.computeLayerBounds(Viewport.this._layerdPane.getBounds(), layer);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Viewport.this.setDirty();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Viewport.this.setDirty();
            }
        });
        ((Container)component).addPropertyChangeListener(e -> this.setDirty());
        this._layerdPane.add((Component)component, this._layerdPane.getComponents().length + 1, 0);
    }

    @Override
    protected void paintComponent(Graphics arg0) {
        super.paintComponent(arg0);
    }

    private void init() {
        super.setBackground(null);
        this.setToolTipText("");
        this.addMouseListeners();
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
            this.dropTarget = new ViewportDropTarget(this);
            DragSource dragSource = DragSource.getDefaultDragSource();
            ViewportDragTarget vdt = new ViewportDragTarget();
            dragSource.createDefaultDragGestureRecognizer(this, 3, vdt);
            dragSource.addDragSourceMotionListener(vdt);
        }
        this._plotLayer = new PlotLayerPanel();
        this._layerdPane = new JLayeredPane(){

            @Override
            public void setBounds(Rectangle r) {
                super.setBounds(r);
                Viewport.this._plotLayer.setBounds(new Rectangle(r.width, r.height));
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                Viewport.this._plotLayer.setBounds(0, 0, width, height);
            }
        };
        this._layerdPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Viewport.this.computeAllLayerBounds(Viewport.this._layerdPane.getBounds());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Viewport.this.computeAllLayerBounds(Viewport.this._layerdPane.getBounds());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Viewport.this.setDirty();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Viewport.this.setDirty();
            }
        });
        this._layerdPane.setBorder(new LineBorder(Color.GREEN));
        this._layerdPane.add((Component)this._plotLayer, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this._layerdPane, "Center");
    }

    private void computeAllLayerBounds(Rectangle plotBounds) {
        this._plotLayer.setBounds(0, 0, plotBounds.width, plotBounds.height);
        for (ViewportLayer<?> viewportLayer : this.viewportLayers) {
            this.computeLayerBounds(plotBounds, viewportLayer);
        }
        if (this.viewportLayers.isEmpty()) {
            this.setDirty();
        }
    }

    private void computeLayerBounds(Rectangle plotBounds, ViewportLayer<?> viewportLayer) {
        Rectangle computeBounds = viewportLayer.getLocation().computeBounds(this._layerdPane, (Component)viewportLayer.getComponent());
        ((Component)viewportLayer.getComponent()).setBounds(computeBounds);
        this.setDirty();
    }

    protected void addMouseListeners() {
        this.addMouseListener(new PopupPlotMouseAdapter(this, this._parent));
    }

    public void setDragEnabled(boolean b) {
        this._dragEnabled = b;
    }

    public boolean isDragEnabled() {
        return this._dragEnabled;
    }

    @Override
    public void setDoubleBuffered(boolean b) {
        this._isDoubleBuffer = b;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this._isDoubleBuffer;
    }

    public void setDirty() {
        this._dirtyBuffer = true;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = "Plot Area";
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            Object dtip = "<html><b>Current Glyphs are:</b>";
            for (int i = 0; i < this._glyphVector.size(); ++i) {
                G2dGlyph glyph = (G2dGlyph)this._glyphVector.get(i);
                dtip = (String)dtip + "<br><b>Glyph:</b>" + glyph.getName() + " <b>Class:</b>" + glyph.getClass().getName();
            }
            dtip = (String)dtip + "</html>";
            return dtip;
        }
        for (int i = 0; i < this._glyphVector.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)this._glyphVector.elementAt(i);
            tip = glyph.getToolTipText(e);
            if (tip == null) continue;
            return tip;
        }
        return tip;
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Viewport Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Viewport");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        this.createMenu(this._popupMenu);
    }

    protected void createMenu(Container c2) {
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.addActionListener(new G2dComponent.EditPropertyListener());
        c2.add(jm);
        c2.add(jm);
        JMenu menu = new JMenu("Add Marker");
        c2.add(menu);
        jm = new JMenuItem("On X-Axis");
        menu.add(jm);
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.addXAxisMarker();
            }
        });
        jm = new JMenuItem("On Y-Axis");
        menu.add(jm);
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.addYAxisMarker();
            }
        });
        jm = new JMenuItem("Add Marker Point");
        c2.add(jm);
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.addAxisMarkerPoint();
            }
        });
    }

    public void addXAxisMarker() {
        this.addAxisMarker("Input an X-Axis Value.", 0);
    }

    public void addAxisMarker(String txt, int axis) {
        String value;
        G2dMarkerProperties prop = new G2dMarkerProperties();
        prop.setDrawOnAxis(axis);
        if (this._scaleVector == null || this._scaleVector.size() <= 0) {
            return;
        }
        Scale scale = (Scale)this._scaleVector.elementAt(0);
        int loc = 0;
        if (this.m_mouseClickPt != null) {
            loc = axis == 0 ? this.m_mouseClickPt.x : this.m_mouseClickPt.y;
        }
        String initialValue = null;
        if (scale.getAxis(axis) instanceof TSAxis) {
            RmaJCalendarField c2 = new RmaJCalendarField();
            if (this.m_mouseClickPt != null) {
                int val = axis == 0 ? (int)scale.x2e(loc) : (int)scale.y2n(loc);
                HecTime time = new HecTime();
                time.set(val);
                initialValue = time.dateAndTime(104);
            }
        } else {
            RmaJDecimalField c3 = new RmaJDecimalField();
            if (this.m_mouseClickPt != null) {
                double val = axis == 0 ? scale.x2e(loc) : scale.y2n(loc);
                initialValue = RMAIO.setPrecision2(val, 3);
            }
        }
        if ((value = JOptionPane.showInputDialog(this, txt, initialValue)) == null) {
            return;
        }
        System.out.println((Object)value);
        if (scale.getAxis(axis) instanceof TSAxis) {
            prop.markerValue = new HecTime(value.toString()).value();
        } else {
            try {
                prop.markerValue = new Double(value.toString());
            }
            catch (NumberFormatException e) {
                String msg = "An invalid value \"" + value + "\" was entered.\nPlease try again.";
                RMAIO.postError(this, msg);
                this.addAxisMarker(txt, axis);
                return;
            }
        }
        this.addAxisMarker(prop);
        this.m_mouseClickPt = null;
    }

    public void addAxisMarkerPoint() {
        RmaJDecimalField field;
        String s;
        RmaJCalendarField dtField;
        JPanel panel;
        RmaJ24HourTimeField timeField;
        G2dMarkerPointProperties prop = new G2dMarkerPointProperties();
        if (this._scaleVector == null || this._scaleVector.size() <= 0) {
            return;
        }
        Scale scale = (Scale)this._scaleVector.elementAt(0);
        int[] loc = new int[2];
        if (this.m_mouseClickPt != null) {
            loc[0] = this.m_mouseClickPt.x;
            loc[1] = this.m_mouseClickPt.y;
        }
        JComponent[] c2 = new JComponent[2];
        String[] initialValues = new String[2];
        for (int axis = 0; axis < 2; ++axis) {
            if (scale.getAxis(axis) instanceof TSAxis) {
                JPanel panel2 = new JPanel(new GridBagLayout());
                RmaJCalendarField dtField2 = new RmaJCalendarField();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS0000;
                panel2.add((Component)dtField2, gbc);
                timeField = new RmaJ24HourTimeField();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS0000;
                panel2.add((Component)timeField, gbc);
                c2[axis] = panel2;
                if (this.m_mouseClickPt == null) continue;
                int val = axis == 0 ? (int)scale.x2e(loc[axis]) : (int)scale.y2n(loc[axis]);
                HecTime time = new HecTime();
                time.set(val);
                initialValues[axis] = time.dateAndTime(104);
                timeField.setText(RMAIO.removeChar(time.time(), ':'));
                dtField2.setText(time.date(104));
                continue;
            }
            RmaJDecimalField field2 = new RmaJDecimalField();
            c2[axis] = field2;
            if (this.m_mouseClickPt == null) continue;
            double val = axis == 0 ? scale.x2e(loc[axis]) : scale.y2n(loc[axis]);
            initialValues[axis] = RMAIO.setPrecision2(val, 3);
            field2.setValue(val);
        }
        Window w = SwingUtilities.windowForComponent(this._parent);
        NewMarkerPointDialog dlg = new NewMarkerPointDialog((Frame)w, c2[0], c2[1]);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        if (c2[0] instanceof JPanel) {
            panel = (JPanel)c2[0];
            dtField = (RmaJCalendarField)panel.getComponent(0);
            timeField = (RmaJ24HourTimeField)panel.getComponent(1);
            s = dtField.getText() + " " + timeField.getText();
            prop.markerXValue = new HecTime(s).value();
        } else {
            field = (RmaJDecimalField)c2[0];
            prop.markerXValue = field.getValue();
        }
        if (c2[1] instanceof JPanel) {
            panel = (JPanel)c2[1];
            dtField = (RmaJCalendarField)panel.getComponent(0);
            timeField = (RmaJ24HourTimeField)panel.getComponent(1);
            s = dtField.getText() + " " + timeField.getText();
            prop.markerYValue = new HecTime(s).value();
        } else {
            field = (RmaJDecimalField)c2[1];
            prop.markerYValue = field.getValue();
        }
        this.addAxisPointMarker(prop);
        this.m_mouseClickPt = null;
    }

    public void addXAxisMarker(String value) {
        this.addAxisMarker(0, value);
    }

    public void addYAxisMarker(String value) {
        this.addAxisMarker(1, value);
    }

    public void addAxisMarker(AxisMarkerDescription description) {
        G2dMarkerProperties props = null;
        if (description.axis.equalsIgnoreCase("Y2")) {
            Axis y2 = this.getAxis("Y2");
            if (y2 == null) {
                System.out.println("Specified viewport does not have a Y2 axis!");
                return;
            }
            Axis y1 = this.getAxis("Y1");
            AxisMarkerDescription desc2 = new AxisMarkerDescription(description);
            double y1Min = y1.getScaleMin();
            double y1Max = y1.getScaleMax();
            double y2Min = y2.getScaleMin();
            double y2Max = y2.getScaleMax();
            double value = Double.parseDouble(desc2.value);
            value = y1Min + (y1Max - y1Min) * (value - y2Min) / (y2Max - y2Min);
            desc2.value = Double.toString(value);
            desc2.axis = "Y";
            props = desc2.toMarkerProperties();
        } else {
            props = description.toMarkerProperties();
        }
        this.addAxisMarker(props);
    }

    public void removeGlyph(G2dGlyph g) {
        Vector glyphs = this.getGlyphVector();
        if (glyphs.remove(g)) {
            // empty if block
        }
    }

    private void addAxisMarker(int axis, String value) {
        G2dMarkerProperties prop = new G2dMarkerProperties();
        prop.setDrawOnAxis(axis);
        if (this._scaleVector == null || this._scaleVector.size() <= 0) {
            return;
        }
        Scale scale = (Scale)this._scaleVector.elementAt(0);
        prop.markerValue = scale.getAxis(axis) instanceof TSAxis ? (double)new HecTime(value).value() : new Double(value);
        this.addAxisMarker(prop);
    }

    public void addXAxisMarker(double value) {
        G2dMarkerProperties prop = new G2dMarkerProperties();
        if (this._scaleVector == null || this._scaleVector.size() <= 0) {
            return;
        }
        Scale scale = (Scale)this._scaleVector.elementAt(0);
        prop.markerValue = scale.getAxis(0) instanceof TSAxis ? value : value;
        this.addAxisMarker(prop);
    }

    public void addYAxisMarker() {
        this.addAxisMarker("Input a Y-Axis Value.", 1);
    }

    public void addAxisMarker(G2dMarkerProperties prop) {
        Scale scl = (Scale)this._scaleVector.elementAt(0);
        G2dMarkerLine ml = new G2dMarkerLine(prop, scl);
        ml.setViewport(this);
        this._markerLines.add(ml);
        Axis a = scl.getAxis(prop.drawOnAxis);
        if (a.getActMin() > prop.markerValue || a.getActMax() < prop.markerValue) {
            this.resetAllDataLimits();
        }
        this.setDirty();
        this.repaint();
    }

    public void addAxisPointMarker(G2dMarkerPointProperties prop) {
        Scale scl = (Scale)this._scaleVector.elementAt(0);
        G2dMarkerPoint ml = new G2dMarkerPoint(prop, scl);
        ml.setViewport(this);
        this._markerPoints.add(ml);
        this.setDirty();
        this.repaint();
    }

    public void setAxisMarkers(List markers) {
        this._markerLines = new Vector();
        if (markers != null) {
            this._markerLines.addAll(markers);
        }
    }

    public List getAxisMarkers() {
        return this._markerLines;
    }

    public void resetDataLimits(Scale scl) {
        this.resetDataLimits(scl, true);
    }

    public void resetDataLimits(Scale scl, boolean invalidateExtents) {
        if (invalidateExtents) {
            scl.invalidateRegionExtents();
        }
        Hashtable<Scale, WorldRect> scaleBoundsMap = new Hashtable<Scale, WorldRect>();
        WorldRect bounds = null;
        Enumeration e = this._glyphVector.elements();
        while (e.hasMoreElements()) {
            WorldRect tempBounds;
            G2dGlyph g = (G2dGlyph)e.nextElement();
            if (g.getScale().getAxis(0) != scl.getAxis(0) && g.getScale().getAxis(1) != g.getScale().getAxis(1) || (tempBounds = g.getBounds()) == null) continue;
            bounds = (WorldRect)scaleBoundsMap.get(scl);
            if (bounds == null) {
                bounds = new WorldRect();
                scaleBoundsMap.put(scl, bounds);
            }
            bounds.grow(tempBounds);
        }
        for (int i = 0; bounds != null && i < this._markerLines.size(); ++i) {
            G2dMarkerLine ml = this._markerLines.elementAt(i);
            if (ml._properties.drawOnAxis == 0) {
                if (!RMAConst.isValidValue(bounds.e) || bounds.e < ml.getMarkerValue()) {
                    bounds.e = ml.getMarkerValue();
                }
                if (RMAConst.isValidValue(bounds.w) && !(bounds.w > ml.getMarkerValue())) continue;
                bounds.w = ml.getMarkerValue();
                continue;
            }
            if (!RMAConst.isValidValue(bounds.n) || bounds.n < ml.getMarkerValue()) {
                bounds.n = ml._properties.getMarkerValue();
            }
            if (RMAConst.isValidValue(bounds.s) && !(bounds.s > ml.getMarkerValue())) continue;
            bounds.s = ml.getMarkerValue();
        }
        Enumeration keys = scaleBoundsMap.keys();
        while (keys.hasMoreElements()) {
            Scale s = (Scale)keys.nextElement();
            bounds = (WorldRect)scaleBoundsMap.get(s);
            this.growScaleToGlyphExtents(s, bounds);
        }
        this._dirtyBuffer = true;
        this._parent.invalidate();
        this._parent.doLayout();
    }

    public void resetAllDataLimits() {
        this.resetAllDataLimits(true);
    }

    public void resetAllDataLimits(boolean growRegionExtents) {
        int i;
        Hashtable<Scale, WorldRect> scaleBoundsMap = new Hashtable<Scale, WorldRect>();
        WorldRect bounds = null;
        for (i = 0; i < this._glyphVector.size(); ++i) {
            G2dGlyph g = (G2dGlyph)this._glyphVector.elementAt(i);
            Scale scl = g.getScale();
            if (scl == null) continue;
            WorldRect tempBounds = null;
            try {
                tempBounds = g.getBounds();
            }
            catch (Exception e) {
                System.out.println("resetAllDataLimits:exception getting bounds on " + g + " Exception " + e);
            }
            if (tempBounds == null) continue;
            bounds = (WorldRect)scaleBoundsMap.get(scl);
            if (bounds == null) {
                bounds = new WorldRect();
                scaleBoundsMap.put(scl, bounds);
            }
            bounds.grow(tempBounds);
        }
        for (i = 0; bounds != null && i < this._markerLines.size(); ++i) {
            G2dMarkerLine ml = this._markerLines.elementAt(i);
            if (ml._properties.drawOnAxis == 0) {
                if (!RMAConst.isValidValue(bounds.e) || bounds.e < ml.getMarkerValue()) {
                    bounds.e = ml.getMarkerValue();
                }
                if (RMAConst.isValidValue(bounds.w) && !(bounds.w > ml.getMarkerValue())) continue;
                bounds.w = ml.getMarkerValue();
                continue;
            }
            if (!RMAConst.isValidValue(bounds.n) || bounds.n < ml.getMarkerValue()) {
                bounds.n = ml._properties.getMarkerValue();
            }
            if (RMAConst.isValidValue(bounds.s) && !(bounds.s > ml.getMarkerValue())) continue;
            bounds.s = ml.getMarkerValue();
        }
        Enumeration keys = scaleBoundsMap.keys();
        while (keys.hasMoreElements()) {
            Scale scl = (Scale)keys.nextElement();
            bounds = (WorldRect)scaleBoundsMap.get(scl);
            if (growRegionExtents) {
                this.growScaleToGlyphExtents(scl, bounds);
                continue;
            }
            Axis xaxis = scl.getAxis(0);
            Axis yaxis = scl.getAxis(1);
            if (!RMAConst.isValidValue(bounds.w)) {
                bounds.w = xaxis.getActMin();
            }
            if (!RMAConst.isValidValue(bounds.e)) {
                bounds.e = xaxis.getActMax();
            }
            if (!RMAConst.isValidValue(bounds.s)) {
                bounds.s = yaxis.getActMin();
            }
            if (!RMAConst.isValidValue(bounds.n)) {
                bounds.n = yaxis.getActMax();
            }
            scl.setRegionExtents(bounds);
        }
        this.updateRatingAxisValues();
        this._dirtyBuffer = true;
        this._parent.invalidate();
        this._parent.doLayout();
    }

    public void clearPlot() {
        this.clearPlot(true);
    }

    public void clearPlot(boolean reval) {
        this._glyphVector.removeAllElements();
        Enumeration e = this._scaleVector.elements();
        while (e.hasMoreElements()) {
            ((Scale)e.nextElement()).clearRegionExtents();
        }
        if (reval) {
            this._dirtyBuffer = true;
            this._parent.invalidate();
            this._parent.doLayout();
        }
    }

    protected Scale findScale(G2dObject go) {
        Scale scl;
        int i;
        DataType dataType = DataTypeFactory.getFactory().getDataType(go);
        String yname = this._parent.getYName(go, dataType);
        String name = yname.toLowerCase() + " vs " + go.getXAxisName().toLowerCase();
        for (i = 0; i < this._scaleVector.size(); ++i) {
            scl = (Scale)this._scaleVector.elementAt(i);
            if (!name.equalsIgnoreCase(scl.getName())) continue;
            return scl;
        }
        name = go.getYAxisName().toLowerCase() + " vs " + go.getXAxisName().toLowerCase();
        for (i = 0; i < this._scaleVector.size(); ++i) {
            scl = (Scale)this._scaleVector.elementAt(i);
            if (!name.equalsIgnoreCase(scl.getName())) continue;
            return scl;
        }
        return null;
    }

    public void addG2dObject(G2dObject obj) {
        Scale scl = this.findScale(obj);
        if (scl == null) {
            return;
        }
        this.addG2dObject(obj, scl);
    }

    public void addG2dObject(G2dObject obj, Scale scl) {
        if (obj == null || scl == null) {
            return;
        }
        if (this.hasG2dObject(obj)) {
            return;
        }
        G2dGlyph glyph = G2dGlyphFactory.newG2dGlyph(this, obj, scl);
        this.addG2dGlyph(glyph, scl);
    }

    public void addG2dGlyph(G2dGlyph glyph) {
        this.addG2dGlyph(glyph, this.getScale());
    }

    public void addG2dGlyph(G2dGlyph glyph, Scale scl) {
        if (glyph != null) {
            this._glyphVector.addElement(glyph);
            WorldRect rc = glyph.getBounds();
            this.growScaleToGlyphExtents(scl, rc);
            if (this._glyphVector.size() <= this._drawProp.glyphProperties.size() && this._drawProp.glyphProperties.size() != 0) {
                glyph.setProperties((G2dGlyphDrawProp)this._drawProp.glyphProperties.elementAt(this._glyphVector.size() - 1));
            }
        }
    }

    public void insertG2dGlyph(G2dGlyph glyph, int ipos) {
        this.insertG2dGlyph(glyph, this.getScale(), ipos);
    }

    public void insertG2dGlyph(G2dGlyph glyph, Scale scl, int ipos) {
        if (glyph != null) {
            if (ipos < 0) {
                ipos = 0;
            }
            if (ipos >= this._glyphVector.size()) {
                this.addG2dGlyph(glyph, scl);
                return;
            }
            this._glyphVector.insertElementAt(glyph, ipos);
            WorldRect rc = glyph.getBounds();
            this.growScaleToGlyphExtents(scl, rc);
        }
    }

    public void addG2dObject(G2dObject obj, Color lc, Color fc) {
        Scale scl = this.findScale(obj);
        if (scl == null) {
            return;
        }
        this.addG2dObject(obj, lc, fc, scl);
    }

    public void addG2dObject(G2dObject obj, Color lc, Color fc, Scale scl) {
        G2dLineProperties lineProp = new G2dLineProperties();
        lineProp.setLineColor(lc);
        lineProp.setFillColor(fc);
        this.addG2dObject(obj, new G2dLineProperties[]{lineProp}, scl);
    }

    public void addG2dObject(G2dObject obj, G2dLineProperties lineProp) {
        this.addG2dObject(obj, new G2dLineProperties[]{lineProp});
    }

    public void addG2dObject(G2dObject obj, G2dLineProperties[] lineProp) {
        Scale scl = this.findScale(obj);
        if (scl == null) {
            return;
        }
        this.addG2dObject(obj, lineProp, scl);
    }

    public void addG2dObject(G2dObject obj, G2dLineProperties lineProp, Scale scl) {
        this.addG2dObject(obj, new G2dLineProperties[]{lineProp}, scl);
    }

    public void addG2dObject(G2dObject obj, G2dLineProperties[] lineProp, Scale scl) {
        if (obj == null || scl == null) {
            return;
        }
        if (this.hasG2dObject(obj)) {
            return;
        }
        G2dGlyph glyph = G2dGlyphFactory.newG2dGlyph(this, obj, scl);
        if (glyph != null) {
            this._glyphVector.addElement(glyph);
            WorldRect rc = glyph.getBounds();
            this.growScaleToGlyphExtents(scl, rc);
            if (this._glyphVector.size() <= this._drawProp.glyphProperties.size() && this._drawProp.glyphProperties.size() != 0) {
                glyph.setProperties((G2dGlyphDrawProp)this._drawProp.glyphProperties.elementAt(this._glyphVector.size() - 1));
            }
            if (lineProp != null) {
                G2dGlyphDrawProp glyphProp = glyph.getProperties();
                if (glyphProp.lineProperties.size() >= 1) {
                    for (int i = 0; i < glyphProp.lineProperties.size() && i < lineProp.length; ++i) {
                        if (lineProp[i] == null) continue;
                        glyphProp.lineProperties.set(i, lineProp[i]);
                    }
                } else {
                    for (int i = 0; i < lineProp.length; ++i) {
                        if (lineProp[i] == null) continue;
                        glyphProp.lineProperties.add(i, lineProp[i]);
                    }
                }
                if (obj instanceof G2dDssTimeSeriesCollection) {
                    glyphProp._showAllCurvesOnLegend = false;
                }
                glyph.setProperties(glyphProp);
            }
        }
    }

    public void addG2dObjects(List g2dObjects, List lineProperties) {
        this.addG2dObjects(g2dObjects, lineProperties, true);
    }

    public void addG2dObjects(List g2dObjects, List lineProperties, boolean append) {
        HashMap<Scale, WorldRect> extentsMap = new HashMap<Scale, WorldRect>();
        for (int i = 0; i < g2dObjects.size(); ++i) {
            int z;
            G2dGlyph glyph;
            G2dObject g2dObject = (G2dObject)g2dObjects.get(i);
            Scale scl = this.findScale(g2dObject);
            if (scl == null || this.hasG2dObject(g2dObject) || (glyph = G2dGlyphFactory.newG2dGlyph(this, g2dObject, scl)) == null) continue;
            if (append) {
                this._glyphVector.addElement(glyph);
            } else {
                this._glyphVector.insertElementAt(glyph, 0);
            }
            WorldRect tempRc = glyph.getBounds();
            WorldRect extents = (WorldRect)extentsMap.get(scl);
            if (extents == null) {
                extents = tempRc;
                extentsMap.put(scl, extents);
            } else if (tempRc != null) {
                extents.grow(tempRc);
            }
            if (this._glyphVector.size() <= this._drawProp.glyphProperties.size() && this._drawProp.glyphProperties.size() != 0) {
                glyph.setProperties((G2dGlyphDrawProp)this._drawProp.glyphProperties.elementAt(this._glyphVector.size() - 1));
            }
            if (lineProperties == null || i >= lineProperties.size()) continue;
            Object linePropObj = lineProperties.get(i);
            G2dLineProperties[] lineProp = linePropObj instanceof G2dLineProperties ? new G2dLineProperties[]{(G2dLineProperties)linePropObj} : (G2dLineProperties[])linePropObj;
            if (linePropObj == null) continue;
            G2dGlyphDrawProp glyphProp = glyph.getProperties();
            if (glyphProp.lineProperties.size() >= 1) {
                for (z = 0; z < glyphProp.lineProperties.size() && z < lineProp.length; ++z) {
                    if (lineProp[z] == null) continue;
                    glyphProp.lineProperties.set(z, lineProp[z]);
                }
            } else {
                for (z = 0; z < lineProp.length; ++z) {
                    if (lineProp[z] == null) continue;
                    glyphProp.lineProperties.add(z, lineProp[z]);
                }
            }
            glyph.setProperties(glyphProp);
        }
        if (extentsMap.size() > 0) {
            Set entries = extentsMap.entrySet();
            for (Map.Entry next : entries) {
                this.growScaleToGlyphExtents((Scale)next.getKey(), (WorldRect)next.getValue());
            }
        }
    }

    public void insertG2dObjects(List g2dObjects, List lineProperties, int insertPosition) {
        HashMap<Scale, WorldRect> extentsMap = new HashMap<Scale, WorldRect>();
        for (int i = 0; i < g2dObjects.size(); ++i) {
            int z;
            G2dGlyph glyph;
            G2dObject g2dObject = (G2dObject)g2dObjects.get(i);
            Scale scl = this.findScale(g2dObject);
            if (scl == null || this.hasG2dObject(g2dObject) || (glyph = G2dGlyphFactory.newG2dGlyph(this, g2dObject, scl)) == null) continue;
            if (insertPosition < 0) {
                this._glyphVector.insertElementAt(glyph, 0);
            } else if (insertPosition >= this._glyphVector.size()) {
                this._glyphVector.add(glyph);
            } else {
                this._glyphVector.insertElementAt(glyph, insertPosition++);
            }
            WorldRect tempRc = glyph.getBounds();
            WorldRect extents = (WorldRect)extentsMap.get(scl);
            if (extents == null) {
                extents = tempRc;
                extentsMap.put(scl, extents);
            } else if (tempRc != null) {
                extents.grow(tempRc);
            }
            if (this._glyphVector.size() <= this._drawProp.glyphProperties.size() && this._drawProp.glyphProperties.size() != 0) {
                glyph.setProperties((G2dGlyphDrawProp)this._drawProp.glyphProperties.elementAt(this._glyphVector.size() - 1));
            }
            if (lineProperties == null || i >= lineProperties.size()) continue;
            Object linePropObj = lineProperties.get(i);
            G2dLineProperties[] lineProp = linePropObj instanceof G2dLineProperties ? new G2dLineProperties[]{(G2dLineProperties)linePropObj} : (G2dLineProperties[])linePropObj;
            if (linePropObj == null) continue;
            G2dGlyphDrawProp glyphProp = glyph.getProperties();
            if (glyphProp.lineProperties.size() >= 1) {
                for (z = 0; z < glyphProp.lineProperties.size() && z < lineProp.length; ++z) {
                    if (lineProp[z] == null) continue;
                    glyphProp.lineProperties.set(z, lineProp[z]);
                }
            } else {
                for (z = 0; z < lineProp.length; ++z) {
                    if (lineProp[z] == null) continue;
                    glyphProp.lineProperties.add(z, lineProp[z]);
                }
            }
            glyph.setProperties(glyphProp);
        }
        if (extentsMap.size() > 0) {
            Set entries = extentsMap.entrySet();
            for (Map.Entry entry : entries) {
                this.growScaleToGlyphExtents((Scale)entry.getKey(), (WorldRect)entry.getValue());
            }
        }
    }

    private void growScaleToGlyphExtents(Scale scl, WorldRect rc) {
        if (rc == null || scl == null) {
            return;
        }
        Axis xaxis = scl.getAxis(0);
        Axis yaxis = scl.getAxis(1);
        boolean validY = true;
        if (!RMAConst.isValidValue(rc.w)) {
            double d = rc.w = xaxis instanceof LogAxis ? 1.0 : xaxis.getActMin();
        }
        if (!RMAConst.isValidValue(rc.e)) {
            rc.e = xaxis.getActMax();
        }
        if (!RMAConst.isValidValue(rc.s)) {
            rc.s = yaxis instanceof LogAxis ? 1.0 : yaxis.getActMin();
            validY = false;
        }
        if (!RMAConst.isValidValue(rc.n)) {
            rc.n = yaxis.getActMax();
            validY = false;
        }
        double deltax = Math.abs(rc.e - rc.w);
        double deltay = Math.abs(rc.n - rc.s);
        if (validY) {
            if (deltay != 0.0) {
                rc.n += deltay * 0.01;
                if (rc.s >= 0.0 && rc.s - deltay * 0.01 < 0.0) {
                    rc.s = rc.s;
                } else if (!(scl.getAxis(1) instanceof LogAxis)) {
                    rc.s -= deltay * 0.01;
                }
            } else {
                rc.n += rc.n * 0.01;
                rc.s -= rc.s * 0.01;
            }
        }
        if (!RMAConst.isValidValue(rc.w)) {
            double d = rc.w = xaxis instanceof LogAxis ? 1.0 : xaxis.getActMin();
        }
        if (!RMAConst.isValidValue(rc.e)) {
            rc.e = xaxis.getActMax();
        }
        if (!RMAConst.isValidValue(rc.s)) {
            double d = rc.s = yaxis instanceof LogAxis ? 1.0 : yaxis.getActMin();
        }
        if (!RMAConst.isValidValue(rc.n)) {
            rc.n = yaxis.getActMax();
        }
        scl.growRegionExtents(rc);
    }

    boolean hasG2dObject(G2dObject obj) {
        if (obj == null) {
            return false;
        }
        for (int i = 0; i < this._glyphVector.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)this._glyphVector.get(i);
            if (glyph == null || !obj.equals(glyph.getG2dObject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector getGlyphVector() {
        return this._glyphVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Axis && arg == "COMPUTED_SCALE" && this.isVisible()) {
            this._dirtyBuffer = true;
            this.paintGfx();
        }
        if (o instanceof Axis && arg == "NEW_ZOOM" && this.isVisible()) {
            this._dirtyBuffer = true;
        }
    }

    public void addScale(Scale scl) {
        if (scl == null) {
            return;
        }
        this._scaleVector.addElement(scl);
        scl.getAxis(0).addObserver(this);
        scl.getAxis(1).addObserver(this);
    }

    @Override
    public Scale getScale() {
        if (this._scaleVector.size() < 1) {
            return null;
        }
        return (Scale)this._scaleVector.firstElement();
    }

    public Scale getScale(int i) {
        if (i >= this._scaleVector.size()) {
            return null;
        }
        return (Scale)this._scaleVector.elementAt(i);
    }

    public Scale getScale(String scaleName) {
        for (int i = 0; i < this._scaleVector.size(); ++i) {
            Scale s = (Scale)this._scaleVector.get(i);
            if (!s.getName().equalsIgnoreCase(scaleName)) continue;
            return s;
        }
        return null;
    }

    public int numScaleElements() {
        return this._scaleVector.size();
    }

    public void computeScaling() {
        Dimension dim = this.getSize();
        Dimension scldim = new Dimension(dim.width - 1, dim.height - 1);
        for (int i = 0; i < this._scaleVector.size(); ++i) {
            Scale scl = (Scale)this._scaleVector.elementAt(i);
            scl.computeScaling(scldim);
        }
    }

    public void deleteMarkerLine(G2dMarkerLine line) {
        if (line == null) {
            return;
        }
        this._markerLines.removeElement(line);
    }

    public void deleteMarkerPoint(G2dMarkerPoint markerPoint) {
        if (markerPoint == null) {
            return;
        }
        this._markerPoints.remove(markerPoint);
    }

    public void deleteAllMarkerLines() {
        this._markerLines.clear();
    }

    public void deleteAllMarkerPoints() {
        this._markerPoints.clear();
    }

    public void drawMarkers(Graphics g) {
        int i;
        if (this._scaleVector.size() == 0) {
            return;
        }
        Scale s = (Scale)this._scaleVector.elementAt(0);
        Rectangle rect = this.getVisibleArea();
        for (i = 0; i < this._markerLines.size(); ++i) {
            G2dMarkerLine ml = this._markerLines.elementAt(i);
            ml.setScale(s);
            ml.drawLine(g, rect);
        }
        for (i = 0; i < this._markerPoints.size(); ++i) {
            G2dMarkerPoint point = this._markerPoints.get(i);
            point.setScale(s);
            point.drawPoint(g, rect);
        }
    }

    public Rectangle getVisibleArea() {
        Scale scale = null;
        if (this._scaleVector.size() > 0) {
            scale = (Scale)this._scaleVector.elementAt(0);
        }
        if (scale == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int xmin = Math.min(scale.getAxis(0).w2l(scale.getAxis(0).getActMin()), scale.getAxis(0).w2l(scale.getAxis(0).getActMax()));
        int ymax = Math.max(scale.getAxis(1).w2l(scale.getAxis(1).getActMax()), scale.getAxis(1).w2l(scale.getAxis(1).getActMin()));
        int xmax = Math.max(scale.getAxis(0).w2l(scale.getAxis(0).getActMin()), scale.getAxis(0).w2l(scale.getAxis(0).getActMax()));
        int ymin = Math.min(scale.getAxis(1).w2l(scale.getAxis(1).getActMax()), scale.getAxis(1).w2l(scale.getAxis(1).getActMin()));
        Rectangle rect = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public void addGraphLabelItem(GfxTextObject textobj) {
        if (textobj == null) {
            return;
        }
        int idx = -1;
        int imax = this._graphLabelList.size();
        for (int i = 0; i < imax; ++i) {
            GfxTextObject label = (GfxTextObject)this._graphLabelList.get(i);
            if (label == null) {
                if (idx >= 0) continue;
                idx = i;
                continue;
            }
            if (!textobj.intersects(label) || label._priority < 0.0f) continue;
            if (textobj._priority >= 0.0f && textobj._priority >= label._priority) {
                return;
            }
            this._graphLabelList.set(i, null);
            if (idx >= 0) continue;
            idx = i;
        }
        if (idx >= 0) {
            this._graphLabelList.set(idx, textobj);
        } else {
            this._graphLabelList.add(textobj);
        }
    }

    public void setLegendRenderer(ViewportLegendRenderer renderer) {
        Objects.requireNonNull(renderer, "NULL Legend Renderer: Legened renderer may not be null");
        this.mLegendRegenderer = renderer;
    }

    public void paintGfx2(Graphics g) {
        if (!this.isDoubleBuffered()) {
            this.paintViewportInternal(g);
            return;
        }
        Rectangle d = this.getBounds();
        if (d.width <= 0 || d.height <= 0) {
            return;
        }
        if (this._doubleBuffer == null || this._doubleBuffer.getWidth() == 0 || this._doubleBuffer.getHeight() == 0) {
            this._doubleBuffer = new BufferedImage(d.width, d.height, 2);
            this._dirtyBuffer = true;
        }
        if (this._dirtyBuffer) {
            Graphics g2 = this._doubleBuffer.getGraphics();
            this.paintViewportInternal(g2);
            g2.dispose();
            this._dirtyBuffer = false;
        }
        g.drawImage(this._doubleBuffer, 0, 0, this._doubleBuffer.getWidth(), this._doubleBuffer.getHeight(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintViewportInternal(Graphics g) {
        this._graphLabelList.clear();
        int g2dResolution = this._parent.getDeviceResoultion();
        int scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        long t1 = System.currentTimeMillis();
        Dimension dim = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, dim.width - 1, dim.height - 1);
        Paint oldPaint = ((Graphics2D)g).getPaint();
        Color oldColor = g.getColor();
        Composite oldAc = ((Graphics2D)g).getComposite();
        if (this._drawProp.drawBackground) {
            g.setColor(this._drawProp.backgroundColor);
            AlphaComposite ac = AlphaComposite.getInstance(3, this._drawProp.getAlphaComposite());
            ((Graphics2D)g).setPaint(FillPatternFactory.createFillPattern(this._drawProp.fillPattern, this._drawProp.backgroundColor));
            ((Graphics2D)g).setComposite(ac);
            g.fillRect(0, 0, dim.width - 1, dim.height - 1);
        }
        ((Graphics2D)g).setComposite(oldAc);
        ((Graphics2D)g).setColor(oldColor);
        ((Graphics2D)g).setPaint(oldPaint);
        this.drawGrid(g);
        this.drawMarkers(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Enumeration e = this._glyphVector.elements();
        while (e.hasMoreElements()) {
            G2dGlyph glyph = (G2dGlyph)e.nextElement();
            Graphics g2 = g.create();
            try {
                glyph.draw(g2);
            }
            finally {
                g2.dispose();
            }
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int numLabels = this._graphLabelList.size();
        for (int i = 0; i < numLabels; ++i) {
            GfxTextObject label = (GfxTextObject)this._graphLabelList.get(i);
            if (label == null) continue;
            try {
                label.draw(g);
                continue;
            }
            catch (Exception e2) {
                System.out.println("paintViewport: Error drawing Label " + label._text + " Error:" + e2);
            }
        }
        if (this._drawProp.drawViewportLegend) {
            this.mLegendRegenderer.drawLegend((Graphics2D)g, this.getG2dPanel(), this);
        }
        if (this._drawProp.drawBorder) {
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                BasicStroke bs = new BasicStroke(this._drawProp.borderWeight, 0, 0, 10.0f, this._drawProp.borderStyle, 0.0f);
                ((Graphics2D)g).setStroke(bs);
            }
            g.setColor(this._drawProp.borderColor);
            g.drawRect((int)this._drawProp.borderWeight / 2, (int)this._drawProp.borderWeight / 2, dim.width - (int)this._drawProp.borderWeight, dim.height - (int)this._drawProp.borderWeight);
            if (oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }
        long t2 = System.currentTimeMillis();
    }

    void drawGrid(Graphics g1) {
        int ix;
        AxisIterator iter;
        Axis ma;
        BasicStroke bs;
        Graphics2D g2d = (Graphics2D)g1.create();
        Dimension d = this.getSize();
        if (this._scaleVector.size() < 1) {
            return;
        }
        Scale scl = (Scale)this._scaleVector.elementAt(0);
        if (scl == null) {
            return;
        }
        Dimension dim = this.getSize();
        Stroke oldStroke = null;
        oldStroke = g2d.getStroke();
        if (this._drawProp.drawMinorYGrid) {
            g2d.setColor(this._drawProp.minorYGridColor);
            bs = new BasicStroke(this._drawProp.minorYGridWeight, 0, 0, 10.0f, this._drawProp.minorYGridStyle, 0.0f);
            g2d.setStroke(bs);
            ma = this.getMasterAxis(1);
            if (ma == null) {
                ma = scl.getAxis(1);
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                int iy = iter.getLocalValue();
                g2d.drawLine(0, iy, dim.width, iy);
            }
        }
        if (this._drawProp.drawMinorXGrid) {
            g2d.setColor(this._drawProp.minorXGridColor);
            bs = new BasicStroke(this._drawProp.minorXGridWeight, 0, 0, 10.0f, this._drawProp.minorXGridStyle, 0.0f);
            g2d.setStroke(bs);
            ma = this.getMasterAxis(0);
            if (ma == null) {
                ma = scl.getAxis(0);
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                ix = iter.getLocalValue();
                if (ix < 0) continue;
                g2d.drawLine(ix, 0, ix, dim.height);
            }
        }
        if (this._drawProp.drawMajorXGrid) {
            g2d.setColor(this._drawProp.majorXGridColor);
            bs = new BasicStroke(this._drawProp.majorXGridWeight, 0, 0, 10.0f, this._drawProp.majorXGridStyle, 0.0f);
            g2d.setStroke(bs);
            ma = this.getMasterAxis(0);
            if (ma == null) {
                ma = scl.getAxis(0);
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                ix = iter.getLocalValue();
                if (ix < 0) continue;
                g2d.drawLine(ix, 0, ix, dim.height);
            }
        }
        if (this._drawProp.drawMajorYGrid) {
            Axis ax = scl.getAxis(1);
            g2d.setColor(this._drawProp.majorYGridColor);
            BasicStroke bs2 = new BasicStroke(this._drawProp.majorYGridWeight, 0, 0, 10.0f, this._drawProp.majorYGridStyle, 0.0f);
            g2d.setStroke(bs2);
            Axis ma2 = this.getMasterAxis(1);
            if (ma2 == null) {
                ma2 = scl.getAxis(1);
            }
            AxisIterator iter2 = AxisFactory.createAxisIterator(ma2, ma2.getMajorTic());
            while (iter2.next()) {
                int iy = iter2.getLocalValue();
                g2d.drawLine(0, iy, dim.width, iy);
            }
        }
        if (oldStroke != null) {
            g2d.setStroke(oldStroke);
        }
        g2d.dispose();
    }

    @Override
    public void zoomIn(LocalRect rc) {
        Scale scl = null;
        Axis ax = null;
        Vector<Axis> vec = new Vector<Axis>();
        Vector<Integer> alignvec = new Vector<Integer>();
        Enumeration e = this._scaleVector.elements();
        while (e.hasMoreElements()) {
            scl = (Scale)e.nextElement();
            if (scl == null) continue;
            ax = scl.getAxis(0);
            if (!vec.contains(ax)) {
                vec.addElement(ax);
                alignvec.addElement(new Integer(0));
            }
            if (vec.contains(ax = scl.getAxis(1))) continue;
            vec.addElement(ax);
            alignvec.addElement(new Integer(1));
        }
        int icnt = 0;
        Enumeration e2 = vec.elements();
        while (e2.hasMoreElements()) {
            ax = (Axis)e2.nextElement();
            if (ax == null) continue;
            Integer align = (Integer)alignvec.elementAt(icnt);
            if (align == 0) {
                ax.zoomIn(rc.l, rc.r);
            } else {
                ax.zoomIn(rc.t, rc.b);
            }
            ++icnt;
        }
        this._dirtyBuffer = true;
        this._parent.invalidate();
        this._parent.doLayout();
        this._parent.repaint();
    }

    public void scaleAxisFromOpposite(String axisName) {
        double bMax2;
        Axis a = null;
        Axis b = null;
        int axis = -1;
        if (axisName.equals("Y1")) {
            a = this.getAxis("Y2");
            b = this.getAxis("Y1");
            axis = 1;
        } else if (axisName.equals("Y2")) {
            a = this.getAxis("Y1");
            b = this.getAxis("Y2");
            axis = 1;
        } else if (axisName.equals("X1")) {
            a = this.getAxis("X2");
            b = this.getAxis("X1");
            axis = 0;
        } else if (axisName.equals("X2")) {
            a = this.getAxis("X1");
            b = this.getAxis("X2");
            axis = 0;
        } else {
            System.out.println("Invalid axis name (\"" + axisName + "\") for " + this.getClass().getName() + ".scaleAxisFromOpposite()");
            return;
        }
        double aMin = a.getScaleMin();
        double aMax = a.getScaleMax();
        double aInt = a.getMajorTic();
        int count = (int)((aMax - aMin) / aInt + 0.5);
        double bMin = b.getScaleMin();
        double bMax = b.getScaleMax();
        double bInt = (bMax - bMin) / (double)count;
        double magnitude = Math.pow(10.0, Math.floor(Math.log(bInt) / Math.log(10.0)));
        double factor = bInt / magnitude;
        factor = factor == 1.0 ? 1.0 : (factor <= 2.0 ? 2.0 : (factor <= 5.0 ? 5.0 : 10.0));
        bInt = factor * magnitude;
        double remainder = Math.IEEEremainder(bMin, bInt);
        if (Math.abs(remainder) > bInt / 10000.0) {
            bMin = bMin < 0.0 ^ remainder < 0.0 ? (bMin -= bInt + remainder) : (bMin -= remainder);
        }
        if ((bMax2 = bMin + (double)count * bInt) < bMax) {
            double maxVal = Double.MIN_VALUE;
            for (int i = 0; i < this._glyphVector.size(); ++i) {
                double bound;
                G2dGlyph glyph = (G2dGlyph)this._glyphVector.elementAt(i);
                if (glyph.getScale().getAxis(axis) != b) continue;
                WorldRect rect = glyph.getBounds();
                double d = bound = axis == 0 ? rect.e : rect.n;
                if (!(bound > maxVal)) continue;
                maxVal = bound;
            }
            if (bMax2 < maxVal) {
                bMax2 += bInt;
                a.setScaleLimits(aMin, aMax += aInt);
            }
        }
        b.setScaleLimits(bMin, bMax2);
    }

    @Override
    public void zoomByFactor(double factor) {
        RatingFunction f;
        Axis x1 = this.getAxis("X1");
        Axis y1 = this.getAxis("Y1");
        Axis x2 = this.getAxis("X2");
        Axis y2 = this.getAxis("Y2");
        if (x1 != null) {
            x1.zoomByFactor(factor);
        }
        if (y1 != null) {
            y1.zoomByFactor(factor);
        }
        if (y2 != null) {
            f = y2.getRatingFunction();
            if (f == null) {
                y2.zoomByFactor(factor);
            } else {
                y2.zoomIn(f.getBaseValue(y1.getActMin()), f.getBaseValue(y1.getActMax()));
            }
        }
        if (x2 != null) {
            f = x2.getRatingFunction();
            if (f == null) {
                x2.zoomByFactor(factor);
            } else {
                x2.zoomIn(f.getBaseValue(x1.getActMin()), f.getBaseValue(x1.getActMax()));
            }
        }
        this._dirtyBuffer = true;
        this._parent.invalidate();
        this._parent.doLayout();
        this._parent.repaint();
    }

    public void updateRatingAxisValues() {
        Axis y2Axis = this.getAxis("Y2");
        if (y2Axis == null) {
            return;
        }
        if (!y2Axis.rateAxis() && y2Axis.getRatingFunction() == null) {
            return;
        }
        Axis masterAxis = this.getMasterAxis(1);
        if (masterAxis == null) {
            return;
        }
        if (!y2Axis.rateAxis() && y2Axis.getRatingFunction() != null) {
            RatingFunction f = y2Axis.getRatingFunction();
            double max = f.getBaseValue(masterAxis.getMax());
            double min = f.getBaseValue(masterAxis.getMin());
            y2Axis.setMinMax(min, max);
        } else if (y2Axis.rateAxis()) {
            G2dObject go1 = null;
            G2dObject go2 = null;
            Vector glyphList = this.getGlyphVector();
            if (glyphList == null || glyphList.size() <= 1) {
                return;
            }
            for (int i = 0; i < glyphList.size(); ++i) {
                G2dGlyph glyph = (G2dGlyph)glyphList.get(i);
                Axis a = glyph.getScale().getAxis(1);
                if (a == y2Axis && go1 == null) {
                    go1 = glyph.getG2dObject();
                    continue;
                }
                if (a == y2Axis || go2 != null) continue;
                go2 = glyph.getG2dObject();
            }
            if (go1 == null || go2 == null) {
                return;
            }
            DataObjectRating f = new DataObjectRating(go1, go2);
            y2Axis.setRatingFunction(f, true);
            double max = f.getBaseValue(masterAxis.getMax());
            double min = f.getBaseValue(masterAxis.getMin());
            y2Axis.setMinMax(min, max);
        } else {
            return;
        }
        y2Axis.computeScaling();
        AxisTics y2AxisTics = this.getAxisTics("Y2");
        if (y2AxisTics != null) {
            y2AxisTics.revalidate();
            y2AxisTics.repaint();
            this.repaint();
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.computeScaling();
        if (w > 0 && h > 0) {
            this.setDirty();
            this._doubleBuffer = new BufferedImage(w, h, 2);
        }
    }

    public void setGridColor(String colorString) {
        Color c2 = RmaColor.parseColorString(colorString);
        this.setGridColor(c2);
    }

    public void setGridColor(Color c2) {
        this._drawProp.setMajorXGridColor(c2);
        this._drawProp.setMinorXGridColor(c2);
        this._drawProp.setMajorYGridColor(c2);
        this._drawProp.setMinorYGridColor(c2);
    }

    public void setGridYColor(String colorString) {
        this.setGridYColor(RmaColor.parseColorString(colorString));
    }

    public void setGridYColor(Color c2) {
        this._drawProp.setMajorXGridColor(c2);
        this._drawProp.setMinorXGridColor(c2);
    }

    public void setGridXColor(String colorString) {
        this.setGridXColor(RmaColor.parseColorString(colorString));
    }

    public void setGridXColor(Color c2) {
        this._drawProp.setMajorYGridColor(c2);
        this._drawProp.setMinorYGridColor(c2);
    }

    public Color getMajorGridXColor() {
        return this._drawProp.getMajorXGridColor();
    }

    public Color getMajorGridYColor() {
        return this._drawProp.getMajorYGridColor();
    }

    public void setMajorGridYColor(String majorGridYColor) {
        Color c2 = RmaColor.parseColorString(majorGridYColor);
        this._drawProp.setMajorYGridColor(c2);
    }

    public String getMajorGridYColorString() {
        return RmaColor.color2String(this._drawProp.getMajorYGridColor());
    }

    public void setMinorGridYColor(String minorGridYColor) {
        Color c2 = RmaColor.parseColorString(minorGridYColor);
        this._drawProp.setMinorYGridColor(c2);
    }

    public Color getMinorGridYColor() {
        return this._drawProp.getMinorYGridColor();
    }

    public String getMinorGridYColorString() {
        return RmaColor.color2String(this._drawProp.getMinorYGridColor());
    }

    public void setMajorGridXColor(String majorGridXColor) {
        Color c2 = RmaColor.parseColorString(majorGridXColor);
        this._drawProp.setMajorXGridColor(c2);
    }

    public String getMajorGridXColorString() {
        return RmaColor.color2String(this._drawProp.getMajorXGridColor());
    }

    public void setMinorGridXColor(String minorGridXColor) {
        Color c2 = RmaColor.parseColorString(minorGridXColor);
        this._drawProp.setMinorXGridColor(c2);
    }

    public Color getMinorGridXColor() {
        return this._drawProp.getMinorXGridColor();
    }

    public String getMinorGridXColorString() {
        return RmaColor.color2String(this._drawProp.getMinorXGridColor());
    }

    public void setMajorGridXVisible(boolean draw) {
        this._drawProp.drawMajorXGrid = draw;
    }

    public boolean isMajorGridXVisible() {
        return this._drawProp.drawMajorXGrid;
    }

    public void setMajorGridYVisible(boolean draw) {
        this._drawProp.drawMajorYGrid = draw;
    }

    public boolean isMajorGridYVisible() {
        return this._drawProp.drawMajorYGrid;
    }

    public void setMinorGridXVisible(boolean draw) {
        this._drawProp.drawMinorXGrid = draw;
    }

    public boolean isMinorGridXVisible() {
        return this._drawProp.drawMinorXGrid;
    }

    public void setMinorGridYVisible(boolean draw) {
        this._drawProp.drawMinorYGrid = draw;
    }

    public boolean isMinorGridYVisible() {
        return this._drawProp.drawMinorYGrid;
    }

    public void setMajorGridXWidth(float gridLineWidth) {
        this._drawProp.setMajorXGridWeight(gridLineWidth);
    }

    public float getMajorGridXWidth() {
        return this._drawProp.getMajorXGridWeight();
    }

    public void setMajorGridYWidth(float gridLineWidth) {
        this._drawProp.setMajorYGridWeight(gridLineWidth);
    }

    public float getMajorGridYWidth() {
        return this._drawProp.getMajorYGridWeight();
    }

    public void setMinorGridXWidth(float gridLineWidth) {
        this._drawProp.setMinorXGridWeight(gridLineWidth);
    }

    public float getMinorGridXWidth() {
        return this._drawProp.getMinorXGridWeight();
    }

    public void setMinorGridYWidth(float gridLineWidth) {
        this._drawProp.setMinorYGridWeight(gridLineWidth);
    }

    public float getMinorGridYWidth() {
        return this._drawProp.getMinorYGridWeight();
    }

    public void setMajorGridXStyle(String majorGridXStyle) {
        float[] style = G2dLineProperties.lookupStyle(majorGridXStyle);
        if (style != null) {
            this._drawProp.setMajorXGridStyle(style);
        }
    }

    public String getMajorGridXStyleString() {
        return G2dLineProperties.lookupStyleName(this._drawProp.getMajorXGridStyle());
    }

    public void setMajorGridYStyle(String majorGridYStyle) {
        float[] style = G2dLineProperties.lookupStyle(majorGridYStyle);
        if (style != null) {
            this._drawProp.setMajorYGridStyle(style);
        }
    }

    public String getMajorGridYStyleString() {
        return G2dLineProperties.lookupStyleName(this._drawProp.getMajorYGridStyle());
    }

    public void setMinorGridXStyle(String minorGridXStyle) {
        float[] style = G2dLineProperties.lookupStyle(minorGridXStyle);
        if (style != null) {
            this._drawProp.setMinorXGridStyle(style);
        }
    }

    public String getMinorGridXStyleString() {
        return G2dLineProperties.lookupStyleName(this._drawProp.getMinorXGridStyle());
    }

    public void setMinorGridYStyle(String minorGridYStyle) {
        float[] style = G2dLineProperties.lookupStyle(minorGridYStyle);
        if (style != null) {
            this._drawProp.setMinorYGridStyle(style);
        }
    }

    public String getMinorGridYStyleString() {
        return G2dLineProperties.lookupStyleName(this._drawProp.getMinorYGridStyle());
    }

    public void setBorderVisible(boolean draw) {
        this._drawProp.drawBorder = draw;
    }

    public boolean isBorderVisible() {
        return this._drawProp.drawBorder;
    }

    public void setBorderWeight(float borderWeight) {
        this._drawProp.borderWeight = borderWeight;
    }

    public float getBorderWeight() {
        return this._drawProp.borderWeight;
    }

    public Color getBorderColor() {
        return this._drawProp.borderColor;
    }

    public String getBorderColorString() {
        return RmaColor.color2String(this.getBorderColor());
    }

    public void setBorderColor(String borderColor) {
        Color c2;
        this._drawProp.borderColor = c2 = RmaColor.parseColorString(borderColor);
    }

    public void setFillPattern(String pattern) {
        this._drawProp.fillPattern = RmaDrawConst.lookupFillPattern(pattern);
    }

    public String getFillPatternString() {
        return RmaDrawConst.lookupFillPatternName(this._drawProp.fillPattern);
    }

    public void setBackgroundVisible(boolean draw) {
        this._drawProp.setDrawBackground(draw);
    }

    public boolean isBackgroundVisible() {
        return this._drawProp.drawBackground;
    }

    public void setAlpha(float alpha) {
        if (this._drawProp != null) {
            if (alpha < 0.0f) {
                alpha = 0.0f;
            } else if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            this._drawProp.setAlphaComposite(alpha);
        }
    }

    public float getAlpha() {
        if (this._drawProp == null || !this._drawProp.drawBackground) {
            return 1.0f;
        }
        return this._drawProp.getAlphaComposite();
    }

    public void setBackground(String colorString) {
        Color c2 = RmaColor.parseColorString(colorString);
        this.setBackground(c2);
    }

    @Override
    public void setBackground(Color c2) {
        super.setBackground(c2);
        if (this._drawProp != null) {
            this._drawProp.setBackgroundColor(c2);
        }
    }

    @Override
    public Color getBackground() {
        if (this._drawProp == null || !this._drawProp.drawBackground) {
            return super.getBackground();
        }
        return this._drawProp.getBackgroundColor();
    }

    public String getBackgroundString() {
        return RmaColor.color2String(this.getBackground());
    }

    public G2dGlyph getGlyphAtPoint(LocalPt pt) {
        Vector glyphVec = this.getGlyphVector();
        if (glyphVec == null) {
            return null;
        }
        for (int i = 0; i < glyphVec.size(); ++i) {
            G2dGlyph g = (G2dGlyph)glyphVec.get(i);
            if (!g.dataAtPoint(pt)) continue;
            return g;
        }
        return null;
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        int i;
        Vector glyphVec = this.getGlyphVector();
        if (glyphVec == null) {
            return false;
        }
        for (i = glyphVec.size() - 1; i >= 0; --i) {
            G2dGlyph g = (G2dGlyph)glyphVec.get(i);
            if (!g.objectPopupMenu(pt, modifiers)) continue;
            return true;
        }
        for (i = 0; i < this._markerPoints.size(); ++i) {
            G2dMarkerPoint mp = this._markerPoints.get(i);
            if (!mp.contains(pt)) continue;
            mp.showPopup(this, pt.x, pt.y);
            return true;
        }
        for (i = 0; i < this._markerLines.size(); ++i) {
            G2dMarkerLine ml = this._markerLines.elementAt(i);
            if (!ml.contains(pt)) continue;
            ml.showPopup(this, pt.x, pt.y);
            return true;
        }
        Rectangle rect = this.getBounds();
        if (!this.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        this.m_mouseClickPt = new LocalPt(pt);
        this._popupMenu.show(this, pt.x, pt.y);
        return true;
    }

    @Override
    public void pointerOver(LocalPt pt) {
        Vector glyphVec = this.getGlyphVector();
        if (glyphVec == null) {
            return;
        }
        for (int i = 0; i < glyphVec.size(); ++i) {
            G2dGlyph g = (G2dGlyph)glyphVec.elementAt(i);
            if (!g.pointerOver(pt)) continue;
            return;
        }
    }

    @Override
    public boolean objectSelect(LocalPt pt, int modifiers) {
        Vector glyphVec = this.getGlyphVector();
        if (glyphVec == null) {
            return false;
        }
        for (int i = 0; i < glyphVec.size(); ++i) {
            G2dGlyph g = (G2dGlyph)glyphVec.elementAt(i);
            if (!g.objectSelect(pt, modifiers)) continue;
            this.fireObjectSelectionChanged(new ObjectSelectionEvent(g));
            return true;
        }
        return false;
    }

    public void clearSelection() {
        Vector glyphVec = this.getGlyphVector();
        if (glyphVec == null) {
            return;
        }
        for (int i = 0; i < glyphVec.size(); ++i) {
            G2dGlyph g = (G2dGlyph)glyphVec.elementAt(i);
            g.clearSelection();
        }
    }

    @Override
    public G2dMouseAdapter setMouseAdapter(G2dMouseAdapter adapter) {
        this.clearSelection();
        return super.setMouseAdapter(adapter);
    }

    public void setDrawViewportLegend(boolean draw) {
        this._drawProp.drawViewportLegend = draw;
    }

    public boolean getDrawViewportLegend() {
        return this._drawProp.drawViewportLegend;
    }

    public void setLegendAlignment(String align) {
        this._drawProp.drawViewportLegendAlign = align;
    }

    public void setProperties(ViewportDrawProp prop) {
        int i;
        if (prop == null) {
            return;
        }
        this._drawProp = prop;
        if (this._drawProp.lineMarkerProperties.size() == 0) {
            this._markerLines.clear();
        } else {
            for (i = 0; i < this._drawProp.lineMarkerProperties.size(); ++i) {
                this.addAxisMarker((G2dMarkerProperties)this._drawProp.lineMarkerProperties.elementAt(i));
            }
        }
        for (i = 0; i < this._glyphVector.size(); ++i) {
            if (i >= prop.glyphProperties.size()) continue;
            G2dGlyph glyph = (G2dGlyph)this._glyphVector.elementAt(i);
            glyph.setProperties((G2dGlyphDrawProp)prop.glyphProperties.elementAt(i));
        }
    }

    public ViewportDrawProp getProperties() {
        Vector<G2dGlyphDrawProp> glyphProp = new Vector<G2dGlyphDrawProp>();
        for (int i = 0; i < this._glyphVector.size(); ++i) {
            G2dGlyph g = (G2dGlyph)this._glyphVector.elementAt(i);
            glyphProp.addElement(g.getProperties());
        }
        Vector<G2dMarkerProperties> markerProp = new Vector<G2dMarkerProperties>();
        for (int i = 0; i < this._markerLines.size(); ++i) {
            markerProp.addElement(this._markerLines.elementAt(i).getProperties());
        }
        this._drawProp.lineMarkerProperties = markerProp;
        this._drawProp.glyphProperties = glyphProp;
        return this._drawProp;
    }

    @Override
    public void editProperties() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        G2dViewportPropertiesPanel patternPanel = new G2dViewportPropertiesPanel();
        patternPanel.setData(this._drawProp);
        G2dPropertiesDlg dlg = null;
        PropertiesOKListener listener = new PropertiesOKListener();
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, this.getName() + " Properties", new DefaultJPanel[]{patternPanel}) : new G2dPropertiesDlg((Frame)w, false, this.getName() + " Properties", new DefaultJPanel[]{patternPanel});
        dlg.addOKListener(listener);
        this.setCursor(oldCursor);
        dlg.setVisible(true);
    }

    public void addObjectSelectionListener(ObjectSelectionListener l) {
        this.listenerList.add(ObjectSelectionListener.class, l);
    }

    public void fireObjectSelectionChanged(ObjectSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        Object e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ObjectSelectionListener.class) continue;
            ((ObjectSelectionListener)listeners[i + 1]).objectSelectionChanged(event);
        }
    }

    public Axis getMasterAxis(int axisType) {
        return (Axis)this._masterAxisTable.get(new Integer(axisType));
    }

    public void setMasterAxisTable(Hashtable table) {
        if (table == null) {
            return;
        }
        this._masterAxisTable = (Hashtable)table.clone();
    }

    public void setMasterAxis(int axisType, Axis axis) {
        if (axisType != 1 && axisType != 0) {
            return;
        }
        if (axis == null) {
            this._masterAxisTable.remove(axisType);
        } else {
            this._masterAxisTable.put(axisType, axis);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        super.addFocusListener(fl);
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        super.removeFocusListener(fl);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public AxisLabel getAxisLabel(String axisName) {
        int axis = this.getAxisFromName(axisName);
        if (axis == -1) {
            System.out.println("getAxisLabel: unknown axis " + axisName);
        }
        return this._parent.getViewportAxisLabel(this, axis);
    }

    public AxisTics getAxisTics(String axisName) {
        int axis = this.getAxisFromName(axisName);
        if (axis == -1) {
            System.out.println("getAxisTics: unknown axis " + axisName);
        }
        return this._parent.getViewportAxisTics(this, axis);
    }

    public void setLinear(String axisName) {
        this.getAxisTics(axisName).setLinear();
    }

    public void setLogarithmic(String axisName) {
        this.getAxisTics(axisName).setLogarithmic();
    }

    public Axis getAxis(String axisName) {
        int axis = this.getAxisFromName(axisName);
        if (axis == -1) {
            System.out.println("getAxis: unknown axis " + axisName);
        }
        return this._parent.getViewportAxis(this, axis);
    }

    int getAxisFromName(String axisName) {
        if (axisName == null || axisName.length() == 0) {
            System.out.println("getAxisFromName: no axis specified to return");
        }
        if ("x1".equalsIgnoreCase(axisName)) {
            return 0;
        }
        if ("x2".equalsIgnoreCase(axisName)) {
            return 1;
        }
        if ("y1".equalsIgnoreCase(axisName)) {
            return 2;
        }
        if ("y2".equalsIgnoreCase(axisName)) {
            return 3;
        }
        return -1;
    }

    public Vector getScaleVector() {
        return this._scaleVector;
    }

    public void setShowStatistics(boolean showstats) {
        Vector glyphs = this.getGlyphVector();
        for (int i = 0; i < glyphs.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
            if (!(glyph instanceof StatisticsGlyph)) continue;
            ((StatisticsGlyph)((Object)glyph)).setStatsDisplayed(showstats);
        }
        this._showingStats = showstats;
    }

    public boolean isShowingStatistics() {
        return this._showingStats;
    }

    public boolean containsStatistics() {
        Vector glyphs = this.getGlyphVector();
        for (int i = 0; i < glyphs.size(); ++i) {
            G2dGlyph glyph = (G2dGlyph)glyphs.get(i);
            if (!(glyph instanceof StatisticsGlyph)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Color getGridColorX() {
        return this.getMajorGridXColor();
    }

    @Deprecated
    public Color getGridColorY() {
        return this.getMajorGridYColor();
    }

    @Deprecated
    public String getGridXColorString() {
        return this.getMajorGridXColorString();
    }

    @Deprecated
    public String getGridYColorString() {
        return this.getMajorGridYColorString();
    }

    @Deprecated
    public void setGridColorY(Color c2) {
        this.setGridYColor(c2);
    }

    @Deprecated
    public void setGridColorX(Color c2) {
        this.setGridXColor(c2);
    }

    @Deprecated
    public void setDrawMajorXGridOn() {
        this.setMajorGridXVisible(true);
    }

    @Deprecated
    public void setDrawMajorXGridOff() {
        this.setMajorGridXVisible(false);
    }

    @Deprecated
    public boolean isMajorGridXDrawn() {
        return this.isMajorGridXVisible();
    }

    @Deprecated
    public void setDrawMajorYGridOn() {
        this.setMajorGridYVisible(true);
    }

    @Deprecated
    public void setDrawMajorYGridOff() {
        this.setMajorGridYVisible(true);
    }

    @Deprecated
    public boolean isMajorGridYDrawn() {
        return this.isMajorGridYVisible();
    }

    @Deprecated
    public void setDrawMinorXGridOn() {
        this.setMinorGridXVisible(true);
    }

    @Deprecated
    public void setDrawMinorXGridOff() {
        this.setMinorGridXVisible(false);
    }

    @Deprecated
    public boolean isMinorGridXDrawn() {
        return this.isMinorGridXVisible();
    }

    @Deprecated
    public void setDrawMinorYGridOn() {
        this.setMinorGridYVisible(true);
    }

    @Deprecated
    public void setDrawMinorYGridOff() {
        this.setMinorGridYVisible(true);
    }

    @Deprecated
    public boolean isMinorGridYDrawn() {
        return this.isMinorGridYVisible();
    }

    @Deprecated
    public void setMajorXGridWidth(float gridLineWidth) {
        this.setMajorGridXWidth(gridLineWidth);
    }

    @Deprecated
    public float getMajorXGridWidth() {
        return this.getMajorGridXWidth();
    }

    @Deprecated
    public void setMajorYGridWidth(float gridLineWidth) {
        this.setMajorGridYWidth(gridLineWidth);
    }

    @Deprecated
    public float getMajorYGridWidth() {
        return this.getMajorGridYWidth();
    }

    @Deprecated
    public void setMinorXGridWidth(float gridLineWidth) {
        this.setMinorGridXWidth(gridLineWidth);
    }

    @Deprecated
    public float getMinorXGridWidth() {
        return this.getMinorGridXWidth();
    }

    @Deprecated
    public void setMinorYGridWidth(float gridLineWidth) {
        this.setMinorGridYWidth(gridLineWidth);
    }

    @Deprecated
    public float getMinorYGridWidth() {
        return this.getMinorGridYWidth();
    }

    @Deprecated
    public void setDrawBorderOn() {
        this.setBorderVisible(true);
    }

    @Deprecated
    public void setDrawBorderOff() {
        this.setBorderVisible(false);
    }

    @Deprecated
    public boolean isBorderDrawn() {
        return this.isBorderVisible();
    }

    @Deprecated
    public void setDrawBackgroundOn() {
        this.setBackgroundVisible(true);
    }

    @Deprecated
    public void setDrawBackgroundOff() {
        this.setBackgroundVisible(false);
    }

    @Deprecated
    public boolean isBackgroundDrawn() {
        return this.isBackgroundVisible();
    }

    public G2dGlyph getGlyphForObject(G2dObject g2dObj) {
        if (g2dObj == null) {
            return null;
        }
        int size = this._glyphVector.size();
        for (int i = 0; i < size; ++i) {
            G2dGlyph glyph = (G2dGlyph)this._glyphVector.get(i);
            if (glyph.getG2dObject() != g2dObj) continue;
            return glyph;
        }
        return null;
    }

    public void setDrawLegend(boolean draw) {
        this._drawProp.drawViewportLegend = draw;
    }

    private class ViewportLayerMouseAdapter
    extends MouseAdapter {
        G2dComponent g2dComp;
        boolean resizeable = false;
        ResizeCompute resizeCompute = null;

        public ViewportLayerMouseAdapter(G2dComponent g2dComp) {
            this.g2dComp = g2dComp;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                System.out.println("Show Popup Menu");
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int mousex = e.getX();
            int mousey = e.getY();
            Dimension size = this.g2dComp.getSize();
            Point resizeStartPt = new Point(mousex, mousey);
            if (mousex >= 0 && mousex <= 2) {
                this.resizeable = true;
                this.resizeCompute = new ResizeLeft(resizeStartPt);
            } else if (mousey >= 0 && mousey <= 2) {
                this.resizeable = true;
                this.resizeCompute = new ResizeTop(resizeStartPt);
            } else if (mousex >= size.width - 2 && mousex <= size.width) {
                this.resizeable = true;
                this.resizeCompute = new ReiszeRight(resizeStartPt);
            } else if (mousey >= size.height - 2 && mousey <= size.height) {
                this.resizeable = true;
                this.resizeCompute = new ResizeBottom(resizeStartPt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.resizeable = false;
            this.resizeCompute = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.resizeable) {
                Rectangle oldBounds = this.g2dComp.getBounds();
                Dimension minSize = this.g2dComp.getMinimumSize();
                Rectangle newBounds = this.resizeCompute.computeResizeBounds(oldBounds, e);
                if (newBounds.width < minSize.width) {
                    newBounds.x = oldBounds.x;
                    newBounds.width = oldBounds.width;
                }
                if (newBounds.height < minSize.height) {
                    newBounds.y = oldBounds.y;
                    newBounds.height = oldBounds.height;
                }
                this.g2dComp.setBounds(newBounds);
            } else {
                this.g2dComp.setLocation(e.getX(), e.getY());
            }
        }
    }

    private class PlotLayerPanel
    extends JPanel {
        @Override
        protected void paintComponent(Graphics arg0) {
            Viewport.this.paintGfx2(arg0);
        }
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Viewport.this._dirtyBuffer = true;
            Viewport.this.repaint();
        }
    }

    private class ResizeBottom
    implements ResizeCompute {
        private final Point startPoint;

        public ResizeBottom(Point startPoint) {
            this.startPoint = startPoint;
        }

        @Override
        public Rectangle computeResizeBounds(Rectangle bounds, MouseEvent e) {
            int dy = e.getY();
            return new Rectangle(bounds.x, bounds.y, bounds.width, dy);
        }
    }

    private class ReiszeRight
    implements ResizeCompute {
        private final Point startPoint;

        public ReiszeRight(Point startPoint) {
            this.startPoint = startPoint;
        }

        @Override
        public Rectangle computeResizeBounds(Rectangle bounds, MouseEvent e) {
            int dx = e.getX();
            return new Rectangle(bounds.x, bounds.y, dx, bounds.height);
        }
    }

    private class ResizeTop
    implements ResizeCompute {
        private final Point startPoint;

        public ResizeTop(Point startPoint) {
            this.startPoint = startPoint;
        }

        @Override
        public Rectangle computeResizeBounds(Rectangle bounds, MouseEvent e) {
            int dy = e.getY() - this.startPoint.y;
            return new Rectangle(bounds.x, bounds.y + dy, bounds.width, bounds.height - dy);
        }
    }

    private class ResizeLeft
    implements ResizeCompute {
        private final Point startPoint;

        public ResizeLeft(Point startPoint) {
            this.startPoint = startPoint;
        }

        @Override
        public Rectangle computeResizeBounds(Rectangle bounds, MouseEvent e) {
            int dx = e.getX() - this.startPoint.x;
            return new Rectangle(bounds.x + dx, bounds.y, bounds.width - dx, bounds.height);
        }
    }

    private static interface ResizeCompute {
        public Rectangle computeResizeBounds(Rectangle var1, MouseEvent var2);
    }

    private class MouseInputHandler
    extends MouseAdapter {
        MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Viewport.this.requestFocus();
        }
    }
}

