/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphTransferable;
import hec.gfx2d.G2dPointerAdapter;
import hec.gfx2d.GhostGlassPane;
import hec.gfx2d.PanelDragTarget;
import hec.gfx2d.Viewport;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class ViewportDragTarget
extends PanelDragTarget
implements DragSourceMotionListener {
    Viewport mViewport;
    Point mDragOrigin = new Point();
    Point mImageOrigin = new Point();
    Window w = null;
    BufferedImage mBuffer = null;

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Viewport v;
        InputEvent ie = dge.getTriggerEvent();
        if (!(ie instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)ie;
        Component srcComp = dge.getComponent();
        if (!(srcComp instanceof Viewport)) {
            return;
        }
        this.mViewport = v = (Viewport)srcComp;
        if (!(v.getMouseAdapter() instanceof G2dPointerAdapter)) {
            return;
        }
        if (!ViewportDragTarget.pressedButton1(me)) {
            return;
        }
        G2dGlyph g = v.getGlyphAtPoint(new LocalPt(dge.getDragOrigin().x, dge.getDragOrigin().y));
        if (g == null) {
            return;
        }
        G2dGlyphTransferable transferable = new G2dGlyphTransferable(g);
        try {
            this.mBuffer = null;
            dge.startDrag(DragSource.DefaultCopyNoDrop, transferable, new DSListener());
            Component c2 = SwingUtilities.getRootPane(v).getGlassPane();
            if (c2 instanceof GhostGlassPane) {
                GhostGlassPane glassPane = (GhostGlassPane)c2;
                glassPane.setVisible(true);
                this.mDragOrigin = (Point)dge.getDragOrigin().clone();
                SwingUtilities.convertPointToScreen(this.mDragOrigin, v);
                SwingUtilities.convertPointFromScreen(this.mDragOrigin, glassPane);
                Point p = new Point(0, 0);
                SwingUtilities.convertPointToScreen(p, v);
                SwingUtilities.convertPointFromScreen(p, glassPane);
                this.mImageOrigin = (Point)p.clone();
                System.out.println("Drag Recognized Image pt" + p);
                System.out.println("Drag Origin " + this.mDragOrigin);
                glassPane.setPoint(p);
                BufferedImage img = this.getItemPicture(v.getBounds(), g);
                glassPane.setImage(img, img.getWidth());
                glassPane.repaint();
            }
        }
        catch (InvalidDnDOperationException idoe) {
            System.err.println(idoe);
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        if (this.mViewport == null) {
            return;
        }
        if (((DragSourceContext)dsde.getSource()).getComponent() != this.mViewport) {
            return;
        }
        JRootPane jrp = SwingUtilities.getRootPane(this.mViewport);
        if (jrp == null) {
            return;
        }
        Component c2 = jrp.getGlassPane();
        if (c2 instanceof GhostGlassPane) {
            GhostGlassPane glassPane = (GhostGlassPane)c2;
            Point p = (Point)dsde.getLocation().clone();
            SwingUtilities.convertPointFromScreen(p, glassPane);
            Point offset = new Point();
            offset.x = p.x - this.mDragOrigin.x;
            offset.y = p.y - this.mDragOrigin.y;
            p.x = this.mImageOrigin.x + offset.x;
            p.y = this.mImageOrigin.y + offset.y;
            glassPane.setPoint((Point)p.clone());
            glassPane.repaint(glassPane.getRepaintRect());
        }
    }

    private void renderOffscreen(Rectangle bounds, G2dGlyph glyph) {
        this.mBuffer = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D g2 = this.mBuffer.createGraphics();
        glyph.draw(g2);
        g2.dispose();
    }

    public BufferedImage getItemPicture(Rectangle bounds, G2dGlyph glyph) {
        if (this.mBuffer == null) {
            this.renderOffscreen(bounds, glyph);
        }
        return this.mBuffer;
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            Component c2;
            JRootPane rp = SwingUtilities.getRootPane(ViewportDragTarget.this.mViewport);
            if (rp != null && (c2 = rp.getGlassPane()) instanceof GhostGlassPane) {
                GhostGlassPane glassPane = (GhostGlassPane)c2;
                glassPane.setImage(null);
                glassPane.repaint();
                glassPane.setVisible(false);
            }
            if (!e.getDropSuccess()) {
                return;
            }
            if (e.getDropAction() == 2) {
                // empty if block
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & 3) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int sa = context.getSourceActions();
            int ua = e.getUserAction();
            int da = e.getDropAction();
            int ta = e.getTargetActions();
        }

        @Override
        public void dragExit(DragSourceEvent e) {
            DragSourceContext context = e.getDragSourceContext();
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }
}

