/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.GridProperties;
import hec.gfx2d.PatternProperties;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Vector;
import rma.swing.RmaColor;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class ViewportDrawProp
extends PlotProperties
implements PatternProperties,
GridProperties,
AsciiSerializable {
    public static final String CLS_NAME = "Viewport_";
    public static final String END_TAG = "Viewport End";
    public static final String BEGIN_TAG = "Viewport Begin";
    private static final String DRAW_MAJOR_XGRID = "drawMajorXGrid";
    private static final String DRAW_MINOR_XGRID = "drawMinorXGrid";
    private static final String DRAW_MAJOR_YGRID = "drawMajorYGrid";
    private static final String DRAW_MINOR_YGRID = "drawMinorYGrid";
    private static final String MAJOR_XGRID_WEIGHT = "majorXGridWeight";
    private static final String MINOR_XGRID_WEIGHT = "minorXGridWeight";
    private static final String MAJOR_XGRID_COLOR = "majorXGridColor";
    private static final String MINOR_XGRID_COLOR = "minorXGridColor";
    private static final String MAJOR_XGRID_STYLE = "majorXGridStyle";
    private static final String MINOR_XGRID_STYLE = "minorXGridStyle";
    private static final String MAJOR_YGRID_WEIGHT = "majorYGridWeight";
    private static final String MINOR_YGRID_WEIGHT = "minorYGridWeight";
    private static final String MAJOR_YGRID_STYLE = "majorYGridStyle";
    private static final String MINOR_YGRID_STYLE = "minorYGridStyle";
    private static final String MAJOR_YGRID_COLOR = "majorYGridColor";
    private static final String MINOR_YGRID_COLOR = "minorYGridColor";
    private static final String DRAW_BORDER = "drawBorder";
    private static final String DRAW_BACKGROUND = "drawBackground";
    private static final String BORDER_STYLE = "borderStyle";
    private static final String BORDER_WEIGHT = "borderWeight";
    private static final String BORDER_COLOR = "borderColor";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String FILL_PATTERN = "fillPattern";
    private static final String VIEWPORT_LEGEND = "drawViewportLegend";
    private static final String VIEWPORT_LEGEND_ALIGN = "drawViewportLegendAlign";
    private static final String VIEWPORT_ALPHA = "viewportAlpha";
    private static final String VIEWPORT_LEGEND_FONT_SIZE = "viewportLegendFontSize";
    public boolean drawMajorXGrid;
    public boolean drawMinorXGrid;
    public boolean drawMajorYGrid;
    public boolean drawMinorYGrid;
    public float majorXGridWeight;
    public float minorXGridWeight;
    public Color majorXGridColor;
    public Color minorXGridColor;
    public float[] majorXGridStyle;
    public float[] minorXGridStyle;
    public float majorYGridWeight;
    public float minorYGridWeight;
    public Color majorYGridColor;
    public Color minorYGridColor;
    public float[] majorYGridStyle;
    public float[] minorYGridStyle;
    public boolean drawBorder;
    public boolean drawBackground;
    public float[] borderStyle;
    public float borderWeight;
    public Color borderColor;
    public Color backgroundColor;
    public float viewportAlpha;
    public int fillPattern;
    public boolean drawViewportLegend;
    public String drawViewportLegendAlign;
    public int viewportLegendFontSize;
    public Vector lineMarkerProperties = new Vector();
    public Vector glyphProperties = new Vector();

    public static void init() {
        ViewportDrawProp.init(CLS_NAME);
    }

    static void init(String cls) {
        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_XGRID, true);
        ViewportDrawProp.setDefault(cls + DRAW_MINOR_XGRID, false);
        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_YGRID, true);
        ViewportDrawProp.setDefault(cls + DRAW_MINOR_YGRID, false);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_WEIGHT, 1.0f);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_WEIGHT, 1.0f);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_COLOR, Color.lightGray);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_COLOR, Color.lightGray);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_STYLE, G2dLineProperties.SOLID_STYLE_PATTERN);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_STYLE, G2dLineProperties.DASH_STYLE_PATTERN);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_WEIGHT, 1.0f);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_WEIGHT, 1.0f);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_STYLE, G2dLineProperties.SOLID_STYLE_PATTERN);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_STYLE, G2dLineProperties.DASH_STYLE_PATTERN);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_COLOR, Color.lightGray);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_COLOR, Color.lightGray);
        ViewportDrawProp.setDefault(cls + DRAW_BORDER, true);
        ViewportDrawProp.setDefault(cls + DRAW_BACKGROUND, false);
        ViewportDrawProp.setDefault(cls + BORDER_STYLE, G2dLineProperties.SOLID_STYLE_PATTERN);
        ViewportDrawProp.setDefault(cls + BORDER_WEIGHT, 1.0f);
        ViewportDrawProp.setDefault(cls + BORDER_COLOR, Color.black);
        ViewportDrawProp.setDefault(cls + BACKGROUND_COLOR, Color.white);
        ViewportDrawProp.setDefault(cls + VIEWPORT_ALPHA, 1.0f);
        ViewportDrawProp.setDefault(cls + FILL_PATTERN, 0);
        ViewportDrawProp.setDefault(cls + VIEWPORT_LEGEND, false);
        ViewportDrawProp.setDefault(cls + VIEWPORT_LEGEND_ALIGN, "LEFT");
        ViewportDrawProp.setDefault(cls + VIEWPORT_LEGEND_FONT_SIZE, 12);
    }

    public ViewportDrawProp() {
        this(CLS_NAME);
    }

    public ViewportDrawProp(String cls) {
        this.drawMajorXGrid = ViewportDrawProp.getDefaultBoolean(cls + DRAW_MAJOR_XGRID);
        this.drawMinorXGrid = ViewportDrawProp.getDefaultBoolean(cls + DRAW_MINOR_XGRID);
        this.drawMajorYGrid = ViewportDrawProp.getDefaultBoolean(cls + DRAW_MAJOR_YGRID);
        this.drawMinorYGrid = ViewportDrawProp.getDefaultBoolean(cls + DRAW_MINOR_YGRID);
        this.majorXGridWeight = ViewportDrawProp.getDefaultFloat(cls + MAJOR_XGRID_WEIGHT);
        this.minorXGridWeight = ViewportDrawProp.getDefaultFloat(cls + MINOR_XGRID_WEIGHT);
        this.majorXGridColor = ViewportDrawProp.getDefaultColor(cls + MAJOR_XGRID_COLOR);
        this.minorXGridColor = ViewportDrawProp.getDefaultColor(cls + MINOR_XGRID_COLOR);
        this.majorXGridStyle = ViewportDrawProp.getDefaultFloatArray(cls + MAJOR_XGRID_STYLE);
        this.minorXGridStyle = ViewportDrawProp.getDefaultFloatArray(cls + MINOR_XGRID_STYLE);
        this.majorYGridWeight = ViewportDrawProp.getDefaultFloat(cls + MAJOR_YGRID_WEIGHT);
        this.minorYGridWeight = ViewportDrawProp.getDefaultFloat(cls + MINOR_YGRID_WEIGHT);
        this.majorYGridColor = ViewportDrawProp.getDefaultColor(cls + MAJOR_YGRID_COLOR);
        this.minorYGridColor = ViewportDrawProp.getDefaultColor(cls + MINOR_YGRID_COLOR);
        this.majorYGridStyle = ViewportDrawProp.getDefaultFloatArray(cls + MAJOR_YGRID_STYLE);
        this.minorYGridStyle = ViewportDrawProp.getDefaultFloatArray(cls + MINOR_YGRID_STYLE);
        this.drawBorder = ViewportDrawProp.getDefaultBoolean(cls + DRAW_BORDER);
        this.drawBackground = ViewportDrawProp.getDefaultBoolean(cls + DRAW_BACKGROUND);
        this.borderStyle = ViewportDrawProp.getDefaultFloatArray(cls + BORDER_STYLE);
        this.borderWeight = ViewportDrawProp.getDefaultFloat(cls + BORDER_WEIGHT);
        this.borderColor = ViewportDrawProp.getDefaultColor(cls + BORDER_COLOR);
        this.backgroundColor = ViewportDrawProp.getDefaultColor(cls + BACKGROUND_COLOR);
        this.viewportAlpha = ViewportDrawProp.getDefaultFloat(cls + VIEWPORT_ALPHA);
        this.fillPattern = ViewportDrawProp.getDefaultInt(cls + FILL_PATTERN);
        this.drawViewportLegend = ViewportDrawProp.getDefaultBoolean(cls + VIEWPORT_LEGEND);
        this.drawViewportLegendAlign = ViewportDrawProp.getDefaultString(cls + VIEWPORT_LEGEND_ALIGN);
        this.viewportLegendFontSize = ViewportDrawProp.getDefaultInt(cls + VIEWPORT_LEGEND_FONT_SIZE);
    }

    @Override
    public void setShowMajorXGridLines(boolean s) {
        this.drawMajorXGrid = s;
    }

    @Override
    public void setShowMinorXGridLines(boolean s) {
        this.drawMinorXGrid = s;
    }

    @Override
    public void setShowMajorYGridLines(boolean s) {
        this.drawMajorYGrid = s;
    }

    @Override
    public void setShowMinorYGridLines(boolean s) {
        this.drawMinorYGrid = s;
    }

    @Override
    public boolean showMajorXGridLines() {
        return this.drawMajorXGrid;
    }

    @Override
    public boolean showMinorXGridLines() {
        return this.drawMinorXGrid;
    }

    @Override
    public boolean showMajorYGridLines() {
        return this.drawMajorYGrid;
    }

    @Override
    public boolean showMinorYGridLines() {
        return this.drawMinorYGrid;
    }

    @Override
    public void setMajorXGridWeight(float w) {
        this.majorXGridWeight = w;
    }

    @Override
    public void setMinorXGridWeight(float w) {
        this.minorXGridWeight = w;
    }

    @Override
    public void setMajorXGridColor(Color c2) {
        this.majorXGridColor = c2;
    }

    @Override
    public void setMinorXGridColor(Color c2) {
        this.minorXGridColor = c2;
    }

    @Override
    public void setMajorXGridStyle(float[] s) {
        this.majorXGridStyle = s;
    }

    @Override
    public void setMinorXGridStyle(float[] s) {
        this.minorXGridStyle = s;
    }

    @Override
    public float getMajorXGridWeight() {
        return this.majorXGridWeight;
    }

    @Override
    public float getMinorXGridWeight() {
        return this.minorXGridWeight;
    }

    @Override
    public Color getMajorXGridColor() {
        return this.majorXGridColor;
    }

    @Override
    public Color getMinorXGridColor() {
        return this.minorXGridColor;
    }

    @Override
    public float[] getMajorXGridStyle() {
        return this.majorXGridStyle;
    }

    @Override
    public float[] getMinorXGridStyle() {
        return this.minorXGridStyle;
    }

    @Override
    public void setMajorYGridWeight(float w) {
        this.majorYGridWeight = w;
    }

    @Override
    public void setMinorYGridWeight(float w) {
        this.minorYGridWeight = w;
    }

    @Override
    public void setMajorYGridColor(Color c2) {
        this.majorYGridColor = c2;
    }

    @Override
    public void setMinorYGridColor(Color c2) {
        this.minorYGridColor = c2;
    }

    @Override
    public void setMajorYGridStyle(float[] s) {
        this.majorYGridStyle = s;
    }

    @Override
    public void setMinorYGridStyle(float[] s) {
        this.minorYGridStyle = s;
    }

    @Override
    public float getMajorYGridWeight() {
        return this.majorYGridWeight;
    }

    @Override
    public float getMinorYGridWeight() {
        return this.minorYGridWeight;
    }

    @Override
    public Color getMajorYGridColor() {
        return this.majorYGridColor;
    }

    @Override
    public Color getMinorYGridColor() {
        return this.minorYGridColor;
    }

    @Override
    public float[] getMajorYGridStyle() {
        return this.majorYGridStyle;
    }

    @Override
    public float[] getMinorYGridStyle() {
        return this.minorYGridStyle;
    }

    @Override
    public void setDrawLine(boolean b) {
        this.drawBorder = b;
    }

    @Override
    public void setDrawBackground(boolean b) {
        this.drawBackground = b;
    }

    @Override
    public void setLineColor(Color c2) {
        this.borderColor = c2;
    }

    @Override
    public void setLineStyle(float[] s) {
        this.borderStyle = s;
    }

    @Override
    public void setLineWeight(float f) {
        this.borderWeight = f;
    }

    @Override
    public void setBackgroundColor(Color c2) {
        this.backgroundColor = c2;
    }

    @Override
    public void setBackgroundFill(int ft) {
        this.fillPattern = ft;
    }

    public void drawViewportLegend(boolean b) {
        this.drawViewportLegend = b;
    }

    public void setViewportLegendFontSize(int i) {
        this.viewportLegendFontSize = i;
    }

    @Override
    public Color getLineColor() {
        return this.borderColor;
    }

    @Override
    public float[] getLineStyle() {
        return this.borderStyle;
    }

    @Override
    public float getLineWeight() {
        return this.borderWeight;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public boolean getDrawLine() {
        return this.drawBorder;
    }

    @Override
    public boolean getDrawBackground() {
        return this.drawBackground;
    }

    @Override
    public int getBackgroundFill() {
        return this.fillPattern;
    }

    public boolean getDrawViewportLegend() {
        return this.drawViewportLegend;
    }

    public int getViewportLegendFontSize() {
        return this.viewportLegendFontSize;
    }

    @Override
    public void setAlphaComposite(float alpha) {
        this.viewportAlpha = alpha;
    }

    @Override
    public float getAlphaComposite() {
        return this.viewportAlpha;
    }

    public void addGlyphProperties(G2dGlyphDrawProp prop) {
        if (prop == null) {
            return;
        }
        this.glyphProperties.addElement(prop);
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        this.writeProperties(writer, endTag, CLS_NAME);
    }

    protected void writeProperties(BufferedWriter writer, String endTag, String cls) {
        int i;
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (!ViewportDrawProp.isDefault(cls + DRAW_MAJOR_XGRID, this.drawMajorXGrid)) {
            RMAIO.fout(writer, indent + "drawMajorXGrid=" + this.drawMajorXGrid);
        }
        if (!ViewportDrawProp.isDefault(cls + DRAW_MINOR_XGRID, this.drawMinorXGrid)) {
            RMAIO.fout(writer, indent + "drawMinorXGrid=" + this.drawMinorXGrid);
        }
        if (!ViewportDrawProp.isDefault(cls + DRAW_MAJOR_YGRID, this.drawMajorYGrid)) {
            RMAIO.fout(writer, indent + "drawMajorYGrid=" + this.drawMajorYGrid);
        }
        if (!ViewportDrawProp.isDefault(cls + DRAW_MINOR_YGRID, this.drawMinorYGrid)) {
            RMAIO.fout(writer, indent + "drawMinorYGrid=" + this.drawMinorYGrid);
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_XGRID_WEIGHT, this.majorXGridWeight)) {
            RMAIO.fout(writer, indent + "majorXGridWeight=" + this.majorXGridWeight);
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_XGRID_WEIGHT, this.minorXGridWeight)) {
            RMAIO.fout(writer, indent + "minorXGridWeight=" + this.minorXGridWeight);
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_XGRID_COLOR, this.majorXGridColor)) {
            RMAIO.fout(writer, indent + "majorXGridColor=" + RmaColor.color2String(this.majorXGridColor));
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_XGRID_COLOR, this.minorXGridColor)) {
            RMAIO.fout(writer, indent + "minorXGridColor=" + RmaColor.color2String(this.minorXGridColor));
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_XGRID_STYLE, this.majorXGridStyle)) {
            RMAIO.fout(writer, indent + "majorXGridStyle=" + G2dLineProperties.lookupStyleName(this.majorXGridStyle));
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_XGRID_STYLE, this.minorXGridStyle)) {
            RMAIO.fout(writer, indent + "minorXGridStyle=" + G2dLineProperties.lookupStyleName(this.minorXGridStyle));
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_YGRID_WEIGHT, this.majorYGridWeight)) {
            RMAIO.fout(writer, indent + "majorYGridWeight=" + this.majorYGridWeight);
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_YGRID_WEIGHT, this.minorYGridWeight)) {
            RMAIO.fout(writer, indent + "minorYGridWeight=" + this.minorYGridWeight);
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_YGRID_COLOR, this.majorYGridColor)) {
            RMAIO.fout(writer, indent + "majorYGridColor=" + RmaColor.color2String(this.majorYGridColor));
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_YGRID_COLOR, this.minorYGridColor)) {
            RMAIO.fout(writer, indent + "minorYGridColor=" + RmaColor.color2String(this.minorYGridColor));
        }
        if (!ViewportDrawProp.isDefault(cls + MAJOR_YGRID_STYLE, this.majorYGridStyle)) {
            RMAIO.fout(writer, indent + "majorYGridStyle=" + G2dLineProperties.lookupStyleName(this.minorYGridStyle));
        }
        if (!ViewportDrawProp.isDefault(cls + MINOR_YGRID_STYLE, this.minorYGridStyle)) {
            RMAIO.fout(writer, indent + "minorYGridStyle=" + G2dLineProperties.lookupStyleName(this.minorYGridStyle));
        }
        if (!ViewportDrawProp.isDefault(cls + DRAW_BORDER, this.drawBorder)) {
            RMAIO.fout(writer, indent + "drawBorder=" + this.drawBorder);
        }
        if (!ViewportDrawProp.isDefault(cls + DRAW_BACKGROUND, this.drawBackground)) {
            RMAIO.fout(writer, indent + "drawBackground=" + this.drawBackground);
        }
        if (!ViewportDrawProp.isDefault(cls + BORDER_STYLE, this.borderStyle)) {
            RMAIO.fout(writer, indent + "borderStyle=" + G2dLineProperties.lookupStyleName(this.borderStyle));
        }
        if (!ViewportDrawProp.isDefault(cls + BORDER_WEIGHT, this.borderWeight)) {
            RMAIO.fout(writer, indent + "borderWeight=" + this.borderWeight);
        }
        if (!ViewportDrawProp.isDefault(cls + BORDER_COLOR, this.borderColor)) {
            RMAIO.fout(writer, indent + "borderColor=" + RmaColor.color2String(this.borderColor));
        }
        if (!ViewportDrawProp.isDefault(cls + BACKGROUND_COLOR, this.backgroundColor)) {
            RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(this.backgroundColor));
        }
        if (!ViewportDrawProp.isDefault(cls + VIEWPORT_ALPHA, this.viewportAlpha)) {
            RMAIO.fout(writer, indent + "viewportAlpha=" + Float.toString(this.viewportAlpha));
        }
        if (!ViewportDrawProp.isDefault(cls + FILL_PATTERN, this.fillPattern)) {
            RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(this.fillPattern));
        }
        if (!ViewportDrawProp.isDefault(cls + VIEWPORT_LEGEND, this.drawViewportLegend)) {
            RMAIO.fout(writer, indent + "drawViewportLegend=" + this.drawViewportLegend);
        }
        if (!ViewportDrawProp.isDefault(cls + VIEWPORT_LEGEND_ALIGN, this.drawViewportLegendAlign)) {
            RMAIO.fout(writer, indent + "drawViewportLegendAlign=" + this.drawViewportLegendAlign);
        }
        if (!ViewportDrawProp.isDefault(cls + VIEWPORT_LEGEND_FONT_SIZE, this.viewportLegendFontSize)) {
            RMAIO.fout(writer, indent + "viewportLegendFontSize=" + this.viewportLegendFontSize);
        }
        for (i = 0; i < this.lineMarkerProperties.size(); ++i) {
            RMAIO.fout(writer, indent + "Marker Begin");
            ((G2dMarkerProperties)this.lineMarkerProperties.elementAt(i)).writeProperties(writer, "Marker End");
        }
        for (i = 0; i < this.glyphProperties.size(); ++i) {
            RMAIO.fout(writer, indent + "Glyph Begin");
            ((G2dGlyphDrawProp)this.glyphProperties.elementAt(i)).writeProperties(writer, "Glyph End");
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(DRAW_MAJOR_XGRID)) {
                        this.drawMajorXGrid = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MINOR_XGRID)) {
                        this.drawMinorXGrid = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MAJOR_YGRID)) {
                        this.drawMajorYGrid = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MINOR_YGRID)) {
                        this.drawMinorYGrid = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_WEIGHT)) {
                        this.majorXGridWeight = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_WEIGHT)) {
                        this.minorXGridWeight = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_COLOR)) {
                        this.majorXGridColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_COLOR)) {
                        this.minorXGridColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_STYLE)) {
                        this.majorXGridStyle = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_STYLE)) {
                        this.minorXGridStyle = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_WEIGHT)) {
                        this.majorYGridWeight = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_WEIGHT)) {
                        this.minorYGridWeight = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_COLOR)) {
                        this.majorYGridColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_COLOR)) {
                        this.minorYGridColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_STYLE)) {
                        this.majorYGridStyle = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_STYLE)) {
                        this.minorYGridStyle = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_BORDER)) {
                        this.drawBorder = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_BACKGROUND)) {
                        this.drawBackground = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_STYLE)) {
                        this.borderStyle = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_WEIGHT)) {
                        this.borderWeight = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
                        this.backgroundColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_ALPHA)) {
                        this.viewportAlpha = RMAIO.parseFloat(param, 1.0f);
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_COLOR)) {
                        this.borderColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_PATTERN)) {
                        this.fillPattern = RmaDrawConst.lookupFillPattern(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_LEGEND)) {
                        this.drawViewportLegend = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_LEGEND_ALIGN)) {
                        this.drawViewportLegendAlign = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_LEGEND_FONT_SIZE)) {
                        this.viewportLegendFontSize = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("Marker Begin")) {
                        G2dMarkerProperties mp = new G2dMarkerProperties();
                        mp.readProperties(in, "Marker End");
                        this.lineMarkerProperties.add(mp);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("Glyph Begin")) continue;
                    G2dGlyphDrawProp gdp = new G2dGlyphDrawProp();
                    gdp.readProperties(in, "Glyph End");
                    this.glyphProperties.addElement(gdp);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    public void addLineMarkerProperties(G2dMarkerProperties prop) {
        if (prop == null) {
            return;
        }
        this.lineMarkerProperties.addElement(prop);
    }

    public static String getFileName() {
        return "viewportDefaults";
    }

    public static boolean loadDefaults(BufferedReader in) {
        return ViewportDrawProp.loadDefaults(in, END_TAG, CLS_NAME);
    }

    protected static boolean loadDefaults(BufferedReader in, String endTag, String cls) {
        if (in == null) {
            return false;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(DRAW_MAJOR_XGRID)) {
                        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_XGRID, "true".equalsIgnoreCase(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MINOR_XGRID)) {
                        ViewportDrawProp.setDefault(cls + DRAW_MINOR_XGRID, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MAJOR_YGRID)) {
                        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_YGRID, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MINOR_YGRID)) {
                        ViewportDrawProp.setDefault(cls + DRAW_MINOR_YGRID, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_WEIGHT)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_WEIGHT, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_WEIGHT)) {
                        ViewportDrawProp.setDefault(cls + MINOR_XGRID_WEIGHT, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_COLOR)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_COLOR)) {
                        ViewportDrawProp.setDefault(cls + MINOR_XGRID_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_XGRID_STYLE)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_XGRID_STYLE)) {
                        ViewportDrawProp.setDefault(cls + MINOR_XGRID_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_WEIGHT)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_WEIGHT, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_WEIGHT)) {
                        ViewportDrawProp.setDefault(cls + MINOR_YGRID_WEIGHT, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_COLOR)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_COLOR)) {
                        ViewportDrawProp.setDefault(cls + MINOR_YGRID_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MAJOR_YGRID_STYLE)) {
                        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MINOR_YGRID_STYLE)) {
                        ViewportDrawProp.setDefault(cls + MINOR_YGRID_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_BORDER)) {
                        ViewportDrawProp.setDefault(cls + DRAW_BORDER, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_BACKGROUND)) {
                        ViewportDrawProp.setDefault(cls + DRAW_BACKGROUND, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_STYLE)) {
                        ViewportDrawProp.setDefault(cls + BORDER_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_WEIGHT)) {
                        ViewportDrawProp.setDefault(cls + BORDER_WEIGHT, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
                        ViewportDrawProp.setDefault(cls + BACKGROUND_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_ALPHA)) {
                        ViewportDrawProp.setDefault(cls + VIEWPORT_ALPHA, RMAIO.parseFloat(param, 1.0f));
                        continue;
                    }
                    if (type.equalsIgnoreCase(BORDER_COLOR)) {
                        ViewportDrawProp.setDefault(cls + BORDER_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (!type.equalsIgnoreCase(FILL_PATTERN)) continue;
                    ViewportDrawProp.setDefault(cls + FILL_PATTERN, RmaDrawConst.lookupFillPattern(param));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return false;
        }
        return true;
    }

    public static void setDefaults(ViewportDrawProp defaultProps) {
        ViewportDrawProp.setDefaults(defaultProps, CLS_NAME);
    }

    protected static void setDefaults(ViewportDrawProp defaultProps, String cls) {
        if (defaultProps == null) {
            return;
        }
        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_XGRID, defaultProps.drawMajorXGrid);
        ViewportDrawProp.setDefault(cls + DRAW_MINOR_XGRID, defaultProps.drawMinorXGrid);
        ViewportDrawProp.setDefault(cls + DRAW_MAJOR_YGRID, defaultProps.drawMajorYGrid);
        ViewportDrawProp.setDefault(cls + DRAW_MINOR_YGRID, defaultProps.drawMinorYGrid);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_WEIGHT, defaultProps.majorXGridWeight);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_WEIGHT, defaultProps.minorXGridWeight);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_COLOR, defaultProps.majorXGridColor);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_COLOR, defaultProps.minorXGridColor);
        ViewportDrawProp.setDefault(cls + MAJOR_XGRID_STYLE, defaultProps.majorXGridStyle);
        ViewportDrawProp.setDefault(cls + MINOR_XGRID_STYLE, defaultProps.minorXGridStyle);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_WEIGHT, defaultProps.majorYGridWeight);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_WEIGHT, defaultProps.minorYGridWeight);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_STYLE, defaultProps.majorYGridStyle);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_STYLE, defaultProps.minorYGridStyle);
        ViewportDrawProp.setDefault(cls + MAJOR_YGRID_COLOR, defaultProps.majorYGridColor);
        ViewportDrawProp.setDefault(cls + MINOR_YGRID_COLOR, defaultProps.minorYGridColor);
        ViewportDrawProp.setDefault(cls + DRAW_BORDER, defaultProps.drawBorder);
        ViewportDrawProp.setDefault(cls + DRAW_BACKGROUND, defaultProps.drawBackground);
        ViewportDrawProp.setDefault(cls + BORDER_STYLE, defaultProps.borderStyle);
        ViewportDrawProp.setDefault(cls + BORDER_WEIGHT, defaultProps.borderWeight);
        ViewportDrawProp.setDefault(cls + BORDER_COLOR, defaultProps.borderColor);
        ViewportDrawProp.setDefault(cls + BACKGROUND_COLOR, defaultProps.backgroundColor);
        ViewportDrawProp.setDefault(cls + VIEWPORT_ALPHA, defaultProps.viewportAlpha);
        ViewportDrawProp.setDefault(cls + FILL_PATTERN, defaultProps.fillPattern);
    }

    public static boolean writeDefaults() {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(ViewportDrawProp.class);
        boolean b = ViewportDrawProp.writeDefaults(writer);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("");
        }
        return b;
    }

    public static boolean writeDefaults(BufferedWriter writer) {
        return ViewportDrawProp.writeDefaults(CLS_NAME, writer);
    }

    protected static boolean writeDefaults(String cls, BufferedWriter writer) {
        if (writer == null) {
            return false;
        }
        RMAIO.fout(writer, BEGIN_TAG);
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + "drawMajorXGrid=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_MAJOR_XGRID));
        RMAIO.fout(writer, indent + "drawMinorXGrid=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_MINOR_XGRID));
        RMAIO.fout(writer, indent + "drawMajorYGrid=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_MAJOR_YGRID));
        RMAIO.fout(writer, indent + "drawMinorYGrid=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_MINOR_YGRID));
        RMAIO.fout(writer, indent + "majorXGridWeight=" + ViewportDrawProp.getDefaultFloat(cls + MAJOR_XGRID_WEIGHT));
        RMAIO.fout(writer, indent + "minorXGridWeight=" + ViewportDrawProp.getDefaultFloat(cls + MINOR_XGRID_WEIGHT));
        RMAIO.fout(writer, indent + "majorXGridColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + MAJOR_XGRID_COLOR)));
        RMAIO.fout(writer, indent + "minorXGridColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + MINOR_XGRID_COLOR)));
        RMAIO.fout(writer, indent + "majorXGridStyle=" + G2dLineProperties.lookupStyleName(ViewportDrawProp.getDefaultFloatArray(cls + MAJOR_XGRID_STYLE)));
        RMAIO.fout(writer, indent + "minorXGridStyle=" + G2dLineProperties.lookupStyleName(ViewportDrawProp.getDefaultFloatArray(cls + MINOR_XGRID_STYLE)));
        RMAIO.fout(writer, indent + "majorYGridWeight=" + ViewportDrawProp.getDefaultFloat(cls + MAJOR_YGRID_WEIGHT));
        RMAIO.fout(writer, indent + "minorYGridWeight=" + ViewportDrawProp.getDefaultFloat(cls + MINOR_YGRID_WEIGHT));
        RMAIO.fout(writer, indent + "majorYGridColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + MAJOR_YGRID_COLOR)));
        RMAIO.fout(writer, indent + "minorYGridColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + MINOR_YGRID_COLOR)));
        RMAIO.fout(writer, indent + "majorYGridStyle=" + G2dLineProperties.lookupStyleName(ViewportDrawProp.getDefaultFloatArray(cls + MAJOR_YGRID_STYLE)));
        RMAIO.fout(writer, indent + "minorYGridStyle=" + G2dLineProperties.lookupStyleName(ViewportDrawProp.getDefaultFloatArray(cls + MINOR_YGRID_STYLE)));
        RMAIO.fout(writer, indent + "drawBorder=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_BORDER));
        RMAIO.fout(writer, indent + "drawBackground=" + ViewportDrawProp.getDefaultBoolean(cls + DRAW_BACKGROUND));
        RMAIO.fout(writer, indent + "borderStyle=" + G2dLineProperties.lookupStyleName(ViewportDrawProp.getDefaultFloatArray(cls + BORDER_STYLE)));
        RMAIO.fout(writer, indent + "borderWeight=" + ViewportDrawProp.getDefaultFloat(cls + BORDER_WEIGHT));
        RMAIO.fout(writer, indent + "borderColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + BORDER_COLOR)));
        RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(ViewportDrawProp.getDefaultColor(cls + BACKGROUND_COLOR)));
        RMAIO.fout(writer, indent + "viewportAlpha=" + ViewportDrawProp.getDefaultFloat(cls + VIEWPORT_ALPHA));
        RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(ViewportDrawProp.getDefaultInt(cls + FILL_PATTERN)));
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + END_TAG);
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static {
        ViewportDrawProp.init();
    }
}

