/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Scale;
import hec.gfx2d.DnDUtils;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.GhostGlassPane;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.PanelDropTarget;
import hec.gfx2d.Viewport;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ViewportDropTarget
extends PanelDropTarget {
    Viewport mViewport = null;

    public ViewportDropTarget(Viewport v) {
        super(v);
        this.mViewport = v;
    }

    private void setGlassPaneVisile(boolean visible) {
        Component c2 = SwingUtilities.getRootPane(this.mViewport).getGlassPane();
        if (c2 instanceof GhostGlassPane) {
            GhostGlassPane glassPane = (GhostGlassPane)c2;
            glassPane.setImage(null);
            glassPane.repaint();
            glassPane.setVisible(visible);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DnDUtils.debugPrintln("DropTarget drop, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        if ((dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            if (this.mTransferHandler != null && this.mTransferHandler.canImport(this.pane, dtde.getCurrentDataFlavors())) {
                this.mTransferHandler.importData(this.pane, dtde.getTransferable());
                return;
            }
            try {
                boolean result = this.dropGlyph(dtde);
                this.setGlassPaneVisile(false);
                dtde.dropComplete(result);
                DnDUtils.debugPrintln("Drop completed, success: " + result);
            }
            catch (Exception e) {
                DnDUtils.debugPrintln("Exception while handling drop " + e);
                dtde.dropComplete(false);
            }
        } else {
            DnDUtils.debugPrintln("Drop target rejected drop");
            dtde.rejectDrop();
        }
    }

    protected boolean dropGlyph(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        Transferable transferable = dtde.getTransferable();
        int dropAction = dtde.getDropAction();
        Object obj = transferable.getTransferData(this.targetFlavor);
        if (!(obj instanceof G2dGlyph)) {
            return false;
        }
        G2dObject gObj = ((G2dGlyph)obj).getG2dObject();
        Scale scale = this.mViewport.findScale(gObj);
        G2dGlyph newGlyph = null;
        if (scale != null) {
            newGlyph = G2dGlyphFactory.newG2dGlyph(this.mViewport, gObj, this.mViewport.getScale());
        }
        newGlyph.setProperties((G2dGlyphDrawProp)((G2dGlyph)obj).getProperties().clone());
        ((Viewport)this.pane).addG2dGlyph(newGlyph);
        if (dropAction == 2) {
            Viewport srcComp = (Viewport)dtde.getDropTargetContext().getComponent();
            srcComp.getG2dPanel().removeGlyph((G2dGlyph)obj);
            G2dPanel panel = ((Viewport)this.pane).getG2dPanel();
            LegendPanel lp = panel.getLegendPanel();
            Vector viewports = panel.getViewportVector();
            lp.rebuildall();
            for (int i = 0; i < viewports.size(); ++i) {
                lp.addViewport((Viewport)viewports.get(i));
            }
            lp.invalidate();
            lp.repaint();
            panel.repaint();
        }
        return true;
    }

    @Override
    protected boolean acceptOrRejectDrag(DropTargetDragEvent dtde) {
        if (!super.acceptOrRejectDrag(dtde)) {
            return false;
        }
        boolean acceptRejectDrag = true;
        Transferable transferable = dtde.getTransferable();
        try {
            if (this.mTransferHandler != null && this.mTransferHandler.canImport(this.pane, dtde.getCurrentDataFlavors())) {
                return true;
            }
            Object obj = transferable.getTransferData(this.targetFlavor);
            if (!(obj instanceof G2dGlyph)) {
                dtde.rejectDrag();
                return false;
            }
            Vector glyphList = this.mViewport.getGlyphVector();
            if (glyphList.contains(obj)) {
                dtde.rejectDrag();
                return false;
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
            return false;
        }
        return true;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DnDUtils.debugPrintln("dragEnter, drop action = " + DnDUtils.showActions(dtde.getDropAction()));
        this.checkTransferType(dtde);
        if (!this.acceptOrRejectDrag(dtde)) {
            return;
        }
    }
}

