/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;

public class ViewportLayer<T extends G2dComponent> {
    public static final String LOCATION = "Location";
    T _component;
    Location _location;
    PropertyChangeSupport _support;

    public ViewportLayer() {
        this._component = null;
        this._support = new PropertyChangeSupport(this);
    }

    public ViewportLayer(T component) {
        Objects.requireNonNull(component, "Invalid NULL Component in ViewportLayer");
        this._component = component;
        this._support = new PropertyChangeSupport(this);
    }

    public void setComponent(T component) {
        this._component = component;
    }

    public T getComponent() {
        return this._component;
    }

    public void setSize(int width, int height) {
        ((Component)this._component).setSize(width, height);
    }

    public void computePreferredSize() {
        ((Component)this._component).setSize(((G2dComponent)this._component).getPreferredSize());
    }

    public void setLocation(Location location) {
        Location oldLocation = this._location;
        this._location = location;
        this._support.firePropertyChange(LOCATION, (Object)oldLocation, (Object)location);
    }

    public Location getLocation() {
        return this._location;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(propertyName, listener);
    }

    public static enum Location {
        BOTTOM_LEFT("Bottom Left", 1),
        BOTTOM_RIGHT("Bottom Right", 2),
        TOP_LEFT("Top Left", 3),
        TOP_RIGHT("Top Right", 4),
        TOP_CENTER("Top Center", 5),
        RIGHT_CENTER("Right Center", 6),
        BOTTOM_CENTER("Bottom Center", 7),
        LEFT_CENTER("Left Center", 8),
        CENTER("Center", 9);

        int location;
        String name;

        private Location(String name, int location) {
            this.name = name;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public Rectangle computeBounds(Component parent, Component child) {
            Dimension size = parent.getSize();
            switch (this.location) {
                case 1: {
                    return new Rectangle(1, size.height - child.getHeight() - 1, child.getWidth(), child.getHeight());
                }
                case 2: {
                    return new Rectangle(size.width - child.getWidth() - 1, size.height - child.getHeight() - 1, child.getWidth(), child.getHeight());
                }
                case 3: {
                    return new Rectangle(1, 1, child.getWidth(), child.getHeight());
                }
                case 4: {
                    return new Rectangle(size.width - child.getWidth() - 1, 1, child.getWidth(), child.getHeight());
                }
                case 5: {
                    return new Rectangle((size.width - child.getWidth()) / 2, 1, child.getWidth(), child.getHeight());
                }
                case 6: {
                    return new Rectangle(size.width - child.getWidth() - 1, (size.height - child.getHeight()) / 2, child.getWidth(), child.getHeight());
                }
                case 7: {
                    return new Rectangle((size.width - child.getWidth()) / 2, size.height - child.getHeight() - 1, child.getWidth(), child.getHeight());
                }
                case 8: {
                    return new Rectangle(1, (size.height - child.getHeight()) / 2, child.getWidth(), child.getHeight());
                }
                case 9: {
                    return new Rectangle((size.width - child.getWidth()) / 2, (size.height - child.getHeight()) / 2, child.getWidth(), child.getHeight());
                }
            }
            return new Rectangle(0, 0, child.getWidth(), child.getHeight());
        }
    }
}

