/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerPointProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.ViewportLayer;
import hec.gfx2d.ViewportTextLayer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.util.ArrayList;
import java.util.List;

public class ViewportLayout {
    public static final int BASE_COLUMN = 1;
    public static final int RATED_COLUMN = 0;
    public static final String AXIS_TYPE_LINEAR = "Linear";
    public static final String AXIS_TYPE_LOG = "Log";
    public static final String AXIS_TYPE_TIME = "Time";
    public static final String AXIS_TYPE_PROBABILITY = "Probability";
    public static final String AXIS_TYPE_SEASONAL = "Seasonal";
    public static final String Y1 = "Y1";
    public static final String Y2 = "Y2";
    public static final String X1 = "X1";
    public static final String X2 = "X2";
    List m_y1AxisData = new ArrayList();
    List m_y2AxisData = new ArrayList();
    List m_x2y1AxisData = new ArrayList();
    List m_x2y2AxisData = new ArrayList();
    List m_y1AxisDataColorProp = new ArrayList();
    List m_y2AxisDataColorProp = new ArrayList();
    List m_x2y1AxisDataColorProp = new ArrayList();
    List m_x2y2AxisDataColorProp = new ArrayList();
    List m_y1AxisMarkerValues = new ArrayList();
    List m_x1AxisMarkerValues = new ArrayList();
    List m_x1AxisMarkerColorProp = new ArrayList();
    List m_y1AxisMarkerColorProp = new ArrayList();
    List<G2dMarkerPointProperties> m_markerPointProps = new ArrayList<G2dMarkerPointProperties>();
    String m_y1AxisLabel = null;
    String m_y2AxisLabel = null;
    String m_x1AxisLabel = null;
    String m_x2AxisLabel = null;
    String m_y1AxisType = null;
    String m_y2AxisType = null;
    String m_x1AxisType = null;
    String m_x2AxisType = null;
    String m_y1AxisName = null;
    String m_y2AxisName = null;
    String m_x1AxisName = null;
    String m_x2AxisName = null;
    boolean[] m_axisReversed = new boolean[]{false, false, true, true};
    boolean m_autoRateAxis = false;
    double[][] m_ratingFunction = null;
    boolean m_viewportLegendVisible = false;
    List<ViewportLayer> m_viewportLayers = new ArrayList<ViewportLayer>();

    public void setViewportLegendVisible(boolean b) {
        this.m_viewportLegendVisible = b;
    }

    public boolean isViewportLegendVisible() {
        return this.m_viewportLegendVisible;
    }

    public int convertAxisType(String axis) {
        if (axis == null) {
            return -1;
        }
        if (AXIS_TYPE_LOG.equalsIgnoreCase(axis)) {
            return 3;
        }
        if (AXIS_TYPE_LINEAR.equalsIgnoreCase(axis)) {
            return 0;
        }
        if (AXIS_TYPE_TIME.equalsIgnoreCase(axis)) {
            return 1;
        }
        if (AXIS_TYPE_PROBABILITY.equalsIgnoreCase(axis)) {
            return 4;
        }
        if (AXIS_TYPE_SEASONAL.equalsIgnoreCase(axis)) {
            return 2;
        }
        return -1;
    }

    public String convertAxisType(int axis) {
        switch (axis) {
            case 3: {
                return AXIS_TYPE_LOG;
            }
            case 0: {
                return AXIS_TYPE_LINEAR;
            }
            case 1: {
                return AXIS_TYPE_TIME;
            }
            case 4: {
                return AXIS_TYPE_PROBABILITY;
            }
            case 2: {
                return AXIS_TYPE_SEASONAL;
            }
        }
        return null;
    }

    public void setAxisType(String axis, String type) {
        if (X1.equalsIgnoreCase(axis)) {
            this.m_x1AxisType = type;
        } else if (X2.equalsIgnoreCase(axis)) {
            this.m_x2AxisType = type;
        } else if (Y1.equalsIgnoreCase(axis)) {
            this.m_y1AxisType = type;
        } else if (Y2.equalsIgnoreCase(axis)) {
            this.m_y2AxisType = type;
        }
    }

    public String getAxisType(String axis) {
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_x1AxisType;
        }
        if (X2.equalsIgnoreCase(axis)) {
            return this.m_x2AxisType;
        }
        if (Y1.equalsIgnoreCase(axis)) {
            return this.m_y1AxisType;
        }
        if (Y2.equalsIgnoreCase(axis)) {
            return this.m_y2AxisType;
        }
        return null;
    }

    public boolean isAxisReversed(String axis) {
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_axisReversed[0];
        }
        if (X2.equalsIgnoreCase(axis)) {
            return this.m_axisReversed[1];
        }
        if (Y1.equalsIgnoreCase(axis)) {
            return this.m_axisReversed[2];
        }
        if (Y2.equalsIgnoreCase(axis)) {
            return this.m_axisReversed[3];
        }
        return false;
    }

    public void setAxisReversed(String axis, boolean isReversed) {
        if (X1.equalsIgnoreCase(axis)) {
            this.m_axisReversed[0] = isReversed;
        } else if (X2.equalsIgnoreCase(axis)) {
            this.m_axisReversed[1] = isReversed;
        } else if (Y1.equalsIgnoreCase(axis)) {
            this.m_axisReversed[2] = !isReversed;
        } else if (Y2.equalsIgnoreCase(axis)) {
            this.m_axisReversed[3] = !isReversed;
        }
    }

    public void setAxisName(String axis, String name) {
        if (Y1.equalsIgnoreCase(axis)) {
            this.m_y1AxisName = name;
        } else if (Y2.equalsIgnoreCase(axis)) {
            this.m_y2AxisName = name;
        } else if (X1.equalsIgnoreCase(axis)) {
            this.m_x1AxisName = name;
        } else if (X2.equalsIgnoreCase(axis)) {
            this.m_x2AxisName = name;
        }
    }

    public String getAxisName(String axis) {
        if (Y1.equalsIgnoreCase(axis)) {
            return this.m_y1AxisName;
        }
        if (Y2.equalsIgnoreCase(axis)) {
            return this.m_y2AxisName;
        }
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_x1AxisName;
        }
        if (X2.equalsIgnoreCase(axis)) {
            return this.m_x2AxisName;
        }
        return null;
    }

    public void setAxisLabel(String axis, String label) {
        if (Y1.equalsIgnoreCase(axis)) {
            this.m_y1AxisLabel = label;
        } else if (Y2.equalsIgnoreCase(axis)) {
            this.m_y2AxisLabel = label;
        } else if (X1.equalsIgnoreCase(axis)) {
            this.m_x1AxisLabel = label;
        } else if (X2.equalsIgnoreCase(axis)) {
            this.m_x2AxisLabel = label;
        }
    }

    public String getAxisLabel(String axis) {
        if (Y1.equalsIgnoreCase(axis)) {
            return this.m_y1AxisLabel;
        }
        if (Y2.equalsIgnoreCase(axis)) {
            return this.m_y2AxisLabel;
        }
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_x1AxisLabel;
        }
        if (X2.equalsIgnoreCase(axis)) {
            return this.m_x2AxisLabel;
        }
        return null;
    }

    public boolean hasAutoRatedAxis() {
        return this.m_autoRateAxis;
    }

    public void setAutoRatedAxis(boolean b) {
        this.m_autoRateAxis = b;
        this.m_ratingFunction = null;
    }

    public void setRatingFunction(double[] b1, double[] r1) {
        if (b1 == null || r1 == null) {
            this.m_ratingFunction = null;
            return;
        }
        if (b1.length != r1.length) {
            throw new IllegalArgumentException("ViewportLayout.setRatingFunction() - Both arrays have to be of equal length");
        }
        this.m_ratingFunction = new double[2][];
        this.m_ratingFunction[1] = b1;
        this.m_ratingFunction[0] = r1;
        this.m_autoRateAxis = false;
    }

    public double[][] getRatingFunction() {
        return this.m_ratingFunction;
    }

    public boolean hasY1Data(String axis) {
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_y1AxisData.size() > 0;
        }
        return this.m_x2y1AxisData.size() > 0;
    }

    public boolean hasY2Data(String axis) {
        if (X1.equalsIgnoreCase(axis)) {
            return this.m_y2AxisData.size() > 0;
        }
        return this.m_x2y2AxisData.size() > 0;
    }

    public void addCurve(String axis, Object data) {
        this.addCurve(X1, axis, data, (G2dLineProperties)null);
    }

    public void addCurve(String yaxis, Object data, G2dLineProperties properties) {
        this.addCurve(X1, yaxis, data, properties);
    }

    public void addCurve(String xaxis, String yaxis, Object data, G2dLineProperties properties) {
        G2dObject dataObject;
        if (xaxis == null) {
            return;
        }
        if (yaxis == null) {
            return;
        }
        if (data == null) {
            return;
        }
        if (data instanceof TimeSeriesContainer) {
            TimeSeriesDataSet ts = new TimeSeriesDataSet((TimeSeriesContainer)data);
            if (((TimeSeriesContainer)data).timeZoneID != null) {
                ts.setGmtOffset(((TimeSeriesContainer)data).timeZoneRawOffset / 3600000);
            }
            dataObject = ts;
        } else if (data instanceof PairedDataContainer) {
            dataObject = new PairedDataSet((PairedDataContainer)data);
        } else if (data instanceof G2dObject) {
            dataObject = (G2dObject)data;
        } else {
            return;
        }
        if (Y1.equalsIgnoreCase(yaxis) && X1.equalsIgnoreCase(xaxis)) {
            this.m_y1AxisData.add(dataObject);
            this.addProperties(dataObject, this.m_y1AxisDataColorProp, properties);
        } else if (Y2.equalsIgnoreCase(yaxis) && X1.equalsIgnoreCase(xaxis)) {
            this.m_y2AxisData.add(dataObject);
            this.addProperties(dataObject, this.m_y2AxisDataColorProp, properties);
        } else if (Y1.equalsIgnoreCase(yaxis) && X2.equalsIgnoreCase(xaxis)) {
            this.m_x2y1AxisData.add(dataObject);
            this.addProperties(dataObject, this.m_x2y1AxisDataColorProp, properties);
        } else if (Y2.equalsIgnoreCase(yaxis) && X2.equalsIgnoreCase(xaxis)) {
            this.m_x2y2AxisData.add(dataObject);
            this.addProperties(dataObject, this.m_x2y2AxisDataColorProp, properties);
        } else {
            System.out.println("addCurve:unknown axis X=" + xaxis + " Y=" + yaxis);
        }
    }

    private void addProperties(G2dObject dataObject, List axisProps, G2dLineProperties properties) {
        for (int i = 0; i < dataObject.getCurveCount(); ++i) {
            axisProps.add(properties);
        }
    }

    public void addCurve(String yaxis, Object data, List properties) {
        this.addCurve(X1, yaxis, data, properties);
    }

    public void addCurve(String xaxis, String yaxis, Object data, List properties) {
        block23: {
            G2dObject dataObject;
            block25: {
                block24: {
                    block22: {
                        if (xaxis == null) {
                            return;
                        }
                        if (yaxis == null) {
                            return;
                        }
                        if (data == null) {
                            return;
                        }
                        if (data instanceof TimeSeriesContainer) {
                            TimeSeriesDataSet ts = new TimeSeriesDataSet((TimeSeriesContainer)data);
                            if (((TimeSeriesContainer)data).timeZoneID != null) {
                                ts.setGmtOffset(((TimeSeriesContainer)data).timeZoneRawOffset / 3600000);
                            }
                            dataObject = ts;
                        } else if (data instanceof PairedDataContainer) {
                            dataObject = new PairedDataSet((PairedDataContainer)data);
                        } else if (data instanceof G2dObject) {
                            dataObject = (G2dObject)data;
                        } else {
                            return;
                        }
                        if (!Y1.equalsIgnoreCase(yaxis) || !X1.equalsIgnoreCase(xaxis)) break block22;
                        this.m_y1AxisData.add(dataObject);
                        if (properties != null) {
                            this.m_y1AxisDataColorProp.addAll(properties);
                        } else {
                            for (int i = 0; i < dataObject.getCurveCount(); ++i) {
                                this.m_y1AxisDataColorProp.add(null);
                            }
                        }
                        break block23;
                    }
                    if (!Y2.equalsIgnoreCase(yaxis) || !X1.equalsIgnoreCase(xaxis)) break block24;
                    this.m_y2AxisData.add(dataObject);
                    if (properties != null) {
                        this.m_y2AxisDataColorProp.addAll(properties);
                    } else {
                        for (int i = 0; i < dataObject.getCurveCount(); ++i) {
                            this.m_y2AxisDataColorProp.add(null);
                        }
                    }
                    break block23;
                }
                if (!Y1.equalsIgnoreCase(yaxis) || !X2.equalsIgnoreCase(xaxis)) break block25;
                this.m_x2y1AxisData.add(dataObject);
                if (properties != null) {
                    this.m_x2y1AxisDataColorProp.addAll(properties);
                } else {
                    for (int i = 0; i < dataObject.getCurveCount(); ++i) {
                        this.m_x2y1AxisDataColorProp.add(null);
                    }
                }
                break block23;
            }
            if (!Y2.equalsIgnoreCase(yaxis) || !X2.equalsIgnoreCase(xaxis)) break block23;
            this.m_x2y2AxisData.add(dataObject);
            if (properties != null) {
                this.m_x2y2AxisDataColorProp.addAll(properties);
            } else {
                for (int i = 0; i < dataObject.getCurveCount(); ++i) {
                    this.m_x2y2AxisDataColorProp.add(null);
                }
            }
        }
    }

    public List getY1Data(String xAxis) {
        if (X1.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_y1AxisData).clone();
        }
        if (X2.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_x2y1AxisData).clone();
        }
        return new ArrayList();
    }

    public List getY1DataProperties(String xAxis) {
        if (X1.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_y1AxisDataColorProp).clone();
        }
        if (X2.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_x2y1AxisDataColorProp).clone();
        }
        return new ArrayList();
    }

    public List getY2Data(String xAxis) {
        if (X1.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_y2AxisData).clone();
        }
        if (X2.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_x2y2AxisData).clone();
        }
        return new ArrayList();
    }

    public List getY2DataProperties(String xAxis) {
        if (X1.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_y2AxisDataColorProp).clone();
        }
        if (X2.equalsIgnoreCase(xAxis)) {
            return (List)((ArrayList)this.m_x2y2AxisDataColorProp).clone();
        }
        return new ArrayList();
    }

    public void addMarkerLine(String axis, double markerValue) {
        this.addMarkerLine(axis, markerValue);
    }

    public void addMarkerLine(String axis, double markerValue, G2dMarkerProperties properties) {
        if (axis == null) {
            return;
        }
        if (Y1.equalsIgnoreCase(axis)) {
            this.m_y1AxisMarkerValues.add(markerValue);
            this.m_y1AxisMarkerColorProp.add(properties);
        } else if (X1.equalsIgnoreCase(axis)) {
            this.m_x1AxisMarkerValues.add(markerValue);
            this.m_x1AxisMarkerColorProp.add(properties);
        } else {
            System.out.println("addMarkerLine:unknown axis=" + axis);
        }
    }

    public List getY1MarkerLines() {
        return this.m_y1AxisMarkerValues;
    }

    public List getY1MarklineProps() {
        return this.m_y1AxisMarkerColorProp;
    }

    public List getX1MarkerLines() {
        return this.m_x1AxisMarkerValues;
    }

    public List getX1MarklineProps() {
        return this.m_x1AxisMarkerColorProp;
    }

    public void addMarkerPoint(G2dMarkerPointProperties markerProps) {
        if (markerProps == null) {
            return;
        }
        this.m_markerPointProps.add(markerProps);
    }

    public List<G2dMarkerPointProperties> getMarkerPoints() {
        return this.m_markerPointProps;
    }

    public List<ViewportLayer> getViewportLayers() {
        return this.m_viewportLayers;
    }

    public ViewportTextLayer addViewportTextLayer() {
        ViewportTextLayer layer = new ViewportTextLayer();
        this.m_viewportLayers.add(layer);
        return layer;
    }
}

