/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dBorder;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFontPropertiesPanel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.G2dPatternPropertiesPanel;
import hec.gfx2d.G2dPointerComponent;
import hec.gfx2d.G2dPropertiesDlg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;

public class ViewportTextComponent
extends G2dComponent
implements G2dPointerComponent {
    JLabel label;
    private static final long serialVersionUID = 1L;
    G2dLabelDrawProp properties;
    List<ActionListener> mPropertiesOKListeners = new ArrayList<ActionListener>();

    public ViewportTextComponent() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.setBackground(null);
        this.label.setBackground(Color.green);
        this.add((Component)this.label, "Center");
    }

    @Override
    public Font getFont() {
        return this.label != null ? this.label.getFont() : super.getFont();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.label != null) {
            this.label.setFont(f);
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Rectangle boundingRect = this.getBounds();
        this._popupMenu.show(this, pt.x, pt.y);
        return true;
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Label Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Text Layer");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(new G2dComponent.EditPropertyListener());
        this._popupMenu.add(jm);
    }

    @Override
    public G2dMouseAdapter setMouseAdapter(G2dMouseAdapter adapter) {
        return super.setMouseAdapter(adapter);
    }

    @Override
    public void setMouseAdapter(String className) {
        super.setMouseAdapter(className);
    }

    @Override
    public boolean objectSelect(LocalPt pt, int modifiers) {
        return false;
    }

    @Override
    public void editProperties() {
        this.properties = new G2dLabelDrawProp();
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        G2dPatternPropertiesPanel patternPanel = new G2dPatternPropertiesPanel();
        G2dFontPropertiesPanel fontPanel = new G2dFontPropertiesPanel();
        this.properties.text = this.getText();
        this.properties.setFont(this.getFont());
        Color c2 = this.label.getForeground();
        this.properties.textColor = c2 != null ? c2 : Color.black;
        Color background = this.getBackground();
        this.properties.setBackgroundColor(this.getBackground());
        this.properties.setDrawBackground(background != null);
        Border b = this.getBorder();
        this.properties.drawBorder = false;
        if (b != null && b instanceof G2dBorder) {
            this.properties.drawBorder = true;
            this.properties.borderColor = ((G2dBorder)b).getLineColor();
            this.properties.borderWeight = ((G2dBorder)b).getThickness();
            this.properties.borderStyle = ((G2dBorder)b).getBorderStyle();
        }
        patternPanel.setData(this.properties);
        fontPanel.setData(this.properties);
        G2dPropertiesDlg dlg = null;
        PropertiesOKListener listener = new PropertiesOKListener();
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Label Properties", new DefaultJPanel[]{patternPanel, fontPanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Label Properties", new DefaultJPanel[]{patternPanel, fontPanel});
        dlg.addOKListener(listener);
        for (int i = 0; i < this.mPropertiesOKListeners.size(); ++i) {
            ActionListener alistener = this.mPropertiesOKListeners.get(i);
            if (alistener == null) continue;
            dlg.addOKListener(alistener);
        }
        this.setCursor(oldCursor);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void addPropertiesOKListener(ActionListener listener) {
        if (listener != null) {
            this.mPropertiesOKListeners.add(listener);
        }
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component[] components;
            ViewportTextComponent.this.setFont(ViewportTextComponent.this.properties.getFont());
            ViewportTextComponent.this.setBackground(ViewportTextComponent.this.properties.getBackgroundColor());
            if (ViewportTextComponent.this.properties.drawBorder) {
                G2dBorder border = new G2dBorder(ViewportTextComponent.this.properties.borderColor, (int)ViewportTextComponent.this.properties.borderWeight, ViewportTextComponent.this.properties.borderStyle);
                ViewportTextComponent.this.setBorder(border);
            } else {
                ViewportTextComponent.this.setBorder(null);
            }
            ViewportTextComponent.this.label.setForeground(ViewportTextComponent.this.properties.textColor);
            ViewportTextComponent.this.revalidate();
            ViewportTextComponent.this.repaint();
            for (Component component : components = ViewportTextComponent.this.getComponents()) {
                component.repaint();
            }
        }
    }
}

