/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dToolbarListener;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportToolbarProp;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import rma.swing.RmaImage;

public class ViewportToolbar
extends JPanel {
    G2dPanel _parent = null;
    GridBagLayout _gridbag = new GridBagLayout();
    SymAction lSymAction;
    Vector _buttonVector = new Vector();
    Vector _buttonGifVector = new Vector();
    Vector _viewportVector = new Vector();
    int _selectedButton = -1;
    ButtonGroup _group = new ButtonGroup();
    Vector _toolListenerList = new Vector();

    public ViewportToolbar(G2dPanel p) {
        this._parent = p;
        this.setLayout(this._gridbag);
        this.lSymAction = new SymAction();
        this.setBorder(new BevelBorder(1));
        this.setBackground(null);
    }

    public void configureToolbar(ViewportToolbarProp prop) {
        this.clearToolbar();
        if (prop == null) {
            return;
        }
        int nbuttons = prop.getButtonCount();
        int icnt = 1;
        Enumeration e = prop.buttonElements();
        while (e.hasMoreElements()) {
            ToolbarButtonProp bp = (ToolbarButtonProp)e.nextElement();
            JToggleButton button = new JToggleButton();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = icnt;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            if (icnt == nbuttons) {
                gbc.weighty = 1.0;
            }
            gbc.anchor = 11;
            this.addToolButton(button, bp, gbc);
            ++icnt;
        }
    }

    public void addViewport(Viewport view) {
        this._viewportVector.addElement(view);
    }

    public void addToolButton(JToggleButton button, ToolbarButtonProp bgstr) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        this.addToolButton(button, bgstr, gbc);
    }

    public void addToolButton(JToggleButton button, ToolbarButtonProp bgstr, GridBagConstraints gbc) {
        ImageIcon ii;
        button.setRolloverEnabled(true);
        try {
            ii = RmaImage.getImageIcon(bgstr.over);
            button.setRolloverIcon(ii);
        }
        catch (Exception e) {
            System.out.println("ViewportToolbar.addToolButton: bad URL " + bgstr.over + " " + e);
        }
        try {
            ii = RmaImage.getImageIcon(bgstr.down);
            button.setPressedIcon(ii);
        }
        catch (Exception e) {
            System.out.println("ViewportToolbar.addToolButton: bad URL " + bgstr.down + " " + e);
        }
        try {
            ii = RmaImage.getImageIcon(bgstr.up);
            button.setIcon(ii);
        }
        catch (Exception e) {
            System.out.println("ViewportToolbar.addToolButton: bad URL " + bgstr.up + " " + e);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        if (bgstr.toolTipText != null) {
            button.setToolTipText(bgstr.toolTipText);
        }
        button.setEnabled(true);
        this._gridbag.setConstraints(button, gbc);
        this.add(button);
        this._group.add(button);
        this._buttonVector.addElement(button);
        button.addActionListener(this.lSymAction);
        this._buttonGifVector.addElement(bgstr);
    }

    public int getSelectedButton() {
        return this._selectedButton;
    }

    public Vector getButtonVector() {
        return this._buttonVector;
    }

    public void forceSelectButton(int idx) {
        this._selectedButton = -1;
        this.selectButton(idx);
    }

    public void selectButton(int idx) {
        ImageIcon ii;
        ToolbarButtonProp bgstr;
        JToggleButton button;
        if (this._selectedButton == idx) {
            return;
        }
        if (this._selectedButton >= 0) {
            button = (JToggleButton)this._buttonVector.elementAt(this._selectedButton);
            button.setSelected(false);
            bgstr = (ToolbarButtonProp)this._buttonGifVector.elementAt(this._selectedButton);
            ii = RmaImage.getImageIcon(bgstr.over);
            button.setRolloverIcon(ii);
            ii = RmaImage.getImageIcon(bgstr.up);
            button.setIcon(ii);
        }
        this._selectedButton = idx;
        if (this._selectedButton >= this._buttonVector.size()) {
            return;
        }
        if (this._selectedButton < 0) {
            this.notifyToolListeners(null);
            return;
        }
        button = (JToggleButton)this._buttonVector.elementAt(this._selectedButton);
        button.setSelected(true);
        bgstr = (ToolbarButtonProp)this._buttonGifVector.elementAt(this._selectedButton);
        ii = RmaImage.getImageIcon(bgstr.on);
        button.setRolloverIcon(ii);
        button.setIcon(ii);
        this.notifyToolListeners(bgstr.adapter);
    }

    public ViewportToolbarProp getProperties() {
        ViewportToolbarProp prop = new ViewportToolbarProp();
        if (this._buttonGifVector == null) {
            return prop;
        }
        for (int i = 0; i < this._buttonGifVector.size(); ++i) {
            ToolbarButtonProp p = (ToolbarButtonProp)this._buttonGifVector.elementAt(i);
            prop.addButtonProp(p);
        }
        prop.defaultButton = this._selectedButton;
        return prop;
    }

    void miButton_Action(ActionEvent event) {
        Object object = event.getSource();
        for (int i = 0; i < this._buttonVector.size(); ++i) {
            if (object != this._buttonVector.elementAt(i)) continue;
            this.selectButton(i);
        }
    }

    void clearToolbar() {
        this.removeAll();
        this._buttonVector.removeAllElements();
        this._buttonGifVector.removeAllElements();
        this._selectedButton = -1;
    }

    public synchronized void addToolbarListener(G2dToolbarListener l) {
        if (l == null || this._toolListenerList.contains(l)) {
            return;
        }
        this._toolListenerList.add(l);
    }

    public synchronized void removeToolbarLisntener(G2dToolbarListener l) {
        this._toolListenerList.remove(l);
    }

    protected void notifyToolListeners(String adpterClss) {
        for (int i = 0; i < this._toolListenerList.size(); ++i) {
            ((G2dToolbarListener)this._toolListenerList.elementAt(i)).setMouseAdapter(adpterClss);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object instanceof JToggleButton) {
                ViewportToolbar.this.miButton_Action(event);
            }
        }
    }
}

